// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbb -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBB
// RUN: %clang_cc1 -triple riscv64 -target-feature +zbb -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBB

#include <riscv_bitmanip.h>

// RV32ZBB-LABEL: @orc_b_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.orc.b.i32(i32 [[A:%.*]])
// RV32ZBB-NEXT:    ret i32 [[TMP0]]
//
// RV64ZBB-LABEL: @orc_b_32(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.orc.b.i32(i32 [[A:%.*]])
// RV64ZBB-NEXT:    ret i32 [[TMP0]]
//
uint32_t orc_b_32(uint32_t a) {
  return __riscv_orc_b_32(a);
}

#if __riscv_xlen == 64
// RV64ZBB-LABEL: @orc_b_64(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.orc.b.i64(i64 [[A:%.*]])
// RV64ZBB-NEXT:    ret i64 [[TMP0]]
//
uint64_t orc_b_64(uint64_t a) {
  return __riscv_orc_b_64(a);
}
#endif

// RV32ZBB-LABEL: @clz_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.ctlz.i32(i32 [[A:%.*]], i1 false)
// RV32ZBB-NEXT:    ret i32 [[TMP0]]
//
// RV64ZBB-LABEL: @clz_32(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.ctlz.i32(i32 [[A:%.*]], i1 false)
// RV64ZBB-NEXT:    ret i32 [[TMP0]]
//
unsigned int clz_32(uint32_t a) {
  return __riscv_clz_32(a);
}

#if __riscv_xlen == 64
// RV64ZBB-LABEL: @clz_64(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i64 @llvm.ctlz.i64(i64 [[A:%.*]], i1 false)
// RV64ZBB-NEXT:    [[CAST_I:%.*]] = trunc i64 [[TMP0]] to i32
// RV64ZBB-NEXT:    ret i32 [[CAST_I]]
//
unsigned int clz_64(uint64_t a) {
  return __riscv_clz_64(a);
}
#endif

// RV32ZBB-LABEL: @ctz_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[A:%.*]], i1 false)
// RV32ZBB-NEXT:    ret i32 [[TMP0]]
//
// RV64ZBB-LABEL: @ctz_32(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[A:%.*]], i1 false)
// RV64ZBB-NEXT:    ret i32 [[TMP0]]
//
unsigned int ctz_32(uint32_t a) {
  return __riscv_ctz_32(a);
}

#if __riscv_xlen == 64
// RV64ZBB-LABEL: @ctz_64(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i64 @llvm.cttz.i64(i64 [[A:%.*]], i1 false)
// RV64ZBB-NEXT:    [[CAST_I:%.*]] = trunc i64 [[TMP0]] to i32
// RV64ZBB-NEXT:    ret i32 [[CAST_I]]
//
unsigned int ctz_64(uint64_t a) {
  return __riscv_ctz_64(a);
}
#endif

// RV32ZBB-LABEL: @cpop_32(
// RV32ZBB-NEXT:  entry:
// RV32ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.ctpop.i32(i32 [[A:%.*]])
// RV32ZBB-NEXT:    ret i32 [[TMP0]]
//
// RV64ZBB-LABEL: @cpop_32(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i32 @llvm.ctpop.i32(i32 [[A:%.*]])
// RV64ZBB-NEXT:    ret i32 [[TMP0]]
//
unsigned int cpop_32(uint32_t a) {
  return __riscv_cpop_32(a);
}

#if __riscv_xlen == 64
// RV64ZBB-LABEL: @cpop_64(
// RV64ZBB-NEXT:  entry:
// RV64ZBB-NEXT:    [[TMP0:%.*]] = call i64 @llvm.ctpop.i64(i64 [[A:%.*]])
// RV64ZBB-NEXT:    [[CAST_I:%.*]] = trunc i64 [[TMP0]] to i32
// RV64ZBB-NEXT:    ret i32 [[CAST_I]]
//
unsigned int cpop_64(uint64_t a) {
  return __riscv_cpop_64(a);
}
#endif
