/// Assert the fixed point precision macros according to ISO/IEC TR 18037:2008 7.18a.3 are
/// defined when -ffixed-point is provided.

// RUN: %clang_cc1 -triple=x86_64 -E -dM -ffixed-point -x c < /dev/null | FileCheck -match-full-lines %s
// RUN: %clang_cc1 -triple=x86_64 -E -dM -ffixed-point -x c++ < /dev/null | FileCheck -match-full-lines %s

/// These are the implementation-defined values for x86_64.
// CHECK-DAG:#define __SFRACT_EPSILON__ 0.0078125HR
// CHECK-DAG:#define __SFRACT_FBIT__ 7
// CHECK-DAG:#define __SFRACT_MAX__ 0.9921875HR
// CHECK-DAG:#define __SFRACT_MIN__ (-0.5HR-0.5HR)

// CHECK-DAG:#define __USFRACT_EPSILON__ 0.00390625UHR
// CHECK-DAG:#define __USFRACT_FBIT__ 8
// CHECK-DAG:#define __USFRACT_MAX__ 0.99609375UHR

// CHECK-DAG:#define __FRACT_EPSILON__ 0.000030517578125R
// CHECK-DAG:#define __FRACT_FBIT__ 15
// CHECK-DAG:#define __FRACT_MAX__ 0.999969482421875R
// CHECK-DAG:#define __FRACT_MIN__ (-0.5R-0.5R)

// CHECK-DAG:#define __UFRACT_EPSILON__ 0.0000152587890625UR
// CHECK-DAG:#define __UFRACT_FBIT__ 16
// CHECK-DAG:#define __UFRACT_MAX__ 0.9999847412109375UR

// CHECK-DAG:#define __LFRACT_EPSILON__ 0.0000000004656612873077392578125LR
// CHECK-DAG:#define __LFRACT_FBIT__ 31
// CHECK-DAG:#define __LFRACT_MAX__ 0.9999999995343387126922607421875LR
// CHECK-DAG:#define __LFRACT_MIN__ (-0.5LR-0.5LR)

// CHECK-DAG:#define __ULFRACT_EPSILON__ 0.00000000023283064365386962890625ULR
// CHECK-DAG:#define __ULFRACT_FBIT__ 32
// CHECK-DAG:#define __ULFRACT_MAX__ 0.99999999976716935634613037109375ULR

// CHECK-DAG:#define __SACCUM_EPSILON__ 0.0078125HK
// CHECK-DAG:#define __SACCUM_FBIT__ 7
// CHECK-DAG:#define __SACCUM_MAX__ 255.9921875HK
// CHECK-DAG:#define __SACCUM_MIN__ (-128.0HK-128.0HK)

// CHECK-DAG:#define __USACCUM_EPSILON__ 0.00390625UHK
// CHECK-DAG:#define __USACCUM_FBIT__ 8
// CHECK-DAG:#define __USACCUM_MAX__ 255.99609375UHK

// CHECK-DAG:#define __ACCUM_EPSILON__ 0.000030517578125K
// CHECK-DAG:#define __ACCUM_FBIT__ 15
// CHECK-DAG:#define __ACCUM_MAX__ 65535.999969482421875K
// CHECK-DAG:#define __ACCUM_MIN__ (-32768.0K-32768.0K)

// CHECK-DAG:#define __UACCUM_EPSILON__ 0.0000152587890625UK
// CHECK-DAG:#define __UACCUM_FBIT__ 16
// CHECK-DAG:#define __UACCUM_MAX__ 65535.9999847412109375UK

// CHECK-DAG:#define __LACCUM_EPSILON__ 0.0000000004656612873077392578125LK
// CHECK-DAG:#define __LACCUM_FBIT__ 31
// CHECK-DAG:#define __LACCUM_MAX__ 4294967295.9999999995343387126922607421875LK
// CHECK-DAG:#define __LACCUM_MIN__ (-2147483648.0LK-2147483648.0LK)

// CHECK-DAG:#define __ULACCUM_EPSILON__ 0.00000000023283064365386962890625ULK
// CHECK-DAG:#define __ULACCUM_FBIT__ 32
// CHECK-DAG:#define __ULACCUM_MAX__ 4294967295.99999999976716935634613037109375ULK

// CHECK-DAG:#define __SACCUM_IBIT__ 8
// CHECK-DAG:#define __USACCUM_IBIT__ 8
// CHECK-DAG:#define __ACCUM_IBIT__ 16
// CHECK-DAG:#define __UACCUM_IBIT__ 16
// CHECK-DAG:#define __LACCUM_IBIT__ 32
// CHECK-DAG:#define __ULACCUM_IBIT__ 32
