/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import java.util.Objects;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.sdkman.Sdkman;
import org.jreleaser.sdk.sdkman.SdkmanCommand;
import org.jreleaser.util.StringUtils;

abstract class AbstractSdkmanCommand
implements SdkmanCommand {
    protected final boolean dryrun;
    protected final String candidate;
    protected final String version;
    protected final Sdkman sdkman;

    protected AbstractSdkmanCommand(JReleaserContext context, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String candidate, String version, boolean dryrun) {
        this.sdkman = new Sdkman(context, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, dryrun);
        this.candidate = candidate;
        this.version = version;
        this.dryrun = dryrun;
    }

    static class Builder<S extends Builder<S>> {
        protected final JReleaserContext context;
        protected boolean dryrun;
        protected boolean skipAnnounce;
        protected String consumerKey;
        protected String consumerToken;
        protected String candidate;
        protected String version;
        protected String apiHost = "https://vendors.sdkman.io";
        protected int connectTimeout = 20;
        protected int readTimeout = 60;

        protected Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        protected final S self() {
            return (S)this;
        }

        public S dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this.self();
        }

        public S skipAnnounce(boolean skipAnnounce) {
            this.skipAnnounce = skipAnnounce;
            return this.self();
        }

        public S consumerKey(String consumerKey) {
            this.consumerKey = StringUtils.requireNonBlank((String)consumerKey, (String)"'consumerKey' must not be blank").trim();
            return this.self();
        }

        public S consumerToken(String consumerToken) {
            this.consumerToken = StringUtils.requireNonBlank((String)consumerToken, (String)"'consumerToken' must not be blank").trim();
            return this.self();
        }

        public S candidate(String candidate) {
            this.candidate = StringUtils.requireNonBlank((String)candidate, (String)"'candidate' must not be blank").trim();
            return this.self();
        }

        public S version(String version) {
            this.version = StringUtils.requireNonBlank((String)version, (String)"'version' must not be blank").trim();
            return this.self();
        }

        public S apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this.self();
        }

        public S connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public S readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }
    }
}

