/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.engine.context.ModelConfigurer;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.util.PlatformUtils;

public final class ContextCreator {
    private ContextCreator() {
    }

    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, JReleaserCommand command, Path configFile, Path basedir, Path settings, Path outputDirectory, boolean yolo, boolean dryrun, boolean gitRootSearch, boolean strict, List<String> selectedPlatforms, List<String> rejectedPlatforms) {
        return ContextCreator.create(logger, configurer, mode, command, ContextCreator.resolveModel(logger, configFile), basedir, settings, outputDirectory, yolo, dryrun, gitRootSearch, strict, selectedPlatforms, rejectedPlatforms);
    }

    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, JReleaserCommand command, JReleaserModel model, Path basedir, Path settings, Path outputDirectory, boolean yolo, boolean dryrun, boolean gitRootSearch, boolean strict, List<String> selectedPlatforms, List<String> rejectedPlatforms) {
        JReleaserContext context = new JReleaserContext(logger, configurer, mode, command, model, basedir, settings, outputDirectory, yolo, dryrun, gitRootSearch, strict, selectedPlatforms, rejectedPlatforms);
        PlatformUtils.resolveCurrentPlatform((JReleaserLogger)logger);
        logger.info(RB.$((String)"context.creator.git_root_search", (Object[])new Object[]{context.isGitRootSearch()}));
        ModelConfigurer.configure(context);
        return context;
    }

    public static JReleaserModel resolveModel(JReleaserLogger logger, Path configFile) {
        try {
            logger.info(RB.$((String)"context.creator.reading_configuration", (Object[])new Object[0]));
            return JReleaserConfigLoader.loadConfig((Path)configFile);
        }
        catch (JReleaserException e) {
            logger.trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_creator_parse_configuration", (Object[])new Object[]{configFile.toAbsolutePath()}), (Throwable)e);
        }
    }
}

