/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mastodon;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.List;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.mastodon.MastodonException;
import org.jreleaser.sdk.mastodon.api.MastodonAPI;
import org.jreleaser.sdk.mastodon.api.Status;
import org.jreleaser.util.StringUtils;

public class MastodonSdk {
    private static final String API_V1 = "/api/v1";
    private final JReleaserContext context;
    private final MastodonAPI api;
    private final boolean dryrun;

    private MastodonSdk(JReleaserContext context, String host, String accessToken, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank");
        if (!host.endsWith(API_V1)) {
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            host = host + API_V1;
        }
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.dryrun = dryrun;
        this.api = (MastodonAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", accessToken)})).target(MastodonAPI.class, host);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void toot(List<String> statuses) throws MastodonException {
        this.wrap(() -> {
            Status status = this.api.status(Status.of((String)statuses.get(0)));
            for (int i = 1; i < statuses.size(); ++i) {
                status = this.api.status(Status.of((String)statuses.get(i), status.getId()));
            }
        });
    }

    private void wrap(Runnable runnable) throws MastodonException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new MastodonException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Mastodon"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String accessToken;
        private String host;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank").trim();
            return this;
        }

        public Builder host(String host) {
            this.host = StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.accessToken, (String)"'accessToken' must not be blank");
        }

        public MastodonSdk build() {
            this.validate();
            return new MastodonSdk(this.context, this.host, this.accessToken, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

