/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.DebAssembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.assemble.ArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JavaArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JlinkAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.NativeImageAssemblerResolver;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class DebAssemblerResolver {
    private DebAssemblerResolver() {
    }

    public static void resolveDebOutputs(JReleaserContext context, Errors errors) {
        List<DebAssembler> activeDebs = context.getModel().getAssemble().getActiveDebs();
        if (!activeDebs.isEmpty()) {
            context.getLogger().debug("assemble.deb");
        }
        for (DebAssembler deb : activeDebs) {
            if (!deb.isExported()) continue;
            DebAssemblerResolver.resolveDebOutputs(context, deb, errors);
        }
    }

    private static void resolveDebOutputs(JReleaserContext context, DebAssembler assembler, Errors errors) {
        if (!assembler.isEnabled() || !context.isDistributionSelected(assembler.getName())) {
            return;
        }
        Path assembleDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String assemblerRef = assembler.getAssemblerRef();
        if (StringUtils.isNotBlank((String)assemblerRef)) {
            Assembler<?> assemblerReference = DebAssemblerResolver.resolveAssemblerReference(context, assemblerRef.trim(), errors);
            for (Artifact artifact : assemblerReference.getOutputs()) {
                DebAssemblerResolver.resolveDebianArtifact(context, assembleDirectory, assembler, artifact, errors);
            }
        } else {
            DebAssemblerResolver.resolveDebianArtifact(context, assembleDirectory, assembler, null, errors);
        }
    }

    private static Assembler<?> resolveAssemblerReference(JReleaserContext context, String assemblerName, Errors errors) {
        Assembler<?> assemblerReference = context.getModel().getAssemble().findAssembler(assemblerName);
        if (assemblerReference instanceof ArchiveAssembler) {
            ArchiveAssemblerResolver.resolveArchiveOutputs(context, (ArchiveAssembler)assemblerReference, errors);
        } else if (assemblerReference instanceof JavaArchiveAssembler) {
            JavaArchiveAssemblerResolver.resolveJavaArchiveOutputs(context, (JavaArchiveAssembler)assemblerReference, errors);
        } else if (assemblerReference instanceof JlinkAssembler) {
            JlinkAssemblerResolver.resolveJlinkOutputs(context, (JlinkAssembler)assemblerReference, errors);
        } else if (assemblerReference instanceof NativeImageAssembler) {
            NativeImageAssemblerResolver.resolveNativeImageOutputs(context, (NativeImageAssembler)assemblerReference, errors);
        }
        return assemblerReference;
    }

    private static void resolveDebianArtifact(JReleaserContext context, Path assembleDirectory, DebAssembler assembler, Artifact artifact, Errors errors) {
        Path path;
        String architecture = StringUtils.isNotBlank((String)assembler.getArchitecture()) ? assembler.getArchitecture().trim() : "all";
        String platform = "";
        if (null != artifact) {
            platform = artifact.getPlatform();
            if (StringUtils.isBlank((String)platform)) {
                architecture = "all";
            } else if (PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform)) {
                architecture = "amd64";
            } else if (PlatformUtils.isLinux((String)platform) && PlatformUtils.isArm64((String)platform)) {
                architecture = "arm64";
            } else {
                return;
            }
        }
        if (!Files.exists(path = assembleDirectory.resolve(assembler.getControl().getPackageName() + "-" + assembler.getControl().getPackageVersion() + "-" + assembler.getControl().getPackageRevision() + "_" + architecture + ".deb"), new LinkOption[0])) {
            errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
            errors.assembly(context.relativizeToBasedir(path.toAbsolutePath()).toString());
        } else {
            Artifact a = Artifact.of(path, platform);
            a.resolveActiveAndSelected(context);
            a.setExtraProperties(assembler.getExtraProperties());
            assembler.addOutput(a);
        }
    }
}

