/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class ArchiveAssemblerResolver {
    private ArchiveAssemblerResolver() {
    }

    public static void resolveArchiveOutputs(JReleaserContext context, Errors errors) {
        List<ArchiveAssembler> activeArchives = context.getModel().getAssemble().getActiveArchives();
        if (!activeArchives.isEmpty()) {
            context.getLogger().debug("assemble.archive");
        }
        for (ArchiveAssembler archive : activeArchives) {
            if (!archive.isExported()) continue;
            ArchiveAssemblerResolver.resolveArchiveOutputs(context, archive, errors);
        }
    }

    public static void resolveArchiveOutputs(JReleaserContext context, ArchiveAssembler assembler, Errors errors) {
        if (!assembler.isEnabled() || !context.isDistributionSelected(assembler.getName())) {
            return;
        }
        if (!assembler.getMatrix().isEmpty()) {
            for (Map<String, String> matrixRow : assembler.getMatrix().resolve()) {
                if (matrixRow.containsKey("platform")) {
                    String srcPlatform = matrixRow.get("platform");
                    if (!context.isPlatformSelected(srcPlatform, assembler.getPlatform())) continue;
                    ArchiveAssemblerResolver.resolveArchiveOutput(context, assembler, matrixRow, srcPlatform, errors);
                    continue;
                }
                ArchiveAssemblerResolver.resolveArchiveOutput(context, assembler, matrixRow, assembler.isAttachPlatform() ? PlatformUtils.getCurrentFull() : "", errors);
            }
        } else {
            ArchiveAssemblerResolver.resolveArchiveOutput(context, assembler, Collections.emptyMap(), assembler.isAttachPlatform() ? PlatformUtils.getCurrentFull() : "", errors);
        }
    }

    private static void resolveArchiveOutput(JReleaserContext context, ArchiveAssembler assembler, Map<String, String> matrix, String platform, Errors errors) {
        if (assembler.isAttachPlatform() && !context.isPlatformSelected(PlatformUtils.getCurrentFull())) {
            return;
        }
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String archiveName = assembler.getResolvedArchiveName(context, matrix);
        for (Archive.Format format : assembler.getFormats()) {
            String skipKey = "skip" + StringUtils.capitalize((String)format.formatted());
            if (assembler.extraPropertyIsTrue(skipKey) || StringUtils.isTrue((Object)matrix.get(skipKey))) continue;
            Path path = baseOutputDirectory.resolve(archiveName + "." + format.extension()).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                errors.assembly(context.relativizeToBasedir(path.toAbsolutePath()).toString());
                continue;
            }
            Artifact artifact = Artifact.of(path, platform);
            artifact.resolveActiveAndSelected(context);
            artifact.setExtraProperties(assembler.getExtraProperties());
            matrix.keySet().stream().filter(k -> k.startsWith("skip")).forEach(k -> artifact.addExtraProperty((String)k, matrix.get(k)));
            assembler.addOutput(artifact);
        }
    }
}

