/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog.swid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.catalog.swid.Entity;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;

public class SwidTag
extends AbstractActivatable<SwidTag>
implements Domain {
    private static final long serialVersionUID = -5231801224571096074L;
    private final Set<Entity> entities = new TreeSet<Entity>();
    private String tagRef;
    private String name;
    private String path;
    private String tagId;
    private Integer tagVersion;
    private String lang;
    private Boolean corpus;
    private Boolean patch;
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.swid.SwidTag immutable = new org.jreleaser.model.api.catalog.swid.SwidTag(){
        private static final long serialVersionUID = -566446887267136193L;
        private Set<? extends org.jreleaser.model.api.catalog.swid.Entity> entities;

        public String getTagRef() {
            return SwidTag.this.tagRef;
        }

        public String getName() {
            return SwidTag.this.name;
        }

        public String getPath() {
            return SwidTag.this.path;
        }

        public String getTagId() {
            return SwidTag.this.tagId;
        }

        public Integer getTagVersion() {
            return SwidTag.this.tagVersion;
        }

        public String getLang() {
            return SwidTag.this.lang;
        }

        public Set<? extends org.jreleaser.model.api.catalog.swid.Entity> getEntities() {
            if (null == this.entities) {
                this.entities = SwidTag.this.entities.stream().map(Entity::asImmutable).collect(Collectors.toSet());
            }
            return this.entities;
        }

        public boolean isCorpus() {
            return SwidTag.this.isCorpus();
        }

        public boolean isPatch() {
            return SwidTag.this.isPatch();
        }

        public Active getActive() {
            return SwidTag.this.getActive();
        }

        public boolean isEnabled() {
            return SwidTag.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return SwidTag.this.asMap(full);
        }
    };

    public org.jreleaser.model.api.catalog.swid.SwidTag asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SwidTag source) {
        super.merge(source);
        this.tagRef = this.merge(this.tagRef, source.tagRef);
        this.name = this.merge(this.name, source.name);
        this.path = this.merge(this.path, source.path);
        this.tagId = this.merge(this.tagId, source.tagId);
        this.tagVersion = this.merge(this.tagVersion, source.tagVersion);
        this.lang = this.merge(this.lang, source.lang);
        this.corpus = this.merge(this.corpus, source.corpus);
        this.patch = this.merge(this.patch, source.patch);
        this.setEntities(this.merge(this.entities, source.entities));
    }

    public void copyFrom(SwidTag other) {
        if (null == other) {
            return;
        }
        this.setActive(this.merge(other.getActive(), this.getActive()));
        this.setName(this.merge(other.getName(), this.getName()));
        this.setPath(this.merge(other.getPath(), this.getPath()));
        this.setTagId(this.merge(other.getTagId(), this.getTagId()));
        this.setTagVersion(this.merge(other.getTagVersion(), this.getTagVersion()));
        this.setLang(this.merge(other.getLang(), this.getLang()));
        this.setCorpus(this.merge(other.getCorpus(), this.getCorpus()));
        this.setPatch(this.merge(other.getPatch(), this.getPatch()));
        this.setEntities(this.merge(other.getEntities(), this.getEntities()));
    }

    public String getTagRef() {
        return this.tagRef;
    }

    public void setTagRef(String tagRef) {
        this.tagRef = tagRef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTagId() {
        return this.tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public Integer getTagVersion() {
        return this.tagVersion;
    }

    public void setTagVersion(Integer tagVersion) {
        this.tagVersion = tagVersion;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Boolean getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Boolean corpus) {
        this.corpus = corpus;
    }

    public Boolean getPatch() {
        return this.patch;
    }

    public void setPatch(Boolean patch) {
        this.patch = patch;
    }

    public Set<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Set<Entity> entities) {
        this.entities.clear();
        this.entities.addAll(entities);
    }

    public void addEntity(Entity entity) {
        if (null != entity) {
            this.entities.add(entity);
        }
    }

    public boolean isCorpus() {
        return null != this.corpus && this.corpus != false;
    }

    public boolean isPatch() {
        return null != this.patch && this.patch != false;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("tagRef", this.tagRef);
        props.put("name", this.name);
        props.put("path", this.path);
        props.put("tagId", this.tagId);
        props.put("tagVersion", this.tagVersion);
        props.put("lang", this.lang);
        props.put("corpus", this.isCorpus());
        props.put("patch", this.isPatch());
        LinkedHashMap<String, Map<String, Object>> mappedEntities = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Entity entity : this.entities) {
            mappedEntities.put("entity " + i++, entity.asMap(full));
        }
        props.put("entities", mappedEntities);
        return props;
    }
}

