/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.release.AbstractReleaser;
import org.jreleaser.sdk.gitea.Gitea;
import org.jreleaser.sdk.gitea.api.GtAsset;
import org.jreleaser.sdk.gitea.api.GtIssue;
import org.jreleaser.sdk.gitea.api.GtLabel;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.util.StringUtils;

public class GiteaReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.GiteaReleaser> {
    private static final long serialVersionUID = -8160459963248847787L;
    private final org.jreleaser.model.internal.release.GiteaReleaser gitea;

    public GiteaReleaser(JReleaserContext context, Set<Asset> assets) {
        super(context, assets);
        this.gitea = context.getModel().getRelease().getGitea();
    }

    public org.jreleaser.model.api.release.GiteaReleaser getReleaser() {
        return this.gitea.asImmutable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        String pullBranch = this.gitea.getBranch();
        String pushBranch = this.gitea.getResolvedBranchPush(this.context.getModel());
        boolean mustCheckoutBranch = !pushBranch.equals(pullBranch);
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.gitea.getResolvedRepoUrl(this.context.getModel()), pushBranch});
        String tagName = this.gitea.getEffectiveTagName(this.context.getModel());
        try {
            Gitea api = new Gitea(this.context.asImmutable(), this.gitea.getApiEndpoint(), this.gitea.getToken(), this.gitea.getConnectTimeout(), this.gitea.getReadTimeout());
            if (!this.context.isDryrun()) {
                List<String> branchNames = api.listBranches(this.gitea.getOwner(), this.gitea.getName());
                if (mustCheckoutBranch) {
                    GitSdk.of((JReleaserContext)this.context).checkoutBranch((BaseReleaser)this.gitea, pushBranch, !branchNames.contains(pushBranch));
                }
            }
            String changelog = this.context.getChangelog().getResolvedChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.gitea.getCanonicalRepoName()});
            GtRelease release = this.findReleaseByTag(api, tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.gitea.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.gitea.getOwner(), this.gitea.getName(), tagName, release.getId());
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.gitea.isMatch());
                    return;
                }
                if (this.gitea.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    GtRelease updater = new GtRelease();
                    if (this.gitea.getPrerelease().isEnabledSet()) {
                        updater.setPrerelease(this.gitea.getPrerelease().isEnabled());
                    }
                    if (this.gitea.isDraftSet()) {
                        updater.setDraft(this.gitea.isDraft());
                    }
                    if (this.gitea.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.gitea.getEffectiveReleaseName()});
                        updater.setName(this.gitea.getEffectiveReleaseName());
                    }
                    if (this.gitea.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setBody(changelog);
                    }
                    api.updateRelease(this.gitea.getOwner(), this.gitea.getName(), release.getId(), updater);
                    if (this.gitea.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.updateIssues(this.gitea, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{StringUtils.capitalize((String)this.gitea.getServiceName()), tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.gitea.isMatch());
            return;
        }
        catch (IOException | IllegalStateException | RestAPIException e) {
            this.context.getLogger().trace(e);
            throw new ReleaseException(e);
        }
    }

    private GtRelease findReleaseByTag(Gitea api, String tagName) {
        if (this.context.isDryrun()) {
            return null;
        }
        return api.findReleaseByTag(this.gitea.getOwner(), this.gitea.getName(), tagName);
    }

    protected Repository.Kind resolveRepositoryKind() {
        return Repository.Kind.OTHER;
    }

    public Repository maybeCreateRepository(String owner, String repo, String password, ExtraProperties extraProperties) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Gitea api = new Gitea(this.context.asImmutable(), this.gitea.getApiEndpoint(), password, this.gitea.getConnectTimeout(), this.gitea.getReadTimeout());
        GtRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(this.resolveRepositoryKind(), owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        try {
            String host = this.gitea.getHost();
            String endpoint = this.gitea.getApiEndpoint();
            host = endpoint.startsWith("https") ? "https://" + host : "http://" + host;
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            return new Gitea(this.context.asImmutable(), this.gitea.getApiEndpoint(), this.gitea.getToken(), this.gitea.getConnectTimeout(), this.gitea.getReadTimeout()).findUser(email, name, host);
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        Gitea api = new Gitea(this.context.asImmutable(), this.gitea.getApiEndpoint(), this.gitea.getToken(), this.gitea.getConnectTimeout(), this.gitea.getReadTimeout());
        List<Release> releases = api.listReleases(owner, repo);
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Gitea api, String tagName, String changelog, boolean deleteTags) throws IOException {
        if (this.context.isDryrun()) {
            for (Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            this.updateIssues(this.gitea, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, this.gitea.getOwner(), this.gitea.getName(), tagName);
        }
        if (deleteTags || !this.gitea.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName, this.context.getModel().getCommit().getShortHash()});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GtRelease release = new GtRelease();
        release.setName(this.gitea.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(this.gitea.getResolvedBranchPush(this.context.getModel()));
        release.setBody(changelog);
        if (this.gitea.getPrerelease().isEnabledSet()) {
            release.setPrerelease(this.gitea.getPrerelease().isEnabled());
        }
        if (this.gitea.isDraftSet()) {
            release.setDraft(this.gitea.isDraft());
        }
        release = api.createRelease(this.gitea.getOwner(), this.gitea.getName(), release);
        api.uploadAssets(this.gitea.getOwner(), this.gitea.getName(), release, this.assets);
        if (this.gitea.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot()) {
            Optional<GtMilestone> milestone = api.findMilestoneByName(this.gitea.getOwner(), this.gitea.getName(), this.gitea.getMilestone().getEffectiveName());
            milestone.ifPresent(gtMilestone -> api.closeMilestone(this.gitea.getOwner(), this.gitea.getName(), (GtMilestone)gtMilestone));
        }
        this.updateIssues(this.gitea, api);
    }

    private void updateIssues(org.jreleaser.model.internal.release.GiteaReleaser gitea, Gitea api) throws IOException {
        if (!gitea.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        String tagName = gitea.getEffectiveTagName(this.context.getModel());
        String labelName = gitea.getIssues().getLabel().getName();
        String labelColor = gitea.getIssues().getLabel().getColor();
        TemplateContext props = gitea.props(this.context.getModel());
        gitea.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)gitea.getIssues().getComment(), (TemplateContext)props);
        if (labelColor.startsWith("#")) {
            labelColor = labelColor.substring(1);
        }
        GtLabel gtLabel = null;
        try {
            gtLabel = api.getOrCreateLabel(gitea.getOwner(), gitea.getName(), labelName, labelColor, gitea.getIssues().getLabel().getDescription());
        }
        catch (RestAPIException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = gitea.getIssues().getApplyMilestone();
        if (gitea.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(gitea.getOwner(), gitea.getName(), gitea.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(gitea.getOwner(), gitea.getName(), gitea.getMilestone().getEffectiveName());
        }
        for (String issueNumber : issueNumbers) {
            GtIssue gtIssue;
            Optional<GtIssue> op = api.findIssue(gitea.getOwner(), gitea.getName(), Integer.parseInt(issueNumber));
            if (!op.isPresent() || !"closed".equals((gtIssue = op.get()).getState()) || !gtIssue.getLabels().stream().noneMatch(l -> l.getName().equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            api.addLabelToIssue(gitea.getOwner(), gitea.getName(), gtIssue, gtLabel);
            api.commentOnIssue(gitea.getOwner(), gitea.getName(), gtIssue, comment);
            milestone.ifPresent(gtMilestone -> this.applyMilestone(gitea, api, issueNumber, gtIssue, applyMilestone, (GtMilestone)gtMilestone));
        }
    }

    private void applyMilestone(org.jreleaser.model.internal.release.GiteaReleaser gitea, Gitea api, String issueNumber, GtIssue gtIssue, Apply applyMilestone, GtMilestone targetMilestone) {
        GtMilestone issueMilestone = gtIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(gitea.getOwner(), gitea.getName(), gtIssue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(gitea.getOwner(), gitea.getName(), gtIssue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private void updateAssets(Gitea api, GtRelease release) throws IOException {
        TreeSet<Asset> assetsToBeUpdated = new TreeSet<Asset>();
        TreeSet<Asset> assetsToBeUploaded = new TreeSet<Asset>();
        Map<String, GtAsset> existingAssets = api.listAssets(this.gitea.getOwner(), this.gitea.getName(), release);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((Asset)assetsToBePublished.get(name));
            }
        });
        api.updateAssets(this.gitea.getOwner(), this.gitea.getName(), release, assetsToBeUpdated, existingAssets);
        api.uploadAssets(this.gitea.getOwner(), this.gitea.getName(), release, assetsToBeUploaded);
    }

    private void deleteTags(Gitea api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }
}

