/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ftp;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.net.ftp.FTPClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.download.FtpDownloader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.sdk.commons.AbstractArtifactDownloader;
import org.jreleaser.sdk.ftp.FtpUtils;
import org.jreleaser.util.StringUtils;

public class FtpArtifactDownloader
extends AbstractArtifactDownloader<FtpDownloader, org.jreleaser.model.internal.download.FtpDownloader> {
    private org.jreleaser.model.internal.download.FtpDownloader downloader;

    public FtpArtifactDownloader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.download.FtpDownloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(org.jreleaser.model.internal.download.FtpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getType() {
        return "scp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String name) throws DownloadException {
        FTPClient ftp = FtpUtils.open(this.context, this.downloader);
        try {
            for (Downloader.Asset asset : this.downloader.getAssets()) {
                this.downloadAsset(name, ftp, asset);
            }
        }
        finally {
            FtpUtils.close(this.downloader, ftp);
        }
    }

    private void downloadAsset(String name, FTPClient ftp, Downloader.Asset asset) throws DownloadException {
        String input = asset.getResolvedInput(this.context, (Downloader)this.downloader);
        String output = asset.getResolvedOutput(this.context, (Downloader)this.downloader, Paths.get(input, new String[0]).getFileName().toString());
        if (StringUtils.isBlank((String)output)) {
            output = Paths.get(input, new String[0]).getFileName().toString();
        }
        Path outputPath = this.context.getDownloadDirectory().resolve(name).resolve(output);
        this.context.getLogger().info("{} -> {}", new Object[]{input, this.context.relativizeToBasedir(outputPath)});
        if (!this.context.isDryrun()) {
            try {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
            }
            try (OutputStream out = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                Files.createDirectories(outputPath.toAbsolutePath().getParent(), new FileAttribute[0]);
                ftp.retrieveFile(input, out);
            }
            catch (IOException e) {
                throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
            }
        }
        this.unpack(asset.getUnpack(), outputPath);
    }
}

