/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.function.Function;
import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.internal.BaseCrcChecksum;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class CrcCloneOnMarkChecksum
extends BaseCrcChecksum {
    private final Function<Checksum, Checksum> cloneFunction;

    public CrcCloneOnMarkChecksum(Checksum checksum, Function<Checksum, Checksum> cloneFunction) {
        super(checksum);
        this.cloneFunction = cloneFunction;
    }

    @Override
    Checksum cloneChecksum(Checksum checksum) {
        return this.cloneFunction.apply(checksum);
    }

    @Override
    public byte[] getChecksumBytes() {
        byte[] valueBytes = NumericUtils.longToByte((Long)this.getValue());
        return new byte[]{valueBytes[4], valueBytes[5], valueBytes[6], valueBytes[7]};
    }
}

