/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RedirectionInterceptor;
import feign.Request;
import feign.Response;
import feign.ResponseInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModelPrinter;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.commons.feign.FeignLogger;
import org.jreleaser.util.IoUtils;
import org.jreleaser.util.StringUtils;

public final class ClientUtils {
    private static final Tika TIKA = new Tika();

    private ClientUtils() {
    }

    public static FormData toFormData(String fileName, String contentType, String content) {
        return ClientUtils.toFormData(fileName, contentType, content.getBytes(StandardCharsets.UTF_8));
    }

    public static FormData toFormData(String fileName, String contentType, byte[] content) {
        return FormData.builder().fileName(fileName).contentType(contentType).data(content).build();
    }

    public static FormData toFormData(Path asset) throws IOException {
        return ClientUtils.toFormData(asset.getFileName().toString(), MediaType.parse((String)TIKA.detect(asset)).toString(), Files.readAllBytes(asset));
    }

    public static Feign.Builder builder(JReleaserContext context, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(context, "'logger' must not be null");
        Feign.Builder builder = Feign.builder();
        if (Boolean.getBoolean("jreleaser.disableSslValidation")) {
            context.getLogger().warn(RB.$((String)"warn_ssl_disabled", (Object[])new Object[0]));
            builder = builder.client((Client)new Client.Default(ClientUtils.nonValidatingSSLSocketFactory(), (HostnameVerifier)new NonValidatingHostnameVerifier()));
        }
        return ((Feign.Builder)builder.logger((Logger)new FeignLogger(context.getLogger())).logLevel(FeignLogger.resolveLevel(context)).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).decoder((Decoder)new JacksonDecoder()).responseInterceptor((ResponseInterceptor)new RedirectionInterceptor())).requestInterceptor(template -> template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()})).errorDecoder((methodKey, response) -> new RestAPIException(response.request(), response.status(), response.reason(), ClientUtils.toString(context.getLogger(), response.body()), response.headers())).options(new Request.Options((long)connectTimeout, TimeUnit.SECONDS, (long)readTimeout, TimeUnit.SECONDS, true));
    }

    private static String toString(JReleaserLogger logger, Response.Body body) {
        String string;
        block9: {
            if (null == body) {
                return "";
            }
            Reader reader = body.asReader(StandardCharsets.UTF_8);
            try {
                string = IOUtils.toString((Reader)reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.trace((Throwable)e);
                    return "";
                }
            }
            reader.close();
        }
        return string;
    }

    public static void webhook(JReleaserLogger logger, String webhookUrl, int connectTimeout, int readTimeout, Object message) throws AnnounceException {
        if (message instanceof String) {
            ClientUtils.webhook(logger, webhookUrl, connectTimeout, readTimeout, (String)message);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ClientUtils.webhook(logger, webhookUrl, connectTimeout, readTimeout, objectMapper.writeValueAsString(message));
        }
        catch (JsonProcessingException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    public static void webhook(JReleaserLogger logger, String webhookUrl, int connectTimeout, int readTimeout, String message) throws AnnounceException {
        ClientUtils.post(logger, webhookUrl, connectTimeout, readTimeout, message, Collections.emptyMap());
    }

    public static void post(JReleaserLogger logger, String theUrl, int connectTimeout, int readTimeout, String message, Map<String, String> headers) throws AnnounceException {
        block17: {
            try {
                URL url = new URI(theUrl).toURL();
                logger.debug(RB.$((String)"webhook.connection.open", (Object[])new Object[0]));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                logger.debug(RB.$((String)"webhook.connection.configure", (Object[])new Object[0]));
                connection.setConnectTimeout(connectTimeout * 1000);
                connection.setReadTimeout(readTimeout * 1000);
                connection.setAllowUserInteraction(false);
                connection.setInstanceFollowRedirects(true);
                connection.setRequestMethod("POST");
                connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
                connection.addRequestProperty("Content-Type", "application/json");
                connection.addRequestProperty("Accept", "application/json");
                headers.forEach(connection::addRequestProperty);
                connection.setDoOutput(true);
                logger.debug(RB.$((String)"webhook.message.send", (Object[])new Object[0]));
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = message.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                logger.debug(RB.$((String)"webhook.response.handle", (Object[])new Object[0]));
                int status = connection.getResponseCode();
                if (status < 400) break block17;
                String reason = connection.getResponseMessage();
                StringBuilder b = new StringBuilder("Webhook replied with: ").append(status);
                if (StringUtils.isNotBlank((String)reason)) {
                    b.append(" reason: ").append(reason);
                }
                try (Reader reader = IoUtils.newInputStreamReader((InputStream)connection.getErrorStream());){
                    message = IOUtils.toString((Reader)reader);
                    if (StringUtils.isNotBlank((String)message)) {
                        b.append(",").append(message);
                    }
                }
                throw new AnnounceException(b.toString());
            }
            catch (IOException | URISyntaxException e) {
                logger.trace((Throwable)e);
                throw new AnnounceException((Throwable)e);
            }
        }
    }

    public static Reader postFile(JReleaserLogger logger, URI uri, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        headers.put("METHOD", "POST");
        return ClientUtils.uploadFile(logger, uri, connectTimeout, readTimeout, data, headers);
    }

    public static Reader postFile(JReleaserLogger logger, String url, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        headers.put("METHOD", "POST");
        try {
            return ClientUtils.uploadFile(logger, new URI(url), connectTimeout, readTimeout, data, headers);
        }
        catch (URISyntaxException e) {
            logger.trace((Throwable)e);
            throw new UploadException((Throwable)e);
        }
    }

    public static Reader putFile(JReleaserLogger logger, String url, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        headers.put("METHOD", "PUT");
        headers.put("Expect", "100-continue");
        try {
            return ClientUtils.uploadFile(logger, new URI(url), connectTimeout, readTimeout, data, headers);
        }
        catch (URISyntaxException e) {
            logger.trace((Throwable)e);
            throw new UploadException((Throwable)e);
        }
    }

    private static Reader uploadFile(JReleaserLogger logger, URI uri, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        try {
            URL theUrl = uri.toURL();
            logger.debug("url: {}", new Object[]{theUrl});
            logger.debug(RB.$((String)"webhook.connection.open", (Object[])new Object[0]));
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            logger.debug(RB.$((String)"webhook.connection.configure", (Object[])new Object[0]));
            connection.setConnectTimeout(connectTimeout * 1000);
            connection.setReadTimeout(readTimeout * 1000);
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(headers.remove("METHOD"));
            if (!headers.containsKey("Accept")) {
                connection.addRequestProperty("Accept", "*/*");
            }
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            connection.addRequestProperty("Content-Length", data.getData().length + "");
            connection.setRequestProperty("Content-Type", data.getContentType());
            headers.forEach(connection::setRequestProperty);
            connection.getRequestProperties().forEach((k, v) -> {
                if (JReleaserModelPrinter.isSecret((String)k)) {
                    logger.debug("{}: {}", new Object[]{k, "************"});
                } else {
                    logger.debug("{}: {}", new Object[]{k, v});
                }
            });
            connection.setDoOutput(true);
            logger.debug(RB.$((String)"webhook.data.send", (Object[])new Object[0]));
            try (OutputStream os = connection.getOutputStream();){
                os.write(data.getData(), 0, data.getData().length);
                os.flush();
            }
            logger.debug(RB.$((String)"webhook.response.handle", (Object[])new Object[0]));
            int status = connection.getResponseCode();
            if (status >= 400) {
                String reason = connection.getResponseMessage();
                StringBuilder b = new StringBuilder("Got ").append(status);
                if (StringUtils.isNotBlank((String)reason)) {
                    b.append(" reason: ").append(reason);
                }
                logger.trace(RB.$((String)"webhook.server.reply", (Object[])new Object[]{status, reason}));
                try (Reader reader = IoUtils.newInputStreamReader((InputStream)connection.getErrorStream());){
                    String message = IOUtils.toString((Reader)reader);
                    if (StringUtils.isNotBlank((String)message)) {
                        b.append(", ").append(message);
                    }
                }
                throw new UploadException(b.toString());
            }
            return IoUtils.newInputStreamReader((InputStream)connection.getInputStream());
        }
        catch (IOException e) {
            logger.trace((Throwable)e);
            throw new UploadException((Throwable)e);
        }
    }

    public static boolean head(JReleaserLogger logger, String theUrl, int connectTimeout, int readTimeout) throws RestAPIException {
        try {
            URL url = new URI(theUrl).toURL();
            logger.debug(RB.$((String)"webhook.connection.open", (Object[])new Object[0]));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            logger.debug(RB.$((String)"webhook.connection.configure", (Object[])new Object[0]));
            connection.setConnectTimeout(connectTimeout * 1000);
            connection.setReadTimeout(readTimeout * 1000);
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("HEAD");
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            logger.debug(RB.$((String)"webhook.response.handle", (Object[])new Object[0]));
            int status = connection.getResponseCode();
            if (status == 200) {
                return true;
            }
            if (status == 404) {
                return false;
            }
            String reason = connection.getResponseMessage();
            StringBuilder b = new StringBuilder("Request replied with: ").append(status);
            if (StringUtils.isNotBlank((String)reason)) {
                b.append(" reason: ").append(reason);
            }
            throw new RestAPIException(status, b.toString());
        }
        catch (IOException | URISyntaxException e) {
            logger.trace((Throwable)e);
            throw new RestAPIException(500, (Throwable)e);
        }
    }

    private static SSLSocketFactory nonValidatingSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new NonValidatingTrustManager()}, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class NonValidatingHostnameVerifier
    implements HostnameVerifier {
        private NonValidatingHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class NonValidatingTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];

        private NonValidatingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_CERTIFICATES;
        }
    }
}

