/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.catalog.sbom;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.Sbom;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.catalog.sbom.CyclonedxSbomCatalogerValidator;
import org.jreleaser.model.internal.validation.catalog.sbom.SyftSbomCatalogerValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SbomCatalogersValidator {
    private SbomCatalogersValidator() {
    }

    public static void validateSbomCatalogers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Sbom sbom = context.getModel().getCatalog().getSbom();
        context.getLogger().debug("catalog.sbom");
        CyclonedxSbomCatalogerValidator.validateCyclonedxSbomCataloger(context, sbom.getCyclonedx(), errors);
        SyftSbomCatalogerValidator.validateSyftSbomCataloger(context, sbom.getSyft(), errors);
        if (mode.validateConfig()) {
            boolean activeSet = sbom.isActiveSet();
            Validator.resolveActivatable(context, (Activatable)sbom, "catalog.sbom", "ALWAYS");
            sbom.resolveEnabledWithSnapshot(context.getModel().getProject());
            if (sbom.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = sbom.getCyclonedx().isEnabled() || sbom.getSyft().isEnabled();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    sbom.disable();
                }
            }
        }
    }

    static void validateSbomCataloger(JReleaserContext context, SbomCataloger<?> sbomCataloger, Errors errors) {
        context.getLogger().debug("catalog.sbom.{}", new Object[]{sbomCataloger.getType()});
        Validator.resolveActivatable(context, sbomCataloger, "catalog.sbom." + sbomCataloger.getType(), "NEVER");
        if (!sbomCataloger.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!sbomCataloger.isDistributionsSet()) {
            sbomCataloger.setDistributions(true);
        }
        if (!sbomCataloger.isFilesSet()) {
            sbomCataloger.setFiles(true);
        }
        if (!sbomCataloger.isDistributions() && !sbomCataloger.isFiles()) {
            sbomCataloger.disable();
        }
        if (StringUtils.isBlank((String)sbomCataloger.getPack().getName())) {
            sbomCataloger.getPack().setName("{{projectName}}-{{projectVersion}}-sboms");
        }
    }
}

