# Hatch

<div class="grid" markdown>

![Hatch logo](assets/images/logo.svg){ role="img" }

| | |
| --- | --- |
| CI/CD | [![CI - Test](https://github.com/pypa/hatch/actions/workflows/test.yml/badge.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch/actions/workflows/test.yml) [![CD - Build Hatch](https://github.com/pypa/hatch/actions/workflows/build-hatch.yml/badge.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch/actions/workflows/build-hatch.yml) [![CD - Build Hatchling](https://github.com/pypa/hatch/actions/workflows/build-hatchling.yml/badge.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch/actions/workflows/build-hatchling.yml) |
| Docs | [![Docs - Release](https://github.com/pypa/hatch/actions/workflows/docs-release.yml/badge.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch/actions/workflows/docs-release.yml) [![Docs - Dev](https://github.com/pypa/hatch/actions/workflows/docs-dev.yml/badge.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch/actions/workflows/docs-dev.yml) |
| Package | [![PyPI - Version](https://img.shields.io/pypi/v/hatch.svg?logo=pypi&label=PyPI&logoColor=gold){ loading=lazy .off-glb }](https://pypi.org/project/hatch/) [![PyPI - Downloads](https://img.shields.io/pypi/dm/hatchling.svg?color=blue&label=Downloads&logo=pypi&logoColor=gold){ loading=lazy .off-glb }](https://pypi.org/project/hatch/) [![PyPI - Python Version](https://img.shields.io/pypi/pyversions/hatch.svg?logo=python&label=Python&logoColor=gold){ loading=lazy .off-glb }](https://pypi.org/project/hatch/) |
| Meta | [![Hatch project](https://img.shields.io/badge/%F0%9F%A5%9A-Hatch-4051b5.svg){ loading=lazy .off-glb }](https://github.com/pypa/hatch) [![linting - Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json){ loading=lazy .off-glb }](https://github.com/astral-sh/ruff) [![types - Mypy](https://img.shields.io/badge/types-Mypy-blue.svg){ loading=lazy .off-glb }](https://github.com/python/mypy) [![License - MIT](https://img.shields.io/badge/license-MIT-9400d3.svg){ loading=lazy .off-glb }](https://spdx.org/licenses/) [![GitHub Sponsors](https://img.shields.io/github/sponsors/ofek?logo=GitHub%20Sponsors&style=social){ loading=lazy .off-glb }](https://github.com/sponsors/ofek) |

</div>

-----

Hatch is a modern, extensible Python project manager. See the [Why Hatch?](why.md) page for more information.

<div class="grid cards" markdown>

-   :material-hammer-wrench:{ .lg .middle } __Build system__

    ---

    Reproducible builds by default with a rich ecosystem of plugins

    [:octicons-arrow-right-24: Configure builds](config/build.md#build-system)

-   :material-lock:{ .lg .middle } __Environments__

    ---

    Robust environment management with support for custom scripts and UV

    [:octicons-arrow-right-24: Getting started](environment.md)

-   :material-language-python:{ .lg .middle } __Python management__

    ---

    Choose between easy manual installations or automatic as part of environments

    [:octicons-arrow-right-24: Try it](cli/reference.md#hatch-python)

-   :octicons-shield-check-24:{ .lg .middle } __Testing__

    ---

    Test execution with known best practices

    [:octicons-arrow-right-24: Run](tutorials/testing/overview.md)

-   :material-magnify-scan:{ .lg .middle } __Static analysis__

    ---

    Static analysis backed by Ruff with up-to-date, sane defaults

    [:octicons-arrow-right-24: Learn](config/internal/static-analysis.md)

-   :material-console-line:{ .lg .middle } __Script runner__

    ---

    Execute Python scripts with specific dependencies and Python versions

    [:octicons-arrow-right-24: Execute](how-to/run/python-scripts.md)

-   :material-publish:{ .lg .middle } __Publishing__

    ---

    Easily upload to PyPI or other indices

    [:octicons-arrow-right-24: See how](publish.md)

-   :octicons-number-24:{ .lg .middle } __Versioning__

    ---

    Streamlined workflow for bumping versions

    [:octicons-arrow-right-24: Managing versions](version.md)

-   :octicons-project-template-24:{ .lg .middle } __Project generation__

    ---

    Create new projects from templates with known best practices

    [:octicons-arrow-right-24: Project setup](intro.md#setup)

-   :material-speedometer:{ .lg .middle } __Responsive CLI__

    ---

    Hatch is up to 3x faster than equivalent tools

    [:octicons-arrow-right-24: CLI reference](cli/about.md)

</div>

## License

Hatch is distributed under the terms of the [MIT](https://spdx.org/licenses/MIT.html) license.

## Navigation

Documentation for specific `MAJOR.MINOR` versions can be chosen by using the dropdown on the top of every page. The `dev` version reflects changes that have not yet been released.

Also, desktop readers can use special keyboard shortcuts:

| Keys | Action |
| --- | --- |
| <ul><li><kbd>,</kbd> (comma)</li><li><kbd>p</kbd></li></ul> | Navigate to the "previous" page |
| <ul><li><kbd>.</kbd> (period)</li><li><kbd>n</kbd></li></ul> | Navigate to the "next" page |
| <ul><li><kbd>/</kbd></li><li><kbd>s</kbd></li></ul> | Display the search modal |
