/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.internal.health.memory.CGroupMemoryInfo;
import org.gradle.process.internal.health.memory.DefaultMBeanAttributeProvider;
import org.gradle.process.internal.health.memory.MBeanOsMemoryInfo;
import org.gradle.process.internal.health.memory.MemInfoOsMemoryInfo;
import org.gradle.process.internal.health.memory.NativeOsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.WindowsOsMemoryInfo;

public class DefaultOsMemoryInfo
implements OsMemoryInfo {
    private final OsMemoryInfo delegate;

    public DefaultOsMemoryInfo() {
        OperatingSystem operatingSystem = OperatingSystem.current();
        this.delegate = operatingSystem.isMacOsX() ? new NativeOsMemoryInfo() : (operatingSystem.isLinux() ? this.getLinuxDelegate() : (operatingSystem.isWindows() ? new WindowsOsMemoryInfo() : new MBeanOsMemoryInfo(new DefaultMBeanAttributeProvider())));
    }

    private OsMemoryInfo getLinuxDelegate() {
        OsMemoryStatus memInfoSnapshot;
        OsMemoryStatus cGroupSnapshot;
        CGroupMemoryInfo cGroupDelegate = new CGroupMemoryInfo();
        MemInfoOsMemoryInfo memInfoDelegate = new MemInfoOsMemoryInfo();
        try {
            cGroupSnapshot = cGroupDelegate.getOsSnapshot();
        }
        catch (UnsupportedOperationException e) {
            return memInfoDelegate;
        }
        try {
            memInfoSnapshot = memInfoDelegate.getOsSnapshot();
        }
        catch (UnsupportedOperationException e) {
            return cGroupDelegate;
        }
        long cGroupFreeMemory = cGroupSnapshot.getPhysicalMemory().getFree();
        long memInfoFreeMemory = memInfoSnapshot.getPhysicalMemory().getFree();
        return cGroupFreeMemory > memInfoFreeMemory ? memInfoDelegate : cGroupDelegate;
    }

    @Override
    public OsMemoryStatus getOsSnapshot() {
        return this.delegate.getOsSnapshot();
    }
}

