/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.io.File;
import java.util.Date;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.internal.DefaultJvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.jspecify.annotations.Nullable;

public class DefaultJvmPluginServices
implements JvmPluginServices {
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;
    private final InstanceGenerator instanceGenerator;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public DefaultJvmPluginServices(ObjectFactory objectFactory, ProviderFactory providerFactory, InstanceGenerator instanceGenerator, TaskDependencyFactory taskDependencyFactory) {
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.instanceGenerator = instanceGenerator;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    @Override
    public void configureAsCompileClasspath(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().apiUsage().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public void configureAsRuntimeClasspath(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().runtimeUsage().asJar().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public void configureAsSources(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.withExternalDependencies().asSources()));
    }

    @Override
    public void configureAsApiElements(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().apiUsage().asJar().withExternalDependencies()));
    }

    @Override
    public void configureAsRuntimeElements(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().runtimeUsage().asJar().withExternalDependencies()));
    }

    @Override
    public <T> void configureAttributes(HasConfigurableAttributes<T> configurable, Action<? super JvmEcosystemAttributesDetails> configuration) {
        AttributeContainerInternal attributes = (AttributeContainerInternal)configurable.getAttributes();
        DefaultJvmEcosystemAttributesDetails details = (DefaultJvmEcosystemAttributesDetails)this.instanceGenerator.newInstance(DefaultJvmEcosystemAttributesDetails.class, new Object[]{this.objectFactory, attributes});
        configuration.execute((Object)details);
    }

    @Override
    public void replaceArtifacts(Configuration outgoingConfiguration, Object ... providers) {
        this.clearArtifacts(outgoingConfiguration);
        ConfigurationPublications outgoing = outgoingConfiguration.getOutgoing();
        for (Object provider : providers) {
            outgoing.artifact(provider);
        }
    }

    private void clearArtifacts(Configuration outgoingConfiguration) {
        outgoingConfiguration.getOutgoing().getArtifacts().clear();
        for (Configuration configuration : outgoingConfiguration.getExtendsFrom()) {
            this.clearArtifacts(configuration);
        }
    }

    @Override
    public ConfigurationVariant configureResourcesDirectoryVariant(Configuration configuration, SourceSet sourceSet) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("resources");
        variant.getDescription().convention((Object)("Directories containing assembled resource files for " + sourceSet.getName() + "."));
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "resources")));
        DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
        DefaultSourceSetOutput.DirectoryContribution resourcesContribution = output.getResourcesContribution();
        if (resourcesContribution != null) {
            variant.artifact((Object)new LazyJavaDirectoryArtifact(this.taskDependencyFactory, "java-resources-directory", resourcesContribution.getTask(), resourcesContribution.getDirectory()));
        }
        return variant;
    }

    @Override
    public ConfigurationVariant configureClassesDirectoryVariant(Configuration configuration, SourceSet sourceSet) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("classes");
        variant.getDescription().convention((Object)("Directories containing compiled class files for " + sourceSet.getName() + "."));
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "classes")));
        variant.artifactsProvider(() -> {
            FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
            return classesDirs.getFiles().stream().map(file -> new LazyJavaDirectoryArtifact(this.taskDependencyFactory, "java-classes-directory", classesDirs, (Provider<File>)this.providerFactory.provider(() -> file))).collect(Collectors.toList());
        });
        return variant;
    }

    private static class LazyJavaDirectoryArtifact
    extends AbstractPublishArtifact {
        private final String type;
        private final Provider<File> fileProvider;

        public LazyJavaDirectoryArtifact(TaskDependencyFactory taskDependencyFactory, String type, Object dependency, Provider<File> fileProvider) {
            super(taskDependencyFactory, new Object[]{dependency});
            this.type = type;
            this.fileProvider = fileProvider;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        public @Nullable String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }

        public boolean shouldBePublished() {
            return false;
        }

        public File getFile() {
            return (File)this.fileProvider.get();
        }
    }
}

