"""Generated client library for designcenter version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.designcenter.v1 import designcenter_v1_messages as messages


class DesigncenterV1(base_api.BaseApiClient):
  """Generated client library for service designcenter version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://designcenter.googleapis.com/'
  MTLS_BASE_URL = 'https://designcenter.mtls.googleapis.com/'

  _PACKAGE = 'designcenter'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DesigncenterV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new designcenter handle."""
    url = url or self.BASE_URL
    super(DesigncenterV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_spaces_applicationTemplates_components_connections = self.ProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsService(self)
    self.projects_locations_spaces_applicationTemplates_components = self.ProjectsLocationsSpacesApplicationTemplatesComponentsService(self)
    self.projects_locations_spaces_applicationTemplates_revisions = self.ProjectsLocationsSpacesApplicationTemplatesRevisionsService(self)
    self.projects_locations_spaces_applicationTemplates = self.ProjectsLocationsSpacesApplicationTemplatesService(self)
    self.projects_locations_spaces_applications = self.ProjectsLocationsSpacesApplicationsService(self)
    self.projects_locations_spaces_catalogs_shares = self.ProjectsLocationsSpacesCatalogsSharesService(self)
    self.projects_locations_spaces_catalogs_templates_revisions = self.ProjectsLocationsSpacesCatalogsTemplatesRevisionsService(self)
    self.projects_locations_spaces_catalogs_templates = self.ProjectsLocationsSpacesCatalogsTemplatesService(self)
    self.projects_locations_spaces_catalogs = self.ProjectsLocationsSpacesCatalogsService(self)
    self.projects_locations_spaces_sharedTemplates_revisions = self.ProjectsLocationsSpacesSharedTemplatesRevisionsService(self)
    self.projects_locations_spaces_sharedTemplates = self.ProjectsLocationsSpacesSharedTemplatesService(self)
    self.projects_locations_spaces = self.ProjectsLocationsSpacesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (DesigncenterProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='designcenter.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='DesigncenterProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (DesigncenterProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (DesigncenterProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (DesigncenterProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='designcenter.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_applicationTemplates_components_connections resource."""

    _NAME = 'projects_locations_spaces_applicationTemplates_components_connections'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a connection.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Connection) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}/connections',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.connections.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['connectionId'],
        relative_path='v1/{+parent}/connections',
        request_field='connection',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsCreateRequest',
        response_type_name='Connection',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a connection.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}/connections/{connectionsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.connections.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a connection.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Connection) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}/connections/{connectionsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.connections.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsGetRequest',
        response_type_name='Connection',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists connections in an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConnectionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}/connections',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.connections.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/connections',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsListRequest',
        response_type_name='ListConnectionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a connection.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Connection) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}/connections/{connectionsId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.connections.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='connection',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsConnectionsPatchRequest',
        response_type_name='Connection',
        supports_download=False,
    )

  class ProjectsLocationsSpacesApplicationTemplatesComponentsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_applicationTemplates_components resource."""

    _NAME = 'projects_locations_spaces_applicationTemplates_components'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesApplicationTemplatesComponentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a component.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Component) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['componentId'],
        relative_path='v1/{+parent}/components',
        request_field='component',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsCreateRequest',
        response_type_name='Component',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a component.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a Component.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Component) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsGetRequest',
        response_type_name='Component',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists components in an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListComponentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/components',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsListRequest',
        response_type_name='ListComponentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a component.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Component) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/components/{componentsId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.components.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='component',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesComponentsPatchRequest',
        response_type_name='Component',
        supports_download=False,
    )

  class ProjectsLocationsSpacesApplicationTemplatesRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_applicationTemplates_revisions resource."""

    _NAME = 'projects_locations_spaces_applicationTemplates_revisions'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesApplicationTemplatesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes an application template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about an application template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplateRevision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsGetRequest',
        response_type_name='ApplicationTemplateRevision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists application template revisions in a given application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListApplicationTemplateRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}/revisions',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/revisions',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesRevisionsListRequest',
        response_type_name='ListApplicationTemplateRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSpacesApplicationTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_applicationTemplates resource."""

    _NAME = 'projects_locations_spaces_applicationTemplates'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesApplicationTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Commit(self, request, global_params=None):
      r"""Commits an application template to create a new revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplateRevision) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}:commit',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.commit',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:commit',
        request_field='commitApplicationTemplateRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesCommitRequest',
        response_type_name='ApplicationTemplateRevision',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['applicationTemplateId'],
        relative_path='v1/{+parent}/applicationTemplates',
        request_field='applicationTemplate',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesCreateRequest',
        response_type_name='ApplicationTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Generate(self, request, global_params=None):
      r"""Generates Terraform files for an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesGenerateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateApplicationTemplateIaCResponse) The response message.
      """
      config = self.GetMethodConfig('Generate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Generate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}:generate',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.generate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:generate',
        request_field='generateApplicationTemplateIaCRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesGenerateRequest',
        response_type_name='GenerateApplicationTemplateIaCResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesGetRequest',
        response_type_name='ApplicationTemplate',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports to an existing application template from a given shared template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplate) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}:import',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.import',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:import',
        request_field='importApplicationTemplateRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesImportRequest',
        response_type_name='ApplicationTemplate',
        supports_download=False,
    )

    def ImportIaC(self, request, global_params=None):
      r"""Imports IaC for an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesImportIaCRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImportApplicationTemplateIaCResponse) The response message.
      """
      config = self.GetMethodConfig('ImportIaC')
      return self._RunMethod(
          config, request, global_params=global_params)

    ImportIaC.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}:importIaC',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.importIaC',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:importIaC',
        request_field='importApplicationTemplateIaCRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesImportIaCRequest',
        response_type_name='ImportApplicationTemplateIaCResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists application templates in a given space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListApplicationTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/applicationTemplates',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesListRequest',
        response_type_name='ListApplicationTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an application template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApplicationTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applicationTemplates/{applicationTemplatesId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.applicationTemplates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='applicationTemplate',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationTemplatesPatchRequest',
        response_type_name='ApplicationTemplate',
        supports_download=False,
    )

  class ProjectsLocationsSpacesApplicationsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_applications resource."""

    _NAME = 'projects_locations_spaces_applications'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesApplicationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Application) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applications.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['applicationId'],
        relative_path='v1/{+parent}/applications',
        request_field='application',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsCreateRequest',
        response_type_name='Application',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.applications.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Deploy(self, request, global_params=None):
      r"""Deploys an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsDeployRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deploy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deploy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}:deploy',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applications.deploy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:deploy',
        request_field='deployApplicationRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsDeployRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Generate(self, request, global_params=None):
      r"""Generates Terraform files for an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsGenerateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateApplicationIaCResponse) The response message.
      """
      config = self.GetMethodConfig('Generate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Generate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}:generate',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applications.generate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:generate',
        request_field='generateApplicationIaCRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsGenerateRequest',
        response_type_name='GenerateApplicationIaCResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Application) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applications.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsGetRequest',
        response_type_name='Application',
        supports_download=False,
    )

    def ImportIaC(self, request, global_params=None):
      r"""Imports IaC for an application resource.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsImportIaCRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImportApplicationIaCResponse) The response message.
      """
      config = self.GetMethodConfig('ImportIaC')
      return self._RunMethod(
          config, request, global_params=global_params)

    ImportIaC.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}:importIaC',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applications.importIaC',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:importIaC',
        request_field='importApplicationIaCRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsImportIaCRequest',
        response_type_name='ImportApplicationIaCResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists applications in a given space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListApplicationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.applications.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/applications',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsListRequest',
        response_type_name='ListApplicationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Application) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.applications.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='application',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsPatchRequest',
        response_type_name='Application',
        supports_download=False,
    )

    def Preview(self, request, global_params=None):
      r"""Previews deployment of an application.

      Args:
        request: (DesigncenterProjectsLocationsSpacesApplicationsPreviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Preview')
      return self._RunMethod(
          config, request, global_params=global_params)

    Preview.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/applications/{applicationsId}:preview',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.applications.preview',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:preview',
        request_field='previewApplicationRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesApplicationsPreviewRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsSpacesCatalogsSharesService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_catalogs_shares resource."""

    _NAME = 'projects_locations_spaces_catalogs_shares'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesCatalogsSharesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Shares a catalog from one space to another space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsSharesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/shares',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.catalogs.shares.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['shareId'],
        relative_path='v1/{+parent}/shares',
        request_field='share',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsSharesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a catalog share.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsSharesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/shares/{sharesId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.catalogs.shares.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsSharesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get catalog share object for the space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsSharesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Share) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/shares/{sharesId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.shares.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsSharesGetRequest',
        response_type_name='Share',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists catalog share objects for the space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsSharesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSharesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/shares',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.shares.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/shares',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsSharesListRequest',
        response_type_name='ListSharesResponse',
        supports_download=False,
    )

    def Sync(self, request, global_params=None):
      r"""Synchronizes a share and updates the destination workspace to reflect. reflect the most recent changes to the catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsSharesSyncRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Sync')
      return self._RunMethod(
          config, request, global_params=global_params)

    Sync.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/shares/{sharesId}:sync',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.catalogs.shares.sync',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:sync',
        request_field='syncShareRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsSharesSyncRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsSpacesCatalogsTemplatesRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_catalogs_templates_revisions resource."""

    _NAME = 'projects_locations_spaces_catalogs_templates_revisions'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesCatalogsTemplatesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}/revisions',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.revisions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['catalogTemplateRevisionId'],
        relative_path='v1/{+parent}/revisions',
        request_field='catalogTemplateRevision',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CatalogTemplateRevision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsGetRequest',
        response_type_name='CatalogTemplateRevision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists template revisions.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCatalogTemplateRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}/revisions',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/revisions',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesRevisionsListRequest',
        response_type_name='ListCatalogTemplateRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSpacesCatalogsTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_catalogs_templates resource."""

    _NAME = 'projects_locations_spaces_catalogs_templates'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesCatalogsTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Adds a template to a catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CatalogTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['catalogTemplateId'],
        relative_path='v1/{+parent}/templates',
        request_field='catalogTemplate',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesCreateRequest',
        response_type_name='CatalogTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a catalog template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a catalog template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CatalogTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesGetRequest',
        response_type_name='CatalogTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists catalog templates.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCatalogTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/templates',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesListRequest',
        response_type_name='ListCatalogTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a catalog template resource.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CatalogTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}/templates/{templatesId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.catalogs.templates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='catalogTemplate',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsTemplatesPatchRequest',
        response_type_name='CatalogTemplate',
        supports_download=False,
    )

  class ProjectsLocationsSpacesCatalogsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_catalogs resource."""

    _NAME = 'projects_locations_spaces_catalogs'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Catalog) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.catalogs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['catalogId'],
        relative_path='v1/{+parent}/catalogs',
        request_field='catalog',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsCreateRequest',
        response_type_name='Catalog',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.catalogs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Catalog) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsGetRequest',
        response_type_name='Catalog',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists catalogs in a given space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCatalogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.catalogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/catalogs',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsListRequest',
        response_type_name='ListCatalogsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a catalog.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCatalogsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Catalog) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/catalogs/{catalogsId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.catalogs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='catalog',
        request_type_name='DesigncenterProjectsLocationsSpacesCatalogsPatchRequest',
        response_type_name='Catalog',
        supports_download=False,
    )

  class ProjectsLocationsSpacesSharedTemplatesRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_sharedTemplates_revisions resource."""

    _NAME = 'projects_locations_spaces_sharedTemplates_revisions'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesSharedTemplatesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details about a shared template revision.

      Args:
        request: (DesigncenterProjectsLocationsSpacesSharedTemplatesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SharedTemplateRevision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/sharedTemplates/{sharedTemplatesId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.sharedTemplates.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesSharedTemplatesRevisionsGetRequest',
        response_type_name='SharedTemplateRevision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists shared template revisions in a given space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesSharedTemplatesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSharedTemplateRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/sharedTemplates/{sharedTemplatesId}/revisions',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.sharedTemplates.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/revisions',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesSharedTemplatesRevisionsListRequest',
        response_type_name='ListSharedTemplateRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSpacesSharedTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces_sharedTemplates resource."""

    _NAME = 'projects_locations_spaces_sharedTemplates'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesSharedTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details about a shared template.

      Args:
        request: (DesigncenterProjectsLocationsSpacesSharedTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SharedTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/sharedTemplates/{sharedTemplatesId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.sharedTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesSharedTemplatesGetRequest',
        response_type_name='SharedTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists shared templates in a given space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesSharedTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSharedTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}/sharedTemplates',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.sharedTemplates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/sharedTemplates',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesSharedTemplatesListRequest',
        response_type_name='ListSharedTemplatesResponse',
        supports_download=False,
    )

  class ProjectsLocationsSpacesService(base_api.BaseApiService):
    """Service class for the projects_locations_spaces resource."""

    _NAME = 'projects_locations_spaces'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsSpacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Space) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['spaceId'],
        relative_path='v1/{+parent}/spaces',
        request_field='space',
        request_type_name='DesigncenterProjectsLocationsSpacesCreateRequest',
        response_type_name='Space',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}',
        http_method='DELETE',
        method_id='designcenter.projects.locations.spaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Space) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesGetRequest',
        response_type_name='Space',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (DesigncenterProjectsLocationsSpacesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}:getIamPolicy',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists spaces in a given project and location.

      Args:
        request: (DesigncenterProjectsLocationsSpacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSpacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces',
        http_method='GET',
        method_id='designcenter.projects.locations.spaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/spaces',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsSpacesListRequest',
        response_type_name='ListSpacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a space.

      Args:
        request: (DesigncenterProjectsLocationsSpacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Space) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}',
        http_method='PATCH',
        method_id='designcenter.projects.locations.spaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='space',
        request_type_name='DesigncenterProjectsLocationsSpacesPatchRequest',
        response_type_name='Space',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DesigncenterProjectsLocationsSpacesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}:setIamPolicy',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (DesigncenterProjectsLocationsSpacesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/spaces/{spacesId}:testIamPermissions',
        http_method='POST',
        method_id='designcenter.projects.locations.spaces.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DesigncenterProjectsLocationsSpacesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (DesigncenterProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='designcenter.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (DesigncenterProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='designcenter.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/locations',
        request_field='',
        request_type_name='DesigncenterProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DesigncenterV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
