package burst

import (
	_ "github.com/v2fly/v2ray-core/v5/common/protoext"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// @Document The selectors for outbound under observation
	SubjectSelector []string          `protobuf:"bytes,2,rep,name=subject_selector,json=subjectSelector,proto3" json:"subject_selector,omitempty"`
	PingConfig      *HealthPingConfig `protobuf:"bytes,3,opt,name=ping_config,json=pingConfig,proto3" json:"ping_config,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Config) Reset() {
	*x = Config{}
	mi := &file_app_observatory_burst_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_app_observatory_burst_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_app_observatory_burst_config_proto_rawDescGZIP(), []int{0}
}

func (x *Config) GetSubjectSelector() []string {
	if x != nil {
		return x.SubjectSelector
	}
	return nil
}

func (x *Config) GetPingConfig() *HealthPingConfig {
	if x != nil {
		return x.PingConfig
	}
	return nil
}

type HealthPingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// destination url, need 204 for success return
	// default https://connectivitycheck.gstatic.com/generate_204
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// connectivity check url
	Connectivity string `protobuf:"bytes,2,opt,name=connectivity,proto3" json:"connectivity,omitempty"`
	// health check interval, int64 values of time.Duration
	Interval int64 `protobuf:"varint,3,opt,name=interval,proto3" json:"interval,omitempty"`
	// sampling count is the amount of recent ping results which are kept for calculation
	SamplingCount int32 `protobuf:"varint,4,opt,name=samplingCount,proto3" json:"samplingCount,omitempty"`
	// ping timeout, int64 values of time.Duration
	Timeout       int64 `protobuf:"varint,5,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HealthPingConfig) Reset() {
	*x = HealthPingConfig{}
	mi := &file_app_observatory_burst_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HealthPingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthPingConfig) ProtoMessage() {}

func (x *HealthPingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_app_observatory_burst_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthPingConfig.ProtoReflect.Descriptor instead.
func (*HealthPingConfig) Descriptor() ([]byte, []int) {
	return file_app_observatory_burst_config_proto_rawDescGZIP(), []int{1}
}

func (x *HealthPingConfig) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *HealthPingConfig) GetConnectivity() string {
	if x != nil {
		return x.Connectivity
	}
	return ""
}

func (x *HealthPingConfig) GetInterval() int64 {
	if x != nil {
		return x.Interval
	}
	return 0
}

func (x *HealthPingConfig) GetSamplingCount() int32 {
	if x != nil {
		return x.SamplingCount
	}
	return 0
}

func (x *HealthPingConfig) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

var File_app_observatory_burst_config_proto protoreflect.FileDescriptor

const file_app_observatory_burst_config_proto_rawDesc = "" +
	"\n" +
	"\"app/observatory/burst/config.proto\x12 v2ray.core.app.observatory.burst\x1a common/protoext/extensions.proto\"\xa9\x01\n" +
	"\x06Config\x12)\n" +
	"\x10subject_selector\x18\x02 \x03(\tR\x0fsubjectSelector\x12S\n" +
	"\vping_config\x18\x03 \x01(\v22.v2ray.core.app.observatory.burst.HealthPingConfigR\n" +
	"pingConfig:\x1f\x82\xb5\x18\x1b\n" +
	"\aservice\x12\x10burstObservatory\"\xb4\x01\n" +
	"\x10HealthPingConfig\x12 \n" +
	"\vdestination\x18\x01 \x01(\tR\vdestination\x12\"\n" +
	"\fconnectivity\x18\x02 \x01(\tR\fconnectivity\x12\x1a\n" +
	"\binterval\x18\x03 \x01(\x03R\binterval\x12$\n" +
	"\rsamplingCount\x18\x04 \x01(\x05R\rsamplingCount\x12\x18\n" +
	"\atimeout\x18\x05 \x01(\x03R\atimeoutB\x81\x01\n" +
	"$com.v2ray.core.app.observatory.burstP\x01Z4github.com/v2fly/v2ray-core/v5/app/observatory/burst\xaa\x02 V2Ray.Core.App.Observatory.Burstb\x06proto3"

var (
	file_app_observatory_burst_config_proto_rawDescOnce sync.Once
	file_app_observatory_burst_config_proto_rawDescData []byte
)

func file_app_observatory_burst_config_proto_rawDescGZIP() []byte {
	file_app_observatory_burst_config_proto_rawDescOnce.Do(func() {
		file_app_observatory_burst_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_app_observatory_burst_config_proto_rawDesc), len(file_app_observatory_burst_config_proto_rawDesc)))
	})
	return file_app_observatory_burst_config_proto_rawDescData
}

var file_app_observatory_burst_config_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_app_observatory_burst_config_proto_goTypes = []any{
	(*Config)(nil),           // 0: v2ray.core.app.observatory.burst.Config
	(*HealthPingConfig)(nil), // 1: v2ray.core.app.observatory.burst.HealthPingConfig
}
var file_app_observatory_burst_config_proto_depIdxs = []int32{
	1, // 0: v2ray.core.app.observatory.burst.Config.ping_config:type_name -> v2ray.core.app.observatory.burst.HealthPingConfig
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_app_observatory_burst_config_proto_init() }
func file_app_observatory_burst_config_proto_init() {
	if File_app_observatory_burst_config_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_app_observatory_burst_config_proto_rawDesc), len(file_app_observatory_burst_config_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_app_observatory_burst_config_proto_goTypes,
		DependencyIndexes: file_app_observatory_burst_config_proto_depIdxs,
		MessageInfos:      file_app_observatory_burst_config_proto_msgTypes,
	}.Build()
	File_app_observatory_burst_config_proto = out.File
	file_app_observatory_burst_config_proto_goTypes = nil
	file_app_observatory_burst_config_proto_depIdxs = nil
}
