// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package clonerex

import (
	"tailscale.com/types/ptr"
)

// Clone makes a deep copy of SliceContainer.
// The result aliases no memory with the original.
func (src *SliceContainer) Clone() *SliceContainer {
	if src == nil {
		return nil
	}
	dst := new(SliceContainer)
	*dst = *src
	if src.Slice != nil {
		dst.Slice = make([]*int, len(src.Slice))
		for i := range dst.Slice {
			if src.Slice[i] == nil {
				dst.Slice[i] = nil
			} else {
				dst.Slice[i] = ptr.To(*src.Slice[i])
			}
		}
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _SliceContainerCloneNeedsRegeneration = SliceContainer(struct {
	Slice []*int
}{})

// Clone makes a deep copy of InterfaceContainer.
// The result aliases no memory with the original.
func (src *InterfaceContainer) Clone() *InterfaceContainer {
	if src == nil {
		return nil
	}
	dst := new(InterfaceContainer)
	*dst = *src
	if src.Interface != nil {
		dst.Interface = src.Interface.Clone()
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _InterfaceContainerCloneNeedsRegeneration = InterfaceContainer(struct {
	Interface Cloneable
}{})

// Clone duplicates src into dst and reports whether it succeeded.
// To succeed, <src, dst> must be of types <*T, *T> or <*T, **T>,
// where T is one of SliceContainer,InterfaceContainer.
func Clone(dst, src any) bool {
	switch src := src.(type) {
	case *SliceContainer:
		switch dst := dst.(type) {
		case *SliceContainer:
			*dst = *src.Clone()
			return true
		case **SliceContainer:
			*dst = src.Clone()
			return true
		}
	case *InterfaceContainer:
		switch dst := dst.(type) {
		case *InterfaceContainer:
			*dst = *src.Clone()
			return true
		case **InterfaceContainer:
			*dst = src.Clone()
			return true
		}
	}
	return false
}
