# Verify version annotations

pinact >= v0.1.3

Please see the following code.

```yaml
- uses: actions/checkout@ee0669bd1cc54295c223e0bb666b733df41de1c5 # v3.5.1
```

You would assume the version of the action is v3.5.1 because the version annotation is "v3.5.1".
But the actual version is v2.7.0 because "ee0669bd1cc54295c223e0bb666b733df41de1c5" is the commit hash of v2.7.0.
Please check releases.

- https://github.com/actions/checkout/releases/tag/v3.5.1
- https://github.com/actions/checkout/releases/tag/v2.7.0

This indicates version annotations aren't necessarily correct.
Especially, attackers can specify a full commit SHA including a malicious code while setting a safe tag to the version annotation.
If a pull request includes changes of GitHub Actions, you should verify version annotations.

pinact v0.1.3 or newer can verify version annotations using `pinact run`'s `--verify` option.
This verification works only if the version annotation is semver and the version is full commit hash like the above example.
This option gets a full commit hash from a version annotation by GitHub API and compares it with the version.

e.g.

```console
$ pinact run --verify testdata/bar.yaml
ERRO[0000] parse a line                                  action=actions/checkout action_version=ee0669bd1cc54295c223e0bb666b733df41de1c5 commit_hash_of_version_annotation=83b7061638ee4956cf7545a6f7efe594e5ad0247 error="verify the version annotation: action_version must be equal to commit_hash_of_version_annotation" help_docs="https://github.com/suzuki-shunsuke/pinact/blob/main/docs/codes/001.md" pinact_version= program=pinact version_annotation=v3.5.1 workflow_file=testdata/bar.yaml
```

Note that `--verify` option calls GitHub API to verify version annotations, which may cause API rate limiting.
