# Summary

- [Introduction](./README.md)
- [Installation](./install.md)
- [Quick Start](./quick-start.md)
- [Concepts](./concepts.md)
  - [Exec Plugin](./concepts/exec-plugin.md)
  - [Login Modes](./concepts/login-modes.md)
    - [Device Code](./concepts/login-modes/devicecode.md)
    - [Azure CLI](./concepts/login-modes/azurecli.md)
    - [Azure Developer CLI](./concepts/login-modes/azd.md)
    - [Azure Pipelines](./concepts/login-modes/azurepipelines.md)
    - [Web Browser Interactive](./concepts/login-modes/interactive.md)
    - [Service Principal](./concepts/login-modes/sp.md)
    - [Managed Service Identity](./concepts/login-modes/msi.md)
    - [Workload Identity](./concepts/login-modes/workloadidentity.md)
    - [Resource Owner Password Credential](./concepts/login-modes/ropc.md)
  - [Using kubelogin with AKS](./concepts/aks.md)
  - [Using kubelogin to get Proof-of-Possession (PoP) tokens for Azure Arc](./concepts/azure-arc.md)
- [Command-Line Tool](./cli-reference.md)
  - [convert-kubeconfig](./cli/convert-kubeconfig.md)
  - [get-token](./cli/get-token.md)
  - [remove-cache-dir](./cli/remove-cache-dir.md)
- [Topics](./topics.md)
  - [Using in different environments](./topics/environments.md)
  - [Using Service Principal](./topics/sp.md)
  - [Setup k8s OIDC Provider using Azure AD](./topics/k8s-oidc-aad.md)
  - [Using kubelogin in Jenkins](./topics/jenkins.md)
- [Known Issues](./known-issues.md)
- [Development](./development.md)
  - [Releasing](./development/releasing.md)
- [Contributing](./contributing.md)
- [Code of Conduct](./code-of-conduct.md)
