/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	v1alpha2 "k8s.io/kops/pkg/apis/kops/v1alpha2"
	kopsv1alpha2 "k8s.io/kops/pkg/client/clientset_generated/internalclientset/typed/kops/v1alpha2"
)

// fakeClusters implements ClusterInterface
type fakeClusters struct {
	*gentype.FakeClientWithList[*v1alpha2.Cluster, *v1alpha2.ClusterList]
	Fake *FakeKopsV1alpha2
}

func newFakeClusters(fake *FakeKopsV1alpha2, namespace string) kopsv1alpha2.ClusterInterface {
	return &fakeClusters{
		gentype.NewFakeClientWithList[*v1alpha2.Cluster, *v1alpha2.ClusterList](
			fake.Fake,
			namespace,
			v1alpha2.SchemeGroupVersion.WithResource("clusters"),
			v1alpha2.SchemeGroupVersion.WithKind("Cluster"),
			func() *v1alpha2.Cluster { return &v1alpha2.Cluster{} },
			func() *v1alpha2.ClusterList { return &v1alpha2.ClusterList{} },
			func(dst, src *v1alpha2.ClusterList) { dst.ListMeta = src.ListMeta },
			func(list *v1alpha2.ClusterList) []*v1alpha2.Cluster { return gentype.ToPointerSlice(list.Items) },
			func(list *v1alpha2.ClusterList, items []*v1alpha2.Cluster) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
