## Release notes for kOps 1.28 series

# Significant changes

## AWS

* Node Termination Handler is now enabled by default.

## GCP

* [metadata-proxy](https://github.com/kubernetes/kubernetes/tree/master/cluster/addons/metadata-proxy) is no longer deployed on GCP clusters for Kubernetes 1.29+.

# Breaking changes

## AWS

* The `kops get assets --copy` command no longer sets object-level public-read ACLs in the destination fileRepository.

## OpenStack

* If storing the state in an S3 bucket, it is now required to either [deactivate gossip support](https://github.com/kubernetes/kops/issues/15684#issuecomment-1645384421) (`--dns=none`) or - for example - provide the credentials via cloud-init. Due to changes in [PR#15646](https://github.com/kubernetes/kops/pull/15646/files#diff-c1c852aea92883d3117fae99c1610c5cdcbc217f5aa3b340f23b5dd02e971d99L136-L145) the `S3_*` variables will not get passed on to the boot script of the [nodes anymore](https://github.com/kubernetes/kops/pull/15691). As a result the `kops-configuration.service` will throw an `EnvAccessKeyNotFound: failed to find credentials in the environment.` error and they will not join the cluster. Deactivating the gossip support will make the nodes contact the API servers for the bootstrap information.

## Other breaking changes

* Support for Kubernetes version 1.22 has been removed.

* Support for Ubuntu 18.04 is has been removed.

* Support for Canal and Flannel have been removed for Kubernetes 1.28 and later.

* RHEL-based distros will no longer have `wget`, `curl`, `python2`, and `git` packages installed. Install them with [hooks](/cluster_spec/#hooks) if needed.

* The [default IPv4 service cluster range](https://github.com/kubernetes/kops/pull/15866) is now `100.64.0.0/13`. As this was previously calculated from `nonMasqueradeCIDR` if `serviceClusterIPRange` was not explicitly set, it may be necessary to set it to this value ([the first 1/8](https://github.com/kubernetes/kops/pull/15866/files#diff-5e44add4b8da1d5b1c7119b6cc5a5f42a45c555332f51262162b29790e78f479L397-L404) of the `nonMasqueradeCIDR`).

# Known Issues

* The Amazon VPC CNI is not compatible with Ubuntu 22.04. See [kubernetes/kops#15720](https://github.com/kubernetes/kops/issues/15720) and [aws/amazon-vpc-cni-k8s#2103](https://github.com/aws/amazon-vpc-cni-k8s/issues/2103) for more info.

# Deprecations

* Support for Kubernetes version 1.23 is deprecated and will be removed in kOps 1.29.

* Support for Kubernetes version 1.24 is deprecated and will be removed in kOps 1.30.

* Support for AWS Classic Load Balancer for API is deprecated and should not be used for newly created clusters.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).
