package pcc

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	"google.golang.org/protobuf/types/known/structpb"
	"google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ATLogInclusionProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	// These are the SHA256 hash of the logged data.
	// If the same data has been inserted multiple times, this will return the latest entry.
	Identifier [][]byte `protobuf:"bytes,3,rep,name=identifier,proto3" json:"identifier,omitempty"`
}

func (x *ATLogInclusionProofRequest) Reset() {
	*x = ATLogInclusionProofRequest{}
	mi := &file_ATResearcherApi_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogInclusionProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogInclusionProofRequest) ProtoMessage() {}

func (x *ATLogInclusionProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ATResearcherApi_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogInclusionProofRequest.ProtoReflect.Descriptor instead.
func (*ATLogInclusionProofRequest) Descriptor() ([]byte, []int) {
	return file_ATResearcherApi_proto_rawDescGZIP(), []int{0}
}

func (x *ATLogInclusionProofRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *ATLogInclusionProofRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *ATLogInclusionProofRequest) GetIdentifier() [][]byte {
	if x != nil {
		return x.Identifier
	}
	return nil
}

type ATLogInclusionProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"` // OK, INVALID_REQUEST, or INTERNAL_ERROR
	// root under which all leaves are proven
	Slh *SignedObject `protobuf:"bytes,2,opt,name=slh,proto3" json:"slh,omitempty"`
	// not guaranteed to have every requested proof
	// all these proofs will be under the same log head, sorted by leaf index
	Leaves []*ATLogInclusionProofResponse_Leaf `protobuf:"bytes,3,rep,name=leaves,proto3" json:"leaves,omitempty"`
}

func (x *ATLogInclusionProofResponse) Reset() {
	*x = ATLogInclusionProofResponse{}
	mi := &file_ATResearcherApi_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogInclusionProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogInclusionProofResponse) ProtoMessage() {}

func (x *ATLogInclusionProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ATResearcherApi_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogInclusionProofResponse.ProtoReflect.Descriptor instead.
func (*ATLogInclusionProofResponse) Descriptor() ([]byte, []int) {
	return file_ATResearcherApi_proto_rawDescGZIP(), []int{1}
}

func (x *ATLogInclusionProofResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *ATLogInclusionProofResponse) GetSlh() *SignedObject {
	if x != nil {
		return x.Slh
	}
	return nil
}

func (x *ATLogInclusionProofResponse) GetLeaves() []*ATLogInclusionProofResponse_Leaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

type ATLogInclusionProofResponse_Leaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodeType                  NodeType `protobuf:"varint,1,opt,name=nodeType,proto3,enum=NodeType" json:"nodeType,omitempty"` // always NodeType.ATL_NODE (ChangeLogNodeV2 with an ATLeafData struct)
	NodeBytes                 []byte   `protobuf:"bytes,2,opt,name=nodeBytes,proto3" json:"nodeBytes,omitempty"`
	NodePosition              uint64   `protobuf:"varint,3,opt,name=nodePosition,proto3" json:"nodePosition,omitempty"`                          // in range [0, slh.logSize)
	HashesOfPeersInPathToRoot [][]byte `protobuf:"bytes,4,rep,name=hashesOfPeersInPathToRoot,proto3" json:"hashesOfPeersInPathToRoot,omitempty"` // Path to slh above. Ordered with leaf at 0, root-1 at end
	RawData                   []byte   `protobuf:"bytes,5,opt,name=rawData,proto3" json:"rawData,omitempty"`
	Metadata                  []byte   `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ATLogInclusionProofResponse_Leaf) Reset() {
	*x = ATLogInclusionProofResponse_Leaf{}
	mi := &file_ATResearcherApi_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogInclusionProofResponse_Leaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogInclusionProofResponse_Leaf) ProtoMessage() {}

func (x *ATLogInclusionProofResponse_Leaf) ProtoReflect() protoreflect.Message {
	mi := &file_ATResearcherApi_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogInclusionProofResponse_Leaf.ProtoReflect.Descriptor instead.
func (*ATLogInclusionProofResponse_Leaf) Descriptor() ([]byte, []int) {
	return file_ATResearcherApi_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ATLogInclusionProofResponse_Leaf) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_PACL_NODE
}

func (x *ATLogInclusionProofResponse_Leaf) GetNodeBytes() []byte {
	if x != nil {
		return x.NodeBytes
	}
	return nil
}

func (x *ATLogInclusionProofResponse_Leaf) GetNodePosition() uint64 {
	if x != nil {
		return x.NodePosition
	}
	return 0
}

func (x *ATLogInclusionProofResponse_Leaf) GetHashesOfPeersInPathToRoot() [][]byte {
	if x != nil {
		return x.HashesOfPeersInPathToRoot
	}
	return nil
}

func (x *ATLogInclusionProofResponse_Leaf) GetRawData() []byte {
	if x != nil {
		return x.RawData
	}
	return nil
}

func (x *ATLogInclusionProofResponse_Leaf) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

var File_ATResearcherApi_proto protoreflect.FileDescriptor

var file_ATResearcherApi_proto_rawDesc = []byte{
	0x0a, 0x15, 0x41, 0x54, 0x52, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x41, 0x70,
	0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x41, 0x54, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x11, 0x4b, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x10, 0x41, 0x75, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x41, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98, 0x01, 0x0a, 0x1a, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x49, 0x6e,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0c, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x22,
	0x80, 0x03, 0x0a, 0x1b, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x1f, 0x0a, 0x03, 0x73, 0x6c, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x03, 0x73, 0x6c,
	0x68, 0x12, 0x39, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x1a, 0xe3, 0x01, 0x0a,
	0x04, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x25, 0x0a, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c,
	0x0a, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65, 0x72, 0x73, 0x49,
	0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0c, 0x52, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65, 0x72, 0x73,
	0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x72, 0x61, 0x77, 0x44, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x72,
	0x61, 0x77, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x62, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e,
	0x6b, 0x65, 0x79, 0x74, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x74, 0x42, 0x0f, 0x41, 0x54, 0x52,
	0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x41, 0x70, 0x69, 0x50, 0x01, 0x5a, 0x2e,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6c, 0x61, 0x63, 0x6b,
	0x74, 0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73, 0x77, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2f, 0x70, 0x63, 0x63, 0xba, 0x02,
	0x05, 0x54, 0x78, 0x50, 0x42, 0x5f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ATResearcherApi_proto_rawDescOnce sync.Once
	file_ATResearcherApi_proto_rawDescData = file_ATResearcherApi_proto_rawDesc
)

func file_ATResearcherApi_proto_rawDescGZIP() []byte {
	file_ATResearcherApi_proto_rawDescOnce.Do(func() {
		file_ATResearcherApi_proto_rawDescData = protoimpl.X.CompressGZIP(file_ATResearcherApi_proto_rawDescData)
	})
	return file_ATResearcherApi_proto_rawDescData
}

var file_ATResearcherApi_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_ATResearcherApi_proto_goTypes = []any{
	(*ATLogInclusionProofRequest)(nil),       // 0: ATLogInclusionProofRequest
	(*ATLogInclusionProofResponse)(nil),      // 1: ATLogInclusionProofResponse
	(*ATLogInclusionProofResponse_Leaf)(nil), // 2: ATLogInclusionProofResponse.Leaf
	(ProtocolVersion)(0),                     // 3: ProtocolVersion
	(Application)(0),                         // 4: Application
	(Status)(0),                              // 5: Status
	(*SignedObject)(nil),                     // 6: SignedObject
	(NodeType)(0),                            // 7: NodeType
}
var file_ATResearcherApi_proto_depIdxs = []int32{
	3, // 0: ATLogInclusionProofRequest.version:type_name -> ProtocolVersion
	4, // 1: ATLogInclusionProofRequest.application:type_name -> Application
	5, // 2: ATLogInclusionProofResponse.status:type_name -> Status
	6, // 3: ATLogInclusionProofResponse.slh:type_name -> SignedObject
	2, // 4: ATLogInclusionProofResponse.leaves:type_name -> ATLogInclusionProofResponse.Leaf
	7, // 5: ATLogInclusionProofResponse.Leaf.nodeType:type_name -> NodeType
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() {
	file_ATResearcherApi_proto_init()
	file_ATServiceApi_proto_init()
	file_AuditorApi_proto_init()
	file_KtClientApi_proto_init()
	file_ReleaseMetadata_proto_init()
	file_Transparency_proto_init()
}
func file_ATResearcherApi_proto_init() {
	if File_ATResearcherApi_proto != nil {
		return
	}
	file_Transparency_proto_init()
	file_ATServiceApi_proto_init()
	file_KtClientApi_proto_init()
	file_AuditorApi_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ATResearcherApi_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ATResearcherApi_proto_goTypes,
		DependencyIndexes: file_ATResearcherApi_proto_depIdxs,
		MessageInfos:      file_ATResearcherApi_proto_msgTypes,
	}.Build()
	File_ATResearcherApi_proto = out.File
	file_ATResearcherApi_proto_rawDesc = nil
	file_ATResearcherApi_proto_goTypes = nil
	file_ATResearcherApi_proto_depIdxs = nil
}

type ATLogDataType int32

const (
	ATLogDataType_UNKNOWN ATLogDataType = 0
	ATLogDataType_RELEASE ATLogDataType = 1
	// MODEL = 2; not used
	ATLogDataType_KEYBUNDLE_TGT   ATLogDataType = 3
	ATLogDataType_KEYBUNDLE_OTT   ATLogDataType = 4
	ATLogDataType_KEYBUNDLE_OHTTP ATLogDataType = 5
	ATLogDataType_TEST_MARKER     ATLogDataType = 100
)

// Enum value maps for ATLogDataType.
var (
	ATLogDataType_name = map[int32]string{
		0:   "UNKNOWN",
		1:   "RELEASE",
		3:   "KEYBUNDLE_TGT",
		4:   "KEYBUNDLE_OTT",
		5:   "KEYBUNDLE_OHTTP",
		100: "TEST_MARKER",
	}
	ATLogDataType_value = map[string]int32{
		"UNKNOWN":         0,
		"RELEASE":         1,
		"KEYBUNDLE_TGT":   3,
		"KEYBUNDLE_OTT":   4,
		"KEYBUNDLE_OHTTP": 5,
		"TEST_MARKER":     100,
	}
)

func (x ATLogDataType) Enum() *ATLogDataType {
	p := new(ATLogDataType)
	*p = x
	return p
}

func (x ATLogDataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ATLogDataType) Descriptor() protoreflect.EnumDescriptor {
	return file_ATServiceApi_proto_enumTypes[0].Descriptor()
}

func (ATLogDataType) Type() protoreflect.EnumType {
	return &file_ATServiceApi_proto_enumTypes[0]
}

func (x ATLogDataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ATLogDataType.Descriptor instead.
func (ATLogDataType) EnumDescriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{0}
}

// Insert data can go in one of two sets of fields.
// For extra environment verification, populate the ATInsertData field and leave type, data, and
// unhashedMetadata fields empty (they will be ignored if insertData is set).
// For traditional requests, set type, data, and unhashedMetadata fields with data to insert and
// leave insertData empty.
// version, application, and expiryMs fields must be populated in either case.
type ATLogInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	Type        ATLogDataType   `protobuf:"varint,3,opt,name=type,proto3,enum=ATLogDataType" json:"type,omitempty"`
	ExpiryMs    uint64          `protobuf:"varint,4,opt,name=expiryMs,proto3" json:"expiryMs,omitempty"`
	Data        []byte          `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// additional data available to researchers that will not be hashed or signed by the server
	UnhashedMetadata []byte `protobuf:"bytes,6,opt,name=unhashedMetadata,proto3" json:"unhashedMetadata,omitempty"`
	InsertData       []byte `protobuf:"bytes,7,opt,name=insertData,proto3" json:"insertData,omitempty"`
}

func (x *ATLogInsertRequest) Reset() {
	*x = ATLogInsertRequest{}
	mi := &file_ATServiceApi_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogInsertRequest) ProtoMessage() {}

func (x *ATLogInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogInsertRequest.ProtoReflect.Descriptor instead.
func (*ATLogInsertRequest) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{0}
}

func (x *ATLogInsertRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *ATLogInsertRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *ATLogInsertRequest) GetType() ATLogDataType {
	if x != nil {
		return x.Type
	}
	return ATLogDataType_UNKNOWN
}

func (x *ATLogInsertRequest) GetExpiryMs() uint64 {
	if x != nil {
		return x.ExpiryMs
	}
	return 0
}

func (x *ATLogInsertRequest) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *ATLogInsertRequest) GetUnhashedMetadata() []byte {
	if x != nil {
		return x.UnhashedMetadata
	}
	return nil
}

func (x *ATLogInsertRequest) GetInsertData() []byte {
	if x != nil {
		return x.InsertData
	}
	return nil
}

type ATLogInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible status values: MUTATION_PENDING (success), INTERNAL_ERROR, INVALID_REQUEST
	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
}

func (x *ATLogInsertResponse) Reset() {
	*x = ATLogInsertResponse{}
	mi := &file_ATServiceApi_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogInsertResponse) ProtoMessage() {}

func (x *ATLogInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogInsertResponse.ProtoReflect.Descriptor instead.
func (*ATLogInsertResponse) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{1}
}

func (x *ATLogInsertResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

type ATLogProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	// This is the SHA256 hash of the logged data.
	// If the same data has been inserted multiple times, this will return the latest entry.
	Identifier []byte `protobuf:"bytes,3,opt,name=identifier,proto3" json:"identifier,omitempty"`
}

func (x *ATLogProofRequest) Reset() {
	*x = ATLogProofRequest{}
	mi := &file_ATServiceApi_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogProofRequest) ProtoMessage() {}

func (x *ATLogProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogProofRequest.ProtoReflect.Descriptor instead.
func (*ATLogProofRequest) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{2}
}

func (x *ATLogProofRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *ATLogProofRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *ATLogProofRequest) GetIdentifier() []byte {
	if x != nil {
		return x.Identifier
	}
	return nil
}

type ATLogProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible status values: OK, INTERNAL_ERROR, INVALID_REQUEST, NOT_FOUND, MUTATION_PENDING
	// Other values should be treated as INTERNAL_ERROR
	// NOT_FOUND indicates the value was never inserted
	// MUTATION_PENDING means it has been inserted but hasn't yet sequenced into the log, PAT, and TLT
	// OK will return a full response, other values will only include status and serverEventInfo
	Status Status       `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	Proofs *ATLogProofs `protobuf:"bytes,3,opt,name=proofs,proto3" json:"proofs,omitempty"`
	// Expiry time of the returned leaf. Matches the expiry set in the insert request for this leaf.
	// Also available in proofs.inclusionProof.nodsBytes -> parse as as proto ChangeLogNodeV2 -> value -> parse as TLS ATLeafData -> expiryMs
	// That one is hashed... signed... tree consistency protections..., but this is much easier to access.
	ExpiryMs uint64 `protobuf:"varint,4,opt,name=expiryMs,proto3" json:"expiryMs,omitempty"`
}

func (x *ATLogProofResponse) Reset() {
	*x = ATLogProofResponse{}
	mi := &file_ATServiceApi_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogProofResponse) ProtoMessage() {}

func (x *ATLogProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogProofResponse.ProtoReflect.Descriptor instead.
func (*ATLogProofResponse) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{3}
}

func (x *ATLogProofResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *ATLogProofResponse) GetProofs() *ATLogProofs {
	if x != nil {
		return x.Proofs
	}
	return nil
}

func (x *ATLogProofResponse) GetExpiryMs() uint64 {
	if x != nil {
		return x.ExpiryMs
	}
	return 0
}

type ATLogProofs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Inclusion proof for this data if it exists in the TL.
	InclusionProof *LogEntry `protobuf:"bytes,1,opt,name=inclusionProof,proto3" json:"inclusionProof,omitempty"`
	// If the inclusion proof isn't to a milestone root, this will be included to prove consistency with a recent milestone
	MilestoneConsistency *LogConsistency `protobuf:"bytes,2,opt,name=milestoneConsistency,proto3" json:"milestoneConsistency,omitempty"`
}

func (x *ATLogProofs) Reset() {
	*x = ATLogProofs{}
	mi := &file_ATServiceApi_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ATLogProofs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ATLogProofs) ProtoMessage() {}

func (x *ATLogProofs) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ATLogProofs.ProtoReflect.Descriptor instead.
func (*ATLogProofs) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{4}
}

func (x *ATLogProofs) GetInclusionProof() *LogEntry {
	if x != nil {
		return x.InclusionProof
	}
	return nil
}

func (x *ATLogProofs) GetMilestoneConsistency() *LogConsistency {
	if x != nil {
		return x.MilestoneConsistency
	}
	return nil
}

type LogConsistency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartSLH    *SignedObject `protobuf:"bytes,3,opt,name=startSLH,proto3" json:"startSLH,omitempty"` // SLH of a milestone root
	EndSLH      *SignedObject `protobuf:"bytes,4,opt,name=endSLH,proto3" json:"endSLH,omitempty"`     // redundant, matches SLH in inclusionProof
	ProofHashes [][]byte      `protobuf:"bytes,5,rep,name=proofHashes,proto3" json:"proofHashes,omitempty"`
	// inclusion proof of the endSLH in the PAT, and the PAT head in the TLT
	PatInclusionProof *LogEntry `protobuf:"bytes,8,opt,name=patInclusionProof,proto3" json:"patInclusionProof,omitempty"`
	TltInclusionProof *LogEntry `protobuf:"bytes,9,opt,name=tltInclusionProof,proto3" json:"tltInclusionProof,omitempty"`
}

func (x *LogConsistency) Reset() {
	*x = LogConsistency{}
	mi := &file_ATServiceApi_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogConsistency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogConsistency) ProtoMessage() {}

func (x *LogConsistency) ProtoReflect() protoreflect.Message {
	mi := &file_ATServiceApi_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogConsistency.ProtoReflect.Descriptor instead.
func (*LogConsistency) Descriptor() ([]byte, []int) {
	return file_ATServiceApi_proto_rawDescGZIP(), []int{5}
}

func (x *LogConsistency) GetStartSLH() *SignedObject {
	if x != nil {
		return x.StartSLH
	}
	return nil
}

func (x *LogConsistency) GetEndSLH() *SignedObject {
	if x != nil {
		return x.EndSLH
	}
	return nil
}

func (x *LogConsistency) GetProofHashes() [][]byte {
	if x != nil {
		return x.ProofHashes
	}
	return nil
}

func (x *LogConsistency) GetPatInclusionProof() *LogEntry {
	if x != nil {
		return x.PatInclusionProof
	}
	return nil
}

func (x *LogConsistency) GetTltInclusionProof() *LogEntry {
	if x != nil {
		return x.TltInclusionProof
	}
	return nil
}

var File_ATServiceApi_proto protoreflect.FileDescriptor

var file_ATServiceApi_proto_rawDesc = []byte{
	0x0a, 0x12, 0x41, 0x54, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x02, 0x0a, 0x12, 0x41, 0x54, 0x4c,
	0x6f, 0x67, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x0b, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x41, 0x54, 0x4c, 0x6f,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x4d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x4d, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x2a, 0x0a, 0x10, 0x75, 0x6e, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x75, 0x6e, 0x68, 0x61, 0x73,
	0x68, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x0a, 0x69,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0a, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x22, 0x36, 0x0a, 0x13, 0x41,
	0x54, 0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x8f, 0x01, 0x0a, 0x11, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x22, 0x77, 0x0a, 0x12, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a, 0x06,
	0x70, 0x72, 0x6f, 0x6f, 0x66, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x41,
	0x54, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x73, 0x52, 0x06, 0x70, 0x72, 0x6f, 0x6f,
	0x66, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x4d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x4d, 0x73, 0x22, 0x85,
	0x01, 0x0a, 0x0b, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x73, 0x12, 0x31,
	0x0a, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x12, 0x43, 0x0a, 0x14, 0x6d, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x52, 0x14, 0x6d, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x22, 0xf6, 0x01, 0x0a, 0x0e, 0x4c, 0x6f, 0x67, 0x43, 0x6f,
	0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x08, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x53, 0x4c, 0x48, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x53, 0x4c, 0x48, 0x12, 0x25, 0x0a, 0x06, 0x65, 0x6e, 0x64, 0x53, 0x4c, 0x48, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x53, 0x4c, 0x48, 0x12, 0x20, 0x0a, 0x0b, 0x70,
	0x72, 0x6f, 0x6f, 0x66, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0c,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x37, 0x0a,
	0x11, 0x70, 0x61, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x11, 0x70, 0x61, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x37, 0x0a, 0x11, 0x74, 0x6c, 0x74, 0x49, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x74, 0x6c,
	0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x2a,
	0x75, 0x0a, 0x0d, 0x41, 0x54, 0x4c, 0x6f, 0x67, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4b, 0x45,
	0x59, 0x42, 0x55, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x54, 0x47, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a,
	0x0d, 0x4b, 0x45, 0x59, 0x42, 0x55, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x4f, 0x54, 0x54, 0x10, 0x04,
	0x12, 0x13, 0x0a, 0x0f, 0x4b, 0x45, 0x59, 0x42, 0x55, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x4f, 0x48,
	0x54, 0x54, 0x50, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x41,
	0x52, 0x4b, 0x45, 0x52, 0x10, 0x64, 0x42, 0x61, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x65, 0x2e, 0x6b, 0x65, 0x79, 0x74, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x74, 0x42,
	0x0e, 0x41, 0x54, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6c,
	0x61, 0x63, 0x6b, 0x74, 0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73, 0x77, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2f, 0x70, 0x63,
	0x63, 0xba, 0x02, 0x05, 0x54, 0x78, 0x50, 0x42, 0x5f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_ATServiceApi_proto_rawDescOnce sync.Once
	file_ATServiceApi_proto_rawDescData = file_ATServiceApi_proto_rawDesc
)

func file_ATServiceApi_proto_rawDescGZIP() []byte {
	file_ATServiceApi_proto_rawDescOnce.Do(func() {
		file_ATServiceApi_proto_rawDescData = protoimpl.X.CompressGZIP(file_ATServiceApi_proto_rawDescData)
	})
	return file_ATServiceApi_proto_rawDescData
}

var file_ATServiceApi_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ATServiceApi_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_ATServiceApi_proto_goTypes = []any{
	(ATLogDataType)(0),          // 0: ATLogDataType
	(*ATLogInsertRequest)(nil),  // 1: ATLogInsertRequest
	(*ATLogInsertResponse)(nil), // 2: ATLogInsertResponse
	(*ATLogProofRequest)(nil),   // 3: ATLogProofRequest
	(*ATLogProofResponse)(nil),  // 4: ATLogProofResponse
	(*ATLogProofs)(nil),         // 5: ATLogProofs
	(*LogConsistency)(nil),      // 6: LogConsistency
	(ProtocolVersion)(0),        // 7: ProtocolVersion
	(Application)(0),            // 8: Application
	(Status)(0),                 // 9: Status
	(*LogEntry)(nil),            // 10: LogEntry
	(*SignedObject)(nil),        // 11: SignedObject
}
var file_ATServiceApi_proto_depIdxs = []int32{
	7,  // 0: ATLogInsertRequest.version:type_name -> ProtocolVersion
	8,  // 1: ATLogInsertRequest.application:type_name -> Application
	0,  // 2: ATLogInsertRequest.type:type_name -> ATLogDataType
	9,  // 3: ATLogInsertResponse.status:type_name -> Status
	7,  // 4: ATLogProofRequest.version:type_name -> ProtocolVersion
	8,  // 5: ATLogProofRequest.application:type_name -> Application
	9,  // 6: ATLogProofResponse.status:type_name -> Status
	5,  // 7: ATLogProofResponse.proofs:type_name -> ATLogProofs
	10, // 8: ATLogProofs.inclusionProof:type_name -> LogEntry
	6,  // 9: ATLogProofs.milestoneConsistency:type_name -> LogConsistency
	11, // 10: LogConsistency.startSLH:type_name -> SignedObject
	11, // 11: LogConsistency.endSLH:type_name -> SignedObject
	10, // 12: LogConsistency.patInclusionProof:type_name -> LogEntry
	10, // 13: LogConsistency.tltInclusionProof:type_name -> LogEntry
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func file_ATServiceApi_proto_init() {
	if File_ATServiceApi_proto != nil {
		return
	}
	file_Transparency_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ATServiceApi_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ATServiceApi_proto_goTypes,
		DependencyIndexes: file_ATServiceApi_proto_depIdxs,
		EnumInfos:         file_ATServiceApi_proto_enumTypes,
		MessageInfos:      file_ATServiceApi_proto_msgTypes,
	}.Build()
	File_ATServiceApi_proto = out.File
	file_ATServiceApi_proto_rawDesc = nil
	file_ATServiceApi_proto_goTypes = nil
	file_ATServiceApi_proto_depIdxs = nil
}

type ListTreesResponse_Tree_State int32

const (
	ListTreesResponse_Tree_UNKNOWN ListTreesResponse_Tree_State = 0
	ListTreesResponse_Tree_STAGED  ListTreesResponse_Tree_State = 1
	ListTreesResponse_Tree_ACTIVE  ListTreesResponse_Tree_State = 2
	ListTreesResponse_Tree_RETIRED ListTreesResponse_Tree_State = 3
)

// Enum value maps for ListTreesResponse_Tree_State.
var (
	ListTreesResponse_Tree_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "STAGED",
		2: "ACTIVE",
		3: "RETIRED",
	}
	ListTreesResponse_Tree_State_value = map[string]int32{
		"UNKNOWN": 0,
		"STAGED":  1,
		"ACTIVE":  2,
		"RETIRED": 3,
	}
)

func (x ListTreesResponse_Tree_State) Enum() *ListTreesResponse_Tree_State {
	p := new(ListTreesResponse_Tree_State)
	*p = x
	return p
}

func (x ListTreesResponse_Tree_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListTreesResponse_Tree_State) Descriptor() protoreflect.EnumDescriptor {
	return file_AuditorApi_proto_enumTypes[0].Descriptor()
}

func (ListTreesResponse_Tree_State) Type() protoreflect.EnumType {
	return &file_AuditorApi_proto_enumTypes[0]
}

func (x ListTreesResponse_Tree_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListTreesResponse_Tree_State.Descriptor instead.
func (ListTreesResponse_Tree_State) EnumDescriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{1, 0, 0}
}

type ListTreesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	RequestUuid string          `protobuf:"bytes,2,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *ListTreesRequest) Reset() {
	*x = ListTreesRequest{}
	mi := &file_AuditorApi_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTreesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTreesRequest) ProtoMessage() {}

func (x *ListTreesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTreesRequest.ProtoReflect.Descriptor instead.
func (*ListTreesRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{0}
}

func (x *ListTreesRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *ListTreesRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type ListTreesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status                    `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	Trees  []*ListTreesResponse_Tree `protobuf:"bytes,2,rep,name=trees,proto3" json:"trees,omitempty"`
}

func (x *ListTreesResponse) Reset() {
	*x = ListTreesResponse{}
	mi := &file_AuditorApi_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTreesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTreesResponse) ProtoMessage() {}

func (x *ListTreesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTreesResponse.ProtoReflect.Descriptor instead.
func (*ListTreesResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{1}
}

func (x *ListTreesResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *ListTreesResponse) GetTrees() []*ListTreesResponse_Tree {
	if x != nil {
		return x.Trees
	}
	return nil
}

type LogLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	TreeId  uint64          `protobuf:"varint,2,opt,name=treeId,proto3" json:"treeId,omitempty"`
	// 3 -- can reuse
	StartIndex      uint64 `protobuf:"varint,4,opt,name=startIndex,proto3" json:"startIndex,omitempty"`
	EndIndex        uint64 `protobuf:"varint,5,opt,name=endIndex,proto3" json:"endIndex,omitempty"`      // Exclusive
	RequestUuid     string `protobuf:"bytes,6,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
	StartMergeGroup uint32 `protobuf:"varint,7,opt,name=startMergeGroup,proto3" json:"startMergeGroup,omitempty"`
	EndMergeGroup   uint32 `protobuf:"varint,8,opt,name=endMergeGroup,proto3" json:"endMergeGroup,omitempty"`
}

func (x *LogLeavesRequest) Reset() {
	*x = LogLeavesRequest{}
	mi := &file_AuditorApi_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesRequest) ProtoMessage() {}

func (x *LogLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesRequest.ProtoReflect.Descriptor instead.
func (*LogLeavesRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{2}
}

func (x *LogLeavesRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *LogLeavesRequest) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *LogLeavesRequest) GetStartIndex() uint64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *LogLeavesRequest) GetEndIndex() uint64 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *LogLeavesRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

func (x *LogLeavesRequest) GetStartMergeGroup() uint32 {
	if x != nil {
		return x.StartMergeGroup
	}
	return 0
}

func (x *LogLeavesRequest) GetEndMergeGroup() uint32 {
	if x != nil {
		return x.EndMergeGroup
	}
	return 0
}

type LogLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Return NOT_FOUND if any leaves in requested range do not exist.
	// Return INVALID_REQUEST if merge group range is invalid
	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	// 2 - can reuse
	Leaves []*LogLeavesResponse_Leaf `protobuf:"bytes,3,rep,name=leaves,proto3" json:"leaves,omitempty"`
}

func (x *LogLeavesResponse) Reset() {
	*x = LogLeavesResponse{}
	mi := &file_AuditorApi_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesResponse) ProtoMessage() {}

func (x *LogLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesResponse.ProtoReflect.Descriptor instead.
func (*LogLeavesResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{3}
}

func (x *LogLeavesResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *LogLeavesResponse) GetLeaves() []*LogLeavesResponse_Leaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

type LogLeavesForRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	LogType     LogType         `protobuf:"varint,2,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"` // must be PER_APPLICATION_TREE or TOP_LEVEL_TREE
	Application Application     `protobuf:"varint,3,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	Revision    uint64          `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`      // Set to -1 to request latest revision
	RequestUuid string          `protobuf:"bytes,5,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *LogLeavesForRevisionRequest) Reset() {
	*x = LogLeavesForRevisionRequest{}
	mi := &file_AuditorApi_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesForRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesForRevisionRequest) ProtoMessage() {}

func (x *LogLeavesForRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesForRevisionRequest.ProtoReflect.Descriptor instead.
func (*LogLeavesForRevisionRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{4}
}

func (x *LogLeavesForRevisionRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *LogLeavesForRevisionRequest) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *LogLeavesForRevisionRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *LogLeavesForRevisionRequest) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *LogLeavesForRevisionRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type LogLeavesForRevisionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status                               `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"` // Returns NOT_FOUND if revision does not exist.
	Slh    *SignedObject                        `protobuf:"bytes,2,opt,name=slh,proto3" json:"slh,omitempty"`                    // for requested revision. Inclusion proofs will use this root.
	Leaves []*LogLeavesForRevisionResponse_Leaf `protobuf:"bytes,3,rep,name=leaves,proto3" json:"leaves,omitempty"`              // not guaranteed to be in order.
}

func (x *LogLeavesForRevisionResponse) Reset() {
	*x = LogLeavesForRevisionResponse{}
	mi := &file_AuditorApi_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesForRevisionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesForRevisionResponse) ProtoMessage() {}

func (x *LogLeavesForRevisionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesForRevisionResponse.ProtoReflect.Descriptor instead.
func (*LogLeavesForRevisionResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{5}
}

func (x *LogLeavesForRevisionResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *LogLeavesForRevisionResponse) GetSlh() *SignedObject {
	if x != nil {
		return x.Slh
	}
	return nil
}

func (x *LogLeavesForRevisionResponse) GetLeaves() []*LogLeavesForRevisionResponse_Leaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

type LogHeadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	TreeId  uint64          `protobuf:"varint,2,opt,name=treeId,proto3" json:"treeId,omitempty"`
	// 3 -- can reuse
	Revision    int64  `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`      // Set to -1 to request latest revision
	RequestUuid string `protobuf:"bytes,5,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *LogHeadRequest) Reset() {
	*x = LogHeadRequest{}
	mi := &file_AuditorApi_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogHeadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogHeadRequest) ProtoMessage() {}

func (x *LogHeadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogHeadRequest.ProtoReflect.Descriptor instead.
func (*LogHeadRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{6}
}

func (x *LogHeadRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *LogHeadRequest) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *LogHeadRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *LogHeadRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type LogHeadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status  Status        `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	LogHead *SignedObject `protobuf:"bytes,4,opt,name=logHead,proto3" json:"logHead,omitempty"`
}

func (x *LogHeadResponse) Reset() {
	*x = LogHeadResponse{}
	mi := &file_AuditorApi_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogHeadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogHeadResponse) ProtoMessage() {}

func (x *LogHeadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogHeadResponse.ProtoReflect.Descriptor instead.
func (*LogHeadResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{7}
}

func (x *LogHeadResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *LogHeadResponse) GetLogHead() *SignedObject {
	if x != nil {
		return x.LogHead
	}
	return nil
}

type MapHeadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	TreeId  uint64          `protobuf:"varint,2,opt,name=treeId,proto3" json:"treeId,omitempty"`
	// 3 -- can reuse
	Revision    int64  `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`      // Set to -1 to request latest revision
	RequestUuid string `protobuf:"bytes,5,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *MapHeadRequest) Reset() {
	*x = MapHeadRequest{}
	mi := &file_AuditorApi_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapHeadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapHeadRequest) ProtoMessage() {}

func (x *MapHeadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapHeadRequest.ProtoReflect.Descriptor instead.
func (*MapHeadRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{8}
}

func (x *MapHeadRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *MapHeadRequest) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *MapHeadRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *MapHeadRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type MapHeadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status        `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	Smh    *SignedObject `protobuf:"bytes,2,opt,name=smh,proto3" json:"smh,omitempty"`
}

func (x *MapHeadResponse) Reset() {
	*x = MapHeadResponse{}
	mi := &file_AuditorApi_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapHeadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapHeadResponse) ProtoMessage() {}

func (x *MapHeadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapHeadResponse.ProtoReflect.Descriptor instead.
func (*MapHeadResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{9}
}

func (x *MapHeadResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *MapHeadResponse) GetSmh() *SignedObject {
	if x != nil {
		return x.Smh
	}
	return nil
}

type MapNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	TreeId  uint64          `protobuf:"varint,2,opt,name=treeId,proto3" json:"treeId,omitempty"`
	// 3 -- can reuse
	Path  []byte `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`    // Must have at least depth bits, may be longer
	Depth uint32 `protobuf:"varint,5,opt,name=depth,proto3" json:"depth,omitempty"` // Top-down: 0 is root level, 255 is leaf level
	// Request for revision 'i' will return version of node with highest revision less than or equal to 'i'
	Revision    uint64 `protobuf:"varint,6,opt,name=revision,proto3" json:"revision,omitempty"`
	RequestUuid string `protobuf:"bytes,7,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *MapNodeRequest) Reset() {
	*x = MapNodeRequest{}
	mi := &file_AuditorApi_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapNodeRequest) ProtoMessage() {}

func (x *MapNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapNodeRequest.ProtoReflect.Descriptor instead.
func (*MapNodeRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{10}
}

func (x *MapNodeRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *MapNodeRequest) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *MapNodeRequest) GetPath() []byte {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *MapNodeRequest) GetDepth() uint32 {
	if x != nil {
		return x.Depth
	}
	return 0
}

func (x *MapNodeRequest) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *MapNodeRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type MapNodeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Return NOT_FOUND if requested node does not exist in map for specified revision
	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	Hash   []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	Value  []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"` // only present if this is a leaf node
}

func (x *MapNodeResponse) Reset() {
	*x = MapNodeResponse{}
	mi := &file_AuditorApi_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapNodeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapNodeResponse) ProtoMessage() {}

func (x *MapNodeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapNodeResponse.ProtoReflect.Descriptor instead.
func (*MapNodeResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{11}
}

func (x *MapNodeResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *MapNodeResponse) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *MapNodeResponse) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type PaclInclusionProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	Smts        []*SignedObject `protobuf:"bytes,3,rep,name=smts,proto3" json:"smts,omitempty"`
	RequestUuid string          `protobuf:"bytes,4,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging
}

func (x *PaclInclusionProofRequest) Reset() {
	*x = PaclInclusionProofRequest{}
	mi := &file_AuditorApi_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PaclInclusionProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PaclInclusionProofRequest) ProtoMessage() {}

func (x *PaclInclusionProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PaclInclusionProofRequest.ProtoReflect.Descriptor instead.
func (*PaclInclusionProofRequest) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{12}
}

func (x *PaclInclusionProofRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *PaclInclusionProofRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *PaclInclusionProofRequest) GetSmts() []*SignedObject {
	if x != nil {
		return x.Smts
	}
	return nil
}

func (x *PaclInclusionProofRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type PaclInclusionProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status   Status      `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"` // OK, INVALID_REQUEST, or INTERNAL_ERROR
	LogEntry []*LogEntry `protobuf:"bytes,2,rep,name=logEntry,proto3" json:"logEntry,omitempty"`
}

func (x *PaclInclusionProofResponse) Reset() {
	*x = PaclInclusionProofResponse{}
	mi := &file_AuditorApi_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PaclInclusionProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PaclInclusionProofResponse) ProtoMessage() {}

func (x *PaclInclusionProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PaclInclusionProofResponse.ProtoReflect.Descriptor instead.
func (*PaclInclusionProofResponse) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{13}
}

func (x *PaclInclusionProofResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *PaclInclusionProofResponse) GetLogEntry() []*LogEntry {
	if x != nil {
		return x.LogEntry
	}
	return nil
}

type ListTreesResponse_Tree struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TreeId         uint64 `protobuf:"varint,1,opt,name=treeId,proto3" json:"treeId,omitempty"`
	LogBeginningMs uint64 `protobuf:"varint,2,opt,name=logBeginningMs,proto3" json:"logBeginningMs,omitempty"`
	// Types that are assignable to Type:
	//
	//	*ListTreesResponse_Tree_LogType
	//	*ListTreesResponse_Tree_MapType
	Type           isListTreesResponse_Tree_Type `protobuf_oneof:"Type"`
	Application    Application                   `protobuf:"varint,5,opt,name=application,proto3,enum=Application" json:"application,omitempty"` // will be null if LogType is Top-level Tree
	State          ListTreesResponse_Tree_State  `protobuf:"varint,6,opt,name=state,proto3,enum=ListTreesResponse_Tree_State" json:"state,omitempty"`
	MergeGroups    uint64                        `protobuf:"varint,7,opt,name=mergeGroups,proto3" json:"mergeGroups,omitempty"`      // only present for Logs
	PublicKeyBytes []byte                        `protobuf:"bytes,8,opt,name=publicKeyBytes,proto3" json:"publicKeyBytes,omitempty"` // public key for signing roots of all trees for this app, encoded in DER SPKI
}

func (x *ListTreesResponse_Tree) Reset() {
	*x = ListTreesResponse_Tree{}
	mi := &file_AuditorApi_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTreesResponse_Tree) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTreesResponse_Tree) ProtoMessage() {}

func (x *ListTreesResponse_Tree) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTreesResponse_Tree.ProtoReflect.Descriptor instead.
func (*ListTreesResponse_Tree) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ListTreesResponse_Tree) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *ListTreesResponse_Tree) GetLogBeginningMs() uint64 {
	if x != nil {
		return x.LogBeginningMs
	}
	return 0
}

func (m *ListTreesResponse_Tree) GetType() isListTreesResponse_Tree_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ListTreesResponse_Tree) GetLogType() LogType {
	if x, ok := x.GetType().(*ListTreesResponse_Tree_LogType); ok {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *ListTreesResponse_Tree) GetMapType() MapType {
	if x, ok := x.GetType().(*ListTreesResponse_Tree_MapType); ok {
		return x.MapType
	}
	return MapType_UNKNOWN_MAP
}

func (x *ListTreesResponse_Tree) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *ListTreesResponse_Tree) GetState() ListTreesResponse_Tree_State {
	if x != nil {
		return x.State
	}
	return ListTreesResponse_Tree_UNKNOWN
}

func (x *ListTreesResponse_Tree) GetMergeGroups() uint64 {
	if x != nil {
		return x.MergeGroups
	}
	return 0
}

func (x *ListTreesResponse_Tree) GetPublicKeyBytes() []byte {
	if x != nil {
		return x.PublicKeyBytes
	}
	return nil
}

type isListTreesResponse_Tree_Type interface {
	isListTreesResponse_Tree_Type()
}

type ListTreesResponse_Tree_LogType struct {
	LogType LogType `protobuf:"varint,3,opt,name=logType,proto3,enum=LogType,oneof"`
}

type ListTreesResponse_Tree_MapType struct {
	MapType MapType `protobuf:"varint,4,opt,name=mapType,proto3,enum=MapType,oneof"`
}

func (*ListTreesResponse_Tree_LogType) isListTreesResponse_Tree_Type() {}

func (*ListTreesResponse_Tree_MapType) isListTreesResponse_Tree_Type() {}

type LogLeavesResponse_Leaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodeType   NodeType `protobuf:"varint,1,opt,name=nodeType,proto3,enum=NodeType" json:"nodeType,omitempty"`
	NodeBytes  []byte   `protobuf:"bytes,2,opt,name=nodeBytes,proto3" json:"nodeBytes,omitempty"` // parse as appropriate for nodeType
	Index      uint64   `protobuf:"varint,3,opt,name=index,proto3" json:"index,omitempty"`        // 0-indexed
	MergeGroup uint32   `protobuf:"varint,4,opt,name=mergeGroup,proto3" json:"mergeGroup,omitempty"`
	RawData    []byte   `protobuf:"bytes,5,opt,name=rawData,proto3" json:"rawData,omitempty"`   // only for AT leaves
	Metadata   []byte   `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"` // only for AT leaves
}

func (x *LogLeavesResponse_Leaf) Reset() {
	*x = LogLeavesResponse_Leaf{}
	mi := &file_AuditorApi_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesResponse_Leaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesResponse_Leaf) ProtoMessage() {}

func (x *LogLeavesResponse_Leaf) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesResponse_Leaf.ProtoReflect.Descriptor instead.
func (*LogLeavesResponse_Leaf) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{3, 0}
}

func (x *LogLeavesResponse_Leaf) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_PACL_NODE
}

func (x *LogLeavesResponse_Leaf) GetNodeBytes() []byte {
	if x != nil {
		return x.NodeBytes
	}
	return nil
}

func (x *LogLeavesResponse_Leaf) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *LogLeavesResponse_Leaf) GetMergeGroup() uint32 {
	if x != nil {
		return x.MergeGroup
	}
	return 0
}

func (x *LogLeavesResponse_Leaf) GetRawData() []byte {
	if x != nil {
		return x.RawData
	}
	return nil
}

func (x *LogLeavesResponse_Leaf) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type LogLeavesForRevisionResponse_Leaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodeType                  NodeType `protobuf:"varint,1,opt,name=nodeType,proto3,enum=NodeType" json:"nodeType,omitempty"`
	NodeBytes                 []byte   `protobuf:"bytes,2,opt,name=nodeBytes,proto3" json:"nodeBytes,omitempty"`                                 // parse as appropriate for nodeType
	NodePosition              uint64   `protobuf:"varint,3,opt,name=nodePosition,proto3" json:"nodePosition,omitempty"`                          // in range [0, slh.logSize)
	HashesOfPeersInPathToRoot [][]byte `protobuf:"bytes,4,rep,name=hashesOfPeersInPathToRoot,proto3" json:"hashesOfPeersInPathToRoot,omitempty"` // Path to slh above. Ordered with leaf at 0, root-1 at end
	RawData                   []byte   `protobuf:"bytes,5,opt,name=rawData,proto3" json:"rawData,omitempty"`                                     // only for AT leaves
	Metadata                  []byte   `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`                                   // only for AT leaves
}

func (x *LogLeavesForRevisionResponse_Leaf) Reset() {
	*x = LogLeavesForRevisionResponse_Leaf{}
	mi := &file_AuditorApi_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogLeavesForRevisionResponse_Leaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeavesForRevisionResponse_Leaf) ProtoMessage() {}

func (x *LogLeavesForRevisionResponse_Leaf) ProtoReflect() protoreflect.Message {
	mi := &file_AuditorApi_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeavesForRevisionResponse_Leaf.ProtoReflect.Descriptor instead.
func (*LogLeavesForRevisionResponse_Leaf) Descriptor() ([]byte, []int) {
	return file_AuditorApi_proto_rawDescGZIP(), []int{5, 0}
}

func (x *LogLeavesForRevisionResponse_Leaf) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_PACL_NODE
}

func (x *LogLeavesForRevisionResponse_Leaf) GetNodeBytes() []byte {
	if x != nil {
		return x.NodeBytes
	}
	return nil
}

func (x *LogLeavesForRevisionResponse_Leaf) GetNodePosition() uint64 {
	if x != nil {
		return x.NodePosition
	}
	return 0
}

func (x *LogLeavesForRevisionResponse_Leaf) GetHashesOfPeersInPathToRoot() [][]byte {
	if x != nil {
		return x.HashesOfPeersInPathToRoot
	}
	return nil
}

func (x *LogLeavesForRevisionResponse_Leaf) GetRawData() []byte {
	if x != nil {
		return x.RawData
	}
	return nil
}

func (x *LogLeavesForRevisionResponse_Leaf) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

var File_AuditorApi_proto protoreflect.FileDescriptor

var file_AuditorApi_proto_rawDesc = []byte{
	0x0a, 0x10, 0x41, 0x75, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x41, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x11, 0x4b, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x41, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x60, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10,
	0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22, 0xea, 0x03, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x74, 0x72, 0x65, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x72, 0x65, 0x65, 0x52, 0x05, 0x74, 0x72, 0x65, 0x65,
	0x73, 0x1a, 0x84, 0x03, 0x0a, 0x04, 0x54, 0x72, 0x65, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72,
	0x65, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x72, 0x65, 0x65,
	0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x4d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x42,
	0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x12, 0x24, 0x0a, 0x07, 0x6c, 0x6f,
	0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x4c, 0x6f,
	0x67, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x24, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x08, 0x2e, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6d,
	0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x72, 0x65, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x6d,
	0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a,
	0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x39, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x54, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x54, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03,
	0x42, 0x06, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x22, 0x84, 0x02, 0x0a, 0x10, 0x4c, 0x6f, 0x67,
	0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10,
	0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x65,
	0x65, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49,
	0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x20, 0x0a,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x12,
	0x28, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d,
	0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x24, 0x0a, 0x0d, 0x65, 0x6e, 0x64,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22,
	0x9f, 0x02, 0x0a, 0x11, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x65, 0x61, 0x66, 0x52,
	0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x1a, 0xb7, 0x01, 0x0a, 0x04, 0x4c, 0x65, 0x61, 0x66,
	0x12, 0x25, 0x0a, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6e,
	0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x6d,
	0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x72,
	0x61, 0x77, 0x44, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x72, 0x61,
	0x77, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xdb, 0x01, 0x0a, 0x1b, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x46,
	0x6f, 0x72, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08,
	0x2e, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22,
	0x82, 0x03, 0x0a, 0x1c, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x46, 0x6f, 0x72,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x1f, 0x0a, 0x03, 0x73, 0x6c, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x03, 0x73,
	0x6c, 0x68, 0x12, 0x3a, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x46, 0x6f,
	0x72, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x1a, 0xe3,
	0x01, 0x0a, 0x04, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x25, 0x0a, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x0a, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65, 0x72,
	0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0c, 0x52, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65,
	0x72, 0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x18,
	0x0a, 0x07, 0x72, 0x61, 0x77, 0x44, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x72, 0x61, 0x77, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x92, 0x01, 0x0a, 0x0e, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22, 0x5b, 0x0a, 0x0f, 0x4c, 0x6f, 0x67,
	0x48, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x27, 0x0a,
	0x07, 0x6c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x0e, 0x4d, 0x61, 0x70, 0x48, 0x65,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22, 0x53, 0x0a, 0x0f, 0x4d,
	0x61, 0x70, 0x48, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1f, 0x0a, 0x03, 0x73, 0x6d, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x03, 0x73, 0x6d, 0x68,
	0x22, 0xbc, 0x01, 0x0a, 0x0e, 0x4d, 0x61, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x64,
	0x65, 0x70, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x64, 0x65, 0x70, 0x74,
	0x68, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22,
	0x5c, 0x0a, 0x0f, 0x4d, 0x61, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbc, 0x01,
	0x0a, 0x19, 0x50, 0x61, 0x63, 0x6c, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x04, 0x73, 0x6d, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x04, 0x73, 0x6d, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22, 0x64, 0x0a, 0x1a,
	0x50, 0x61, 0x63, 0x6c, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x08, 0x6c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x09, 0x2e,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x32, 0xae, 0x04, 0x0a, 0x0c, 0x4b, 0x74, 0x41, 0x75, 0x64, 0x69, 0x74, 0x6f, 0x72,
	0x41, 0x70, 0x69, 0x12, 0x4c, 0x0a, 0x15, 0x61, 0x75, 0x64, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x18, 0x2e, 0x43,
	0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3a, 0x0a, 0x0f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0x12, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x09, 0x6c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x12, 0x11, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x12, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x32, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x11,
	0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x12, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x14, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x46, 0x6f, 0x72, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x2e,
	0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x6c, 0x6f,
	0x67, 0x48, 0x65, 0x61, 0x64, 0x12, 0x0f, 0x2e, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x10, 0x2e, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x48,
	0x65, 0x61, 0x64, 0x12, 0x0f, 0x2e, 0x4d, 0x61, 0x70, 0x48, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x10, 0x2e, 0x4d, 0x61, 0x70, 0x48, 0x65, 0x61, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x0f, 0x2e, 0x4d, 0x61, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x10, 0x2e, 0x4d, 0x61, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x70, 0x61, 0x63, 0x6c, 0x49, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x1a, 0x2e, 0x50, 0x61, 0x63,
	0x6c, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x50, 0x61, 0x63, 0x6c, 0x49, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x42, 0x5a, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65,
	0x2e, 0x6b, 0x65, 0x79, 0x74, 0x2e, 0x61, 0x70, 0x69, 0x42, 0x0a, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x74, 0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73,
	0x77, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x2f, 0x70, 0x63, 0x63, 0xba, 0x02, 0x05, 0x54, 0x78, 0x50, 0x42, 0x5f, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_AuditorApi_proto_rawDescOnce sync.Once
	file_AuditorApi_proto_rawDescData = file_AuditorApi_proto_rawDesc
)

func file_AuditorApi_proto_rawDescGZIP() []byte {
	file_AuditorApi_proto_rawDescOnce.Do(func() {
		file_AuditorApi_proto_rawDescData = protoimpl.X.CompressGZIP(file_AuditorApi_proto_rawDescData)
	})
	return file_AuditorApi_proto_rawDescData
}

var file_AuditorApi_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_AuditorApi_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_AuditorApi_proto_goTypes = []any{
	(ListTreesResponse_Tree_State)(0),         // 0: ListTreesResponse.Tree.State
	(*ListTreesRequest)(nil),                  // 1: ListTreesRequest
	(*ListTreesResponse)(nil),                 // 2: ListTreesResponse
	(*LogLeavesRequest)(nil),                  // 3: LogLeavesRequest
	(*LogLeavesResponse)(nil),                 // 4: LogLeavesResponse
	(*LogLeavesForRevisionRequest)(nil),       // 5: LogLeavesForRevisionRequest
	(*LogLeavesForRevisionResponse)(nil),      // 6: LogLeavesForRevisionResponse
	(*LogHeadRequest)(nil),                    // 7: LogHeadRequest
	(*LogHeadResponse)(nil),                   // 8: LogHeadResponse
	(*MapHeadRequest)(nil),                    // 9: MapHeadRequest
	(*MapHeadResponse)(nil),                   // 10: MapHeadResponse
	(*MapNodeRequest)(nil),                    // 11: MapNodeRequest
	(*MapNodeResponse)(nil),                   // 12: MapNodeResponse
	(*PaclInclusionProofRequest)(nil),         // 13: PaclInclusionProofRequest
	(*PaclInclusionProofResponse)(nil),        // 14: PaclInclusionProofResponse
	(*ListTreesResponse_Tree)(nil),            // 15: ListTreesResponse.Tree
	(*LogLeavesResponse_Leaf)(nil),            // 16: LogLeavesResponse.Leaf
	(*LogLeavesForRevisionResponse_Leaf)(nil), // 17: LogLeavesForRevisionResponse.Leaf
	(ProtocolVersion)(0),                      // 18: ProtocolVersion
	(Status)(0),                               // 19: Status
	(LogType)(0),                              // 20: LogType
	(Application)(0),                          // 21: Application
	(*SignedObject)(nil),                      // 22: SignedObject
	(*LogEntry)(nil),                          // 23: LogEntry
	(MapType)(0),                              // 24: MapType
	(NodeType)(0),                             // 25: NodeType
	(*ConsistencyProofRequest)(nil),           // 26: ConsistencyProofRequest
	(*PublicKeysRequest)(nil),                 // 27: PublicKeysRequest
	(*ConsistencyProofResponse)(nil),          // 28: ConsistencyProofResponse
	(*PublicKeysResponse)(nil),                // 29: PublicKeysResponse
}
var file_AuditorApi_proto_depIdxs = []int32{
	18, // 0: ListTreesRequest.version:type_name -> ProtocolVersion
	19, // 1: ListTreesResponse.status:type_name -> Status
	15, // 2: ListTreesResponse.trees:type_name -> ListTreesResponse.Tree
	18, // 3: LogLeavesRequest.version:type_name -> ProtocolVersion
	19, // 4: LogLeavesResponse.status:type_name -> Status
	16, // 5: LogLeavesResponse.leaves:type_name -> LogLeavesResponse.Leaf
	18, // 6: LogLeavesForRevisionRequest.version:type_name -> ProtocolVersion
	20, // 7: LogLeavesForRevisionRequest.logType:type_name -> LogType
	21, // 8: LogLeavesForRevisionRequest.application:type_name -> Application
	19, // 9: LogLeavesForRevisionResponse.status:type_name -> Status
	22, // 10: LogLeavesForRevisionResponse.slh:type_name -> SignedObject
	17, // 11: LogLeavesForRevisionResponse.leaves:type_name -> LogLeavesForRevisionResponse.Leaf
	18, // 12: LogHeadRequest.version:type_name -> ProtocolVersion
	19, // 13: LogHeadResponse.status:type_name -> Status
	22, // 14: LogHeadResponse.logHead:type_name -> SignedObject
	18, // 15: MapHeadRequest.version:type_name -> ProtocolVersion
	19, // 16: MapHeadResponse.status:type_name -> Status
	22, // 17: MapHeadResponse.smh:type_name -> SignedObject
	18, // 18: MapNodeRequest.version:type_name -> ProtocolVersion
	19, // 19: MapNodeResponse.status:type_name -> Status
	18, // 20: PaclInclusionProofRequest.version:type_name -> ProtocolVersion
	21, // 21: PaclInclusionProofRequest.application:type_name -> Application
	22, // 22: PaclInclusionProofRequest.smts:type_name -> SignedObject
	19, // 23: PaclInclusionProofResponse.status:type_name -> Status
	23, // 24: PaclInclusionProofResponse.logEntry:type_name -> LogEntry
	20, // 25: ListTreesResponse.Tree.logType:type_name -> LogType
	24, // 26: ListTreesResponse.Tree.mapType:type_name -> MapType
	21, // 27: ListTreesResponse.Tree.application:type_name -> Application
	0,  // 28: ListTreesResponse.Tree.state:type_name -> ListTreesResponse.Tree.State
	25, // 29: LogLeavesResponse.Leaf.nodeType:type_name -> NodeType
	25, // 30: LogLeavesForRevisionResponse.Leaf.nodeType:type_name -> NodeType
	26, // 31: KtAuditorApi.auditConsistencyProof:input_type -> ConsistencyProofRequest
	27, // 32: KtAuditorApi.auditPublicKeys:input_type -> PublicKeysRequest
	1,  // 33: KtAuditorApi.listTrees:input_type -> ListTreesRequest
	3,  // 34: KtAuditorApi.logLeaves:input_type -> LogLeavesRequest
	5,  // 35: KtAuditorApi.logLeavesForRevision:input_type -> LogLeavesForRevisionRequest
	7,  // 36: KtAuditorApi.logHead:input_type -> LogHeadRequest
	9,  // 37: KtAuditorApi.mapHead:input_type -> MapHeadRequest
	11, // 38: KtAuditorApi.mapNode:input_type -> MapNodeRequest
	13, // 39: KtAuditorApi.paclInclusionProof:input_type -> PaclInclusionProofRequest
	28, // 40: KtAuditorApi.auditConsistencyProof:output_type -> ConsistencyProofResponse
	29, // 41: KtAuditorApi.auditPublicKeys:output_type -> PublicKeysResponse
	2,  // 42: KtAuditorApi.listTrees:output_type -> ListTreesResponse
	4,  // 43: KtAuditorApi.logLeaves:output_type -> LogLeavesResponse
	6,  // 44: KtAuditorApi.logLeavesForRevision:output_type -> LogLeavesForRevisionResponse
	8,  // 45: KtAuditorApi.logHead:output_type -> LogHeadResponse
	10, // 46: KtAuditorApi.mapHead:output_type -> MapHeadResponse
	12, // 47: KtAuditorApi.mapNode:output_type -> MapNodeResponse
	14, // 48: KtAuditorApi.paclInclusionProof:output_type -> PaclInclusionProofResponse
	40, // [40:49] is the sub-list for method output_type
	31, // [31:40] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func file_AuditorApi_proto_init() {
	if File_AuditorApi_proto != nil {
		return
	}
	file_Transparency_proto_init()
	file_KtClientApi_proto_init()
	file_AuditorApi_proto_msgTypes[14].OneofWrappers = []any{
		(*ListTreesResponse_Tree_LogType)(nil),
		(*ListTreesResponse_Tree_MapType)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_AuditorApi_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_AuditorApi_proto_goTypes,
		DependencyIndexes: file_AuditorApi_proto_depIdxs,
		EnumInfos:         file_AuditorApi_proto_enumTypes,
		MessageInfos:      file_AuditorApi_proto_msgTypes,
	}.Build()
	File_AuditorApi_proto = out.File
	file_AuditorApi_proto_rawDesc = nil
	file_AuditorApi_proto_goTypes = nil
	file_AuditorApi_proto_depIdxs = nil
}

type ConsistencyProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion                                  `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Requests    []*ConsistencyProofRequest_LogConsistencyRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	LogType     LogType                                          `protobuf:"varint,3,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"`
	Application Application                                      `protobuf:"varint,4,opt,name=application,proto3,enum=Application" json:"application,omitempty"` // If logType is not TopLevelTree, provide an application
	RequestUuid string                                           `protobuf:"bytes,5,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"`                   // Used for logging, not expected when uuid is passed in headers
}

func (x *ConsistencyProofRequest) Reset() {
	*x = ConsistencyProofRequest{}
	mi := &file_KtClientApi_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConsistencyProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistencyProofRequest) ProtoMessage() {}

func (x *ConsistencyProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistencyProofRequest.ProtoReflect.Descriptor instead.
func (*ConsistencyProofRequest) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{0}
}

func (x *ConsistencyProofRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *ConsistencyProofRequest) GetRequests() []*ConsistencyProofRequest_LogConsistencyRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *ConsistencyProofRequest) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *ConsistencyProofRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *ConsistencyProofRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

// Note: the server may, at its discretion, return multiple LogConsistencyResponses for a single LogConsistencyRequest.
// For example, if a client requests a proof from revision 51 to 130, the server may return a consistency
// proof of [51,130], or multiple adjoining proofs, like [51, 100], [100, 120], [120, 130].
//
// The server may omit proofs (such as when too many are requested), the client should record the
// returned proofs and make a new request for the unfulfilled proofs.
type ConsistencyProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	// 2 - can reuse
	// these will be sorted by logId, start revision, end revision
	Responses   []*ConsistencyProofResponse_LogConsistencyResponse `protobuf:"bytes,3,rep,name=responses,proto3" json:"responses,omitempty"`
	LogType     LogType                                            `protobuf:"varint,4,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"`
	Application Application                                        `protobuf:"varint,5,opt,name=application,proto3,enum=Application" json:"application,omitempty"` // If logType is not TopLevelTree, provide an application
}

func (x *ConsistencyProofResponse) Reset() {
	*x = ConsistencyProofResponse{}
	mi := &file_KtClientApi_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConsistencyProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistencyProofResponse) ProtoMessage() {}

func (x *ConsistencyProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistencyProofResponse.ProtoReflect.Descriptor instead.
func (*ConsistencyProofResponse) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{1}
}

func (x *ConsistencyProofResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *ConsistencyProofResponse) GetResponses() []*ConsistencyProofResponse_LogConsistencyResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *ConsistencyProofResponse) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *ConsistencyProofResponse) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

type RevisionLogInclusionProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	LogType     LogType         `protobuf:"varint,3,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"` // Type of log in which to lookup leaves, either PAT or TLT
	// If logType is PAT, revisions will be from PAM. If logType is TLT, revisions will be from PAT.
	Revision []uint64 `protobuf:"varint,4,rep,packed,name=revision,proto3" json:"revision,omitempty"`
}

func (x *RevisionLogInclusionProofRequest) Reset() {
	*x = RevisionLogInclusionProofRequest{}
	mi := &file_KtClientApi_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RevisionLogInclusionProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevisionLogInclusionProofRequest) ProtoMessage() {}

func (x *RevisionLogInclusionProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevisionLogInclusionProofRequest.ProtoReflect.Descriptor instead.
func (*RevisionLogInclusionProofRequest) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{2}
}

func (x *RevisionLogInclusionProofRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *RevisionLogInclusionProofRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *RevisionLogInclusionProofRequest) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *RevisionLogInclusionProofRequest) GetRevision() []uint64 {
	if x != nil {
		return x.Revision
	}
	return nil
}

// The server may omit proofs (such as when too many are requested), the client should record the
// returned proofs and make a new request for the unfulfilled proofs.
type RevisionLogInclusionProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"` // OK, INVALID_REQUEST, or INTERNAL_ERROR
	// not guaranteed to have every requested proof
	// all these proofs will be under the same log head, sorted by leaf index
	LogEntry []*LogEntry `protobuf:"bytes,4,rep,name=logEntry,proto3" json:"logEntry,omitempty"`
	// if logEntries contains PAT proofs, this will be proof of the PAT head in the TLT, may be absent
	TopLevelTreeEntry *LogEntry `protobuf:"bytes,5,opt,name=topLevelTreeEntry,proto3" json:"topLevelTreeEntry,omitempty"`
}

func (x *RevisionLogInclusionProofResponse) Reset() {
	*x = RevisionLogInclusionProofResponse{}
	mi := &file_KtClientApi_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RevisionLogInclusionProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevisionLogInclusionProofResponse) ProtoMessage() {}

func (x *RevisionLogInclusionProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevisionLogInclusionProofResponse.ProtoReflect.Descriptor instead.
func (*RevisionLogInclusionProofResponse) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{3}
}

func (x *RevisionLogInclusionProofResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *RevisionLogInclusionProofResponse) GetLogEntry() []*LogEntry {
	if x != nil {
		return x.LogEntry
	}
	return nil
}

func (x *RevisionLogInclusionProofResponse) GetTopLevelTreeEntry() *LogEntry {
	if x != nil {
		return x.TopLevelTreeEntry
	}
	return nil
}

// When making requests over HTTP the body can be omitted.  Instead, the Application should
// be specified in the "x-apple-application" header using the numeric value, and the version
// specified in the "x-protocol-version" header using the enum value.
// Version 2, iMessage would be indicated with:
// x-apple-application: 1
// x-protocol-version: V2
type PublicKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=ProtocolVersion" json:"version,omitempty"`
	Application Application     `protobuf:"varint,2,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	RequestUuid string          `protobuf:"bytes,3,opt,name=requestUuid,proto3" json:"requestUuid,omitempty"` // Used for logging, not expected when uuid is passed in headers
}

func (x *PublicKeysRequest) Reset() {
	*x = PublicKeysRequest{}
	mi := &file_KtClientApi_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeysRequest) ProtoMessage() {}

func (x *PublicKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeysRequest.ProtoReflect.Descriptor instead.
func (*PublicKeysRequest) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{4}
}

func (x *PublicKeysRequest) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *PublicKeysRequest) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *PublicKeysRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

type PublicKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status Status `protobuf:"varint,1,opt,name=status,proto3,enum=Status" json:"status,omitempty"`
	// DER-encoded SMT and STH signing certificate(s) for the application's trees.
	AppLeafs [][]byte `protobuf:"bytes,2,rep,name=appLeafs,proto3" json:"appLeafs,omitempty"`
	// DER-encoded STH signing certificate(s) for the TLT.
	TltLeafs [][]byte `protobuf:"bytes,3,rep,name=tltLeafs,proto3" json:"tltLeafs,omitempty"`
	// DER-encoded intermediate certificate(s).
	Intermediates [][]byte `protobuf:"bytes,4,rep,name=intermediates,proto3" json:"intermediates,omitempty"` // V2 removed: vrfKey = 5, vrfSignature = 6, vrfPublicKey = 7, tltBeginningMs = 8
	// inclusion proof of the PerApplicationTreeConfigNode
	// Contains VRF public key, public key for signing roots of all trees for this app, and minimum version supported by these trees
	// For Private Cloud Compute PATs, the config node uses the same protocol messages but does not include the VRF public key
	PatConfigProof *PatInclusionProof `protobuf:"bytes,9,opt,name=patConfigProof,proto3" json:"patConfigProof,omitempty"`
	// inclusion proof of the TopLevelTreeConfigNode
	// Contains public key for signing roots of top-level tree and minimum version supported by the TLT
	TltConfigProof *LogEntry `protobuf:"bytes,10,opt,name=tltConfigProof,proto3" json:"tltConfigProof,omitempty"`
	// Inclusion proof of PatClosedNode of the last PAT that supported this ProtocolVersion.
	// Only present if this ProtocolVersion is no longer supported.
	// The patConfigProof will be from the same tree, tltConfigProof will be for the TLT with
	// this PAT's heads, and certificates will be for this set of trees
	PatClosedProof *PatInclusionProof `protobuf:"bytes,11,opt,name=patClosedProof,proto3" json:"patClosedProof,omitempty"`
	// Optional URL to information about tree roll or obsoletion.
	// Displayed by the client in the notification when the roll is detected.
	TreeRollInfoUrl string `protobuf:"bytes,12,opt,name=treeRollInfoUrl,proto3" json:"treeRollInfoUrl,omitempty"`
	// Proof of a recent PAM head in the PAT, used to check populating state
	// Optional unless the PAM is still populating
	// Uses the same PAT root as patConfigProof
	PamHeadInPatProof *LogEntry `protobuf:"bytes,13,opt,name=pamHeadInPatProof,proto3" json:"pamHeadInPatProof,omitempty"`
	// DER-encoded STH signing certificate(s) for old tree root signing certs. PCC only, optional.
	OldAppRootCerts [][]byte `protobuf:"bytes,14,rep,name=oldAppRootCerts,proto3" json:"oldAppRootCerts,omitempty"`
	OldTltRootCerts [][]byte `protobuf:"bytes,15,rep,name=oldTltRootCerts,proto3" json:"oldTltRootCerts,omitempty"`
}

func (x *PublicKeysResponse) Reset() {
	*x = PublicKeysResponse{}
	mi := &file_KtClientApi_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeysResponse) ProtoMessage() {}

func (x *PublicKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeysResponse.ProtoReflect.Descriptor instead.
func (*PublicKeysResponse) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{5}
}

func (x *PublicKeysResponse) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_UNKNOWN_STATUS
}

func (x *PublicKeysResponse) GetAppLeafs() [][]byte {
	if x != nil {
		return x.AppLeafs
	}
	return nil
}

func (x *PublicKeysResponse) GetTltLeafs() [][]byte {
	if x != nil {
		return x.TltLeafs
	}
	return nil
}

func (x *PublicKeysResponse) GetIntermediates() [][]byte {
	if x != nil {
		return x.Intermediates
	}
	return nil
}

func (x *PublicKeysResponse) GetPatConfigProof() *PatInclusionProof {
	if x != nil {
		return x.PatConfigProof
	}
	return nil
}

func (x *PublicKeysResponse) GetTltConfigProof() *LogEntry {
	if x != nil {
		return x.TltConfigProof
	}
	return nil
}

func (x *PublicKeysResponse) GetPatClosedProof() *PatInclusionProof {
	if x != nil {
		return x.PatClosedProof
	}
	return nil
}

func (x *PublicKeysResponse) GetTreeRollInfoUrl() string {
	if x != nil {
		return x.TreeRollInfoUrl
	}
	return ""
}

func (x *PublicKeysResponse) GetPamHeadInPatProof() *LogEntry {
	if x != nil {
		return x.PamHeadInPatProof
	}
	return nil
}

func (x *PublicKeysResponse) GetOldAppRootCerts() [][]byte {
	if x != nil {
		return x.OldAppRootCerts
	}
	return nil
}

func (x *PublicKeysResponse) GetOldTltRootCerts() [][]byte {
	if x != nil {
		return x.OldTltRootCerts
	}
	return nil
}

type ConsistencyProofRequest_LogConsistencyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// V2: moved logType = 1 and application = 2 out of LogConsistencyRequest
	StartRevision uint64 `protobuf:"varint,3,opt,name=startRevision,proto3" json:"startRevision,omitempty"` // Required, must be >= 0
	EndRevision   uint64 `protobuf:"varint,4,opt,name=endRevision,proto3" json:"endRevision,omitempty"`     // Required, must be > startRevision
}

func (x *ConsistencyProofRequest_LogConsistencyRequest) Reset() {
	*x = ConsistencyProofRequest_LogConsistencyRequest{}
	mi := &file_KtClientApi_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConsistencyProofRequest_LogConsistencyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistencyProofRequest_LogConsistencyRequest) ProtoMessage() {}

func (x *ConsistencyProofRequest_LogConsistencyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistencyProofRequest_LogConsistencyRequest.ProtoReflect.Descriptor instead.
func (*ConsistencyProofRequest_LogConsistencyRequest) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ConsistencyProofRequest_LogConsistencyRequest) GetStartRevision() uint64 {
	if x != nil {
		return x.StartRevision
	}
	return 0
}

func (x *ConsistencyProofRequest_LogConsistencyRequest) GetEndRevision() uint64 {
	if x != nil {
		return x.EndRevision
	}
	return 0
}

// Individual consistency proofs, which can be linked to prove larger ranges
type ConsistencyProofResponse_LogConsistencyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// V2: moved logType = 1 and application = 2 out of LogConsistencyResponse
	StartSLH    *SignedObject `protobuf:"bytes,3,opt,name=startSLH,proto3" json:"startSLH,omitempty"`
	EndSLH      *SignedObject `protobuf:"bytes,4,opt,name=endSLH,proto3" json:"endSLH,omitempty"`
	ProofHashes [][]byte      `protobuf:"bytes,5,rep,name=proofHashes,proto3" json:"proofHashes,omitempty"`
}

func (x *ConsistencyProofResponse_LogConsistencyResponse) Reset() {
	*x = ConsistencyProofResponse_LogConsistencyResponse{}
	mi := &file_KtClientApi_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConsistencyProofResponse_LogConsistencyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistencyProofResponse_LogConsistencyResponse) ProtoMessage() {}

func (x *ConsistencyProofResponse_LogConsistencyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_KtClientApi_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistencyProofResponse_LogConsistencyResponse.ProtoReflect.Descriptor instead.
func (*ConsistencyProofResponse_LogConsistencyResponse) Descriptor() ([]byte, []int) {
	return file_KtClientApi_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ConsistencyProofResponse_LogConsistencyResponse) GetStartSLH() *SignedObject {
	if x != nil {
		return x.StartSLH
	}
	return nil
}

func (x *ConsistencyProofResponse_LogConsistencyResponse) GetEndSLH() *SignedObject {
	if x != nil {
		return x.EndSLH
	}
	return nil
}

func (x *ConsistencyProofResponse_LogConsistencyResponse) GetProofHashes() [][]byte {
	if x != nil {
		return x.ProofHashes
	}
	return nil
}

var File_KtClientApi_proto protoreflect.FileDescriptor

var file_KtClientApi_proto_rawDesc = []byte{
	0x0a, 0x11, 0x4b, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x70, 0x69, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe8, 0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x4a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x67, 0x43,
	0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x07, 0x6c,
	0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x4c,
	0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69,
	0x64, 0x1a, 0x5f, 0x0a, 0x15, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xee, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x4e, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c,
	0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x12, 0x22, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x08, 0x2e, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x29, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x53, 0x4c, 0x48, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x53, 0x4c, 0x48, 0x12, 0x25, 0x0a, 0x06, 0x65, 0x6e,
	0x64, 0x53, 0x4c, 0x48, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x53, 0x4c,
	0x48, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x48, 0x61, 0x73,
	0x68, 0x65, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x04, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x21, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x08, 0x6c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x09, 0x2e,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x37, 0x0a, 0x11, 0x74, 0x6f, 0x70, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x54, 0x72,
	0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x74, 0x6f, 0x70, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x91, 0x01, 0x0a, 0x11,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a,
	0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x22,
	0xf5, 0x03, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x07, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x4c, 0x65,
	0x61, 0x66, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x08, 0x61, 0x70, 0x70, 0x4c, 0x65,
	0x61, 0x66, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6c, 0x74, 0x4c, 0x65, 0x61, 0x66, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x08, 0x74, 0x6c, 0x74, 0x4c, 0x65, 0x61, 0x66, 0x73, 0x12,
	0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0e, 0x70, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x50, 0x61, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x52, 0x0e, 0x70, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x12, 0x31, 0x0a, 0x0e, 0x74, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x74, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x12, 0x3a, 0x0a, 0x0e, 0x70, 0x61, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x50,
	0x61, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x52, 0x0e, 0x70, 0x61, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x12, 0x28, 0x0a, 0x0f, 0x74, 0x72, 0x65, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x55, 0x72, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x65, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x72, 0x6c, 0x12, 0x37, 0x0a, 0x11, 0x70, 0x61,
	0x6d, 0x48, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x11, 0x70, 0x61, 0x6d, 0x48, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x12, 0x28, 0x0a, 0x0f, 0x6f, 0x6c, 0x64, 0x41, 0x70, 0x70, 0x52, 0x6f, 0x6f,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0f, 0x6f, 0x6c,
	0x64, 0x41, 0x70, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x28, 0x0a,
	0x0f, 0x6f, 0x6c, 0x64, 0x54, 0x6c, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x18, 0x0f, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0f, 0x6f, 0x6c, 0x64, 0x54, 0x6c, 0x74, 0x52, 0x6f,
	0x6f, 0x74, 0x43, 0x65, 0x72, 0x74, 0x73, 0x42, 0x5d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x61,
	0x70, 0x70, 0x6c, 0x65, 0x2e, 0x6b, 0x65, 0x79, 0x74, 0x2e, 0x61, 0x70, 0x69, 0x42, 0x0d, 0x4b,
	0x54, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2e,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6c, 0x61, 0x63, 0x6b,
	0x74, 0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73, 0x77, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2f, 0x70, 0x63, 0x63, 0xba, 0x02,
	0x05, 0x54, 0x78, 0x50, 0x42, 0x5f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_KtClientApi_proto_rawDescOnce sync.Once
	file_KtClientApi_proto_rawDescData = file_KtClientApi_proto_rawDesc
)

func file_KtClientApi_proto_rawDescGZIP() []byte {
	file_KtClientApi_proto_rawDescOnce.Do(func() {
		file_KtClientApi_proto_rawDescData = protoimpl.X.CompressGZIP(file_KtClientApi_proto_rawDescData)
	})
	return file_KtClientApi_proto_rawDescData
}

var file_KtClientApi_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_KtClientApi_proto_goTypes = []any{
	(*ConsistencyProofRequest)(nil),                         // 0: ConsistencyProofRequest
	(*ConsistencyProofResponse)(nil),                        // 1: ConsistencyProofResponse
	(*RevisionLogInclusionProofRequest)(nil),                // 2: RevisionLogInclusionProofRequest
	(*RevisionLogInclusionProofResponse)(nil),               // 3: RevisionLogInclusionProofResponse
	(*PublicKeysRequest)(nil),                               // 4: PublicKeysRequest
	(*PublicKeysResponse)(nil),                              // 5: PublicKeysResponse
	(*ConsistencyProofRequest_LogConsistencyRequest)(nil),   // 6: ConsistencyProofRequest.LogConsistencyRequest
	(*ConsistencyProofResponse_LogConsistencyResponse)(nil), // 7: ConsistencyProofResponse.LogConsistencyResponse
	(ProtocolVersion)(0),                                    // 8: ProtocolVersion
	(LogType)(0),                                            // 9: LogType
	(Application)(0),                                        // 10: Application
	(Status)(0),                                             // 11: Status
	(*LogEntry)(nil),                                        // 12: LogEntry
	(*PatInclusionProof)(nil),                               // 13: PatInclusionProof
	(*SignedObject)(nil),                                    // 14: SignedObject
}
var file_KtClientApi_proto_depIdxs = []int32{
	8,  // 0: ConsistencyProofRequest.version:type_name -> ProtocolVersion
	6,  // 1: ConsistencyProofRequest.requests:type_name -> ConsistencyProofRequest.LogConsistencyRequest
	9,  // 2: ConsistencyProofRequest.logType:type_name -> LogType
	10, // 3: ConsistencyProofRequest.application:type_name -> Application
	11, // 4: ConsistencyProofResponse.status:type_name -> Status
	7,  // 5: ConsistencyProofResponse.responses:type_name -> ConsistencyProofResponse.LogConsistencyResponse
	9,  // 6: ConsistencyProofResponse.logType:type_name -> LogType
	10, // 7: ConsistencyProofResponse.application:type_name -> Application
	8,  // 8: RevisionLogInclusionProofRequest.version:type_name -> ProtocolVersion
	10, // 9: RevisionLogInclusionProofRequest.application:type_name -> Application
	9,  // 10: RevisionLogInclusionProofRequest.logType:type_name -> LogType
	11, // 11: RevisionLogInclusionProofResponse.status:type_name -> Status
	12, // 12: RevisionLogInclusionProofResponse.logEntry:type_name -> LogEntry
	12, // 13: RevisionLogInclusionProofResponse.topLevelTreeEntry:type_name -> LogEntry
	8,  // 14: PublicKeysRequest.version:type_name -> ProtocolVersion
	10, // 15: PublicKeysRequest.application:type_name -> Application
	11, // 16: PublicKeysResponse.status:type_name -> Status
	13, // 17: PublicKeysResponse.patConfigProof:type_name -> PatInclusionProof
	12, // 18: PublicKeysResponse.tltConfigProof:type_name -> LogEntry
	13, // 19: PublicKeysResponse.patClosedProof:type_name -> PatInclusionProof
	12, // 20: PublicKeysResponse.pamHeadInPatProof:type_name -> LogEntry
	14, // 21: ConsistencyProofResponse.LogConsistencyResponse.startSLH:type_name -> SignedObject
	14, // 22: ConsistencyProofResponse.LogConsistencyResponse.endSLH:type_name -> SignedObject
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func file_KtClientApi_proto_init() {
	if File_KtClientApi_proto != nil {
		return
	}
	file_Transparency_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_KtClientApi_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_KtClientApi_proto_goTypes,
		DependencyIndexes: file_KtClientApi_proto_depIdxs,
		MessageInfos:      file_KtClientApi_proto_msgTypes,
	}.Build()
	File_KtClientApi_proto = out.File
	file_KtClientApi_proto_rawDesc = nil
	file_KtClientApi_proto_goTypes = nil
	file_KtClientApi_proto_depIdxs = nil
}

type ReleaseMetadata_SchemaVersion int32

const (
	ReleaseMetadata_VERSION_UNSPECIFIED ReleaseMetadata_SchemaVersion = 0
	ReleaseMetadata_V1                  ReleaseMetadata_SchemaVersion = 1
)

// Enum value maps for ReleaseMetadata_SchemaVersion.
var (
	ReleaseMetadata_SchemaVersion_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V1",
	}
	ReleaseMetadata_SchemaVersion_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V1":                  1,
	}
)

func (x ReleaseMetadata_SchemaVersion) Enum() *ReleaseMetadata_SchemaVersion {
	p := new(ReleaseMetadata_SchemaVersion)
	*p = x
	return p
}

func (x ReleaseMetadata_SchemaVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReleaseMetadata_SchemaVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_ReleaseMetadata_proto_enumTypes[0].Descriptor()
}

func (ReleaseMetadata_SchemaVersion) Type() protoreflect.EnumType {
	return &file_ReleaseMetadata_proto_enumTypes[0]
}

func (x ReleaseMetadata_SchemaVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReleaseMetadata_SchemaVersion.Descriptor instead.
func (ReleaseMetadata_SchemaVersion) EnumDescriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0, 0}
}

type ReleaseMetadata_AssetType int32

const (
	ReleaseMetadata_ASSET_TYPE_UNSPECIFIED ReleaseMetadata_AssetType = 0
	ReleaseMetadata_ASSET_TYPE_OS          ReleaseMetadata_AssetType = 1 // (VRE) restore image
	ReleaseMetadata_ASSET_TYPE_PCS         ReleaseMetadata_AssetType = 2 // (VRE) PrivateCloudSupport (Private cloud extensions)
	ReleaseMetadata_ASSET_TYPE_MODEL       ReleaseMetadata_AssetType = 3 // (VRE) research model + adapter
	ReleaseMetadata_ASSET_TYPE_HOST_TOOLS  ReleaseMetadata_AssetType = 4 // (Host) PrivateCloudTools
	ReleaseMetadata_ASSET_TYPE_DEBUG_SHELL ReleaseMetadata_AssetType = 5 // (VRE) ssh server, etc
)

// Enum value maps for ReleaseMetadata_AssetType.
var (
	ReleaseMetadata_AssetType_name = map[int32]string{
		0: "ASSET_TYPE_UNSPECIFIED",
		1: "ASSET_TYPE_OS",
		2: "ASSET_TYPE_PCS",
		3: "ASSET_TYPE_MODEL",
		4: "ASSET_TYPE_HOST_TOOLS",
		5: "ASSET_TYPE_DEBUG_SHELL",
	}
	ReleaseMetadata_AssetType_value = map[string]int32{
		"ASSET_TYPE_UNSPECIFIED": 0,
		"ASSET_TYPE_OS":          1,
		"ASSET_TYPE_PCS":         2,
		"ASSET_TYPE_MODEL":       3,
		"ASSET_TYPE_HOST_TOOLS":  4,
		"ASSET_TYPE_DEBUG_SHELL": 5,
	}
)

func (x ReleaseMetadata_AssetType) Enum() *ReleaseMetadata_AssetType {
	p := new(ReleaseMetadata_AssetType)
	*p = x
	return p
}

func (x ReleaseMetadata_AssetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReleaseMetadata_AssetType) Descriptor() protoreflect.EnumDescriptor {
	return file_ReleaseMetadata_proto_enumTypes[1].Descriptor()
}

func (ReleaseMetadata_AssetType) Type() protoreflect.EnumType {
	return &file_ReleaseMetadata_proto_enumTypes[1]
}

func (x ReleaseMetadata_AssetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReleaseMetadata_AssetType.Descriptor instead.
func (ReleaseMetadata_AssetType) EnumDescriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0, 1}
}

type ReleaseMetadata_DigestAlg int32

const (
	ReleaseMetadata_DIGEST_ALG_UNSPECIFIED ReleaseMetadata_DigestAlg = 0
	ReleaseMetadata_DIGEST_ALG_SHA256      ReleaseMetadata_DigestAlg = 1
	ReleaseMetadata_DIGEST_ALG_SHA384      ReleaseMetadata_DigestAlg = 2
)

// Enum value maps for ReleaseMetadata_DigestAlg.
var (
	ReleaseMetadata_DigestAlg_name = map[int32]string{
		0: "DIGEST_ALG_UNSPECIFIED",
		1: "DIGEST_ALG_SHA256",
		2: "DIGEST_ALG_SHA384",
	}
	ReleaseMetadata_DigestAlg_value = map[string]int32{
		"DIGEST_ALG_UNSPECIFIED": 0,
		"DIGEST_ALG_SHA256":      1,
		"DIGEST_ALG_SHA384":      2,
	}
)

func (x ReleaseMetadata_DigestAlg) Enum() *ReleaseMetadata_DigestAlg {
	p := new(ReleaseMetadata_DigestAlg)
	*p = x
	return p
}

func (x ReleaseMetadata_DigestAlg) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReleaseMetadata_DigestAlg) Descriptor() protoreflect.EnumDescriptor {
	return file_ReleaseMetadata_proto_enumTypes[2].Descriptor()
}

func (ReleaseMetadata_DigestAlg) Type() protoreflect.EnumType {
	return &file_ReleaseMetadata_proto_enumTypes[2]
}

func (x ReleaseMetadata_DigestAlg) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReleaseMetadata_DigestAlg.Descriptor instead.
func (ReleaseMetadata_DigestAlg) EnumDescriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0, 2}
}

type ReleaseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SchemaVersion ReleaseMetadata_SchemaVersion `protobuf:"varint,1,opt,name=schemaVersion,proto3,enum=ReleaseMetadata_SchemaVersion" json:"schemaVersion,omitempty"` // V1
	// timestamp is for the release entry
	Timestamp   *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	ReleaseHash []byte                 `protobuf:"bytes,3,opt,name=releaseHash,proto3,oneof" json:"releaseHash,omitempty"` // ATL release hash
	// selected assets are mapped by AssetType darwin_init cryptex[] section;
	// expected to have at least:
	// -  ASSET_TYPE_OS
	// -  ASSET_TYPE_MODEL
	// -  ASSET_TYPE_PCS
	// -  ASSET_TYPE_HOST_TOOLS
	Assets []*ReleaseMetadata_Asset `protobuf:"bytes,4,rep,name=assets,proto3" json:"assets,omitempty"`
	// darwin_init is (json mapped) configuration of guest VM once booted;
	//
	//	dictates cryptex image attachments, service configs, other settings
	DarwinInit *structpb.Struct `protobuf:"bytes,5,opt,name=darwin_init,json=darwinInit,proto3" json:"darwin_init,omitempty"`
}

func (x *ReleaseMetadata) Reset() {
	*x = ReleaseMetadata{}
	mi := &file_ReleaseMetadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReleaseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseMetadata) ProtoMessage() {}

func (x *ReleaseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ReleaseMetadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseMetadata.ProtoReflect.Descriptor instead.
func (*ReleaseMetadata) Descriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0}
}

func (x *ReleaseMetadata) GetSchemaVersion() ReleaseMetadata_SchemaVersion {
	if x != nil {
		return x.SchemaVersion
	}
	return ReleaseMetadata_VERSION_UNSPECIFIED
}

func (x *ReleaseMetadata) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *ReleaseMetadata) GetReleaseHash() []byte {
	if x != nil {
		return x.ReleaseHash
	}
	return nil
}

func (x *ReleaseMetadata) GetAssets() []*ReleaseMetadata_Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ReleaseMetadata) GetDarwinInit() *structpb.Struct {
	if x != nil {
		return x.DarwinInit
	}
	return nil
}

type ReleaseMetadata_Digest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DigestAlg ReleaseMetadata_DigestAlg `protobuf:"varint,1,opt,name=digestAlg,proto3,enum=ReleaseMetadata_DigestAlg" json:"digestAlg,omitempty"`
	Value     []byte                    `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ReleaseMetadata_Digest) Reset() {
	*x = ReleaseMetadata_Digest{}
	mi := &file_ReleaseMetadata_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReleaseMetadata_Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseMetadata_Digest) ProtoMessage() {}

func (x *ReleaseMetadata_Digest) ProtoReflect() protoreflect.Message {
	mi := &file_ReleaseMetadata_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseMetadata_Digest.ProtoReflect.Descriptor instead.
func (*ReleaseMetadata_Digest) Descriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReleaseMetadata_Digest) GetDigestAlg() ReleaseMetadata_DigestAlg {
	if x != nil {
		return x.DigestAlg
	}
	return ReleaseMetadata_DIGEST_ALG_UNSPECIFIED
}

func (x *ReleaseMetadata_Digest) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type ReleaseMetadata_Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type    ReleaseMetadata_AssetType `protobuf:"varint,1,opt,name=type,proto3,enum=ReleaseMetadata_AssetType" json:"type,omitempty"`
	Url     string                    `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`       // CDN path
	Digest  *ReleaseMetadata_Digest   `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"` // over raw artifact (in url)
	Variant string                    `protobuf:"bytes,4,opt,name=variant,proto3" json:"variant,omitempty"`
	Ticket  []byte                    `protobuf:"bytes,5,opt,name=ticket,proto3,oneof" json:"ticket,omitempty"` // matches ticket in leaf node release info
}

func (x *ReleaseMetadata_Asset) Reset() {
	*x = ReleaseMetadata_Asset{}
	mi := &file_ReleaseMetadata_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReleaseMetadata_Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseMetadata_Asset) ProtoMessage() {}

func (x *ReleaseMetadata_Asset) ProtoReflect() protoreflect.Message {
	mi := &file_ReleaseMetadata_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseMetadata_Asset.ProtoReflect.Descriptor instead.
func (*ReleaseMetadata_Asset) Descriptor() ([]byte, []int) {
	return file_ReleaseMetadata_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ReleaseMetadata_Asset) GetType() ReleaseMetadata_AssetType {
	if x != nil {
		return x.Type
	}
	return ReleaseMetadata_ASSET_TYPE_UNSPECIFIED
}

func (x *ReleaseMetadata_Asset) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ReleaseMetadata_Asset) GetDigest() *ReleaseMetadata_Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *ReleaseMetadata_Asset) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *ReleaseMetadata_Asset) GetTicket() []byte {
	if x != nil {
		return x.Ticket
	}
	return nil
}

var File_ReleaseMetadata_proto protoreflect.FileDescriptor

var file_ReleaseMetadata_proto_rawDesc = []byte{
	0x0a, 0x15, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf2, 0x06, 0x0a, 0x0f, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x0d, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1e, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x48, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48,
	0x00, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x48, 0x61, 0x73, 0x68, 0x88, 0x01,
	0x01, 0x12, 0x2e, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x61, 0x72, 0x77, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x69, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0a, 0x64, 0x61, 0x72, 0x77, 0x69, 0x6e, 0x49, 0x6e, 0x69, 0x74, 0x1a, 0x58, 0x0a, 0x06, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x09, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x41,
	0x6c, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x41, 0x6c, 0x67, 0x52, 0x09, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x41, 0x6c, 0x67, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xbc, 0x01, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12,
	0x2e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06,
	0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x74, 0x69,
	0x63, 0x6b, 0x65, 0x74, 0x22, 0x30, 0x0a, 0x0d, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06,
	0x0a, 0x02, 0x56, 0x31, 0x10, 0x01, 0x22, 0x9b, 0x01, 0x0a, 0x09, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f,
	0x53, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x50, 0x43, 0x53, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x53, 0x53, 0x45, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x03, 0x12, 0x19, 0x0a,
	0x15, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54,
	0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x53, 0x53, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x42, 0x55, 0x47, 0x5f, 0x53, 0x48, 0x45,
	0x4c, 0x4c, 0x10, 0x05, 0x22, 0x55, 0x0a, 0x09, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x41, 0x6c,
	0x67, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x5f, 0x41, 0x4c, 0x47, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x11, 0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x5f, 0x41, 0x4c, 0x47, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x5f, 0x41,
	0x4c, 0x47, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x02, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x48, 0x61, 0x73, 0x68, 0x42, 0x38, 0x5a, 0x2e, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x74,
	0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73, 0x77, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2f, 0x70, 0x63, 0x63, 0xba, 0x02, 0x05,
	0x54, 0x78, 0x50, 0x42, 0x5f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ReleaseMetadata_proto_rawDescOnce sync.Once
	file_ReleaseMetadata_proto_rawDescData = file_ReleaseMetadata_proto_rawDesc
)

func file_ReleaseMetadata_proto_rawDescGZIP() []byte {
	file_ReleaseMetadata_proto_rawDescOnce.Do(func() {
		file_ReleaseMetadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_ReleaseMetadata_proto_rawDescData)
	})
	return file_ReleaseMetadata_proto_rawDescData
}

var file_ReleaseMetadata_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_ReleaseMetadata_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_ReleaseMetadata_proto_goTypes = []any{
	(ReleaseMetadata_SchemaVersion)(0), // 0: ReleaseMetadata.SchemaVersion
	(ReleaseMetadata_AssetType)(0),     // 1: ReleaseMetadata.AssetType
	(ReleaseMetadata_DigestAlg)(0),     // 2: ReleaseMetadata.DigestAlg
	(*ReleaseMetadata)(nil),            // 3: ReleaseMetadata
	(*ReleaseMetadata_Digest)(nil),     // 4: ReleaseMetadata.Digest
	(*ReleaseMetadata_Asset)(nil),      // 5: ReleaseMetadata.Asset
	(*timestamppb.Timestamp)(nil),      // 6: google.protobuf.Timestamp
	(*structpb.Struct)(nil),            // 7: google.protobuf.Struct
}
var file_ReleaseMetadata_proto_depIdxs = []int32{
	0, // 0: ReleaseMetadata.schemaVersion:type_name -> ReleaseMetadata.SchemaVersion
	6, // 1: ReleaseMetadata.timestamp:type_name -> google.protobuf.Timestamp
	5, // 2: ReleaseMetadata.assets:type_name -> ReleaseMetadata.Asset
	7, // 3: ReleaseMetadata.darwin_init:type_name -> google.protobuf.Struct
	2, // 4: ReleaseMetadata.Digest.digestAlg:type_name -> ReleaseMetadata.DigestAlg
	1, // 5: ReleaseMetadata.Asset.type:type_name -> ReleaseMetadata.AssetType
	4, // 6: ReleaseMetadata.Asset.digest:type_name -> ReleaseMetadata.Digest
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func file_ReleaseMetadata_proto_init() {
	if File_ReleaseMetadata_proto != nil {
		return
	}
	file_ReleaseMetadata_proto_msgTypes[0].OneofWrappers = []any{}
	file_ReleaseMetadata_proto_msgTypes[2].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ReleaseMetadata_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ReleaseMetadata_proto_goTypes,
		DependencyIndexes: file_ReleaseMetadata_proto_depIdxs,
		EnumInfos:         file_ReleaseMetadata_proto_enumTypes,
		MessageInfos:      file_ReleaseMetadata_proto_msgTypes,
	}.Build()
	File_ReleaseMetadata_proto = out.File
	file_ReleaseMetadata_proto_rawDesc = nil
	file_ReleaseMetadata_proto_goTypes = nil
	file_ReleaseMetadata_proto_depIdxs = nil
}

// Protobuf protocol protocol version.
// Later versions must have larger ordinal numbers.  Device clients require number in enum name to match ordinal number.
type ProtocolVersion int32

const (
	ProtocolVersion_UNKNOWN_VERSION ProtocolVersion = 0
	// V1 used in early builds, deprecated
	ProtocolVersion_V1 ProtocolVersion = 1
	// V2 introduced in 1530 (iOS 15.2). Adds account key, converts map leaves to TLS presentation language, changes some VRFs to SHA256 hashes
	ProtocolVersion_V2 ProtocolVersion = 2
	// V3 (was 2_1) introduced in 1540 (iOS 15.3). Same as V2 but clients can handle opt-in SMTs in query responses
	ProtocolVersion_V3 ProtocolVersion = 3
	// Future version used for testing
	ProtocolVersion_FUTURE ProtocolVersion = 999999999
)

// Enum value maps for ProtocolVersion.
var (
	ProtocolVersion_name = map[int32]string{
		0:         "UNKNOWN_VERSION",
		1:         "V1",
		2:         "V2",
		3:         "V3",
		999999999: "FUTURE",
	}
	ProtocolVersion_value = map[string]int32{
		"UNKNOWN_VERSION": 0,
		"V1":              1,
		"V2":              2,
		"V3":              3,
		"FUTURE":          999999999,
	}
)

func (x ProtocolVersion) Enum() *ProtocolVersion {
	p := new(ProtocolVersion)
	*p = x
	return p
}

func (x ProtocolVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProtocolVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[0].Descriptor()
}

func (ProtocolVersion) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[0]
}

func (x ProtocolVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProtocolVersion.Descriptor instead.
func (ProtocolVersion) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{0}
}

// Application is the smallest grouping that can not be divided across multiple sets of PACL,
// PAM, and PAT. It defines a map-index namespace and is associated with a personality.
type Application int32

const (
	Application_UNKNOWN_APPLICATION            Application = 0
	Application_IDS_MESSAGING                  Application = 1
	Application_PRIVATE_CLOUD_COMPUTE          Application = 5
	Application_PRIVATE_CLOUD_COMPUTE_INTERNAL Application = 6
)

// Enum value maps for Application.
var (
	Application_name = map[int32]string{
		0: "UNKNOWN_APPLICATION",
		1: "IDS_MESSAGING",
		5: "PRIVATE_CLOUD_COMPUTE",
		6: "PRIVATE_CLOUD_COMPUTE_INTERNAL",
	}
	Application_value = map[string]int32{
		"UNKNOWN_APPLICATION":            0,
		"IDS_MESSAGING":                  1,
		"PRIVATE_CLOUD_COMPUTE":          5,
		"PRIVATE_CLOUD_COMPUTE_INTERNAL": 6,
	}
)

func (x Application) Enum() *Application {
	p := new(Application)
	*p = x
	return p
}

func (x Application) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Application) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[1].Descriptor()
}

func (Application) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[1]
}

func (x Application) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Application.Descriptor instead.
func (Application) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{1}
}

// API response status.
type Status int32

const (
	Status_UNKNOWN_STATUS Status = 0
	Status_OK             Status = 1
	// 2 - can reuse
	Status_MUTATION_PENDING Status = 3
	Status_ALREADY_EXISTS   Status = 4
	Status_INTERNAL_ERROR   Status = 5
	Status_INVALID_REQUEST  Status = 6
	Status_NOT_FOUND        Status = 7 // V2: removed TOO_MANY_VRF_REQUESTS = 8; because queries no longer need to request VRF witnesses for deviceId and clientData
)

// Enum value maps for Status.
var (
	Status_name = map[int32]string{
		0: "UNKNOWN_STATUS",
		1: "OK",
		3: "MUTATION_PENDING",
		4: "ALREADY_EXISTS",
		5: "INTERNAL_ERROR",
		6: "INVALID_REQUEST",
		7: "NOT_FOUND",
	}
	Status_value = map[string]int32{
		"UNKNOWN_STATUS":   0,
		"OK":               1,
		"MUTATION_PENDING": 3,
		"ALREADY_EXISTS":   4,
		"INTERNAL_ERROR":   5,
		"INVALID_REQUEST":  6,
		"NOT_FOUND":        7,
	}
)

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}

func (x Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Status) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[2].Descriptor()
}

func (Status) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[2]
}

func (x Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Status.Descriptor instead.
func (Status) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{2}
}

type VRFType int32

const (
	VRFType_UNKNOWN_VRF VRFType = 0
	// 1, 2 - can reuse
	VRFType_ECVRF_ED25519_SHA512_Elligator2 VRFType = 3
)

// Enum value maps for VRFType.
var (
	VRFType_name = map[int32]string{
		0: "UNKNOWN_VRF",
		3: "ECVRF_ED25519_SHA512_Elligator2",
	}
	VRFType_value = map[string]int32{
		"UNKNOWN_VRF":                     0,
		"ECVRF_ED25519_SHA512_Elligator2": 3,
	}
)

func (x VRFType) Enum() *VRFType {
	p := new(VRFType)
	*p = x
	return p
}

func (x VRFType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VRFType) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[3].Descriptor()
}

func (VRFType) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[3]
}

func (x VRFType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VRFType.Descriptor instead.
func (VRFType) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{3}
}

type LogType int32

const (
	LogType_UNKNOWN_LOG                LogType = 0
	LogType_PER_APPLICATION_CHANGE_LOG LogType = 1
	LogType_PER_APPLICATION_TREE       LogType = 2
	LogType_TOP_LEVEL_TREE             LogType = 3
	LogType_CT_LOG                     LogType = 4
	LogType_AT_LOG                     LogType = 5
)

// Enum value maps for LogType.
var (
	LogType_name = map[int32]string{
		0: "UNKNOWN_LOG",
		1: "PER_APPLICATION_CHANGE_LOG",
		2: "PER_APPLICATION_TREE",
		3: "TOP_LEVEL_TREE",
		4: "CT_LOG",
		5: "AT_LOG",
	}
	LogType_value = map[string]int32{
		"UNKNOWN_LOG":                0,
		"PER_APPLICATION_CHANGE_LOG": 1,
		"PER_APPLICATION_TREE":       2,
		"TOP_LEVEL_TREE":             3,
		"CT_LOG":                     4,
		"AT_LOG":                     5,
	}
)

func (x LogType) Enum() *LogType {
	p := new(LogType)
	*p = x
	return p
}

func (x LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[4].Descriptor()
}

func (LogType) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[4]
}

func (x LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogType.Descriptor instead.
func (LogType) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{4}
}

type MapType int32

const (
	MapType_UNKNOWN_MAP        MapType = 0
	MapType_PER_APP_OBJECT_MAP MapType = 1
)

// Enum value maps for MapType.
var (
	MapType_name = map[int32]string{
		0: "UNKNOWN_MAP",
		1: "PER_APP_OBJECT_MAP",
	}
	MapType_value = map[string]int32{
		"UNKNOWN_MAP":        0,
		"PER_APP_OBJECT_MAP": 1,
	}
)

func (x MapType) Enum() *MapType {
	p := new(MapType)
	*p = x
	return p
}

func (x MapType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MapType) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[5].Descriptor()
}

func (MapType) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[5]
}

func (x MapType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MapType.Descriptor instead.
func (MapType) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{5}
}

type NodeType int32

const (
	NodeType_PACL_NODE       NodeType = 0 // Dependent on personality. for IDS this is a ChangeLogNode
	NodeType_PAT_NODE        NodeType = 1 // PerApplicationTreeNode
	NodeType_PAT_CONFIG_NODE NodeType = 2 // Only valid for node index 0. PerApplicationTreeConfigNode
	NodeType_TLT_NODE        NodeType = 3 // TopLevelTreeNode
	NodeType_TLT_CONFIG_NODE NodeType = 4 // Only valid for node index 0. TopLevelTreeConfigNode
	NodeType_LOG_CLOSED_NODE NodeType = 5 // Valid for PAT or TLT. LogClosedNode
	NodeType_CT_NODE         NodeType = 6 // Certificate transparency log node.
	NodeType_ATL_NODE        NodeType = 7 // Private Cloud Compute log node. Can be an attestation node or certificate node (ChangeLogNodeV2 with an ATLeafData struct).
)

// Enum value maps for NodeType.
var (
	NodeType_name = map[int32]string{
		0: "PACL_NODE",
		1: "PAT_NODE",
		2: "PAT_CONFIG_NODE",
		3: "TLT_NODE",
		4: "TLT_CONFIG_NODE",
		5: "LOG_CLOSED_NODE",
		6: "CT_NODE",
		7: "ATL_NODE",
	}
	NodeType_value = map[string]int32{
		"PACL_NODE":       0,
		"PAT_NODE":        1,
		"PAT_CONFIG_NODE": 2,
		"TLT_NODE":        3,
		"TLT_CONFIG_NODE": 4,
		"LOG_CLOSED_NODE": 5,
		"CT_NODE":         6,
		"ATL_NODE":        7,
	}
)

func (x NodeType) Enum() *NodeType {
	p := new(NodeType)
	*p = x
	return p
}

func (x NodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[6].Descriptor()
}

func (NodeType) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[6]
}

func (x NodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType.Descriptor instead.
func (NodeType) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{6}
}

type Signature_SignatureAlgorithm int32

const (
	Signature_UNKNOWN      Signature_SignatureAlgorithm = 0
	Signature_ECDSA_SHA256 Signature_SignatureAlgorithm = 1
)

// Enum value maps for Signature_SignatureAlgorithm.
var (
	Signature_SignatureAlgorithm_name = map[int32]string{
		0: "UNKNOWN",
		1: "ECDSA_SHA256",
	}
	Signature_SignatureAlgorithm_value = map[string]int32{
		"UNKNOWN":      0,
		"ECDSA_SHA256": 1,
	}
)

func (x Signature_SignatureAlgorithm) Enum() *Signature_SignatureAlgorithm {
	p := new(Signature_SignatureAlgorithm)
	*p = x
	return p
}

func (x Signature_SignatureAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Signature_SignatureAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_Transparency_proto_enumTypes[7].Descriptor()
}

func (Signature_SignatureAlgorithm) Type() protoreflect.EnumType {
	return &file_Transparency_proto_enumTypes[7]
}

func (x Signature_SignatureAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Signature_SignatureAlgorithm.Descriptor instead.
func (Signature_SignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{2, 0}
}

type VRFWitness struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type   VRFType `protobuf:"varint,1,opt,name=type,proto3,enum=VRFType" json:"type,omitempty"`
	Output []byte  `protobuf:"bytes,2,opt,name=output,proto3" json:"output,omitempty"`
	Proof  []byte  `protobuf:"bytes,3,opt,name=proof,proto3" json:"proof,omitempty"`
}

func (x *VRFWitness) Reset() {
	*x = VRFWitness{}
	mi := &file_Transparency_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VRFWitness) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRFWitness) ProtoMessage() {}

func (x *VRFWitness) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRFWitness.ProtoReflect.Descriptor instead.
func (*VRFWitness) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{0}
}

func (x *VRFWitness) GetType() VRFType {
	if x != nil {
		return x.Type
	}
	return VRFType_UNKNOWN_VRF
}

func (x *VRFWitness) GetOutput() []byte {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *VRFWitness) GetProof() []byte {
	if x != nil {
		return x.Proof
	}
	return nil
}

type VRFPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VrfKey []byte  `protobuf:"bytes,1,opt,name=vrfKey,proto3" json:"vrfKey,omitempty"`
	Type   VRFType `protobuf:"varint,2,opt,name=type,proto3,enum=VRFType" json:"type,omitempty"`
}

func (x *VRFPublicKey) Reset() {
	*x = VRFPublicKey{}
	mi := &file_Transparency_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VRFPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRFPublicKey) ProtoMessage() {}

func (x *VRFPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRFPublicKey.ProtoReflect.Descriptor instead.
func (*VRFPublicKey) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{1}
}

func (x *VRFPublicKey) GetVrfKey() []byte {
	if x != nil {
		return x.VrfKey
	}
	return nil
}

func (x *VRFPublicKey) GetType() VRFType {
	if x != nil {
		return x.Type
	}
	return VRFType_UNKNOWN_VRF
}

type Signature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Signature []byte `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
	// This is a hash of the DER encoded public key used to verify the signature.
	// It is used to identify the correct key from multiple signing keys.
	SigningKeySPKIHash []byte                       `protobuf:"bytes,2,opt,name=signingKeySPKIHash,proto3" json:"signingKeySPKIHash,omitempty"`
	Algorithm          Signature_SignatureAlgorithm `protobuf:"varint,3,opt,name=algorithm,proto3,enum=Signature_SignatureAlgorithm" json:"algorithm,omitempty"`
}

func (x *Signature) Reset() {
	*x = Signature{}
	mi := &file_Transparency_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signature.ProtoReflect.Descriptor instead.
func (*Signature) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{2}
}

func (x *Signature) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *Signature) GetSigningKeySPKIHash() []byte {
	if x != nil {
		return x.SigningKeySPKIHash
	}
	return nil
}

func (x *Signature) GetAlgorithm() Signature_SignatureAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return Signature_UNKNOWN
}

type SignedObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// parse as a LogHead, MapHead, Mutation, or whatever is appropriate given context
	Object    []byte     `protobuf:"bytes,1,opt,name=object,proto3" json:"object,omitempty"`
	Signature *Signature `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SignedObject) Reset() {
	*x = SignedObject{}
	mi := &file_Transparency_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignedObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignedObject) ProtoMessage() {}

func (x *SignedObject) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignedObject.ProtoReflect.Descriptor instead.
func (*SignedObject) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{3}
}

func (x *SignedObject) GetObject() []byte {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *SignedObject) GetSignature() *Signature {
	if x != nil {
		return x.Signature
	}
	return nil
}

type LogHead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogBeginningMs uint64      `protobuf:"varint,1,opt,name=logBeginningMs,proto3" json:"logBeginningMs,omitempty"` // Used to identify the new tree when the tree has been reset
	LogSize        uint64      `protobuf:"varint,2,opt,name=logSize,proto3" json:"logSize,omitempty"`
	LogHeadHash    []byte      `protobuf:"bytes,3,opt,name=logHeadHash,proto3" json:"logHeadHash,omitempty"`
	Revision       uint64      `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
	LogType        LogType     `protobuf:"varint,5,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"`
	Application    Application `protobuf:"varint,6,opt,name=application,proto3,enum=Application" json:"application,omitempty"` // omitted for TLT
	TreeId         uint64      `protobuf:"varint,7,opt,name=treeId,proto3" json:"treeId,omitempty"`
	TimestampMs    uint64      `protobuf:"varint,8,opt,name=timestampMs,proto3" json:"timestampMs,omitempty"`
}

func (x *LogHead) Reset() {
	*x = LogHead{}
	mi := &file_Transparency_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogHead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogHead) ProtoMessage() {}

func (x *LogHead) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogHead.ProtoReflect.Descriptor instead.
func (*LogHead) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{4}
}

func (x *LogHead) GetLogBeginningMs() uint64 {
	if x != nil {
		return x.LogBeginningMs
	}
	return 0
}

func (x *LogHead) GetLogSize() uint64 {
	if x != nil {
		return x.LogSize
	}
	return 0
}

func (x *LogHead) GetLogHeadHash() []byte {
	if x != nil {
		return x.LogHeadHash
	}
	return nil
}

func (x *LogHead) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *LogHead) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *LogHead) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *LogHead) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *LogHead) GetTimestampMs() uint64 {
	if x != nil {
		return x.TimestampMs
	}
	return 0
}

// The value and inclusion proof of a log leaf.
type LogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogType                   LogType       `protobuf:"varint,1,opt,name=logType,proto3,enum=LogType" json:"logType,omitempty"`
	Slh                       *SignedObject `protobuf:"bytes,2,opt,name=slh,proto3" json:"slh,omitempty"`
	HashesOfPeersInPathToRoot [][]byte      `protobuf:"bytes,3,rep,name=hashesOfPeersInPathToRoot,proto3" json:"hashesOfPeersInPathToRoot,omitempty"` // ordered with leaf at position 0, root-1 at end
	// Parse based on nodeType
	NodeBytes    []byte   `protobuf:"bytes,4,opt,name=nodeBytes,proto3" json:"nodeBytes,omitempty"`
	NodePosition uint64   `protobuf:"varint,5,opt,name=nodePosition,proto3" json:"nodePosition,omitempty"` // in range [0, slh.logSize)
	NodeType     NodeType `protobuf:"varint,6,opt,name=nodeType,proto3,enum=NodeType" json:"nodeType,omitempty"`
}

func (x *LogEntry) Reset() {
	*x = LogEntry{}
	mi := &file_Transparency_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry) ProtoMessage() {}

func (x *LogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry.ProtoReflect.Descriptor instead.
func (*LogEntry) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{5}
}

func (x *LogEntry) GetLogType() LogType {
	if x != nil {
		return x.LogType
	}
	return LogType_UNKNOWN_LOG
}

func (x *LogEntry) GetSlh() *SignedObject {
	if x != nil {
		return x.Slh
	}
	return nil
}

func (x *LogEntry) GetHashesOfPeersInPathToRoot() [][]byte {
	if x != nil {
		return x.HashesOfPeersInPathToRoot
	}
	return nil
}

func (x *LogEntry) GetNodeBytes() []byte {
	if x != nil {
		return x.NodeBytes
	}
	return nil
}

func (x *LogEntry) GetNodePosition() uint64 {
	if x != nil {
		return x.NodePosition
	}
	return 0
}

func (x *LogEntry) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_PACL_NODE
}

type MapHead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogBeginningMs uint64      `protobuf:"varint,1,opt,name=logBeginningMs,proto3" json:"logBeginningMs,omitempty"`
	MapHeadHash    []byte      `protobuf:"bytes,2,opt,name=mapHeadHash,proto3" json:"mapHeadHash,omitempty"`
	Application    Application `protobuf:"varint,3,opt,name=application,proto3,enum=Application" json:"application,omitempty"`
	ChangeLogHead  *LogHead    `protobuf:"bytes,4,opt,name=changeLogHead,proto3" json:"changeLogHead,omitempty"`
	Revision       uint64      `protobuf:"varint,5,opt,name=revision,proto3" json:"revision,omitempty"`
	MapType        MapType     `protobuf:"varint,6,opt,name=mapType,proto3,enum=MapType" json:"mapType,omitempty"`
	TreeId         uint64      `protobuf:"varint,7,opt,name=treeId,proto3" json:"treeId,omitempty"`
	TimestampMs    uint64      `protobuf:"varint,8,opt,name=timestampMs,proto3" json:"timestampMs,omitempty"`
	Populating     bool        `protobuf:"varint,9,opt,name=populating,proto3" json:"populating,omitempty"` // if true, indicates this map may not yet contain a full set of data
}

func (x *MapHead) Reset() {
	*x = MapHead{}
	mi := &file_Transparency_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapHead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapHead) ProtoMessage() {}

func (x *MapHead) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapHead.ProtoReflect.Descriptor instead.
func (*MapHead) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{6}
}

func (x *MapHead) GetLogBeginningMs() uint64 {
	if x != nil {
		return x.LogBeginningMs
	}
	return 0
}

func (x *MapHead) GetMapHeadHash() []byte {
	if x != nil {
		return x.MapHeadHash
	}
	return nil
}

func (x *MapHead) GetApplication() Application {
	if x != nil {
		return x.Application
	}
	return Application_UNKNOWN_APPLICATION
}

func (x *MapHead) GetChangeLogHead() *LogHead {
	if x != nil {
		return x.ChangeLogHead
	}
	return nil
}

func (x *MapHead) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *MapHead) GetMapType() MapType {
	if x != nil {
		return x.MapType
	}
	return MapType_UNKNOWN_MAP
}

func (x *MapHead) GetTreeId() uint64 {
	if x != nil {
		return x.TreeId
	}
	return 0
}

func (x *MapHead) GetTimestampMs() uint64 {
	if x != nil {
		return x.TimestampMs
	}
	return 0
}

func (x *MapHead) GetPopulating() bool {
	if x != nil {
		return x.Populating
	}
	return false
}

// Value and inclusion proof of a map leaf.
type MapEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Smh *SignedObject `protobuf:"bytes,1,opt,name=smh,proto3" json:"smh,omitempty"`
	// When computing the hash chain, prepend each non-leaf hash with 0x01
	// Empty peers may be omitted since they can be calculated by the client
	HashesOfPeersInPathToRoot [][]byte `protobuf:"bytes,2,rep,name=hashesOfPeersInPathToRoot,proto3" json:"hashesOfPeersInPathToRoot,omitempty"` // ordered with leaf at position 0, root-1 at end
	// When computing the hash chain, Prepend the hash of these bytes with 0x00
	MapLeaf []byte `protobuf:"bytes,3,opt,name=mapLeaf,proto3" json:"mapLeaf,omitempty"` // For IDS, Parse as MapLeaf
}

func (x *MapEntry) Reset() {
	*x = MapEntry{}
	mi := &file_Transparency_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapEntry) ProtoMessage() {}

func (x *MapEntry) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapEntry.ProtoReflect.Descriptor instead.
func (*MapEntry) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{7}
}

func (x *MapEntry) GetSmh() *SignedObject {
	if x != nil {
		return x.Smh
	}
	return nil
}

func (x *MapEntry) GetHashesOfPeersInPathToRoot() [][]byte {
	if x != nil {
		return x.HashesOfPeersInPathToRoot
	}
	return nil
}

func (x *MapEntry) GetMapLeaf() []byte {
	if x != nil {
		return x.MapLeaf
	}
	return nil
}

type InclusionProof struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// V2: removed uriVRFOutput = 1
	MapEntry                *MapEntry `protobuf:"bytes,2,opt,name=mapEntry,proto3" json:"mapEntry,omitempty"`
	Index                   []byte    `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`                                     // Added for V2, equals SHA256(uriVrfOutput)
	PerApplicationTreeEntry *LogEntry `protobuf:"bytes,4,opt,name=perApplicationTreeEntry,proto3" json:"perApplicationTreeEntry,omitempty"` // optional
	TopLevelTreeEntry       *LogEntry `protobuf:"bytes,5,opt,name=topLevelTreeEntry,proto3" json:"topLevelTreeEntry,omitempty"`             // optional
}

func (x *InclusionProof) Reset() {
	*x = InclusionProof{}
	mi := &file_Transparency_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InclusionProof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InclusionProof) ProtoMessage() {}

func (x *InclusionProof) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InclusionProof.ProtoReflect.Descriptor instead.
func (*InclusionProof) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{8}
}

func (x *InclusionProof) GetMapEntry() *MapEntry {
	if x != nil {
		return x.MapEntry
	}
	return nil
}

func (x *InclusionProof) GetIndex() []byte {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *InclusionProof) GetPerApplicationTreeEntry() *LogEntry {
	if x != nil {
		return x.PerApplicationTreeEntry
	}
	return nil
}

func (x *InclusionProof) GetTopLevelTreeEntry() *LogEntry {
	if x != nil {
		return x.TopLevelTreeEntry
	}
	return nil
}

// Inclusion proof of a PAT node
type PatInclusionProof struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PerApplicationTreeEntry *LogEntry `protobuf:"bytes,1,opt,name=perApplicationTreeEntry,proto3" json:"perApplicationTreeEntry,omitempty"`
	TopLevelTreeEntry       *LogEntry `protobuf:"bytes,2,opt,name=topLevelTreeEntry,proto3" json:"topLevelTreeEntry,omitempty"`
}

func (x *PatInclusionProof) Reset() {
	*x = PatInclusionProof{}
	mi := &file_Transparency_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PatInclusionProof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatInclusionProof) ProtoMessage() {}

func (x *PatInclusionProof) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatInclusionProof.ProtoReflect.Descriptor instead.
func (*PatInclusionProof) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{9}
}

func (x *PatInclusionProof) GetPerApplicationTreeEntry() *LogEntry {
	if x != nil {
		return x.PerApplicationTreeEntry
	}
	return nil
}

func (x *PatInclusionProof) GetTopLevelTreeEntry() *LogEntry {
	if x != nil {
		return x.TopLevelTreeEntry
	}
	return nil
}

type ChangeLogNodeV2 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parse as appropriate for app, for IDS this is a TLS-encoded IdsMutation
	Mutation []byte `protobuf:"bytes,1,opt,name=mutation,proto3" json:"mutation,omitempty"`
}

func (x *ChangeLogNodeV2) Reset() {
	*x = ChangeLogNodeV2{}
	mi := &file_Transparency_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeLogNodeV2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeLogNodeV2) ProtoMessage() {}

func (x *ChangeLogNodeV2) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeLogNodeV2.ProtoReflect.Descriptor instead.
func (*ChangeLogNodeV2) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{10}
}

func (x *ChangeLogNodeV2) GetMutation() []byte {
	if x != nil {
		return x.Mutation
	}
	return nil
}

// node ID = SHA256( PAM tree ID || PAM revision )
type PerApplicationTreeNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 1 - can reuse
	// predecessorHead contains either MapHead or LogHead depending on the application
	PredecessorHead *SignedObject `protobuf:"bytes,2,opt,name=predecessorHead,proto3" json:"predecessorHead,omitempty"`
}

func (x *PerApplicationTreeNode) Reset() {
	*x = PerApplicationTreeNode{}
	mi := &file_Transparency_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PerApplicationTreeNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerApplicationTreeNode) ProtoMessage() {}

func (x *PerApplicationTreeNode) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerApplicationTreeNode.ProtoReflect.Descriptor instead.
func (*PerApplicationTreeNode) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{11}
}

func (x *PerApplicationTreeNode) GetPredecessorHead() *SignedObject {
	if x != nil {
		return x.PredecessorHead
	}
	return nil
}

type TopLevelTreeNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PatHead *SignedObject `protobuf:"bytes,1,opt,name=patHead,proto3" json:"patHead,omitempty"`
}

func (x *TopLevelTreeNode) Reset() {
	*x = TopLevelTreeNode{}
	mi := &file_Transparency_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TopLevelTreeNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopLevelTreeNode) ProtoMessage() {}

func (x *TopLevelTreeNode) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopLevelTreeNode.ProtoReflect.Descriptor instead.
func (*TopLevelTreeNode) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{12}
}

func (x *TopLevelTreeNode) GetPatHead() *SignedObject {
	if x != nil {
		return x.PatHead
	}
	return nil
}

// The first node (nodePosition 0) in a Per-Application Tree will have this value.
// V1: node ID = SHA256(VRF Public Key)
// V2: node ID = SHA256("Config node")
// Private cloud compute PAT config nodes will not include the VRF public key
type PerApplicationTreeConfigNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VrfPublicKey   *VRFPublicKey `protobuf:"bytes,1,opt,name=vrfPublicKey,proto3" json:"vrfPublicKey,omitempty"`
	PublicKeyBytes []byte        `protobuf:"bytes,2,opt,name=publicKeyBytes,proto3" json:"publicKeyBytes,omitempty"` // public key for signing roots of all trees for this app, encoded in DER SPKI
	// first supported version for this tree, interpret not set as V1
	EarliestVersion ProtocolVersion `protobuf:"varint,3,opt,name=earliestVersion,proto3,enum=ProtocolVersion" json:"earliestVersion,omitempty"`
}

func (x *PerApplicationTreeConfigNode) Reset() {
	*x = PerApplicationTreeConfigNode{}
	mi := &file_Transparency_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PerApplicationTreeConfigNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerApplicationTreeConfigNode) ProtoMessage() {}

func (x *PerApplicationTreeConfigNode) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerApplicationTreeConfigNode.ProtoReflect.Descriptor instead.
func (*PerApplicationTreeConfigNode) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{13}
}

func (x *PerApplicationTreeConfigNode) GetVrfPublicKey() *VRFPublicKey {
	if x != nil {
		return x.VrfPublicKey
	}
	return nil
}

func (x *PerApplicationTreeConfigNode) GetPublicKeyBytes() []byte {
	if x != nil {
		return x.PublicKeyBytes
	}
	return nil
}

func (x *PerApplicationTreeConfigNode) GetEarliestVersion() ProtocolVersion {
	if x != nil {
		return x.EarliestVersion
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

// The first node (nodePosition 0) in a Top-level Tree will have this value.
// V1: node ID = SHA256(signing public key)
// V2: node ID = SHA256("Config node")
type TopLevelTreeConfigNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PublicKeyBytes []byte `protobuf:"bytes,1,opt,name=publicKeyBytes,proto3" json:"publicKeyBytes,omitempty"` // public key for signing roots of the top-level tree, encoded in DER SPKI
	// first supported version for this tree, interpret not set as V1
	EarliestVersion ProtocolVersion `protobuf:"varint,3,opt,name=earliestVersion,proto3,enum=ProtocolVersion" json:"earliestVersion,omitempty"`
	TreeCounter     uint32          `protobuf:"varint,4,opt,name=treeCounter,proto3" json:"treeCounter,omitempty"`
}

func (x *TopLevelTreeConfigNode) Reset() {
	*x = TopLevelTreeConfigNode{}
	mi := &file_Transparency_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TopLevelTreeConfigNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopLevelTreeConfigNode) ProtoMessage() {}

func (x *TopLevelTreeConfigNode) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopLevelTreeConfigNode.ProtoReflect.Descriptor instead.
func (*TopLevelTreeConfigNode) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{14}
}

func (x *TopLevelTreeConfigNode) GetPublicKeyBytes() []byte {
	if x != nil {
		return x.PublicKeyBytes
	}
	return nil
}

func (x *TopLevelTreeConfigNode) GetEarliestVersion() ProtocolVersion {
	if x != nil {
		return x.EarliestVersion
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

func (x *TopLevelTreeConfigNode) GetTreeCounter() uint32 {
	if x != nil {
		return x.TreeCounter
	}
	return 0
}

// Indicates that this PAT or TLT is shut down (for PAT, the PACL and PAM that feed it are also shut down).
// Not necessarily the last PAT node. (PAT should contain no other nodes newer than this + MMD?)
// node ID = SHA256("Closed node")
type LogClosedNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimestampMs uint64 `protobuf:"varint,1,opt,name=timestampMs,proto3" json:"timestampMs,omitempty"` // Any SMTs less than MMD before this may never merge
	// Earliest version that is supported by the new tree.
	EarliestVersionForNextTree ProtocolVersion `protobuf:"varint,3,opt,name=earliestVersionForNextTree,proto3,enum=ProtocolVersion" json:"earliestVersionForNextTree,omitempty"`
}

func (x *LogClosedNode) Reset() {
	*x = LogClosedNode{}
	mi := &file_Transparency_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogClosedNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogClosedNode) ProtoMessage() {}

func (x *LogClosedNode) ProtoReflect() protoreflect.Message {
	mi := &file_Transparency_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogClosedNode.ProtoReflect.Descriptor instead.
func (*LogClosedNode) Descriptor() ([]byte, []int) {
	return file_Transparency_proto_rawDescGZIP(), []int{15}
}

func (x *LogClosedNode) GetTimestampMs() uint64 {
	if x != nil {
		return x.TimestampMs
	}
	return 0
}

func (x *LogClosedNode) GetEarliestVersionForNextTree() ProtocolVersion {
	if x != nil {
		return x.EarliestVersionForNextTree
	}
	return ProtocolVersion_UNKNOWN_VERSION
}

var File_Transparency_proto protoreflect.FileDescriptor

var file_Transparency_proto_rawDesc = []byte{
	0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x58, 0x0a, 0x0a, 0x56, 0x52, 0x46, 0x57, 0x69, 0x74, 0x6e, 0x65,
	0x73, 0x73, 0x12, 0x1c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x08, 0x2e, 0x56, 0x52, 0x46, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f,
	0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x22, 0x44,
	0x0a, 0x0c, 0x56, 0x52, 0x46, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x72, 0x66, 0x4b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x76, 0x72, 0x66, 0x4b, 0x65, 0x79, 0x12, 0x1c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x56, 0x52, 0x46, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x2e, 0x0a, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x53, 0x50,
	0x4b, 0x49, 0x48, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x73, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x53, 0x50, 0x4b, 0x49, 0x48, 0x61, 0x73, 0x68,
	0x12, 0x3b, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x33, 0x0a,
	0x12, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
	0x10, 0x01, 0x22, 0x50, 0x0a, 0x0c, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x28, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x22, 0x97, 0x02, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64,
	0x12, 0x26, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x4d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x42, 0x65, 0x67,
	0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x53,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x6c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x48, 0x61, 0x73,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64,
	0x48, 0x61, 0x73, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x08, 0x2e, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x22, 0xf6,
	0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x22, 0x0a, 0x07, 0x6c,
	0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x4c,
	0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1f, 0x0a, 0x03, 0x73, 0x6c, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x03, 0x73, 0x6c, 0x68,
	0x12, 0x3c, 0x0a, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65, 0x72,
	0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0c, 0x52, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f, 0x66, 0x50, 0x65, 0x65,
	0x72, 0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x1c,
	0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6e,
	0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xcd, 0x02, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x48,
	0x65, 0x61, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x6c, 0x6f, 0x67,
	0x42, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x6d,
	0x61, 0x70, 0x48, 0x65, 0x61, 0x64, 0x48, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0b, 0x6d, 0x61, 0x70, 0x48, 0x65, 0x61, 0x64, 0x48, 0x61, 0x73, 0x68, 0x12, 0x2e, 0x0a,
	0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a,
	0x0d, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x08, 0x2e, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x52, 0x0d,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x6f, 0x67, 0x48, 0x65, 0x61, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x07, 0x6d, 0x61, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x08, 0x2e, 0x4d, 0x61, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x74, 0x72, 0x65, 0x65, 0x49, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74,
	0x72, 0x65, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x4d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x6f, 0x70, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x6f, 0x70,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x83, 0x01, 0x0a, 0x08, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x03, 0x73, 0x6d, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x52, 0x03, 0x73, 0x6d, 0x68, 0x12, 0x3c, 0x0a, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x4f,
	0x66, 0x50, 0x65, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52, 0x6f,
	0x6f, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x19, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73,
	0x4f, 0x66, 0x50, 0x65, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x54, 0x6f, 0x52,
	0x6f, 0x6f, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x22, 0xcb, 0x01,
	0x0a, 0x0e, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x12, 0x25, 0x0a, 0x08, 0x6d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d,
	0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x43, 0x0a,
	0x17, 0x70, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09,
	0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x70, 0x65, 0x72, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x37, 0x0a, 0x11, 0x74, 0x6f, 0x70, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x54, 0x72,
	0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09, 0x2e,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x74, 0x6f, 0x70, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x91, 0x01, 0x0a, 0x11,
	0x50, 0x61, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x12, 0x43, 0x0a, 0x17, 0x70, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x70,
	0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x65,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x37, 0x0a, 0x11, 0x74, 0x6f, 0x70, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x74, 0x6f,
	0x70, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22,
	0x2d, 0x0a, 0x0f, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x6f, 0x67, 0x4e, 0x6f, 0x64, 0x65,
	0x56, 0x32, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x51,
	0x0a, 0x16, 0x50, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x72, 0x65, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x64,
	0x65, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x48, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x65, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x48, 0x65, 0x61,
	0x64, 0x22, 0x3b, 0x0a, 0x10, 0x54, 0x6f, 0x70, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x54, 0x72, 0x65,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x07, 0x70, 0x61, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x74, 0x48, 0x65, 0x61, 0x64, 0x22, 0xb5,
	0x01, 0x0a, 0x1c, 0x50, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x72, 0x65, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x12,
	0x31, 0x0a, 0x0c, 0x76, 0x72, 0x66, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x56, 0x52, 0x46, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x76, 0x72, 0x66, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x12, 0x26, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0f, 0x65, 0x61,
	0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0x0a, 0x16, 0x54, 0x6f, 0x70, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x26, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0f, 0x65, 0x61, 0x72,
	0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x74, 0x72, 0x65, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x74, 0x72, 0x65, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x83, 0x01, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x12, 0x50, 0x0a, 0x1a, 0x65,
	0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f,
	0x72, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x72, 0x65, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x10, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x1a, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x72, 0x65, 0x65, 0x2a, 0x4e, 0x0a,
	0x0f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x31, 0x10, 0x01, 0x12, 0x06, 0x0a,
	0x02, 0x56, 0x32, 0x10, 0x02, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x33, 0x10, 0x03, 0x12, 0x0e, 0x0a,
	0x06, 0x46, 0x55, 0x54, 0x55, 0x52, 0x45, 0x10, 0xff, 0x93, 0xeb, 0xdc, 0x03, 0x2a, 0x78, 0x0a,
	0x0b, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x44, 0x53, 0x5f, 0x4d, 0x45, 0x53,
	0x53, 0x41, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54,
	0x45, 0x10, 0x05, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x06, 0x2a, 0x86, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x4d, 0x55, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f,
	0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10,
	0x06, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x07,
	0x2a, 0x3f, 0x0a, 0x07, 0x56, 0x52, 0x46, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x56, 0x52, 0x46, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f,
	0x45, 0x43, 0x56, 0x52, 0x46, 0x5f, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39, 0x5f, 0x53, 0x48,
	0x41, 0x35, 0x31, 0x32, 0x5f, 0x45, 0x6c, 0x6c, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x32, 0x10,
	0x03, 0x2a, 0x80, 0x01, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4c, 0x4f, 0x47, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x50, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x4c, 0x4f, 0x47, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x50, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x4f, 0x50, 0x5f,
	0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x54, 0x5f, 0x4c, 0x4f, 0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x54, 0x5f, 0x4c,
	0x4f, 0x47, 0x10, 0x05, 0x2a, 0x32, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4d, 0x41, 0x50, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x4f, 0x42, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x4d, 0x41, 0x50, 0x10, 0x01, 0x2a, 0x8f, 0x01, 0x0a, 0x08, 0x4e, 0x6f, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x43, 0x4c, 0x5f, 0x4e, 0x4f,
	0x44, 0x45, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x41, 0x54, 0x5f, 0x4e, 0x4f, 0x44, 0x45,
	0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x41, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x4c, 0x54, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4c, 0x54, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f,
	0x47, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x05, 0x12,
	0x0b, 0x0a, 0x07, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08,
	0x41, 0x54, 0x4c, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x07, 0x42, 0x61, 0x0a, 0x12, 0x63, 0x6f,
	0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x6b, 0x65, 0x79, 0x74, 0x2e, 0x61, 0x70, 0x69,
	0x42, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x74, 0x6f, 0x70, 0x2f, 0x69, 0x70, 0x73, 0x77, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x2f, 0x70, 0x63, 0x63, 0xba, 0x02, 0x05, 0x54, 0x78, 0x50, 0x42, 0x5f, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_Transparency_proto_rawDescOnce sync.Once
	file_Transparency_proto_rawDescData = file_Transparency_proto_rawDesc
)

func file_Transparency_proto_rawDescGZIP() []byte {
	file_Transparency_proto_rawDescOnce.Do(func() {
		file_Transparency_proto_rawDescData = protoimpl.X.CompressGZIP(file_Transparency_proto_rawDescData)
	})
	return file_Transparency_proto_rawDescData
}

var file_Transparency_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_Transparency_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_Transparency_proto_goTypes = []any{
	(ProtocolVersion)(0),                 // 0: ProtocolVersion
	(Application)(0),                     // 1: Application
	(Status)(0),                          // 2: Status
	(VRFType)(0),                         // 3: VRFType
	(LogType)(0),                         // 4: LogType
	(MapType)(0),                         // 5: MapType
	(NodeType)(0),                        // 6: NodeType
	(Signature_SignatureAlgorithm)(0),    // 7: Signature.SignatureAlgorithm
	(*VRFWitness)(nil),                   // 8: VRFWitness
	(*VRFPublicKey)(nil),                 // 9: VRFPublicKey
	(*Signature)(nil),                    // 10: Signature
	(*SignedObject)(nil),                 // 11: SignedObject
	(*LogHead)(nil),                      // 12: LogHead
	(*LogEntry)(nil),                     // 13: LogEntry
	(*MapHead)(nil),                      // 14: MapHead
	(*MapEntry)(nil),                     // 15: MapEntry
	(*InclusionProof)(nil),               // 16: InclusionProof
	(*PatInclusionProof)(nil),            // 17: PatInclusionProof
	(*ChangeLogNodeV2)(nil),              // 18: ChangeLogNodeV2
	(*PerApplicationTreeNode)(nil),       // 19: PerApplicationTreeNode
	(*TopLevelTreeNode)(nil),             // 20: TopLevelTreeNode
	(*PerApplicationTreeConfigNode)(nil), // 21: PerApplicationTreeConfigNode
	(*TopLevelTreeConfigNode)(nil),       // 22: TopLevelTreeConfigNode
	(*LogClosedNode)(nil),                // 23: LogClosedNode
}
var file_Transparency_proto_depIdxs = []int32{
	3,  // 0: VRFWitness.type:type_name -> VRFType
	3,  // 1: VRFPublicKey.type:type_name -> VRFType
	7,  // 2: Signature.algorithm:type_name -> Signature.SignatureAlgorithm
	10, // 3: SignedObject.signature:type_name -> Signature
	4,  // 4: LogHead.logType:type_name -> LogType
	1,  // 5: LogHead.application:type_name -> Application
	4,  // 6: LogEntry.logType:type_name -> LogType
	11, // 7: LogEntry.slh:type_name -> SignedObject
	6,  // 8: LogEntry.nodeType:type_name -> NodeType
	1,  // 9: MapHead.application:type_name -> Application
	12, // 10: MapHead.changeLogHead:type_name -> LogHead
	5,  // 11: MapHead.mapType:type_name -> MapType
	11, // 12: MapEntry.smh:type_name -> SignedObject
	15, // 13: InclusionProof.mapEntry:type_name -> MapEntry
	13, // 14: InclusionProof.perApplicationTreeEntry:type_name -> LogEntry
	13, // 15: InclusionProof.topLevelTreeEntry:type_name -> LogEntry
	13, // 16: PatInclusionProof.perApplicationTreeEntry:type_name -> LogEntry
	13, // 17: PatInclusionProof.topLevelTreeEntry:type_name -> LogEntry
	11, // 18: PerApplicationTreeNode.predecessorHead:type_name -> SignedObject
	11, // 19: TopLevelTreeNode.patHead:type_name -> SignedObject
	9,  // 20: PerApplicationTreeConfigNode.vrfPublicKey:type_name -> VRFPublicKey
	0,  // 21: PerApplicationTreeConfigNode.earliestVersion:type_name -> ProtocolVersion
	0,  // 22: TopLevelTreeConfigNode.earliestVersion:type_name -> ProtocolVersion
	0,  // 23: LogClosedNode.earliestVersionForNextTree:type_name -> ProtocolVersion
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func file_Transparency_proto_init() {
	if File_Transparency_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_Transparency_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_Transparency_proto_goTypes,
		DependencyIndexes: file_Transparency_proto_depIdxs,
		EnumInfos:         file_Transparency_proto_enumTypes,
		MessageInfos:      file_Transparency_proto_msgTypes,
	}.Build()
	File_Transparency_proto = out.File
	file_Transparency_proto_rawDesc = nil
	file_Transparency_proto_goTypes = nil
	file_Transparency_proto_depIdxs = nil
}
