package env

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace-bin/pkg/actions/os"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/bat"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/gh"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/git"
	"github.com/carapace-sh/carapace-bin/pkg/conditions"
	"github.com/carapace-sh/carapace-bridge/pkg/actions/bridge"
)

func init() {
	knownVariables["homebrew"] = func() variables {
		return variables{
			Condition: conditions.ConditionPath("brew"),
			Variables: map[string]string{
				"HOMEBREW_API_DOMAIN":                       "Use this URL as the download mirror for Homebrew JSON API",
				"HOMEBREW_ARCH":                             "Linux only: Pass this value to a type name representing the compiler’s -march option",
				"HOMEBREW_ARTIFACT_DOMAIN":                  "Prefix all download URLs, including those for bottles, with this value",
				"HOMEBREW_API_AUTO_UPDATE_SECS":             "Check Homebrew’s API for new formulae or cask data every given seconds",
				"HOMEBREW_AUTO_UPDATE_SECS":                 "Run brew update once every given seconds before some commands",
				"HOMEBREW_AUTOREMOVE":                       "Calls to brew cleanup and brew uninstall will automatically remove unused formula dependents",
				"HOMEBREW_BAT":                              "Use bat for the brew cat command",
				"HOMEBREW_BAT_CONFIG_PATH":                  "Use this as the bat configuration file",
				"HOMEBREW_BAT_THEME":                        "Use this as the bat theme for syntax highlighting",
				"HOMEBREW_BOOTSNAP":                         "Use Bootsnap to speed up repeated brew calls",
				"HOMEBREW_BOTTLE_DOMAIN":                    "Use this URL as the download mirror for bottles",
				"HOMEBREW_BREW_GIT_REMOTE":                  "Use this URL as the Homebrew/brew git remote",
				"HOMEBREW_BROWSER":                          "Use this as the browser when opening project homepages",
				"HOMEBREW_CACHE":                            "Use this directory as the download cache",
				"HOMEBREW_CASK_OPTS":                        "Append these options to all cask commands",
				"HOMEBREW_CLEANUP_MAX_AGE_DAYS":             "Cleanup all cached files older than this many days",
				"HOMEBREW_CLEANUP_PERIODIC_FULL_DAYS":       "Cleanup all formulae when this number of days has passed",
				"HOMEBREW_COLOR":                            "Force colour output on non-TTY outputs",
				"HOMEBREW_CORE_GIT_REMOTE":                  "Use this URL as the Homebrew/homebrew-core git remote",
				"HOMEBREW_CURL_PATH":                        "Linux only: Set this value to a new enough curl executable for Homebrew to use",
				"HOMEBREW_CURL_RETRIES":                     "Pass the given retry count to --retry when invoking curl",
				"HOMEBREW_CURL_VERBOSE":                     "Pass --verbose when invoking curl",
				"HOMEBREW_CURLRC":                           "If set to an absolute path pass it with --config when invoking curl",
				"HOMEBREW_DEBUG":                            "Always assume --debug when running commands",
				"HOMEBREW_DEVELOPER":                        "Tweak behaviour to be more relevant for Homebrew developers",
				"HOMEBREW_DISABLE_LOAD_FORMULA":             "Refuse to load formulae",
				"HOMEBREW_DISPLAY":                          "Use this X11 display when opening a page in a browser",
				"HOMEBREW_DISPLAY_INSTALL_TIMES":            "Print install times for each formula at the end of the run",
				"HOMEBREW_DOCKER_REGISTRY_BASIC_AUTH_TOKEN": "Use this base64 encoded username and password for authenticating with a Docker registry",
				"HOMEBREW_DOCKER_REGISTRY_TOKEN":            "Use this bearer token for authenticating with a Docker registry",
				"HOMEBREW_EDITOR":                           "Use this editor when editing a single formula",
				"HOMEBREW_EVAL_ALL":                         "Evaluate all formulae and casks",
				"HOMEBREW_FAIL_LOG_LINES":                   "Output this many lines of output on formula system failures",
				"HOMEBREW_FORBIDDEN_LICENSES":               "A space-separated list of licenses",
				"HOMEBREW_FORCE_BREWED_CA_CERTIFICATES":     "Always use a Homebrew-installed ca-certificates",
				"HOMEBREW_FORCE_BREWED_CURL":                "Always use a Homebrew-installed curl",
				"HOMEBREW_FORCE_BREWED_GIT":                 "Always use a Homebrew-installed git",
				"HOMEBREW_FORCE_VENDOR_RUBY":                "Always use Homebrew’s vendored, relocatable Ruby",
				"HOMEBREW_GIT_EMAIL":                        "Set the Git author and committer email to this value",
				"HOMEBREW_GIT_NAME":                         "Set the Git author and committer name to this value",
				"HOMEBREW_GIT_PATH":                         "Linux only: Set this value to a new enough git executable",
				"HOMEBREW_GITHUB_API_TOKEN":                 "Use this personal access token for the GitHub API",
				"HOMEBREW_GITHUB_PACKAGES_TOKEN":            "Use this GitHub personal access token",
				"HOMEBREW_GITHUB_PACKAGES_USER":             "Use this username when accessing the GitHub Packages Registry",
				"HOMEBREW_INSTALL_BADGE":                    "Print this text before the installation summary of each successful build",
				"HOMEBREW_LIVECHECK_WATCHLIST":              "Consult this file for the list of formulae to check by default",
				"HOMEBREW_LOGS":                             "Use this directory to store log files",
				"HOMEBREW_MAKE_JOBS":                        "Use this value as the number of parallel jobs to run when building with make",
				"HOMEBREW_NO_ANALYTICS":                     "Do not send analytics",
				"HOMEBREW_NO_AUTO_UPDATE":                   "Do not automatically update before running some commands",
				"HOMEBREW_NO_BOOTSNAP":                      "Do not use Bootsnap to speed up repeated brew calls",
				"HOMEBREW_NO_CLEANUP_FORMULAE":              "A comma-separated list of formulae",
				"HOMEBREW_NO_COLOR":                         "Do not print text with colour added",
				"HOMEBREW_NO_EMOJI":                         "Do not print HOMEBREW_INSTALL_BADGE on a successful build",
				"HOMEBREW_NO_ENV_HINTS":                     "Do not print any hints about changing Homebrew’s behaviour",
				"HOMEBREW_NO_GITHUB_API":                    "Do not use the GitHub API",
				"HOMEBREW_NO_INSECURE_REDIRECT":             "Forbid redirects from secure HTTPS to insecure HTTP",
				"HOMEBREW_NO_INSTALL_CLEANUP":               "Never automatically cleanup installed/upgraded/reinstalled formulae",
				"HOMEBREW_NO_INSTALL_FROM_API":              "Do not install formulae and casks using Homebrew’s API",
				"HOMEBREW_NO_INSTALL_UPGRADE":               "Do not upgrade formula|cask if it is installed but outdated",
				"HOMEBREW_NO_INSTALLED_DEPENDENTS_CHECK":    "Do not check for broken linkage of dependents or outdated dependents after installing",
				"HOMEBREW_NO_UPDATE_REPORT_NEW":             "Brew update will not show the list of newly added formulae/casks",
				"HOMEBREW_PIP_INDEX_URL":                    "Brew install formula will use this URL to download PyPI package resources",
				"HOMEBREW_PRY":                              "Use Pry for the brew irb command",
				"HOMEBREW_UPGRADE_GREEDY":                   "pass --greedy to all cask upgrade commands",
				"HOMEBREW_SIMULATE_MACOS_ON_LINUX":          "Running Homebrew on Linux will simulate certain macOS code paths",
				"HOMEBREW_SKIP_OR_LATER_BOTTLES":            "Do not use bottles from older versions of macOS",
				"HOMEBREW_SORBET_RUNTIME":                   "Enable runtime typechecking using Sorbet",
				"HOMEBREW_SSH_CONFIG_PATH":                  "Use the given config file instead of ~/.ssh/config",
				"HOMEBREW_SVN":                              "Use this as the svn binary",
				"HOMEBREW_SYSTEM_ENV_TAKES_PRIORITY":        "Load system-wide environment file last",
				"HOMEBREW_SUDO_THROUGH_SUDO_USER":           "Use the SUDO_USER environment variable",
				"HOMEBREW_TEMP":                             "Use this path as the temporary directory for building packages",
				"HOMEBREW_UPDATE_TO_TAG":                    "Always use the latest stable tag",
				"HOMEBREW_VERBOSE":                          "Always assume --verbose when running commands",
				"HOMEBREW_VERBOSE_USING_DOTS":               "Verbose output will print a . no more than once a minute",
			},
			VariableCompletion: map[string]carapace.Action{
				// TODO completions
				"HOMEBREW_API_DOMAIN":                       carapace.ActionValues(),
				"HOMEBREW_ARCH":                             carapace.ActionValues(),
				"HOMEBREW_ARTIFACT_DOMAIN":                  carapace.ActionValues(),
				"HOMEBREW_API_AUTO_UPDATE_SECS":             carapace.ActionValues(),
				"HOMEBREW_AUTO_UPDATE_SECS":                 carapace.ActionValues(),
				"HOMEBREW_AUTOREMOVE":                       carapace.ActionValues("1"),
				"HOMEBREW_BAT":                              carapace.ActionValues("1"),
				"HOMEBREW_BAT_CONFIG_PATH":                  carapace.ActionFiles(),
				"HOMEBREW_BAT_THEME":                        bat.ActionThemes(),
				"HOMEBREW_BOOTSNAP":                         carapace.ActionValues(),
				"HOMEBREW_BOTTLE_DOMAIN":                    carapace.ActionValues(),
				"HOMEBREW_BREW_GIT_REMOTE":                  git.ActionRepositorySearch(git.SearchOpts{}.Default()),
				"HOMEBREW_BROWSER":                          carapace.ActionFiles(),
				"HOMEBREW_CACHE":                            carapace.ActionDirectories(),
				"HOMEBREW_CASK_OPTS":                        carapace.ActionValues(),
				"HOMEBREW_CLEANUP_MAX_AGE_DAYS":             carapace.ActionValues(),
				"HOMEBREW_CLEANUP_PERIODIC_FULL_DAYS":       carapace.ActionValues(),
				"HOMEBREW_COLOR":                            carapace.ActionValues("1"),
				"HOMEBREW_CORE_GIT_REMOTE":                  git.ActionRepositorySearch(git.SearchOpts{}.Default()),
				"HOMEBREW_CURL_PATH":                        carapace.ActionFiles(),
				"HOMEBREW_CURL_RETRIES":                     carapace.ActionValues(),
				"HOMEBREW_CURL_VERBOSE":                     carapace.ActionValues(),
				"HOMEBREW_CURLRC":                           carapace.ActionValues(),
				"HOMEBREW_DEBUG":                            carapace.ActionValues(),
				"HOMEBREW_DEVELOPER":                        carapace.ActionValues(),
				"HOMEBREW_DISABLE_LOAD_FORMULA":             carapace.ActionValues(),
				"HOMEBREW_DISPLAY":                          os.ActionDisplays(),
				"HOMEBREW_DISPLAY_INSTALL_TIMES":            carapace.ActionValues(),
				"HOMEBREW_DOCKER_REGISTRY_BASIC_AUTH_TOKEN": carapace.ActionValues(),
				"HOMEBREW_DOCKER_REGISTRY_TOKEN":            carapace.ActionValues(),
				"HOMEBREW_EDITOR":                           bridge.ActionCarapaceBin().Split(),
				"HOMEBREW_EVAL_ALL":                         carapace.ActionValues("1"),
				"HOMEBREW_FAIL_LOG_LINES":                   carapace.ActionValues(),
				"HOMEBREW_FORBIDDEN_LICENSES":               gh.ActionLicenses(gh.HostOpts{}).UniqueList(","),
				"HOMEBREW_FORCE_BREWED_CA_CERTIFICATES":     carapace.ActionValues(),
				"HOMEBREW_FORCE_BREWED_CURL":                carapace.ActionValues(),
				"HOMEBREW_FORCE_BREWED_GIT":                 carapace.ActionValues(),
				"HOMEBREW_FORCE_VENDOR_RUBY":                carapace.ActionValues(),
				"HOMEBREW_GIT_EMAIL":                        carapace.ActionValues(),
				"HOMEBREW_GIT_NAME":                         carapace.ActionValues(),
				"HOMEBREW_GIT_PATH":                         carapace.ActionFiles(),
				"HOMEBREW_GITHUB_API_TOKEN":                 carapace.ActionValues(),
				"HOMEBREW_GITHUB_PACKAGES_TOKEN":            carapace.ActionValues(),
				"HOMEBREW_GITHUB_PACKAGES_USER":             carapace.ActionValues(),
				"HOMEBREW_INSTALL_BADGE":                    carapace.ActionValues(),
				"HOMEBREW_LIVECHECK_WATCHLIST":              carapace.ActionValues(),
				"HOMEBREW_LOGS":                             carapace.ActionDirectories(),
				"HOMEBREW_MAKE_JOBS":                        carapace.ActionValues(),
				"HOMEBREW_NO_ANALYTICS":                     carapace.ActionValues("1"),
				"HOMEBREW_NO_AUTO_UPDATE":                   carapace.ActionValues("1"),
				"HOMEBREW_NO_BOOTSNAP":                      carapace.ActionValues("1"),
				"HOMEBREW_NO_CLEANUP_FORMULAE":              carapace.ActionValues("1"),
				"HOMEBREW_NO_COLOR":                         carapace.ActionValues("1"),
				"HOMEBREW_NO_EMOJI":                         carapace.ActionValues("1"),
				"HOMEBREW_NO_ENV_HINTS":                     carapace.ActionValues("1"),
				"HOMEBREW_NO_GITHUB_API":                    carapace.ActionValues("1"),
				"HOMEBREW_NO_INSECURE_REDIRECT":             carapace.ActionValues("1"),
				"HOMEBREW_NO_INSTALL_CLEANUP":               carapace.ActionValues("1"),
				"HOMEBREW_NO_INSTALL_FROM_API":              carapace.ActionValues("1"),
				"HOMEBREW_NO_INSTALL_UPGRADE":               carapace.ActionValues("1"),
				"HOMEBREW_NO_INSTALLED_DEPENDENTS_CHECK":    carapace.ActionValues("1"),
				"HOMEBREW_NO_UPDATE_REPORT_NEW":             carapace.ActionValues("1"),
				"HOMEBREW_PIP_INDEX_URL":                    carapace.ActionValues(),
				"HOMEBREW_PRY":                              carapace.ActionValues(),
				"HOMEBREW_UPGRADE_GREEDY":                   carapace.ActionValues(),
				"HOMEBREW_SIMULATE_MACOS_ON_LINUX":          carapace.ActionValues(),
				"HOMEBREW_SKIP_OR_LATER_BOTTLES":            carapace.ActionValues(),
				"HOMEBREW_SORBET_RUNTIME":                   carapace.ActionValues(),
				"HOMEBREW_SSH_CONFIG_PATH":                  carapace.ActionFiles(),
				"HOMEBREW_SVN":                              carapace.ActionValues(),
				"HOMEBREW_SYSTEM_ENV_TAKES_PRIORITY":        carapace.ActionValues(),
				"HOMEBREW_SUDO_THROUGH_SUDO_USER":           carapace.ActionValues(),
				"HOMEBREW_TEMP":                             carapace.ActionDirectories(),
				"HOMEBREW_UPDATE_TO_TAG":                    carapace.ActionValues("1"),
				"HOMEBREW_VERBOSE":                          carapace.ActionValues("1"),
				"HOMEBREW_VERBOSE_USING_DOTS":               carapace.ActionValues("1"),
			},
		}
	}
}
