# v0.27 -  Hulk BASH!

![](./v0.27/banner.png)

Contains strong changes to the [bash] integration.

## Redirects

Support for redirects. [bash] passes these to the completion function, so crazy stuff like this is possible:

```sh
example action >/tmp/stdout.txt embeddedPositional1 --styles 2>/tmp/stderr.txt red 'embeddedPositional2 with space'
```

To make this work [carapace-shlex] is now used to parse `COMP_LINE` when invoked from a [bash] completion function.

## Wordbreaks

Better support for [bash] [`COMP_WORDBREAKS`] using [carapace-shlex].
This was originally intended to make multipart completion easier (e.g. colon separated list),
but actually makes it very complicated and error-prone.

## Case insensitive matching

Added (limited) case insensitive [matching].

Set environment variable `CARAPACE_MATCH` to `CASE_INSENSITIVE` or `1` to activate it.
You might also need to configure your shell, e.g. in elvish:

```elvish
set-env CARAPACE_MATCH CASE_INSENSITIVE
set edit:completion:matcher[argument] = {|seed| edit:match-prefix $seed &ignore-case=$true }
```

[bash]:https://www.gnu.org/software/bash/
[carapace-shlex]:https://github.com/carapace-sh/carapace-shlex
[`COMP_WORDBREAKS`]:https://www.gnu.org/software/bash/manual/html_node/Bash-Variables.html
[matching]:https://github.com/carapace-sh/carapace/blob/master/pkg/match/match.go
