package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace-bin/completers/common/cargo_completer/cmd/action"
	"github.com/spf13/cobra"
)

var report_futureIncompatibilitiesCmd = &cobra.Command{
	Use:     "future-incompatibilities",
	Short:   "Reports any crates which will eventually stop compiling",
	Aliases: []string{"future-incompat"},
	Run:     func(cmd *cobra.Command, args []string) {},
}

func init() {
	carapace.Gen(report_futureIncompatibilitiesCmd).Standalone()

	report_futureIncompatibilitiesCmd.Flags().BoolP("help", "h", false, "Print help")
	report_futureIncompatibilitiesCmd.Flags().String("id", "", "identifier of the report generated by a Cargo command invocation")
	report_futureIncompatibilitiesCmd.Flags().StringP("package", "p", "", "Package to display a report for")
	reportCmd.AddCommand(report_futureIncompatibilitiesCmd)

	carapace.Gen(report_futureIncompatibilitiesCmd).FlagCompletion(carapace.ActionMap{
		"package": action.ActionDependencies(report_futureIncompatibilitiesCmd, false),
	})
}
