package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/spf13/cobra"
)

var prPullCmd = &cobra.Command{
	Use:     "pr-pull",
	Short:   "Download and publish bottles, and apply the bottle commit from a pull request with artifacts generated by GitHub Actions",
	GroupID: "developer",
	Run:     func(cmd *cobra.Command, args []string) {},
}

func init() {
	carapace.Gen(prPullCmd).Standalone()

	prPullCmd.Flags().Bool("artifact", false, "Download artifacts with the specified name (default: `bottles`).")
	prPullCmd.Flags().Bool("autosquash", false, "Automatically reformat and reword commits in the pull request to our preferred format.")
	prPullCmd.Flags().Bool("branch-okay", false, "Do not warn if pulling to a branch besides the repository default (useful for testing).")
	prPullCmd.Flags().Bool("clean", false, "Do not amend the commits from pull requests.")
	prPullCmd.Flags().Bool("committer", false, "Specify a committer name and email in `git`'s standard author format.")
	prPullCmd.Flags().Bool("debug", false, "Display any debugging information.")
	prPullCmd.Flags().Bool("dry-run", false, "Print what would be done rather than doing it.")
	prPullCmd.Flags().Bool("help", false, "Show this message.")
	prPullCmd.Flags().Bool("ignore-missing-artifacts", false, "Comma-separated list of workflows which can be ignored if they have not been run.")
	prPullCmd.Flags().Bool("keep-old", false, "If the formula specifies a rebuild version, attempt to preserve its value in the generated DSL.")
	prPullCmd.Flags().Bool("message", false, "Message to include when autosquashing revision bumps, deletions, and rebuilds.")
	prPullCmd.Flags().Bool("no-cherry-pick", false, "Do not cherry-pick commits from the pull request branch.")
	prPullCmd.Flags().Bool("no-commit", false, "Do not generate a new commit before uploading.")
	prPullCmd.Flags().Bool("no-upload", false, "Download the bottles but don't upload them.")
	prPullCmd.Flags().Bool("quiet", false, "Make some output more quiet.")
	prPullCmd.Flags().Bool("resolve", false, "When a patch fails to apply, leave in progress and allow user to resolve, instead of aborting.")
	prPullCmd.Flags().Bool("retain-bottle-dir", false, "Does not clean up the tmp directory for the bottle so it can be used later.")
	prPullCmd.Flags().Bool("root-url", false, "Use the specified <URL> as the root of the bottle's URL instead of Homebrew's default.")
	prPullCmd.Flags().Bool("root-url-using", false, "Use the specified download strategy class for downloading the bottle's URL instead of Homebrew's default.")
	prPullCmd.Flags().Bool("tap", false, "Target tap repository (default: `homebrew/core`).")
	prPullCmd.Flags().Bool("verbose", false, "Make some output more verbose.")
	prPullCmd.Flags().Bool("warn-on-upload-failure", false, "Warn instead of raising an error if the bottle upload fails. Useful for repairing bottle uploads that previously failed.")
	prPullCmd.Flags().Bool("workflows", false, "Retrieve artifacts from the specified workflow (default: `tests.yml`). Can be a comma-separated list to include multiple workflows.")
	rootCmd.AddCommand(prPullCmd)
}
