// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a process that cleans the specified file share's cache of file entries
// that are failing upload to Amazon S3. This API operation reports success if the
// request is received with valid arguments, and there are no other cache clean
// operations currently in-progress for the specified file share. After a
// successful request, the cache clean operation occurs asynchronously and reports
// progress using CloudWatch logs and notifications.
//
// If ForceRemove is set to True , the cache clean operation will delete file data
// from the gateway which might otherwise be recoverable. We recommend using this
// operation only after all other methods to clear files failing upload have been
// exhausted, and if your business need outweighs the potential data loss.
func (c *Client) EvictFilesFailingUpload(ctx context.Context, params *EvictFilesFailingUploadInput, optFns ...func(*Options)) (*EvictFilesFailingUploadOutput, error) {
	if params == nil {
		params = &EvictFilesFailingUploadInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EvictFilesFailingUpload", params, optFns, c.addOperationEvictFilesFailingUploadMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EvictFilesFailingUploadOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EvictFilesFailingUploadInput struct {

	// The Amazon Resource Name (ARN) of the file share for which you want to start
	// the cache clean operation.
	//
	// This member is required.
	FileShareARN *string

	// Specifies whether cache entries with full or partial file data currently stored
	// on the gateway will be forcibly removed by the cache clean operation.
	//
	// Valid arguments:
	//
	//   - False - The cache clean operation skips cache entries failing upload if they
	//   are associated with data currently stored on the gateway. This preserves the
	//   cached data.
	//
	//   - True - The cache clean operation removes cache entries failing upload even
	//   if they are associated with data currently stored on the gateway. This deletes
	//   the cached data.
	//
	// If ForceRemove is set to True , the cache clean operation will delete file data
	//   from the gateway which might otherwise be recoverable.
	ForceRemove bool

	noSmithyDocumentSerde
}

type EvictFilesFailingUploadOutput struct {

	// The randomly generated ID of the CloudWatch notification associated with the
	// cache clean operation. This ID is in UUID format.
	NotificationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEvictFilesFailingUploadMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpEvictFilesFailingUpload{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpEvictFilesFailingUpload{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EvictFilesFailingUpload"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEvictFilesFailingUploadValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEvictFilesFailingUpload(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEvictFilesFailingUpload(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EvictFilesFailingUpload",
	}
}
