// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about an asset composite model (also known as an asset
// component). An AssetCompositeModel is an instance of an AssetModelCompositeModel
// . If you want to see information about the model this is based on, call [DescribeAssetModelCompositeModel].
//
// [DescribeAssetModelCompositeModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html
func (c *Client) DescribeAssetCompositeModel(ctx context.Context, params *DescribeAssetCompositeModelInput, optFns ...func(*Options)) (*DescribeAssetCompositeModelOutput, error) {
	if params == nil {
		params = &DescribeAssetCompositeModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAssetCompositeModel", params, optFns, c.addOperationDescribeAssetCompositeModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAssetCompositeModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAssetCompositeModelInput struct {

	// The ID of a composite model on this asset. This can be either the actual ID in
	// UUID format, or else externalId: followed by the external ID, if it has one.
	// For more information, see [Referencing objects with external IDs]in the IoT SiteWise User Guide.
	//
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	//
	// This member is required.
	AssetCompositeModelId *string

	// The ID of the asset. This can be either the actual ID in UUID format, or else
	// externalId: followed by the external ID, if it has one. For more information,
	// see [Referencing objects with external IDs]in the IoT SiteWise User Guide.
	//
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	//
	// This member is required.
	AssetId *string

	noSmithyDocumentSerde
}

type DescribeAssetCompositeModelOutput struct {

	// A description for the composite model.
	//
	// This member is required.
	AssetCompositeModelDescription *string

	// The ID of a composite model on this asset.
	//
	// This member is required.
	AssetCompositeModelId *string

	// The unique, friendly name for the composite model.
	//
	// This member is required.
	AssetCompositeModelName *string

	// The path to the composite model listing the parent composite models.
	//
	// This member is required.
	AssetCompositeModelPath []types.AssetCompositeModelPathSegment

	// The property definitions of the composite model that was used to create the
	// asset.
	//
	// This member is required.
	AssetCompositeModelProperties []types.AssetProperty

	// The list of composite model summaries.
	//
	// This member is required.
	AssetCompositeModelSummaries []types.AssetCompositeModelSummary

	// The composite model type. Valid values are AWS/ALARM , CUSTOM , or
	// AWS/L4E_ANOMALY .
	//
	// This member is required.
	AssetCompositeModelType *string

	// The ID of the asset, in UUID format. This ID uniquely identifies the asset
	// within IoT SiteWise and can be used with other IoT SiteWise APIs.
	//
	// This member is required.
	AssetId *string

	// The available actions for a composite model on this asset.
	ActionDefinitions []types.ActionDefinition

	// An external ID to assign to the asset model.
	//
	// If the composite model is a component-based composite model, or one nested
	// inside a component model, you can only set the external ID using
	// UpdateAssetModelCompositeModel and specifying the derived ID of the model or
	// property from the created model it's a part of.
	AssetCompositeModelExternalId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAssetCompositeModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeAssetCompositeModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeAssetCompositeModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAssetCompositeModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opDescribeAssetCompositeModelMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeAssetCompositeModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAssetCompositeModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opDescribeAssetCompositeModelMiddleware struct {
}

func (*endpointPrefix_opDescribeAssetCompositeModelMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opDescribeAssetCompositeModelMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opDescribeAssetCompositeModelMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opDescribeAssetCompositeModelMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opDescribeAssetCompositeModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAssetCompositeModel",
	}
}
