// Code generated by smithy-go-codegen DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation lists all the service deployments that meet the specified filter
// criteria.
//
// A service deployment happens when you release a software update for the
// service. You route traffic from the running service revisions to the new service
// revison and control the number of running tasks.
//
// This API returns the values that you use for the request parameters in [DescribeServiceRevisions].
//
// [DescribeServiceRevisions]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServiceRevisions.html
func (c *Client) ListServiceDeployments(ctx context.Context, params *ListServiceDeploymentsInput, optFns ...func(*Options)) (*ListServiceDeploymentsOutput, error) {
	if params == nil {
		params = &ListServiceDeploymentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceDeployments", params, optFns, c.addOperationListServiceDeploymentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceDeploymentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceDeploymentsInput struct {

	// The ARN or name of the service
	//
	// This member is required.
	Service *string

	// The cluster that hosts the service. This can either be the cluster name or ARN.
	// Starting April 15, 2023, Amazon Web Services will not onboard new customers to
	// Amazon Elastic Inference (EI), and will help current customers migrate their
	// workloads to options that offer better price and performance. If you don't
	// specify a cluster, default is used.
	Cluster *string

	// An optional filter you can use to narrow the results by the service creation
	// date. If you do not specify a value, the result includes all services created
	// before the current time. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
	CreatedAt *types.CreatedAt

	// The maximum number of service deployment results that ListServiceDeployments
	// returned in paginated output. When this parameter is used,
	// ListServiceDeployments only returns maxResults results in a single page along
	// with a nextToken response element. The remaining results of the initial request
	// can be seen by sending another ListServiceDeployments request with the returned
	// nextToken value. This value can be between 1 and 100. If this parameter isn't
	// used, then ListServiceDeployments returns up to 20 results and a nextToken
	// value if applicable.
	MaxResults *int32

	// The nextToken value returned from a ListServiceDeployments request indicating
	// that more results are available to fulfill the request and further calls are
	// needed. If you provided maxResults , it's possible the number of results is
	// fewer than maxResults .
	NextToken *string

	// An optional filter you can use to narrow the results. If you do not specify a
	// status, then all status values are included in the result.
	Status []types.ServiceDeploymentStatus

	noSmithyDocumentSerde
}

type ListServiceDeploymentsOutput struct {

	// The nextToken value to include in a future ListServiceDeployments request. When
	// the results of a ListServiceDeployments request exceed maxResults , this value
	// can be used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string

	// An overview of the service deployment, including the following properties:
	//
	//   - The ARN of the service deployment.
	//
	//   - The ARN of the service being deployed.
	//
	//   - The ARN of the cluster that hosts the service in the service deployment.
	//
	//   - The time that the service deployment started.
	//
	//   - The time that the service deployment completed.
	//
	//   - The service deployment status.
	//
	//   - Information about why the service deployment is in the current state.
	//
	//   - The ARN of the service revision that is being deployed.
	ServiceDeployments []types.ServiceDeploymentBrief

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceDeploymentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListServiceDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListServiceDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceDeployments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServiceDeploymentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceDeployments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListServiceDeployments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceDeployments",
	}
}
