// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelJob struct {
}

func (*validateOpCancelJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateComputeEnvironment struct {
}

func (*validateOpCreateComputeEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateComputeEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateComputeEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateComputeEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateConsumableResource struct {
}

func (*validateOpCreateConsumableResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateConsumableResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateJobQueue struct {
}

func (*validateOpCreateJobQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateJobQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateJobQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateJobQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateSchedulingPolicy struct {
}

func (*validateOpCreateSchedulingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateSchedulingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateSchedulingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateSchedulingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateServiceEnvironment struct {
}

func (*validateOpCreateServiceEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateServiceEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateServiceEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateServiceEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteComputeEnvironment struct {
}

func (*validateOpDeleteComputeEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteComputeEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteComputeEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteComputeEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConsumableResource struct {
}

func (*validateOpDeleteConsumableResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConsumableResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteJobQueue struct {
}

func (*validateOpDeleteJobQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteJobQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteJobQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteJobQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSchedulingPolicy struct {
}

func (*validateOpDeleteSchedulingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSchedulingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSchedulingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSchedulingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteServiceEnvironment struct {
}

func (*validateOpDeleteServiceEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteServiceEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteServiceEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteServiceEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeregisterJobDefinition struct {
}

func (*validateOpDeregisterJobDefinition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeregisterJobDefinition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeregisterJobDefinitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeregisterJobDefinitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeConsumableResource struct {
}

func (*validateOpDescribeConsumableResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeConsumableResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeJobs struct {
}

func (*validateOpDescribeJobs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeJobs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeJobsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeJobsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeSchedulingPolicies struct {
}

func (*validateOpDescribeSchedulingPolicies) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeSchedulingPolicies) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeSchedulingPoliciesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeSchedulingPoliciesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeServiceJob struct {
}

func (*validateOpDescribeServiceJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeServiceJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeServiceJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeServiceJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetJobQueueSnapshot struct {
}

func (*validateOpGetJobQueueSnapshot) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetJobQueueSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetJobQueueSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetJobQueueSnapshotInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListJobsByConsumableResource struct {
}

func (*validateOpListJobsByConsumableResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListJobsByConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListJobsByConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListJobsByConsumableResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterJobDefinition struct {
}

func (*validateOpRegisterJobDefinition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterJobDefinition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterJobDefinitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterJobDefinitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSubmitJob struct {
}

func (*validateOpSubmitJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSubmitJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SubmitJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSubmitJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSubmitServiceJob struct {
}

func (*validateOpSubmitServiceJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSubmitServiceJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SubmitServiceJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSubmitServiceJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTerminateJob struct {
}

func (*validateOpTerminateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTerminateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TerminateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTerminateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTerminateServiceJob struct {
}

func (*validateOpTerminateServiceJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTerminateServiceJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TerminateServiceJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTerminateServiceJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateComputeEnvironment struct {
}

func (*validateOpUpdateComputeEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateComputeEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateComputeEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateComputeEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConsumableResource struct {
}

func (*validateOpUpdateConsumableResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConsumableResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateJobQueue struct {
}

func (*validateOpUpdateJobQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateJobQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateJobQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateJobQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateSchedulingPolicy struct {
}

func (*validateOpUpdateSchedulingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateSchedulingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateSchedulingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateSchedulingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateServiceEnvironment struct {
}

func (*validateOpUpdateServiceEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateServiceEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateServiceEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateServiceEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelJob{}, middleware.After)
}

func addOpCreateComputeEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateComputeEnvironment{}, middleware.After)
}

func addOpCreateConsumableResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateConsumableResource{}, middleware.After)
}

func addOpCreateJobQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateJobQueue{}, middleware.After)
}

func addOpCreateSchedulingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateSchedulingPolicy{}, middleware.After)
}

func addOpCreateServiceEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateServiceEnvironment{}, middleware.After)
}

func addOpDeleteComputeEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteComputeEnvironment{}, middleware.After)
}

func addOpDeleteConsumableResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConsumableResource{}, middleware.After)
}

func addOpDeleteJobQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteJobQueue{}, middleware.After)
}

func addOpDeleteSchedulingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSchedulingPolicy{}, middleware.After)
}

func addOpDeleteServiceEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteServiceEnvironment{}, middleware.After)
}

func addOpDeregisterJobDefinitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeregisterJobDefinition{}, middleware.After)
}

func addOpDescribeConsumableResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeConsumableResource{}, middleware.After)
}

func addOpDescribeJobsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeJobs{}, middleware.After)
}

func addOpDescribeSchedulingPoliciesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeSchedulingPolicies{}, middleware.After)
}

func addOpDescribeServiceJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeServiceJob{}, middleware.After)
}

func addOpGetJobQueueSnapshotValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetJobQueueSnapshot{}, middleware.After)
}

func addOpListJobsByConsumableResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListJobsByConsumableResource{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRegisterJobDefinitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterJobDefinition{}, middleware.After)
}

func addOpSubmitJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSubmitJob{}, middleware.After)
}

func addOpSubmitServiceJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSubmitServiceJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpTerminateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTerminateJob{}, middleware.After)
}

func addOpTerminateServiceJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTerminateServiceJob{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateComputeEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateComputeEnvironment{}, middleware.After)
}

func addOpUpdateConsumableResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConsumableResource{}, middleware.After)
}

func addOpUpdateJobQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateJobQueue{}, middleware.After)
}

func addOpUpdateSchedulingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateSchedulingPolicy{}, middleware.After)
}

func addOpUpdateServiceEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateServiceEnvironment{}, middleware.After)
}

func validateComputeEnvironmentOrder(v *types.ComputeEnvironmentOrder) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeEnvironmentOrder"}
	if v.Order == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Order"))
	}
	if v.ComputeEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeEnvironment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputeEnvironmentOrders(v []types.ComputeEnvironmentOrder) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeEnvironmentOrders"}
	for i := range v {
		if err := validateComputeEnvironmentOrder(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputeResource(v *types.ComputeResource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeResource"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.MaxvCpus == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxvCpus"))
	}
	if v.Subnets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subnets"))
	}
	if v.Ec2Configuration != nil {
		if err := validateEc2ConfigurationList(v.Ec2Configuration); err != nil {
			invalidParams.AddNested("Ec2Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputeResourceUpdate(v *types.ComputeResourceUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeResourceUpdate"}
	if v.Ec2Configuration != nil {
		if err := validateEc2ConfigurationList(v.Ec2Configuration); err != nil {
			invalidParams.AddNested("Ec2Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateContainerOverrides(v *types.ContainerOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ContainerOverrides"}
	if v.ResourceRequirements != nil {
		if err := validateResourceRequirements(v.ResourceRequirements); err != nil {
			invalidParams.AddNested("ResourceRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateContainerProperties(v *types.ContainerProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ContainerProperties"}
	if v.Volumes != nil {
		if err := validateVolumes(v.Volumes); err != nil {
			invalidParams.AddNested("Volumes", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ulimits != nil {
		if err := validateUlimits(v.Ulimits); err != nil {
			invalidParams.AddNested("Ulimits", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceRequirements != nil {
		if err := validateResourceRequirements(v.ResourceRequirements); err != nil {
			invalidParams.AddNested("ResourceRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if v.LinuxParameters != nil {
		if err := validateLinuxParameters(v.LinuxParameters); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.LogConfiguration != nil {
		if err := validateLogConfiguration(v.LogConfiguration); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Secrets != nil {
		if err := validateSecretList(v.Secrets); err != nil {
			invalidParams.AddNested("Secrets", err.(smithy.InvalidParamsError))
		}
	}
	if v.EphemeralStorage != nil {
		if err := validateEphemeralStorage(v.EphemeralStorage); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(smithy.InvalidParamsError))
		}
	}
	if v.RepositoryCredentials != nil {
		if err := validateRepositoryCredentials(v.RepositoryCredentials); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDevice(v *types.Device) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Device"}
	if v.HostPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HostPath"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDevicesList(v []types.Device) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DevicesList"}
	for i := range v {
		if err := validateDevice(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2Configuration(v *types.Ec2Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2Configuration"}
	if v.ImageType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2ConfigurationList(v []types.Ec2Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2ConfigurationList"}
	for i := range v {
		if err := validateEc2Configuration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcsProperties(v *types.EcsProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcsProperties"}
	if v.TaskProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaskProperties"))
	} else if v.TaskProperties != nil {
		if err := validateListEcsTaskProperties(v.TaskProperties); err != nil {
			invalidParams.AddNested("TaskProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcsPropertiesOverride(v *types.EcsPropertiesOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcsPropertiesOverride"}
	if v.TaskProperties != nil {
		if err := validateListTaskPropertiesOverride(v.TaskProperties); err != nil {
			invalidParams.AddNested("TaskProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcsTaskProperties(v *types.EcsTaskProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcsTaskProperties"}
	if v.Containers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Containers"))
	} else if v.Containers != nil {
		if err := validateListTaskContainerProperties(v.Containers); err != nil {
			invalidParams.AddNested("Containers", err.(smithy.InvalidParamsError))
		}
	}
	if v.EphemeralStorage != nil {
		if err := validateEphemeralStorage(v.EphemeralStorage); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(smithy.InvalidParamsError))
		}
	}
	if v.Volumes != nil {
		if err := validateVolumes(v.Volumes); err != nil {
			invalidParams.AddNested("Volumes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEFSVolumeConfiguration(v *types.EFSVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EFSVolumeConfiguration"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksConfiguration(v *types.EksConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksConfiguration"}
	if v.EksClusterArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EksClusterArn"))
	}
	if v.KubernetesNamespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KubernetesNamespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainer(v *types.EksContainer) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainer"}
	if v.Image == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Image"))
	}
	if v.Env != nil {
		if err := validateEksContainerEnvironmentVariables(v.Env); err != nil {
			invalidParams.AddNested("Env", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainerEnvironmentVariable(v *types.EksContainerEnvironmentVariable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainerEnvironmentVariable"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainerEnvironmentVariables(v []types.EksContainerEnvironmentVariable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainerEnvironmentVariables"}
	for i := range v {
		if err := validateEksContainerEnvironmentVariable(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainerOverride(v *types.EksContainerOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainerOverride"}
	if v.Env != nil {
		if err := validateEksContainerEnvironmentVariables(v.Env); err != nil {
			invalidParams.AddNested("Env", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainerOverrideList(v []types.EksContainerOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainerOverrideList"}
	for i := range v {
		if err := validateEksContainerOverride(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksContainers(v []types.EksContainer) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksContainers"}
	for i := range v {
		if err := validateEksContainer(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksPersistentVolumeClaim(v *types.EksPersistentVolumeClaim) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksPersistentVolumeClaim"}
	if v.ClaimName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClaimName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksPodProperties(v *types.EksPodProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksPodProperties"}
	if v.ImagePullSecrets != nil {
		if err := validateImagePullSecrets(v.ImagePullSecrets); err != nil {
			invalidParams.AddNested("ImagePullSecrets", err.(smithy.InvalidParamsError))
		}
	}
	if v.Containers != nil {
		if err := validateEksContainers(v.Containers); err != nil {
			invalidParams.AddNested("Containers", err.(smithy.InvalidParamsError))
		}
	}
	if v.InitContainers != nil {
		if err := validateEksContainers(v.InitContainers); err != nil {
			invalidParams.AddNested("InitContainers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Volumes != nil {
		if err := validateEksVolumes(v.Volumes); err != nil {
			invalidParams.AddNested("Volumes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksPodPropertiesOverride(v *types.EksPodPropertiesOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksPodPropertiesOverride"}
	if v.Containers != nil {
		if err := validateEksContainerOverrideList(v.Containers); err != nil {
			invalidParams.AddNested("Containers", err.(smithy.InvalidParamsError))
		}
	}
	if v.InitContainers != nil {
		if err := validateEksContainerOverrideList(v.InitContainers); err != nil {
			invalidParams.AddNested("InitContainers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksProperties(v *types.EksProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksProperties"}
	if v.PodProperties != nil {
		if err := validateEksPodProperties(v.PodProperties); err != nil {
			invalidParams.AddNested("PodProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksPropertiesOverride(v *types.EksPropertiesOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksPropertiesOverride"}
	if v.PodProperties != nil {
		if err := validateEksPodPropertiesOverride(v.PodProperties); err != nil {
			invalidParams.AddNested("PodProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksSecret(v *types.EksSecret) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksSecret"}
	if v.SecretName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksVolume(v *types.EksVolume) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksVolume"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Secret != nil {
		if err := validateEksSecret(v.Secret); err != nil {
			invalidParams.AddNested("Secret", err.(smithy.InvalidParamsError))
		}
	}
	if v.PersistentVolumeClaim != nil {
		if err := validateEksPersistentVolumeClaim(v.PersistentVolumeClaim); err != nil {
			invalidParams.AddNested("PersistentVolumeClaim", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksVolumes(v []types.EksVolume) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksVolumes"}
	for i := range v {
		if err := validateEksVolume(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEphemeralStorage(v *types.EphemeralStorage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EphemeralStorage"}
	if v.SizeInGiB == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SizeInGiB"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvaluateOnExit(v *types.EvaluateOnExit) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EvaluateOnExit"}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvaluateOnExitList(v []types.EvaluateOnExit) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EvaluateOnExitList"}
	for i := range v {
		if err := validateEvaluateOnExit(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFairsharePolicy(v *types.FairsharePolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FairsharePolicy"}
	if v.ShareDistribution != nil {
		if err := validateShareAttributesList(v.ShareDistribution); err != nil {
			invalidParams.AddNested("ShareDistribution", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFirelensConfiguration(v *types.FirelensConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FirelensConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImagePullSecret(v *types.ImagePullSecret) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImagePullSecret"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImagePullSecrets(v []types.ImagePullSecret) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImagePullSecrets"}
	for i := range v {
		if err := validateImagePullSecret(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobStateTimeLimitAction(v *types.JobStateTimeLimitAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobStateTimeLimitAction"}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if len(v.State) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("State"))
	}
	if v.MaxTimeSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxTimeSeconds"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobStateTimeLimitActions(v []types.JobStateTimeLimitAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobStateTimeLimitActions"}
	for i := range v {
		if err := validateJobStateTimeLimitAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLinuxParameters(v *types.LinuxParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LinuxParameters"}
	if v.Devices != nil {
		if err := validateDevicesList(v.Devices); err != nil {
			invalidParams.AddNested("Devices", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tmpfs != nil {
		if err := validateTmpfsList(v.Tmpfs); err != nil {
			invalidParams.AddNested("Tmpfs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListEcsTaskProperties(v []types.EcsTaskProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListEcsTaskProperties"}
	for i := range v {
		if err := validateEcsTaskProperties(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListTaskContainerOverrides(v []types.TaskContainerOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTaskContainerOverrides"}
	for i := range v {
		if err := validateTaskContainerOverrides(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListTaskContainerProperties(v []types.TaskContainerProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTaskContainerProperties"}
	for i := range v {
		if err := validateTaskContainerProperties(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListTaskPropertiesOverride(v []types.TaskPropertiesOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTaskPropertiesOverride"}
	for i := range v {
		if err := validateTaskPropertiesOverride(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogConfiguration(v *types.LogConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogConfiguration"}
	if len(v.LogDriver) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LogDriver"))
	}
	if v.SecretOptions != nil {
		if err := validateSecretList(v.SecretOptions); err != nil {
			invalidParams.AddNested("SecretOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodeOverrides(v *types.NodeOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodeOverrides"}
	if v.NodePropertyOverrides != nil {
		if err := validateNodePropertyOverrides(v.NodePropertyOverrides); err != nil {
			invalidParams.AddNested("NodePropertyOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodeProperties(v *types.NodeProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodeProperties"}
	if v.NumNodes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NumNodes"))
	}
	if v.MainNode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MainNode"))
	}
	if v.NodeRangeProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NodeRangeProperties"))
	} else if v.NodeRangeProperties != nil {
		if err := validateNodeRangeProperties(v.NodeRangeProperties); err != nil {
			invalidParams.AddNested("NodeRangeProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodePropertyOverride(v *types.NodePropertyOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodePropertyOverride"}
	if v.TargetNodes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetNodes"))
	}
	if v.ContainerOverrides != nil {
		if err := validateContainerOverrides(v.ContainerOverrides); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcsPropertiesOverride != nil {
		if err := validateEcsPropertiesOverride(v.EcsPropertiesOverride); err != nil {
			invalidParams.AddNested("EcsPropertiesOverride", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksPropertiesOverride != nil {
		if err := validateEksPropertiesOverride(v.EksPropertiesOverride); err != nil {
			invalidParams.AddNested("EksPropertiesOverride", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodePropertyOverrides(v []types.NodePropertyOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodePropertyOverrides"}
	for i := range v {
		if err := validateNodePropertyOverride(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodeRangeProperties(v []types.NodeRangeProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodeRangeProperties"}
	for i := range v {
		if err := validateNodeRangeProperty(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNodeRangeProperty(v *types.NodeRangeProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NodeRangeProperty"}
	if v.TargetNodes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetNodes"))
	}
	if v.Container != nil {
		if err := validateContainerProperties(v.Container); err != nil {
			invalidParams.AddNested("Container", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcsProperties != nil {
		if err := validateEcsProperties(v.EcsProperties); err != nil {
			invalidParams.AddNested("EcsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksProperties != nil {
		if err := validateEksProperties(v.EksProperties); err != nil {
			invalidParams.AddNested("EksProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRepositoryCredentials(v *types.RepositoryCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RepositoryCredentials"}
	if v.CredentialsParameter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CredentialsParameter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceRequirement(v *types.ResourceRequirement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceRequirement"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceRequirements(v []types.ResourceRequirement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceRequirements"}
	for i := range v {
		if err := validateResourceRequirement(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetryStrategy(v *types.RetryStrategy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetryStrategy"}
	if v.EvaluateOnExit != nil {
		if err := validateEvaluateOnExitList(v.EvaluateOnExit); err != nil {
			invalidParams.AddNested("EvaluateOnExit", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSecret(v *types.Secret) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Secret"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ValueFrom == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ValueFrom"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSecretList(v []types.Secret) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SecretList"}
	for i := range v {
		if err := validateSecret(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceEnvironmentOrder(v *types.ServiceEnvironmentOrder) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceEnvironmentOrder"}
	if v.Order == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Order"))
	}
	if v.ServiceEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceEnvironment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceEnvironmentOrders(v []types.ServiceEnvironmentOrder) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceEnvironmentOrders"}
	for i := range v {
		if err := validateServiceEnvironmentOrder(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceJobRetryStrategy(v *types.ServiceJobRetryStrategy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceJobRetryStrategy"}
	if v.Attempts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attempts"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateShareAttributes(v *types.ShareAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ShareAttributes"}
	if v.ShareIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ShareIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateShareAttributesList(v []types.ShareAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ShareAttributesList"}
	for i := range v {
		if err := validateShareAttributes(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaskContainerOverrides(v *types.TaskContainerOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaskContainerOverrides"}
	if v.ResourceRequirements != nil {
		if err := validateResourceRequirements(v.ResourceRequirements); err != nil {
			invalidParams.AddNested("ResourceRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaskContainerProperties(v *types.TaskContainerProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaskContainerProperties"}
	if v.FirelensConfiguration != nil {
		if err := validateFirelensConfiguration(v.FirelensConfiguration); err != nil {
			invalidParams.AddNested("FirelensConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Image == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Image"))
	}
	if v.LinuxParameters != nil {
		if err := validateLinuxParameters(v.LinuxParameters); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.LogConfiguration != nil {
		if err := validateLogConfiguration(v.LogConfiguration); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.RepositoryCredentials != nil {
		if err := validateRepositoryCredentials(v.RepositoryCredentials); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceRequirements != nil {
		if err := validateResourceRequirements(v.ResourceRequirements); err != nil {
			invalidParams.AddNested("ResourceRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if v.Secrets != nil {
		if err := validateSecretList(v.Secrets); err != nil {
			invalidParams.AddNested("Secrets", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ulimits != nil {
		if err := validateUlimits(v.Ulimits); err != nil {
			invalidParams.AddNested("Ulimits", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaskPropertiesOverride(v *types.TaskPropertiesOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaskPropertiesOverride"}
	if v.Containers != nil {
		if err := validateListTaskContainerOverrides(v.Containers); err != nil {
			invalidParams.AddNested("Containers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTmpfs(v *types.Tmpfs) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tmpfs"}
	if v.ContainerPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ContainerPath"))
	}
	if v.Size == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Size"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTmpfsList(v []types.Tmpfs) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TmpfsList"}
	for i := range v {
		if err := validateTmpfs(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUlimit(v *types.Ulimit) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ulimit"}
	if v.HardLimit == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HardLimit"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.SoftLimit == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SoftLimit"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUlimits(v []types.Ulimit) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ulimits"}
	for i := range v {
		if err := validateUlimit(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVolume(v *types.Volume) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Volume"}
	if v.EfsVolumeConfiguration != nil {
		if err := validateEFSVolumeConfiguration(v.EfsVolumeConfiguration); err != nil {
			invalidParams.AddNested("EfsVolumeConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVolumes(v []types.Volume) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Volumes"}
	for i := range v {
		if err := validateVolume(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelJobInput(v *CancelJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateComputeEnvironmentInput(v *CreateComputeEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateComputeEnvironmentInput"}
	if v.ComputeEnvironmentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeEnvironmentName"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ComputeResources != nil {
		if err := validateComputeResource(v.ComputeResources); err != nil {
			invalidParams.AddNested("ComputeResources", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksConfiguration != nil {
		if err := validateEksConfiguration(v.EksConfiguration); err != nil {
			invalidParams.AddNested("EksConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateConsumableResourceInput(v *CreateConsumableResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateConsumableResourceInput"}
	if v.ConsumableResourceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumableResourceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateJobQueueInput(v *CreateJobQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateJobQueueInput"}
	if v.JobQueueName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueueName"))
	}
	if v.Priority == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Priority"))
	}
	if v.ComputeEnvironmentOrder != nil {
		if err := validateComputeEnvironmentOrders(v.ComputeEnvironmentOrder); err != nil {
			invalidParams.AddNested("ComputeEnvironmentOrder", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceEnvironmentOrder != nil {
		if err := validateServiceEnvironmentOrders(v.ServiceEnvironmentOrder); err != nil {
			invalidParams.AddNested("ServiceEnvironmentOrder", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobStateTimeLimitActions != nil {
		if err := validateJobStateTimeLimitActions(v.JobStateTimeLimitActions); err != nil {
			invalidParams.AddNested("JobStateTimeLimitActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateSchedulingPolicyInput(v *CreateSchedulingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSchedulingPolicyInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.FairsharePolicy != nil {
		if err := validateFairsharePolicy(v.FairsharePolicy); err != nil {
			invalidParams.AddNested("FairsharePolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateServiceEnvironmentInput(v *CreateServiceEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateServiceEnvironmentInput"}
	if v.ServiceEnvironmentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceEnvironmentName"))
	}
	if len(v.ServiceEnvironmentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceEnvironmentType"))
	}
	if v.CapacityLimits == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CapacityLimits"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteComputeEnvironmentInput(v *DeleteComputeEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteComputeEnvironmentInput"}
	if v.ComputeEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeEnvironment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConsumableResourceInput(v *DeleteConsumableResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConsumableResourceInput"}
	if v.ConsumableResource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumableResource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteJobQueueInput(v *DeleteJobQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteJobQueueInput"}
	if v.JobQueue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSchedulingPolicyInput(v *DeleteSchedulingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSchedulingPolicyInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteServiceEnvironmentInput(v *DeleteServiceEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteServiceEnvironmentInput"}
	if v.ServiceEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceEnvironment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeregisterJobDefinitionInput(v *DeregisterJobDefinitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeregisterJobDefinitionInput"}
	if v.JobDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobDefinition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeConsumableResourceInput(v *DescribeConsumableResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeConsumableResourceInput"}
	if v.ConsumableResource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumableResource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeJobsInput(v *DescribeJobsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeJobsInput"}
	if v.Jobs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Jobs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeSchedulingPoliciesInput(v *DescribeSchedulingPoliciesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeSchedulingPoliciesInput"}
	if v.Arns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeServiceJobInput(v *DescribeServiceJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeServiceJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetJobQueueSnapshotInput(v *GetJobQueueSnapshotInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetJobQueueSnapshotInput"}
	if v.JobQueue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListJobsByConsumableResourceInput(v *ListJobsByConsumableResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListJobsByConsumableResourceInput"}
	if v.ConsumableResource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumableResource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterJobDefinitionInput(v *RegisterJobDefinitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterJobDefinitionInput"}
	if v.JobDefinitionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobDefinitionName"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ContainerProperties != nil {
		if err := validateContainerProperties(v.ContainerProperties); err != nil {
			invalidParams.AddNested("ContainerProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.NodeProperties != nil {
		if err := validateNodeProperties(v.NodeProperties); err != nil {
			invalidParams.AddNested("NodeProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetryStrategy != nil {
		if err := validateRetryStrategy(v.RetryStrategy); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksProperties != nil {
		if err := validateEksProperties(v.EksProperties); err != nil {
			invalidParams.AddNested("EksProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcsProperties != nil {
		if err := validateEcsProperties(v.EcsProperties); err != nil {
			invalidParams.AddNested("EcsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSubmitJobInput(v *SubmitJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubmitJobInput"}
	if v.JobName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobName"))
	}
	if v.JobQueue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueue"))
	}
	if v.JobDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobDefinition"))
	}
	if v.ContainerOverrides != nil {
		if err := validateContainerOverrides(v.ContainerOverrides); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.NodeOverrides != nil {
		if err := validateNodeOverrides(v.NodeOverrides); err != nil {
			invalidParams.AddNested("NodeOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetryStrategy != nil {
		if err := validateRetryStrategy(v.RetryStrategy); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksPropertiesOverride != nil {
		if err := validateEksPropertiesOverride(v.EksPropertiesOverride); err != nil {
			invalidParams.AddNested("EksPropertiesOverride", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcsPropertiesOverride != nil {
		if err := validateEcsPropertiesOverride(v.EcsPropertiesOverride); err != nil {
			invalidParams.AddNested("EcsPropertiesOverride", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSubmitServiceJobInput(v *SubmitServiceJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubmitServiceJobInput"}
	if v.JobName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobName"))
	}
	if v.JobQueue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueue"))
	}
	if v.RetryStrategy != nil {
		if err := validateServiceJobRetryStrategy(v.RetryStrategy); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceRequestPayload == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceRequestPayload"))
	}
	if len(v.ServiceJobType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceJobType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTerminateJobInput(v *TerminateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TerminateJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTerminateServiceJobInput(v *TerminateServiceJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TerminateServiceJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateComputeEnvironmentInput(v *UpdateComputeEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateComputeEnvironmentInput"}
	if v.ComputeEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeEnvironment"))
	}
	if v.ComputeResources != nil {
		if err := validateComputeResourceUpdate(v.ComputeResources); err != nil {
			invalidParams.AddNested("ComputeResources", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConsumableResourceInput(v *UpdateConsumableResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConsumableResourceInput"}
	if v.ConsumableResource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumableResource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateJobQueueInput(v *UpdateJobQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateJobQueueInput"}
	if v.JobQueue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobQueue"))
	}
	if v.ComputeEnvironmentOrder != nil {
		if err := validateComputeEnvironmentOrders(v.ComputeEnvironmentOrder); err != nil {
			invalidParams.AddNested("ComputeEnvironmentOrder", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceEnvironmentOrder != nil {
		if err := validateServiceEnvironmentOrders(v.ServiceEnvironmentOrder); err != nil {
			invalidParams.AddNested("ServiceEnvironmentOrder", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobStateTimeLimitActions != nil {
		if err := validateJobStateTimeLimitActions(v.JobStateTimeLimitActions); err != nil {
			invalidParams.AddNested("JobStateTimeLimitActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateSchedulingPolicyInput(v *UpdateSchedulingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSchedulingPolicyInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.FairsharePolicy != nil {
		if err := validateFairsharePolicy(v.FairsharePolicy); err != nil {
			invalidParams.AddNested("FairsharePolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateServiceEnvironmentInput(v *UpdateServiceEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateServiceEnvironmentInput"}
	if v.ServiceEnvironment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceEnvironment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
