// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure that contains advanced options for EDI processing. Currently, only
// X12 advanced options are supported.
type AdvancedOptions struct {

	// A structure that contains X12-specific advanced options, such as split options
	// for processing X12 EDI files.
	X12 *X12AdvancedOptions

	noSmithyDocumentSerde
}

// A capability object. Currently, only EDI (electronic data interchange)
// capabilities are supported. A trading capability contains the information
// required to transform incoming EDI documents into JSON or XML outputs.
//
// The following types satisfy this interface:
//
//	CapabilityConfigurationMemberEdi
type CapabilityConfiguration interface {
	isCapabilityConfiguration()
}

// An EDI (electronic data interchange) configuration object.
type CapabilityConfigurationMemberEdi struct {
	Value EdiConfiguration

	noSmithyDocumentSerde
}

func (*CapabilityConfigurationMemberEdi) isCapabilityConfiguration() {}

// Contains the details for an Outbound EDI capability.
type CapabilityOptions struct {

	// A structure that contains the inbound EDI options for the capability.
	InboundEdi *InboundEdiOptions

	// A structure that contains the outbound EDI options.
	OutboundEdi OutboundEdiOptions

	noSmithyDocumentSerde
}

// Returns the capability summary details. A trading capability contains the
// information required to transform incoming EDI documents into JSON or XML
// outputs.
type CapabilitySummary struct {

	// Returns a system-assigned unique identifier for the capability.
	//
	// This member is required.
	CapabilityId *string

	// Returns a timestamp for creation date and time of the capability.
	//
	// This member is required.
	CreatedAt *time.Time

	// The display name of the capability.
	//
	// This member is required.
	Name *string

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// This member is required.
	Type CapabilityType

	// Returns a timestamp that identifies the most recent date and time that the
	// capability was modified.
	ModifiedAt *time.Time

	noSmithyDocumentSerde
}

// Describes the input for an outbound transformation.
type ConversionSource struct {

	// The format for the input file: either JSON or XML.
	//
	// This member is required.
	FileFormat ConversionSourceFormat

	// File to be converted
	//
	// This member is required.
	InputFile InputFileSource

	noSmithyDocumentSerde
}

// Provide a sample of what the output of the transformation should look like.
type ConversionTarget struct {

	// Currently, only X12 format is supported.
	//
	// This member is required.
	FileFormat ConversionTargetFormat

	// A structure that contains advanced options for EDI processing. Currently, only
	// X12 advanced options are supported.
	AdvancedOptions *AdvancedOptions

	// A structure that contains the formatting details for the conversion target.
	FormatDetails ConversionTargetFormatDetails

	// Customer uses this to provide a sample on what should file look like after
	// conversion X12 EDI use case around this would be discovering the file syntax
	OutputSampleFile OutputSampleFileSource

	noSmithyDocumentSerde
}

// Contains a structure describing the X12 details for the conversion target.
//
// The following types satisfy this interface:
//
//	ConversionTargetFormatDetailsMemberX12
type ConversionTargetFormatDetails interface {
	isConversionTargetFormatDetails()
}

// A structure that contains the X12 transaction set and version. The X12
// structure is used when the system transforms an EDI (electronic data
// interchange) file.
//
// If an EDI input file contains more than one transaction, each transaction must
// have the same transaction set and version, for example 214/4010. If not, the
// transformer cannot parse the file.
type ConversionTargetFormatDetailsMemberX12 struct {
	Value X12Details

	noSmithyDocumentSerde
}

func (*ConversionTargetFormatDetailsMemberX12) isConversionTargetFormatDetails() {}

// Specifies the details for the EDI (electronic data interchange) transformation.
type EdiConfiguration struct {

	// Contains the Amazon S3 bucket and prefix for the location of the input file,
	// which is contained in an S3Location object.
	//
	// This member is required.
	InputLocation *S3Location

	// Contains the Amazon S3 bucket and prefix for the location of the output file,
	// which is contained in an S3Location object.
	//
	// This member is required.
	OutputLocation *S3Location

	// Returns the system-assigned unique identifier for the transformer.
	//
	// This member is required.
	TransformerId *string

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// This member is required.
	Type EdiType

	// Specifies whether this is capability is for inbound or outbound transformations.
	CapabilityDirection CapabilityDirection

	noSmithyDocumentSerde
}

// Specifies the details for the EDI standard that is being used for the
// transformer. Currently, only X12 is supported. X12 is a set of standards and
// corresponding messages that define specific business documents.
//
// The following types satisfy this interface:
//
//	EdiTypeMemberX12Details
type EdiType interface {
	isEdiType()
}

// Returns the details for the EDI standard that is being used for the
// transformer. Currently, only X12 is supported. X12 is a set of standards and
// corresponding messages that define specific business documents.
type EdiTypeMemberX12Details struct {
	Value X12Details

	noSmithyDocumentSerde
}

func (*EdiTypeMemberX12Details) isEdiType() {}

// A structure that contains the X12 transaction set and version.
//
// The following types satisfy this interface:
//
//	FormatOptionsMemberX12
type FormatOptions interface {
	isFormatOptions()
}

// A structure that contains the X12 transaction set and version. The X12
// structure is used when the system transforms an EDI (electronic data
// interchange) file.
//
// If an EDI input file contains more than one transaction, each transaction must
// have the same transaction set and version, for example 214/4010. If not, the
// transformer cannot parse the file.
type FormatOptionsMemberX12 struct {
	Value X12Details

	noSmithyDocumentSerde
}

func (*FormatOptionsMemberX12) isFormatOptions() {}

// Contains options for processing inbound EDI files. These options allow for
// customizing how incoming EDI documents are processed.
type InboundEdiOptions struct {

	// A structure that contains X12-specific options for processing inbound X12 EDI
	// files.
	X12 *X12InboundEdiOptions

	noSmithyDocumentSerde
}

// Contains the input formatting options for an inbound transformer (takes an
// X12-formatted EDI document as input and converts it to JSON or XML.
type InputConversion struct {

	// The format for the transformer input: currently on X12 is supported.
	//
	// This member is required.
	FromFormat FromFormat

	// Specifies advanced options for the input conversion process. These options
	// provide additional control over how EDI files are processed during
	// transformation.
	AdvancedOptions *AdvancedOptions

	// A structure that contains the formatting options for an inbound transformer.
	FormatOptions FormatOptions

	noSmithyDocumentSerde
}

// The input file to use for an outbound transformation.
//
// The following types satisfy this interface:
//
//	InputFileSourceMemberFileContent
type InputFileSource interface {
	isInputFileSource()
}

// Specify the input contents, as a string, for the source of an outbound
// transformation.
type InputFileSourceMemberFileContent struct {
	Value string

	noSmithyDocumentSerde
}

func (*InputFileSourceMemberFileContent) isInputFileSource() {}

// Specifies the mapping template for the transformer. This template is used to
// map the parsed EDI file using JSONata or XSLT.
type Mapping struct {

	// The transformation language for the template, either XSLT or JSONATA.
	//
	// This member is required.
	TemplateLanguage MappingTemplateLanguage

	// A string that represents the mapping template, in the transformation language
	// specified in templateLanguage .
	Template *string

	noSmithyDocumentSerde
}

// A container for outbound EDI options.
//
// The following types satisfy this interface:
//
//	OutboundEdiOptionsMemberX12
type OutboundEdiOptions interface {
	isOutboundEdiOptions()
}

// A structure that contains an X12 envelope structure.
type OutboundEdiOptionsMemberX12 struct {
	Value X12Envelope

	noSmithyDocumentSerde
}

func (*OutboundEdiOptionsMemberX12) isOutboundEdiOptions() {}

// Contains the formatting options for an outbound transformer (takes JSON or XML
// as input and converts it to an EDI document (currently only X12 format is
// supported).
type OutputConversion struct {

	// The format for the output from an outbound transformer: only X12 is currently
	// supported.
	//
	// This member is required.
	ToFormat ToFormat

	// A structure that contains advanced options for EDI processing. Currently, only
	// X12 advanced options are supported.
	AdvancedOptions *AdvancedOptions

	// A structure that contains the X12 transaction set and version for the
	// transformer output.
	FormatOptions FormatOptions

	noSmithyDocumentSerde
}

// Container for the location of a sample file used for outbound transformations.
//
// The following types satisfy this interface:
//
//	OutputSampleFileSourceMemberFileLocation
type OutputSampleFileSource interface {
	isOutputSampleFileSource()
}

// Specifies the details for the Amazon S3 file location that is being used with
// Amazon Web Services B2B Data Interchange. File locations in Amazon S3 are
// identified using a combination of the bucket and key.
type OutputSampleFileSourceMemberFileLocation struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*OutputSampleFileSourceMemberFileLocation) isOutputSampleFileSource() {}

// A structure that contains the details for a partnership. A partnership
// represents the connection between you and your trading partner. It ties together
// a profile and one or more trading capabilities.
type PartnershipSummary struct {

	// Returns a timestamp for creation date and time of the partnership.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the unique, system-generated identifier for a partnership.
	//
	// This member is required.
	PartnershipId *string

	// Returns the unique, system-generated identifier for the profile connected to
	// this partnership.
	//
	// This member is required.
	ProfileId *string

	// Returns one or more capabilities associated with this partnership.
	Capabilities []string

	// Contains the details for an Outbound EDI capability.
	CapabilityOptions *CapabilityOptions

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time

	// Returns the name of the partnership.
	Name *string

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string

	noSmithyDocumentSerde
}

// Contains the details for a profile. A profile is the mechanism used to create
// the concept of a private network.
type ProfileSummary struct {

	// Returns the name for the business associated with this profile.
	//
	// This member is required.
	BusinessName *string

	// Returns the timestamp for creation date and time of the profile.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the display name for profile.
	//
	// This member is required.
	Name *string

	// Returns the unique, system-generated identifier for the profile.
	//
	// This member is required.
	ProfileId *string

	// Returns the name of the logging group.
	LogGroupName *string

	// Specifies whether or not logging is enabled for this profile.
	Logging Logging

	// Returns the timestamp that identifies the most recent date and time that the
	// profile was modified.
	ModifiedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the details for the Amazon S3 file location that is being used with
// Amazon Web Services B2B Data Interchange. File locations in Amazon S3 are
// identified using a combination of the bucket and key.
type S3Location struct {

	// Specifies the name of the Amazon S3 bucket.
	BucketName *string

	// Specifies the Amazon S3 key for the file location.
	Key *string

	noSmithyDocumentSerde
}

// An array of the Amazon S3 keys used to identify the location for your sample
// documents.
type SampleDocumentKeys struct {

	// An array of keys for your input sample documents.
	Input *string

	// An array of keys for your output sample documents.
	Output *string

	noSmithyDocumentSerde
}

// Describes a structure that contains the Amazon S3 bucket and an array of the
// corresponding keys used to identify the location for your sample documents.
type SampleDocuments struct {

	// Contains the Amazon S3 bucket that is used to hold your sample documents.
	//
	// This member is required.
	BucketName *string

	// Contains an array of the Amazon S3 keys used to identify the location for your
	// sample documents.
	//
	// This member is required.
	Keys []SampleDocumentKeys

	noSmithyDocumentSerde
}

// Creates a key-value pair for a specific resource. Tags are metadata that you
// can use to search for and group a resource for various purposes. You can apply
// tags to capabilities, partnerships, profiles and transformers. A tag key can
// take more than one value. For example, to group capabilities for accounting
// purposes, you might create a tag called Group and assign the values Research
// and Accounting to that group.
type Tag struct {

	// Specifies the name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// Contains one or more values that you assigned to the key name that you create.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A data structure that contains the information to use when generating a mapping
// template.
//
// The following types satisfy this interface:
//
//	TemplateDetailsMemberX12
type TemplateDetails interface {
	isTemplateDetails()
}

// A structure that contains the X12 transaction set and version. The X12
// structure is used when the system transforms an EDI (electronic data
// interchange) file.
//
// If an EDI input file contains more than one transaction, each transaction must
// have the same transaction set and version, for example 214/4010. If not, the
// transformer cannot parse the file.
type TemplateDetailsMemberX12 struct {
	Value X12Details

	noSmithyDocumentSerde
}

func (*TemplateDetailsMemberX12) isTemplateDetails() {}

// Contains the details for a transformer object. A transformer can take an EDI
// file as input and transform it into a JSON-or XML-formatted document.
// Alternatively, a transformer can take a JSON-or XML-formatted document as input
// and transform it into an EDI file.
type TransformerSummary struct {

	// Returns a timestamp indicating when the transformer was created. For example,
	// 2023-07-20T19:58:44.624Z .
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns the descriptive name for the transformer.
	//
	// This member is required.
	Name *string

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive . For the transformer to be used in a capability, its
	// status must active .
	//
	// This member is required.
	Status TransformerStatus

	// Returns the system-assigned unique identifier for the transformer.
	//
	// This member is required.
	TransformerId *string

	// Returns the details for the EDI standard that is being used for the
	// transformer. Currently, only X12 is supported. X12 is a set of standards and
	// corresponding messages that define specific business documents.
	//
	// Deprecated: This is a legacy trait. Please use input-conversion or
	// output-conversion.
	EdiType EdiType

	// Returns that the currently supported file formats for EDI transformations are
	// JSON and XML .
	//
	// Deprecated: This is a legacy trait. Please use input-conversion or
	// output-conversion.
	FileFormat FileFormat

	// Returns a structure that contains the format options for the transformation.
	InputConversion *InputConversion

	// Returns the structure that contains the mapping template and its language
	// (either XSLT or JSONATA).
	Mapping *Mapping

	// Returns the mapping template for the transformer. This template is used to map
	// the parsed EDI file using JSONata or XSLT.
	//
	// Deprecated: This is a legacy trait. Please use input-conversion or
	// output-conversion.
	MappingTemplate *string

	// Returns a timestamp representing the date and time for the most recent change
	// for the transformer object.
	ModifiedAt *time.Time

	// Returns the OutputConversion object, which contains the format options for the
	// outbound transformation.
	OutputConversion *OutputConversion

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	//
	// Deprecated: This is a legacy trait. Please use input-conversion or
	// output-conversion.
	SampleDocument *string

	// Returns a structure that contains the Amazon S3 bucket and an array of the
	// corresponding keys used to identify the location for your sample documents.
	SampleDocuments *SampleDocuments

	noSmithyDocumentSerde
}

// Contains options for wrapping (line folding) in X12 EDI files. Wrapping
// controls how long lines are handled in the EDI output.
type WrapOptions struct {

	// Specifies the method used for wrapping lines in the EDI output. Valid values:
	//
	//   - SEGMENT : Wraps by segment.
	//
	//   - ONE_LINE : Indicates that the entire content is on a single line.
	//
	// When you specify ONE_LINE , do not provide either the line length nor the line
	//   terminator value.
	//
	//   - LINE_LENGTH : Wraps by character count, as specified by lineLength value.
	//
	// This member is required.
	WrapBy WrapFormat

	// Specifies the maximum length of a line before wrapping occurs. This value is
	// used when wrapBy is set to LINE_LENGTH .
	LineLength *int32

	// Specifies the character sequence used to terminate lines when wrapping. Valid
	// values:
	//
	//   - CRLF : carriage return and line feed
	//
	//   - LF : line feed)
	//
	//   - CR : carriage return
	LineTerminator LineTerminator

	noSmithyDocumentSerde
}

// Contains options for configuring X12 acknowledgments. These options control how
// functional and technical acknowledgments are handled.
type X12AcknowledgmentOptions struct {

	// Specifies whether functional acknowledgments (997/999) should be generated for
	// incoming X12 transactions. Valid values are DO_NOT_GENERATE ,
	// GENERATE_ALL_SEGMENTS and GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP .
	//
	// If you choose GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP , Amazon Web
	// Services B2B Data Interchange skips the AK2_Loop when generating an
	// acknowledgment document.
	//
	// This member is required.
	FunctionalAcknowledgment X12FunctionalAcknowledgment

	// Specifies whether technical acknowledgments (TA1) should be generated for
	// incoming X12 interchanges. Valid values are DO_NOT_GENERATE and
	// GENERATE_ALL_SEGMENTS and.
	//
	// This member is required.
	TechnicalAcknowledgment X12TechnicalAcknowledgment

	noSmithyDocumentSerde
}

// Contains advanced options specific to X12 EDI processing, such as splitting
// large X12 files into smaller units.
type X12AdvancedOptions struct {

	// Specifies options for splitting X12 EDI files. These options control how large
	// X12 files are divided into smaller, more manageable units.
	SplitOptions *X12SplitOptions

	// Specifies validation options for X12 EDI processing. These options control how
	// validation rules are applied during EDI document processing, including custom
	// validation rules for element length constraints, code list validations, and
	// element requirement checks.
	ValidationOptions *X12ValidationOptions

	noSmithyDocumentSerde
}

// Defines a validation rule that modifies the allowed code values for a specific
// X12 element. This rule allows you to add or remove valid codes from an element's
// standard code list, providing flexibility to accommodate trading
// partner-specific requirements or industry variations. You can specify codes to
// add to expand the allowed values beyond the X12 standard, or codes to remove to
// restrict the allowed values for stricter validation.
type X12CodeListValidationRule struct {

	// Specifies the four-digit element ID to which the code list modifications apply.
	// This identifies which X12 element will have its allowed code values modified.
	//
	// This member is required.
	ElementId *string

	// Specifies a list of code values to add to the element's allowed values. These
	// codes will be considered valid for the specified element in addition to the
	// standard codes defined by the X12 specification.
	CodesToAdd []string

	// Specifies a list of code values to remove from the element's allowed values.
	// These codes will be considered invalid for the specified element, even if they
	// are part of the standard codes defined by the X12 specification.
	CodesToRemove []string

	noSmithyDocumentSerde
}

// Contains configuration for X12 control numbers used in X12 EDI generation.
// Control numbers are used to uniquely identify interchanges, functional groups,
// and transaction sets.
type X12ControlNumbers struct {

	// Specifies the starting functional group control number (GS06) to use for X12
	// EDI generation. This number is incremented for each new functional group. For
	// the GS (functional group) envelope, Amazon Web Services B2B Data Interchange
	// generates a functional group control number that is unique to the sender ID,
	// receiver ID, and functional identifier code combination.
	StartingFunctionalGroupControlNumber *int32

	// Specifies the starting interchange control number (ISA13) to use for X12 EDI
	// generation. This number is incremented for each new interchange. For the ISA
	// (interchange) envelope, Amazon Web Services B2B Data Interchange generates an
	// interchange control number that is unique for the ISA05 and ISA06 (sender) &
	// ISA07 and ISA08 (receiver) combination.
	StartingInterchangeControlNumber *int32

	// Specifies the starting transaction set control number (ST02) to use for X12 EDI
	// generation. This number is incremented for each new transaction set.
	StartingTransactionSetControlNumber *int32

	noSmithyDocumentSerde
}

// In X12 EDI messages, delimiters are used to mark the end of segments or
// elements, and are defined in the interchange control header. The delimiters are
// part of the message's syntax and divide up its different elements.
type X12Delimiters struct {

	// The component, or sub-element, separator. The default value is : (colon).
	ComponentSeparator *string

	// The data element separator. The default value is * (asterisk).
	DataElementSeparator *string

	// The segment terminator. The default value is ~ (tilde).
	SegmentTerminator *string

	noSmithyDocumentSerde
}

// A structure that contains the X12 transaction set and version. The X12
// structure is used when the system transforms an EDI (electronic data
// interchange) file.
//
// If an EDI input file contains more than one transaction, each transaction must
// have the same transaction set and version, for example 214/4010. If not, the
// transformer cannot parse the file.
type X12Details struct {

	// Returns an enumerated type where each value identifies an X12 transaction set.
	// Transaction sets are maintained by the X12 Accredited Standards Committee.
	TransactionSet X12TransactionSet

	// Returns the version to use for the specified X12 transaction set.
	Version X12Version

	noSmithyDocumentSerde
}

// Defines a validation rule that specifies custom length constraints for a
// specific X12 element. This rule allows you to override the standard minimum and
// maximum length requirements for an element, enabling validation of trading
// partner-specific length requirements that may differ from the X12 specification.
// Both minimum and maximum length values must be specified and must be between 1
// and 200 characters.
type X12ElementLengthValidationRule struct {

	// Specifies the four-digit element ID to which the length constraints will be
	// applied. This identifies which X12 element will have its length requirements
	// modified.
	//
	// This member is required.
	ElementId *string

	// Specifies the maximum allowed length for the identified element. This value
	// must be between 1 and 200 characters and defines the upper limit for the
	// element's content length.
	//
	// This member is required.
	MaxLength *int32

	// Specifies the minimum required length for the identified element. This value
	// must be between 1 and 200 characters and defines the lower limit for the
	// element's content length.
	//
	// This member is required.
	MinLength *int32

	noSmithyDocumentSerde
}

// Defines a validation rule that modifies the requirement status of a specific
// X12 element within a segment. This rule allows you to make optional elements
// mandatory or mandatory elements optional, providing flexibility to accommodate
// different trading partner requirements and business rules. The rule targets a
// specific element position within a segment and sets its requirement status to
// either OPTIONAL or MANDATORY.
type X12ElementRequirementValidationRule struct {

	// Specifies the position of the element within an X12 segment for which the
	// requirement status will be modified. The format follows the pattern of segment
	// identifier followed by element position (e.g., "ST-01" for the first element of
	// the ST segment).
	//
	// This member is required.
	ElementPosition *string

	// Specifies the requirement status for the element at the specified position.
	// Valid values are OPTIONAL (the element may be omitted) or MANDATORY (the element
	// must be present).
	//
	// This member is required.
	Requirement ElementRequirement

	noSmithyDocumentSerde
}

// A wrapper structure for an X12 definition object.
//
// the X12 envelope ensures the integrity of the data and the efficiency of the
// information exchange. The X12 message structure has hierarchical levels. From
// highest to the lowest, they are:
//
//   - Interchange Envelope
//
//   - Functional Group
//
//   - Transaction Set
type X12Envelope struct {

	// A container for the X12 outbound EDI headers.
	Common *X12OutboundEdiHeaders

	// Contains options for wrapping (line folding) in X12 EDI files. Wrapping
	// controls how long lines are handled in the EDI output.
	WrapOptions *WrapOptions

	noSmithyDocumentSerde
}

// Part of the X12 message structure. These are the functional group headers for
// the X12 EDI object.
type X12FunctionalGroupHeaders struct {

	// A value representing the code used to identify the party receiving a message,
	// at position GS-03.
	ApplicationReceiverCode *string

	// A value representing the code used to identify the party transmitting a
	// message, at position GS-02.
	ApplicationSenderCode *string

	// A code that identifies the issuer of the standard, at position GS-07.
	ResponsibleAgencyCode *string

	noSmithyDocumentSerde
}

// Contains options specific to processing inbound X12 EDI files.
type X12InboundEdiOptions struct {

	// Specifies acknowledgment options for inbound X12 EDI files. These options
	// control how functional and technical acknowledgments are handled.
	AcknowledgmentOptions *X12AcknowledgmentOptions

	noSmithyDocumentSerde
}

// In X12, the Interchange Control Header is the first segment of an EDI document
// and is part of the Interchange Envelope. It contains information about the
// sender and receiver, the date and time of transmission, and the X12 version
// being used. It also includes delivery information, such as the sender and
// receiver IDs.
type X12InterchangeControlHeaders struct {

	// Located at position ISA-14 in the header. The value "1" indicates that the
	// sender is requesting an interchange acknowledgment at receipt of the
	// interchange. The value "0" is used otherwise.
	AcknowledgmentRequestedCode *string

	// Located at position ISA-08 in the header. This value (along with the
	// receiverIdQualifier ) identifies the intended recipient of the interchange.
	ReceiverId *string

	// Located at position ISA-07 in the header. Qualifier for the receiver ID.
	// Together, the ID and qualifier uniquely identify the receiving trading partner.
	ReceiverIdQualifier *string

	// Located at position ISA-11 in the header. This string makes it easier when you
	// need to group similar adjacent element values together without using extra
	// segments.
	//
	// This parameter is only honored for version greater than 401 ( VERSION_4010 and
	// higher).
	//
	// For versions less than 401, this field is called [StandardsId], in which case our service
	// sets the value to U .
	//
	// [StandardsId]: https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11
	RepetitionSeparator *string

	// Located at position ISA-06 in the header. This value (along with the
	// senderIdQualifier ) identifies the sender of the interchange.
	SenderId *string

	// Located at position ISA-05 in the header. Qualifier for the sender ID.
	// Together, the ID and qualifier uniquely identify the sending trading partner.
	SenderIdQualifier *string

	// Located at position ISA-15 in the header. Specifies how this interchange is
	// being used:
	//
	//   - T indicates this interchange is for testing.
	//
	//   - P indicates this interchange is for production.
	//
	//   - I indicates this interchange is informational.
	UsageIndicatorCode *string

	noSmithyDocumentSerde
}

// A structure containing the details for an outbound EDI object.
type X12OutboundEdiHeaders struct {

	// Specifies control number configuration for outbound X12 EDI headers. These
	// settings determine the starting values for interchange, functional group, and
	// transaction set control numbers.
	ControlNumbers *X12ControlNumbers

	// The delimiters, for example semicolon ( ; ), that separates sections of the
	// headers for the X12 object.
	Delimiters *X12Delimiters

	// The functional group headers for the X12 object.
	FunctionalGroupHeaders *X12FunctionalGroupHeaders

	// Specifies the time format in the GS05 element (time) of the functional group
	// header. The following formats use 24-hour clock time:
	//
	//   - HHMM - Hours and minutes
	//
	//   - HHMMSS - Hours, minutes, and seconds
	//
	//   - HHMMSSDD - Hours, minutes, seconds, and decimal seconds
	//
	// Where:
	//
	//   - HH - Hours (00-23)
	//
	//   - MM - Minutes (00-59)
	//
	//   - SS - Seconds (00-59)
	//
	//   - DD - Hundredths of seconds (00-99)
	Gs05TimeFormat X12GS05TimeFormat

	// In X12 EDI messages, delimiters are used to mark the end of segments or
	// elements, and are defined in the interchange control header.
	InterchangeControlHeaders *X12InterchangeControlHeaders

	// Specifies whether or not to validate the EDI for this X12 object: TRUE or FALSE
	// . When enabled, this performs both standard EDI validation and applies any
	// configured custom validation rules including element length constraints, code
	// list validations, and element requirement checks. Validation results are
	// returned in the response validation messages.
	ValidateEdi *bool

	noSmithyDocumentSerde
}

// Contains options for splitting X12 EDI files into smaller units. This is useful
// for processing large EDI files more efficiently.
type X12SplitOptions struct {

	// Specifies the method used to split X12 EDI files. Valid values include
	// TRANSACTION (split by individual transaction sets), or NONE (no splitting).
	//
	// This member is required.
	SplitBy X12SplitBy

	noSmithyDocumentSerde
}

// Contains configuration options for X12 EDI validation. This structure allows
// you to specify custom validation rules that will be applied during EDI document
// processing, including element length constraints, code list modifications, and
// element requirement changes. These validation options provide flexibility to
// accommodate trading partner-specific requirements while maintaining EDI
// compliance. The validation rules are applied in addition to standard X12
// validation to ensure documents meet both standard and custom requirements.
type X12ValidationOptions struct {

	// Specifies a list of validation rules to apply during EDI document processing.
	// These rules can include code list modifications, element length constraints, and
	// element requirement changes.
	ValidationRules []X12ValidationRule

	noSmithyDocumentSerde
}

// Represents a single validation rule that can be applied during X12 EDI
// processing. This is a union type that can contain one of several specific
// validation rule types: code list validation rules for modifying allowed element
// codes, element length validation rules for enforcing custom length constraints,
// or element requirement validation rules for changing mandatory/optional status.
// Each validation rule targets specific aspects of EDI document validation to
// ensure compliance with trading partner requirements and business rules.
//
// The following types satisfy this interface:
//
//	X12ValidationRuleMemberCodeListValidationRule
//	X12ValidationRuleMemberElementLengthValidationRule
//	X12ValidationRuleMemberElementRequirementValidationRule
type X12ValidationRule interface {
	isX12ValidationRule()
}

// Specifies a code list validation rule that modifies the allowed code values for
// a specific X12 element. This rule enables you to customize which codes are
// considered valid for an element, allowing for trading partner-specific code
// requirements.
type X12ValidationRuleMemberCodeListValidationRule struct {
	Value X12CodeListValidationRule

	noSmithyDocumentSerde
}

func (*X12ValidationRuleMemberCodeListValidationRule) isX12ValidationRule() {}

// Specifies an element length validation rule that defines custom length
// constraints for a specific X12 element. This rule allows you to enforce minimum
// and maximum length requirements that may differ from the standard X12
// specification.
type X12ValidationRuleMemberElementLengthValidationRule struct {
	Value X12ElementLengthValidationRule

	noSmithyDocumentSerde
}

func (*X12ValidationRuleMemberElementLengthValidationRule) isX12ValidationRule() {}

// Specifies an element requirement validation rule that modifies whether a
// specific X12 element is required or optional within a segment. This rule
// provides flexibility to accommodate different trading partner requirements for
// element presence.
type X12ValidationRuleMemberElementRequirementValidationRule struct {
	Value X12ElementRequirementValidationRule

	noSmithyDocumentSerde
}

func (*X12ValidationRuleMemberElementRequirementValidationRule) isX12ValidationRule() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCapabilityConfiguration()       {}
func (*UnknownUnionMember) isConversionTargetFormatDetails() {}
func (*UnknownUnionMember) isEdiType()                       {}
func (*UnknownUnionMember) isFormatOptions()                 {}
func (*UnknownUnionMember) isInputFileSource()               {}
func (*UnknownUnionMember) isOutboundEdiOptions()            {}
func (*UnknownUnionMember) isOutputSampleFileSource()        {}
func (*UnknownUnionMember) isTemplateDetails()               {}
func (*UnknownUnionMember) isX12ValidationRule()             {}
