// Code generated by smithy-go-codegen DO NOT EDIT.

package aiops

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/aiops/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of the specified investigation group.
func (c *Client) UpdateInvestigationGroup(ctx context.Context, params *UpdateInvestigationGroupInput, optFns ...func(*Options)) (*UpdateInvestigationGroupOutput, error) {
	if params == nil {
		params = &UpdateInvestigationGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateInvestigationGroup", params, optFns, c.addOperationUpdateInvestigationGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateInvestigationGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateInvestigationGroupInput struct {

	// Specify either the name or the ARN of the investigation group that you want to
	// modify.
	//
	// This member is required.
	Identifier *string

	// Use this structure to integrate CloudWatch investigations with chat
	// applications. This structure is a string array. For the first string, specify
	// the ARN of an Amazon SNS topic. For the array of strings, specify the ARNs of
	// one or more chat applications configurations that you want to associate with
	// that topic. For more information about these configuration ARNs, see [Getting started with Amazon Q in chat applications]and [Resource type defined by Amazon Web Services Chatbot].
	//
	// [Resource type defined by Amazon Web Services Chatbot]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies
	// [Getting started with Amazon Q in chat applications]: https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html
	ChatbotNotificationChannel map[string][]string

	// Used to configure cross-account access for an investigation group. It allows
	// the investigation group to access resources in other accounts.
	CrossAccountConfigurations []types.CrossAccountConfiguration

	// Use this structure if you want to use a customer managed KMS key to encrypt
	// your investigation data. If you omit this parameter, CloudWatch investigations
	// will use an Amazon Web Services key to encrypt the data. For more information,
	// see [Encryption of investigation data].
	//
	// [Encryption of investigation data]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS
	EncryptionConfiguration *types.EncryptionConfiguration

	// Specify true to enable CloudWatch investigations to have access to change
	// events that are recorded by CloudTrail. The default is true .
	IsCloudTrailEventHistoryEnabled *bool

	// Specify this field if you want to change the IAM role that CloudWatch
	// investigations will use when it gathers investigation data. To do so, specify
	// the ARN of the new role.
	//
	// The permissions in this role determine which of your resources that CloudWatch
	// investigations will have access to during investigations.
	//
	// For more information, see [How to control what data CloudWatch investigations has access to during investigations].
	//
	// [How to control what data CloudWatch investigations has access to during investigations]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data
	RoleArn *string

	// Enter the existing custom tag keys for custom applications in your system.
	// Resource tags help CloudWatch investigations narrow the search space when it is
	// unable to discover definite relationships between resources. For example, to
	// discover that an Amazon ECS service depends on an Amazon RDS database,
	// CloudWatch investigations can discover this relationship using data sources such
	// as X-Ray and CloudWatch Application Signals. However, if you haven't deployed
	// these features, CloudWatch investigations will attempt to identify possible
	// relationships. Tag boundaries can be used to narrow the resources that will be
	// discovered by CloudWatch investigations in these cases.
	//
	// You don't need to enter tags created by myApplications or CloudFormation,
	// because CloudWatch investigations can automatically detect those tags.
	TagKeyBoundaries []string

	noSmithyDocumentSerde
}

type UpdateInvestigationGroupOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateInvestigationGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateInvestigationGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateInvestigationGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateInvestigationGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateInvestigationGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateInvestigationGroup",
	}
}
