//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package generated

import "time"

// AccessPolicy - An Access policy
type AccessPolicy struct {
	// the date-time the policy expires
	Expiry *time.Time `xml:"Expiry"`

	// the permissions for the acl policy
	Permission *string `xml:"Permission"`

	// the date-time the policy is active
	Start *time.Time `xml:"Start"`
}

// CORSRule - CORS is an HTTP feature that enables a web application running under one domain to access resources in another
// domain. Web browsers implement a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin
// domain) to call APIs in another domain
type CORSRule struct {
	// REQUIRED; the request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `xml:"AllowedHeaders"`

	// REQUIRED; The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods *string `xml:"AllowedMethods"`

	// REQUIRED; The origin domains that are permitted to make a request against the storage service via CORS. The origin domain
	// is the domain from which the request originates. Note that the origin must be an exact
	// case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*'
	// to allow all origin domains to make requests via CORS.
	AllowedOrigins *string `xml:"AllowedOrigins"`

	// REQUIRED; The response headers that may be sent in the response to the CORS request and exposed by the browser to the request
	// issuer
	ExposedHeaders *string `xml:"ExposedHeaders"`

	// REQUIRED; The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int32 `xml:"MaxAgeInSeconds"`
}

// DequeuedMessage - The object returned in the QueueMessageList array when calling Get Messages on a Queue.
type DequeuedMessage struct {
	// REQUIRED; The number of times the message has been dequeued.
	DequeueCount *int64 `xml:"DequeueCount"`

	// REQUIRED; The time that the Message will expire and be automatically deleted.
	ExpirationTime *time.Time `xml:"ExpirationTime"`

	// REQUIRED; The time the Message was inserted into the Queue.
	InsertionTime *time.Time `xml:"InsertionTime"`

	// REQUIRED; The Id of the Message.
	MessageID *string `xml:"MessageId"`

	// REQUIRED; The content of the Message.
	MessageText *string `xml:"MessageText"`

	// REQUIRED; This value is required to delete the Message. If deletion fails using this popreceipt then the message has been
	// dequeued by another client.
	PopReceipt *string `xml:"PopReceipt"`

	// REQUIRED; The time that the message will again become visible in the Queue.
	TimeNextVisible *time.Time `xml:"TimeNextVisible"`
}

// EnqueuedMessage - The object returned in the QueueMessageList array when calling Put Message on a Queue
type EnqueuedMessage struct {
	// REQUIRED; The time that the Message will expire and be automatically deleted.
	ExpirationTime *time.Time `xml:"ExpirationTime"`

	// REQUIRED; The time the Message was inserted into the Queue.
	InsertionTime *time.Time `xml:"InsertionTime"`

	// REQUIRED; The Id of the Message.
	MessageID *string `xml:"MessageId"`

	// REQUIRED; This value is required to delete the Message. If deletion fails using this popreceipt then the message has been
	// dequeued by another client.
	PopReceipt *string `xml:"PopReceipt"`

	// REQUIRED; The time that the message will again become visible in the Queue.
	TimeNextVisible *time.Time `xml:"TimeNextVisible"`
}

type GeoReplication struct {
	// REQUIRED; A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available
	// for read operations at the secondary. Primary writes after this point in time may or may
	// not be available for reads.
	LastSyncTime *time.Time `xml:"LastSyncTime"`

	// REQUIRED; The status of the secondary location
	Status *GeoReplicationStatus `xml:"Status"`
}

// ListQueuesSegmentResponse - The object returned when calling List Queues on a Queue Service.
type ListQueuesSegmentResponse struct {
	// REQUIRED
	MaxResults *int32 `xml:"MaxResults"`

	// REQUIRED
	NextMarker *string `xml:"NextMarker"`

	// REQUIRED
	Prefix *string `xml:"Prefix"`

	// REQUIRED
	ServiceEndpoint *string  `xml:"ServiceEndpoint,attr"`
	Marker          *string  `xml:"Marker"`
	Queues          []*Queue `xml:"Queues>Queue"`
}

// Logging - Azure Analytics Logging settings.
type Logging struct {
	// REQUIRED; Indicates whether all delete requests should be logged.
	Delete *bool `xml:"Delete"`

	// REQUIRED; Indicates whether all read requests should be logged.
	Read *bool `xml:"Read"`

	// REQUIRED; the retention policy
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`

	// REQUIRED; The version of Storage Analytics to configure.
	Version *string `xml:"Version"`

	// REQUIRED; Indicates whether all write requests should be logged.
	Write *bool `xml:"Write"`
}

// MessageIDClientDeleteOptions contains the optional parameters for the MessageIDClient.Delete method.
type MessageIDClientDeleteOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// MessageIDClientUpdateOptions contains the optional parameters for the MessageIDClient.Update method.
type MessageIDClientUpdateOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
	// Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds.
	// A specified value must be larger than or equal to 1 second, and cannot be
	// larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout
	// of a message can be set to a value later than the expiry time.
	Visibilitytimeout *int32
}

// MessagesClientClearOptions contains the optional parameters for the MessagesClient.Clear method.
type MessagesClientClearOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// MessagesClientDequeueOptions contains the optional parameters for the MessagesClient.Dequeue method.
type MessagesClientDequeueOptions struct {
	// Optional. A nonzero integer value that specifies the number of messages to retrieve from the queue, up to a maximum of
	// 32. If fewer are visible, the visible messages are returned. By default, a single
	// message is retrieved from the queue with this operation.
	NumberOfMessages *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
	// Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds.
	// A specified value must be larger than or equal to 1 second, and cannot be
	// larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout
	// of a message can be set to a value later than the expiry time.
	Visibilitytimeout *int32
}

// MessagesClientEnqueueOptions contains the optional parameters for the MessagesClient.Enqueue method.
type MessagesClientEnqueueOptions struct {
	// Optional. Specifies the time-to-live interval for the message, in seconds. Prior to version 2017-07-29, the maximum time-to-live
	// allowed is 7 days. For version 2017-07-29 or later, the maximum
	// time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this parameter is
	// omitted, the default time-to-live is 7 days.
	MessageTimeToLive *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
	// Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or later. If not specified, the default
	// value is 0. Specifies the new visibility timeout value, in seconds,
	// relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
	// timeout of a message cannot be set to a value later than the expiry time.
	// visibilitytimeout should be set to a value smaller than the time-to-live value.
	Visibilitytimeout *int32
}

// MessagesClientPeekOptions contains the optional parameters for the MessagesClient.Peek method.
type MessagesClientPeekOptions struct {
	// Optional. A nonzero integer value that specifies the number of messages to retrieve from the queue, up to a maximum of
	// 32. If fewer are visible, the visible messages are returned. By default, a single
	// message is retrieved from the queue with this operation.
	NumberOfMessages *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// Metrics - a summary of request statistics grouped by API in hour or minute aggregates for queues
type Metrics struct {
	// REQUIRED; Indicates whether metrics are enabled for the Queue service.
	Enabled *bool `xml:"Enabled"`

	// Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs *bool `xml:"IncludeAPIs"`

	// the retention policy
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`

	// The version of Storage Analytics to configure.
	Version *string `xml:"Version"`
}

// PeekedMessage - The object returned in the QueueMessageList array when calling Peek Messages on a Queue
type PeekedMessage struct {
	// REQUIRED; The number of times the message has been dequeued.
	DequeueCount *int64 `xml:"DequeueCount"`

	// REQUIRED; The time that the Message will expire and be automatically deleted.
	ExpirationTime *time.Time `xml:"ExpirationTime"`

	// REQUIRED; The time the Message was inserted into the Queue.
	InsertionTime *time.Time `xml:"InsertionTime"`

	// REQUIRED; The Id of the Message.
	MessageID *string `xml:"MessageId"`

	// REQUIRED; The content of the Message.
	MessageText *string `xml:"MessageText"`
}

// Queue - An Azure Storage Queue.
type Queue struct {
	// REQUIRED; The name of the Queue.
	Name *string `xml:"Name"`

	// Dictionary of
	Metadata map[string]*string `xml:"Metadata"`
}

// QueueClientCreateOptions contains the optional parameters for the QueueClient.Create method.
type QueueClientCreateOptions struct {
	// Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that
	// metadata requested with this parameter must be stored in accordance with the
	// naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names
	// must adhere to the naming conventions for C# identifiers.
	Metadata map[string]*string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueClientDeleteOptions contains the optional parameters for the QueueClient.Delete method.
type QueueClientDeleteOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueClientGetAccessPolicyOptions contains the optional parameters for the QueueClient.GetAccessPolicy method.
type QueueClientGetAccessPolicyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueClientGetPropertiesOptions contains the optional parameters for the QueueClient.GetProperties method.
type QueueClientGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueClientSetAccessPolicyOptions contains the optional parameters for the QueueClient.SetAccessPolicy method.
type QueueClientSetAccessPolicyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueClientSetMetadataOptions contains the optional parameters for the QueueClient.SetMetadata method.
type QueueClientSetMetadataOptions struct {
	// Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that
	// metadata requested with this parameter must be stored in accordance with the
	// naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names
	// must adhere to the naming conventions for C# identifiers.
	Metadata map[string]*string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// QueueMessage - A Message object which can be stored in a Queue
type QueueMessage struct {
	// REQUIRED; The content of the message
	MessageText *string `xml:"MessageText"`
}

// RetentionPolicy - the retention policy
type RetentionPolicy struct {
	// REQUIRED; Indicates whether a retention policy is enabled for the storage service
	Enabled *bool `xml:"Enabled"`

	// Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than this
	// value will be deleted
	Days *int32 `xml:"Days"`
}

// ServiceClientGetPropertiesOptions contains the optional parameters for the ServiceClient.GetProperties method.
type ServiceClientGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// ServiceClientGetStatisticsOptions contains the optional parameters for the ServiceClient.GetStatistics method.
type ServiceClientGetStatisticsOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// ServiceClientListQueuesSegmentOptions contains the optional parameters for the ServiceClient.NewListQueuesSegmentPager
// method.
type ServiceClientListQueuesSegmentOptions struct {
	// Include this parameter to specify that the queues' metadata be returned as part of the response body.
	Include []string
	// A string value that identifies the portion of the list of queues to be returned with the next listing operation. The operation
	// returns the NextMarker value within the response body if the listing
	// operation did not return all queues remaining to be listed with the current page. The NextMarker value can be used as the
	// value for the marker parameter in a subsequent call to request the next page
	// of list items. The marker value is opaque to the client.
	Marker *string
	// Specifies the maximum number of queues to return. If the request does not specify maxresults, or specifies a value greater
	// than 5000, the server will return up to 5000 items. Note that if the listing
	// operation crosses a partition boundary, then the service will return a continuation token for retrieving the remainder
	// of the results. For this reason, it is possible that the service will return
	// fewer results than specified by maxresults, or than the default of 5000.
	Maxresults *int32
	// Filters the results to return only queues whose name begins with the specified prefix.
	Prefix *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// ServiceClientSetPropertiesOptions contains the optional parameters for the ServiceClient.SetProperties method.
type ServiceClientSetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string
	// The The timeout parameter is expressed in seconds. For more information, see
	Timeout *int32
}

// SignedIdentifier - signed identifier
type SignedIdentifier struct {
	// REQUIRED; The access policy
	AccessPolicy *AccessPolicy `xml:"AccessPolicy"`

	// REQUIRED; a unique id
	ID *string `xml:"Id"`
}

type StorageError struct {
	Message *string `json:"Message,omitempty"`
}

// StorageServiceProperties - Storage Service Properties.
type StorageServiceProperties struct {
	// The set of CORS rules.
	CORS []*CORSRule `xml:"Cors>CorsRule"`

	// A summary of request statistics grouped by API in hourly aggregates for queues
	HourMetrics *Metrics `xml:"HourMetrics"`

	// Azure Analytics Logging settings
	Logging *Logging `xml:"Logging"`

	// a summary of request statistics grouped by API in minute aggregates for queues
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`
}

// StorageServiceStats - Stats for the storage service.
type StorageServiceStats struct {
	// Geo-Replication information for the Secondary Storage Service
	GeoReplication *GeoReplication `xml:"GeoReplication"`
}
