//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armworkloads

import "time"

// ApplicationServerConfiguration - Gets or sets the application server configuration.
type ApplicationServerConfiguration struct {
	// REQUIRED; The number of app server instances.
	InstanceCount *int64

	// REQUIRED; The subnet id.
	SubnetID *string

	// REQUIRED; Gets or sets the virtual machine configuration.
	VirtualMachineConfiguration *VirtualMachineConfiguration
}

// ApplicationServerFullResourceNames - The full resource names object for application layer resources. The number of entries
// in this list should be equal to the number VMs to be created for application layer.
type ApplicationServerFullResourceNames struct {
	// The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
	AvailabilitySetName *string

	// The list of virtual machine naming details.
	VirtualMachines []*VirtualMachineResourceNames
}

// ApplicationServerVMDetails - The Application Server VM Details.
type ApplicationServerVMDetails struct {
	// READ-ONLY; Storage details of all the Storage Accounts attached to the App Virtual Machine. For e.g. NFS on AFS Shared
	// Storage.
	StorageDetails []*StorageInformation

	// READ-ONLY; Defines the type of application server VM.
	Type *ApplicationServerVirtualMachineType

	// READ-ONLY
	VirtualMachineID *string
}

// CentralServerConfiguration - Gets or sets the central server configuration.
type CentralServerConfiguration struct {
	// REQUIRED; The number of central server VMs.
	InstanceCount *int64

	// REQUIRED; The subnet id.
	SubnetID *string

	// REQUIRED; Gets or sets the virtual machine configuration.
	VirtualMachineConfiguration *VirtualMachineConfiguration
}

// CentralServerFullResourceNames - The full resource names object for central server layer resources.
type CentralServerFullResourceNames struct {
	// The full name for availability set. In case name is not provided, it will be defaulted to {SID}-ASCS-AvSet.
	AvailabilitySetName *string

	// The resource names object for load balancer and related resources.
	LoadBalancer *LoadBalancerResourceNames

	// The list of names for all ASCS virtual machines to be deployed. The number of entries in this list should be equal to the
	// number VMs to be created for ASCS layer. At maximum, there can be two virtual
	// machines at this layer: ASCS and ERS.
	VirtualMachines []*VirtualMachineResourceNames
}

// CentralServerVMDetails - The SAP Central Services Instance VM details.
type CentralServerVMDetails struct {
	// READ-ONLY; Storage details of all the Storage Accounts attached to the ASCS Virtual Machine. For e.g. NFS on AFS Shared
	// Storage.
	StorageDetails []*StorageInformation

	// READ-ONLY; Defines the type of central server VM.
	Type *CentralServerVirtualMachineType

	// READ-ONLY
	VirtualMachineID *string
}

// CreateAndMountFileShareConfiguration - Gets or sets the file share configuration where the transport directory fileshare
// is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place
// the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
type CreateAndMountFileShareConfiguration struct {
	// REQUIRED; The type of file share config.
	ConfigurationType *ConfigurationType

	// The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case
	// of missing input.
	ResourceGroup *string

	// The name of file share storage account name . A custom name is used in case of missing input.
	StorageAccountName *string
}

// GetFileShareConfiguration implements the FileShareConfigurationClassification interface for type CreateAndMountFileShareConfiguration.
func (c *CreateAndMountFileShareConfiguration) GetFileShareConfiguration() *FileShareConfiguration {
	return &FileShareConfiguration{
		ConfigurationType: c.ConfigurationType,
	}
}

// DB2ProviderInstanceProperties - Gets or sets the DB2 provider properties.
type DB2ProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// Gets or sets the db2 database name.
	DbName *string

	// Gets or sets the db2 database password.
	DbPassword *string

	// Gets or sets the key vault URI to secret with the database password.
	DbPasswordURI *string

	// Gets or sets the db2 database sql port.
	DbPort *string

	// Gets or sets the db2 database user name.
	DbUsername *string

	// Gets or sets the target virtual machine name.
	Hostname *string

	// Gets or sets the blob URI to SSL certificate for the DB2 Database.
	SSLCertificateURI *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the SAP System Identifier
	SapSid *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type DB2ProviderInstanceProperties.
func (d *DB2ProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: d.ProviderType,
	}
}

// DatabaseConfiguration - Gets or sets the database configuration.
type DatabaseConfiguration struct {
	// REQUIRED; The number of database VMs.
	InstanceCount *int64

	// REQUIRED; The subnet id.
	SubnetID *string

	// REQUIRED; Gets or sets the virtual machine configuration.
	VirtualMachineConfiguration *VirtualMachineConfiguration

	// The database type.
	DatabaseType *SAPDatabaseType

	// Gets or sets the disk configuration.
	DiskConfiguration *DiskConfiguration
}

// DatabaseServerFullResourceNames - The full resource names object for database layer resources. The number of entries in
// this list should be equal to the number VMs to be created for database layer.
type DatabaseServerFullResourceNames struct {
	// The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
	AvailabilitySetName *string

	// The resource names object for load balancer and related resources.
	LoadBalancer *LoadBalancerResourceNames

	// The list of virtual machine naming details.
	VirtualMachines []*VirtualMachineResourceNames
}

// DatabaseVMDetails - Database VM details.
type DatabaseVMDetails struct {
	// READ-ONLY; Defines the SAP Instance status.
	Status *SAPVirtualInstanceStatus

	// READ-ONLY; Storage details of all the Storage Accounts attached to the Database Virtual Machine. For e.g. NFS on AFS Shared
	// Storage.
	StorageDetails []*StorageInformation

	// READ-ONLY
	VirtualMachineID *string
}

// DeployerVMPackages - Defines the url and storage account ID where deployer VM packages are uploaded
type DeployerVMPackages struct {
	// The deployer VM packages storage account id
	StorageAccountID *string

	// The URL to the deployer VM packages file.
	URL *string
}

// DeploymentConfiguration - Deployment Configuration.
type DeploymentConfiguration struct {
	// REQUIRED; The configuration Type.
	ConfigurationType *SAPConfigurationType

	// The geo-location where the SAP system is to be created.
	AppLocation *string

	// The infrastructure configuration.
	InfrastructureConfiguration InfrastructureConfigurationClassification

	// The software configuration.
	SoftwareConfiguration SoftwareConfigurationClassification
}

// GetSAPConfiguration implements the SAPConfigurationClassification interface for type DeploymentConfiguration.
func (d *DeploymentConfiguration) GetSAPConfiguration() *SAPConfiguration {
	return &SAPConfiguration{
		ConfigurationType: d.ConfigurationType,
	}
}

// DeploymentWithOSConfiguration - Deployment along with OS Configuration.
type DeploymentWithOSConfiguration struct {
	// REQUIRED; The configuration Type.
	ConfigurationType *SAPConfigurationType

	// The geo-location where the SAP system is to be created.
	AppLocation *string

	// The infrastructure configuration.
	InfrastructureConfiguration InfrastructureConfigurationClassification

	// The OS and SAP configuration.
	OSSapConfiguration *OsSapConfiguration

	// The software configuration.
	SoftwareConfiguration SoftwareConfigurationClassification
}

// GetSAPConfiguration implements the SAPConfigurationClassification interface for type DeploymentWithOSConfiguration.
func (d *DeploymentWithOSConfiguration) GetSAPConfiguration() *SAPConfiguration {
	return &SAPConfiguration{
		ConfigurationType: d.ConfigurationType,
	}
}

// DiscoveryConfiguration - Discovery Details.
type DiscoveryConfiguration struct {
	// REQUIRED; The configuration Type.
	ConfigurationType *SAPConfigurationType

	// The virtual machine ID of the Central Server.
	CentralServerVMID *string

	// The custom storage account name for the storage account created by the service in the managed resource group created as
	// part of VIS deployment.
	// Refer to the storage account naming rules here [https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage].
	// If not provided, the service will create the storage account with a random name.
	ManagedRgStorageAccountName *string

	// READ-ONLY; The geo-location where the SAP system exists.
	AppLocation *string
}

// GetSAPConfiguration implements the SAPConfigurationClassification interface for type DiscoveryConfiguration.
func (d *DiscoveryConfiguration) GetSAPConfiguration() *SAPConfiguration {
	return &SAPConfiguration{
		ConfigurationType: d.ConfigurationType,
	}
}

// DiskConfiguration - The Disk Configuration Details.
type DiskConfiguration struct {
	// The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap',
	// 'os'], Optional volume : ['backup'].
	DiskVolumeConfigurations map[string]*DiskVolumeConfiguration
}

// DiskDetails - The supported disk size details for a disk type.
type DiskDetails struct {
	// The disk tier, e.g. P10, E10.
	DiskTier *string

	// The disk Iops.
	IopsReadWrite *int64

	// The maximum supported disk count.
	MaximumSupportedDiskCount *int64

	// The disk provisioned throughput in MBps.
	MbpsReadWrite *int64

	// The minimum supported disk count.
	MinimumSupportedDiskCount *int64

	// The type of disk sku. For example, StandardLRS, StandardZRS, PremiumLRS, PremiumZRS.
	SKU *DiskSKU

	// The disk size in GB.
	SizeGB *int64
}

// DiskSKU - The type of disk sku. For example, StandardLRS, StandardZRS, PremiumLRS, PremiumZRS.
type DiskSKU struct {
	// Defines the disk sku name.
	Name *DiskSKUName
}

// DiskVolumeConfiguration - The disk configuration required for the selected volume.
type DiskVolumeConfiguration struct {
	// The total number of disks required for the concerned volume.
	Count *int64

	// The disk SKU details.
	SKU *DiskSKU

	// The disk size in GB.
	SizeGB *int64
}

// EnqueueReplicationServerProperties - Defines the SAP Enqueue Replication Server (ERS) properties.
type EnqueueReplicationServerProperties struct {
	// READ-ONLY; Defines the type of Enqueue Replication Server.
	ErsVersion *EnqueueReplicationServerType

	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; ERS SAP Hostname.
	Hostname *string

	// READ-ONLY; ERS SAP IP Address.
	IPAddress *string

	// READ-ONLY; ERS Instance Number.
	InstanceNo *string

	// READ-ONLY; ERS SAP Kernel Patch level.
	KernelPatch *string

	// READ-ONLY; ERS SAP Kernel Version.
	KernelVersion *string
}

// EnqueueServerProperties - Defines the SAP Enqueue Server properties.
type EnqueueServerProperties struct {
	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; Enqueue Server SAP Hostname.
	Hostname *string

	// READ-ONLY; Enqueue Server SAP IP Address.
	IPAddress *string

	// READ-ONLY; Enqueue Server Port.
	Port *int64
}

// Error - Standard error object.
type Error struct {
	// READ-ONLY; Server-defined set of error codes.
	Code *string

	// READ-ONLY; Array of details about specific errors that led to this reported error.
	Details []*Error

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError *ErrorInnerError

	// READ-ONLY; Human-readable representation of the error.
	Message *string

	// READ-ONLY; Target of the error.
	Target *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorInnerError - Object containing more specific information than the current object about the error.
type ErrorInnerError struct {
	// Standard error object.
	InnerError *Error
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ExternalInstallationSoftwareConfiguration - The SAP Software configuration Input when the software is installed externally
// outside the service.
type ExternalInstallationSoftwareConfiguration struct {
	// REQUIRED; The SAP software installation Type.
	SoftwareInstallationType *SAPSoftwareInstallationType

	// The resource ID of the virtual machine containing the central server instance.
	CentralServerVMID *string
}

// GetSoftwareConfiguration implements the SoftwareConfigurationClassification interface for type ExternalInstallationSoftwareConfiguration.
func (e *ExternalInstallationSoftwareConfiguration) GetSoftwareConfiguration() *SoftwareConfiguration {
	return &SoftwareConfiguration{
		SoftwareInstallationType: e.SoftwareInstallationType,
	}
}

// FileShareConfiguration - File Share configuration details, populated with information on storage configuration mounted
// on the VIS. The createAndMount option is selected in case of missing input.
type FileShareConfiguration struct {
	// REQUIRED; The type of file share config.
	ConfigurationType *ConfigurationType
}

// GetFileShareConfiguration implements the FileShareConfigurationClassification interface for type FileShareConfiguration.
func (f *FileShareConfiguration) GetFileShareConfiguration() *FileShareConfiguration { return f }

// GatewayServerProperties - Defines the SAP Gateway Server properties.
type GatewayServerProperties struct {
	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; Gateway Port.
	Port *int64
}

// HanaDbProviderInstanceProperties - Gets or sets the provider properties.
type HanaDbProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// Gets or sets the hana database name.
	DbName *string

	// Gets or sets the database password.
	DbPassword *string

	// Gets or sets the key vault URI to secret with the database password.
	DbPasswordURI *string

	// Gets or sets the database user name.
	DbUsername *string

	// Gets or sets the target virtual machine size.
	Hostname *string

	// Gets or sets the database instance number.
	InstanceNumber *string

	// Gets or sets the database sql port.
	SQLPort *string

	// Gets or sets the blob URI to SSL certificate for the DB.
	SSLCertificateURI *string

	// Gets or sets the hostname(s) in the SSL certificate.
	SSLHostNameInCertificate *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the SAP System Identifier.
	SapSid *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type HanaDbProviderInstanceProperties.
func (h *HanaDbProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: h.ProviderType,
	}
}

// HighAvailabilityConfiguration - Gets or sets the high availability configuration.
type HighAvailabilityConfiguration struct {
	// REQUIRED; The high availability type.
	HighAvailabilityType *SAPHighAvailabilityType
}

// HighAvailabilitySoftwareConfiguration - Gets or sets the HA software configuration.
type HighAvailabilitySoftwareConfiguration struct {
	// REQUIRED; The fencing client id.
	FencingClientID *string

	// REQUIRED; The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop
	// the cluster VMs.
	FencingClientPassword *string
}

// ImageReference - Specifies information about the image to use. You can specify information about platform images, marketplace
// images, or virtual machine images. This element is required when you want to use a platform
// image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference
// publisher and offer can only be set when you create the scale set.
type ImageReference struct {
	// Specifies the offer of the platform image or marketplace image used to create the virtual machine.
	Offer *string

	// The image publisher.
	Publisher *string

	// The image SKU.
	SKU *string

	// Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats
	// are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers.
	// Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image
	// will not automatically update after deploy time even if a new version becomes
	// available.
	Version *string
}

// InfrastructureConfiguration - Deploy SAP Infrastructure Details.
type InfrastructureConfiguration struct {
	// REQUIRED; The application resource group where SAP system resources will be deployed.
	AppResourceGroup *string

	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType
}

// GetInfrastructureConfiguration implements the InfrastructureConfigurationClassification interface for type InfrastructureConfiguration.
func (i *InfrastructureConfiguration) GetInfrastructureConfiguration() *InfrastructureConfiguration {
	return i
}

// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine.
// For a list of supported Linux distributions, see Linux on Azure-Endorsed Distributions [https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros].
type LinuxConfiguration struct {
	// REQUIRED; The OS Type
	OSType *OSType

	// Specifies whether password authentication should be disabled.
	DisablePasswordAuthentication *bool

	// Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
	SSH *SSHConfiguration

	// The SSH Key-pair used to authenticate with the VM's.
	SSHKeyPair *SSHKeyPair
}

// GetOSConfiguration implements the OSConfigurationClassification interface for type LinuxConfiguration.
func (l *LinuxConfiguration) GetOSConfiguration() *OSConfiguration {
	return &OSConfiguration{
		OSType: l.OSType,
	}
}

// LoadBalancerDetails - The Load Balancer details such as Load Balancer ID.
type LoadBalancerDetails struct {
	// READ-ONLY
	ID *string
}

// LoadBalancerResourceNames - The resource names object for load balancer and related resources.
type LoadBalancerResourceNames struct {
	// The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
	BackendPoolNames []*string

	// The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should
	// be 1 for database layer.
	FrontendIPConfigurationNames []*string

	// The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database
	// layer.
	HealthProbeNames []*string

	// The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
	LoadBalancerName *string
}

// ManagedRGConfiguration - Managed resource group configuration
type ManagedRGConfiguration struct {
	// Managed resource group name
	Name *string
}

// MessageServerProperties - Defines the SAP Message Server properties.
type MessageServerProperties struct {
	// READ-ONLY; Message Server HTTP Port.
	HTTPPort *int64

	// READ-ONLY; Message Server HTTPS Port.
	HTTPSPort *int64

	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; Message Server SAP Hostname.
	Hostname *string

	// READ-ONLY; Message server IP Address.
	IPAddress *string

	// READ-ONLY; Message Server internal MS port.
	InternalMsPort *int64

	// READ-ONLY; Message Server port.
	MSPort *int64
}

// Monitor - SAP monitor info on Azure (ARM properties and SAP monitor properties)
type Monitor struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// [currently not in use] Managed service identity(user assigned identities)
	Identity *UserAssignedServiceIdentity

	// SAP monitor properties
	Properties *MonitorProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MonitorListResult - The response from the List SAP monitors operation.
type MonitorListResult struct {
	// The URL to get the next set of SAP monitors.
	NextLink *string

	// The list of SAP monitors.
	Value []*Monitor
}

// MonitorProperties - Describes the properties of a SAP monitor.
type MonitorProperties struct {
	// The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring
	// region.
	AppLocation *string

	// The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
	LogAnalyticsWorkspaceArmID *string

	// Managed resource group configuration
	ManagedResourceGroupConfiguration *ManagedRGConfiguration

	// The subnet which the SAP monitor will be deployed in
	MonitorSubnet *string

	// Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
	RoutingPreference *RoutingPreference

	// Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created
	// which do not support zone redundancy.
	ZoneRedundancyPreference *string

	// READ-ONLY; Defines the SAP monitor errors.
	Errors *MonitorPropertiesErrors

	// READ-ONLY; The ARM ID of the MSI used for SAP monitoring.
	MsiArmID *string

	// READ-ONLY; State of provisioning of the SAP monitor.
	ProvisioningState *WorkloadMonitorProvisioningState

	// READ-ONLY; The ARM ID of the Storage account used for SAP monitoring.
	StorageAccountArmID *string
}

// MonitorPropertiesErrors - Defines the SAP monitor errors.
type MonitorPropertiesErrors struct {
	// READ-ONLY; Server-defined set of error codes.
	Code *string

	// READ-ONLY; Array of details about specific errors that led to this reported error.
	Details []*Error

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError *ErrorInnerError

	// READ-ONLY; Human-readable representation of the error.
	Message *string

	// READ-ONLY; Target of the error.
	Target *string
}

// MountFileShareConfiguration - Gets or sets the file share configuration where the transport directory fileshare already
// exists, and user wishes to mount the fileshare as a part of the create infra flow.
type MountFileShareConfiguration struct {
	// REQUIRED; The type of file share config.
	ConfigurationType *ConfigurationType

	// REQUIRED; The fileshare resource ID
	ID *string

	// REQUIRED; The private endpoint resource ID
	PrivateEndpointID *string
}

// GetFileShareConfiguration implements the FileShareConfigurationClassification interface for type MountFileShareConfiguration.
func (m *MountFileShareConfiguration) GetFileShareConfiguration() *FileShareConfiguration {
	return &FileShareConfiguration{
		ConfigurationType: m.ConfigurationType,
	}
}

// MsSQLServerProviderInstanceProperties - Gets or sets the SQL server provider properties.
type MsSQLServerProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// Gets or sets the database password.
	DbPassword *string

	// Gets or sets the key vault URI to secret with the database password.
	DbPasswordURI *string

	// Gets or sets the database sql port.
	DbPort *string

	// Gets or sets the database user name.
	DbUsername *string

	// Gets or sets the SQL server host name.
	Hostname *string

	// Gets or sets the blob URI to SSL certificate for the SQL Database.
	SSLCertificateURI *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the SAP System Identifier
	SapSid *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type MsSQLServerProviderInstanceProperties.
func (m *MsSQLServerProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: m.ProviderType,
	}
}

// NetworkConfiguration - Defines the network configuration type for SAP system infrastructure that is being deployed
type NetworkConfiguration struct {
	// Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
	IsSecondaryIPEnabled *bool
}

// NetworkInterfaceResourceNames - The resource names object for network interface and related resources.
type NetworkInterfaceResourceNames struct {
	// The full name for network interface. If name is not provided, service uses a default name based on the deployment type.
	// For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems,
	// default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per
	// layer. For distributed and HA-AvSet systems, default name will be
	// {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
	NetworkInterfaceName *string
}

// OSConfiguration - Defines the OS configuration.
type OSConfiguration struct {
	// REQUIRED; The OS Type
	OSType *OSType
}

// GetOSConfiguration implements the OSConfigurationClassification interface for type OSConfiguration.
func (o *OSConfiguration) GetOSConfiguration() *OSConfiguration { return o }

// OSProfile - Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once
// VM is provisioned.
type OSProfile struct {
	// Specifies the password of the administrator account.
	// Minimum-length (Windows): 8 characters
	// Minimum-length (Linux): 6 characters
	// Max-length (Windows): 123 characters
	// Max-length (Linux): 72 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	// For resetting the password, see How to reset the Remote Desktop service or its login password in a Windows VM [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp]
	// For resetting root password, see Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension
	// [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection]
	AdminPassword *string

	// Specifies the name of the administrator account.
	// This property cannot be updated after the VM is created.
	// Windows-only restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length (Linux): 1 character
	// Max-length (Linux): 64 characters
	// Max-length (Windows): 20 characters.
	AdminUsername *string

	// Specifies Windows operating system settings on the virtual machine.
	OSConfiguration OSConfigurationClassification
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time
}

// OperationsContent - Defines the workload operation content.
type OperationsContent struct {
	// Operations content.
	Properties *OperationsDefinition

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OperationsDefinition - Properties of an Operation.
type OperationsDefinition struct {
	// REQUIRED; Display information of the operation.
	Display *OperationsDefinitionDisplay

	// REQUIRED; Name of the operation.
	Name *string

	// Defines the action type of workload operation.
	ActionType *WorkloadMonitorActionType

	// Indicates whether the operation applies to data-plane.
	IsDataAction *bool

	// Defines the workload operation origin.
	Origin *OperationProperties

	// Defines the workload operation properties.
	Properties any
}

// OperationsDefinitionArrayResponseWithContinuation - Defines the workload operation definition response.
type OperationsDefinitionArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string

	// Defines the workload operation definition response properties.
	Value []*OperationsDefinition
}

// OperationsDefinitionDisplay - Display information of the operation.
type OperationsDefinitionDisplay struct {
	// REQUIRED; Describes the workload operation.
	Description *string

	// REQUIRED; Defines the workload operation.
	Operation *string

	// REQUIRED; Defines the workload provider.
	Provider *string

	// REQUIRED; Defines the workload resource.
	Resource *string
}

// OperationsDisplayDefinition - Defines the workload operation.
type OperationsDisplayDefinition struct {
	// REQUIRED; Describes the workload operation.
	Description *string

	// REQUIRED; Defines the workload operation.
	Operation *string

	// REQUIRED; Defines the workload provider.
	Provider *string

	// REQUIRED; Defines the workload resource.
	Resource *string
}

// OsSapConfiguration - Defines the OS and SAP Configurations for Deployment
type OsSapConfiguration struct {
	// The url and storage account ID where deployer VM packages are uploaded
	DeployerVMPackages *DeployerVMPackages

	// The FQDN to set for the SAP system
	SapFqdn *string
}

// PrometheusHaClusterProviderInstanceProperties - Gets or sets the PrometheusHaCluster provider properties.
type PrometheusHaClusterProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// Gets or sets the clusterName.
	ClusterName *string

	// Gets or sets the target machine name.
	Hostname *string

	// URL of the Node Exporter endpoint.
	PrometheusURL *string

	// Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
	SSLCertificateURI *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the cluster sid.
	Sid *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type PrometheusHaClusterProviderInstanceProperties.
func (p *PrometheusHaClusterProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: p.ProviderType,
	}
}

// PrometheusOSProviderInstanceProperties - Gets or sets the PrometheusOS provider properties.
type PrometheusOSProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// URL of the Node Exporter endpoint
	PrometheusURL *string

	// Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
	SSLCertificateURI *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the SAP System Identifier
	SapSid *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type PrometheusOSProviderInstanceProperties.
func (p *PrometheusOSProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: p.ProviderType,
	}
}

// ProviderInstance - A provider instance associated with SAP monitor.
type ProviderInstance struct {
	// [currently not in use] Managed service identity(user assigned identities)
	Identity *UserAssignedServiceIdentity

	// Provider Instance properties
	Properties *ProviderInstanceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProviderInstanceListResult - The response from the List provider instances operation.
type ProviderInstanceListResult struct {
	// The URL to get the next set of provider instances.
	NextLink *string

	// The list of provider instances.
	Value []*ProviderInstance
}

// ProviderInstanceProperties - Describes the properties of a provider instance.
type ProviderInstanceProperties struct {
	// Defines the provider specific properties.
	ProviderSettings ProviderSpecificPropertiesClassification

	// READ-ONLY; Defines the provider instance errors.
	Errors *ProviderInstancePropertiesErrors

	// READ-ONLY; State of provisioning of the provider instance
	ProvisioningState *WorkloadMonitorProvisioningState
}

// ProviderInstancePropertiesErrors - Defines the provider instance errors.
type ProviderInstancePropertiesErrors struct {
	// READ-ONLY; Server-defined set of error codes.
	Code *string

	// READ-ONLY; Array of details about specific errors that led to this reported error.
	Details []*Error

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError *ErrorInnerError

	// READ-ONLY; Human-readable representation of the error.
	Message *string

	// READ-ONLY; Target of the error.
	Target *string
}

// ProviderSpecificProperties - Gets or sets the provider specific properties.
type ProviderSpecificProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type ProviderSpecificProperties.
func (p *ProviderSpecificProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return p
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPApplicationServerInstance - Define the SAP Application Server Instance resource.
type SAPApplicationServerInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Defines the SAP Application Server instance properties.
	Properties *SAPApplicationServerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPApplicationServerInstanceList - Defines the collection of SAP Application Server Instance resources.
type SAPApplicationServerInstanceList struct {
	// Gets the value of next link.
	NextLink *string

	// Gets the list of SAP Application Server instance resources.
	Value []*SAPApplicationServerInstance
}

// SAPApplicationServerProperties - Defines the SAP Application Server instance properties.
type SAPApplicationServerProperties struct {
	// READ-ONLY; Defines the Application Instance errors.
	Errors *SAPVirtualInstanceError

	// READ-ONLY; Application server instance gateway Port.
	GatewayPort *int64

	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; Application server instance SAP hostname.
	Hostname *string

	// READ-ONLY; Application server instance SAP IP Address.
	IPAddress *string

	// READ-ONLY; Application server instance ICM HTTP Port.
	IcmHTTPPort *int64

	// READ-ONLY; Application server instance ICM HTTPS Port.
	IcmHTTPSPort *int64

	// READ-ONLY; Application server Instance Number.
	InstanceNo *string

	// READ-ONLY; Application server instance SAP Kernel Patch level.
	KernelPatch *string

	// READ-ONLY; Application server instance SAP Kernel Version.
	KernelVersion *string

	// READ-ONLY; The Load Balancer details such as LoadBalancer ID attached to Application Server Virtual Machines
	LoadBalancerDetails *LoadBalancerDetails

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *SapVirtualInstanceProvisioningState

	// READ-ONLY; Defines the SAP Instance status.
	Status *SAPVirtualInstanceStatus

	// READ-ONLY; Application server Subnet.
	Subnet *string

	// READ-ONLY; The list of virtual machines.
	VMDetails []*ApplicationServerVMDetails
}

// SAPAvailabilityZoneDetailsRequest - The SAP request to get list of availability zones.
type SAPAvailabilityZoneDetailsRequest struct {
	// REQUIRED; The geo-location where the SAP resources will be created.
	AppLocation *string

	// REQUIRED; The database type. Eg: HANA, DB2, etc
	DatabaseType *SAPDatabaseType

	// REQUIRED; Defines the SAP Product type.
	SapProduct *SAPProductType
}

// SAPAvailabilityZoneDetailsResult - The list of supported availability zone pairs which are part of SAP HA deployment.
type SAPAvailabilityZoneDetailsResult struct {
	// Gets the list of availability zone pairs.
	AvailabilityZonePairs []*SAPAvailabilityZonePair
}

// SAPAvailabilityZonePair - The SAP Availability Zone Pair.
type SAPAvailabilityZonePair struct {
	// The zone A.
	ZoneA *int64

	// The zone B.
	ZoneB *int64
}

// SAPCentralInstanceList - Defines the collection of SAP Central Services Instance resources.
type SAPCentralInstanceList struct {
	// Gets the value of next link.
	NextLink *string

	// Gets the list of SAP central services instance resources.
	Value []*SAPCentralServerInstance
}

// SAPCentralServerInstance - Define the SAP Central Services Instance resource.
type SAPCentralServerInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Defines the SAP Central Services Instance properties.
	Properties *SAPCentralServerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPCentralServerProperties - Defines the SAP Central Services Instance properties.
type SAPCentralServerProperties struct {
	// Defines the SAP Enqueue Replication Server (ERS) properties.
	EnqueueReplicationServerProperties *EnqueueReplicationServerProperties

	// Defines the SAP Enqueue Server properties.
	EnqueueServerProperties *EnqueueServerProperties

	// Defines the SAP Gateway Server properties.
	GatewayServerProperties *GatewayServerProperties

	// Defines the SAP Message Server properties.
	MessageServerProperties *MessageServerProperties

	// READ-ONLY; Defines the errors related to SAP Central Services Instance resource.
	Errors *SAPVirtualInstanceError

	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; The central services instance number.
	InstanceNo *string

	// READ-ONLY; The central services instance Kernel Patch level.
	KernelPatch *string

	// READ-ONLY; The central services instance Kernel Version.
	KernelVersion *string

	// READ-ONLY; The Load Balancer details such as LoadBalancer ID attached to ASCS Virtual Machines
	LoadBalancerDetails *LoadBalancerDetails

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *SapVirtualInstanceProvisioningState

	// READ-ONLY; Defines the SAP Instance status.
	Status *SAPVirtualInstanceStatus

	// READ-ONLY; The central services instance subnet.
	Subnet *string

	// READ-ONLY; The list of virtual machines corresponding to the Central Services instance.
	VMDetails []*CentralServerVMDetails
}

// SAPConfiguration - The SAP Configuration.
type SAPConfiguration struct {
	// REQUIRED; The configuration Type.
	ConfigurationType *SAPConfigurationType
}

// GetSAPConfiguration implements the SAPConfigurationClassification interface for type SAPConfiguration.
func (s *SAPConfiguration) GetSAPConfiguration() *SAPConfiguration { return s }

// SAPDatabaseInstance - Define the Database resource.
type SAPDatabaseInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Defines the Database properties.
	Properties *SAPDatabaseProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPDatabaseInstanceList - Defines the collection of SAP Database Instances.
type SAPDatabaseInstanceList struct {
	// Gets the value of next link.
	NextLink *string

	// Gets the list of SAP Database instances.
	Value []*SAPDatabaseInstance
}

// SAPDatabaseProperties - Defines the Database properties.
type SAPDatabaseProperties struct {
	// READ-ONLY; Database SID name.
	DatabaseSid *string

	// READ-ONLY; Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or MS SQL Server.
	DatabaseType *string

	// READ-ONLY; Defines the errors related to Database resource.
	Errors *SAPVirtualInstanceError

	// READ-ONLY; Database IP Address.
	IPAddress *string

	// READ-ONLY; The Load Balancer details such as LoadBalancer ID attached to Database Virtual Machines
	LoadBalancerDetails *LoadBalancerDetails

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *SapVirtualInstanceProvisioningState

	// READ-ONLY; Defines the SAP Instance status.
	Status *SAPVirtualInstanceStatus

	// READ-ONLY; Database subnet.
	Subnet *string

	// READ-ONLY; The list of virtual machines corresponding to the Database resource.
	VMDetails []*DatabaseVMDetails
}

// SAPDiskConfiguration - The SAP Disk Configuration contains 'recommended disk' details and list of supported disks detail
// for a volume type.
type SAPDiskConfiguration struct {
	// The recommended disk details for a given VM Sku.
	RecommendedConfiguration *DiskVolumeConfiguration

	// The list of supported disks for a given VM Sku.
	SupportedConfigurations []*DiskDetails
}

// SAPDiskConfigurationsRequest - The SAP request to get list of disk configurations.
type SAPDiskConfigurationsRequest struct {
	// REQUIRED; The geo-location where the SAP resources will be created.
	AppLocation *string

	// REQUIRED; The database type. Eg: HANA, DB2, etc
	DatabaseType *SAPDatabaseType

	// REQUIRED; The VM SKU for database instance.
	DbVMSKU *string

	// REQUIRED; The deployment type. Eg: SingleServer/ThreeTier
	DeploymentType *SAPDeploymentType

	// REQUIRED; Defines the environment type - Production/Non Production.
	Environment *SAPEnvironmentType

	// REQUIRED; Defines the SAP Product type.
	SapProduct *SAPProductType
}

// SAPDiskConfigurationsResult - The list of disk configuration for vmSku which are part of SAP deployment.
type SAPDiskConfigurationsResult struct {
	// The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap',
	// 'os'], Optional volume : ['backup'].
	VolumeConfigurations map[string]*SAPDiskConfiguration
}

// SAPInstallWithoutOSConfigSoftwareConfiguration - The SAP Software configuration Input when the software is to be installed
// by service without OS Configurations
type SAPInstallWithoutOSConfigSoftwareConfiguration struct {
	// REQUIRED; The URL to the SAP Build of Materials(BOM) file.
	BomURL *string

	// REQUIRED; The SAP bits storage account id.
	SapBitsStorageAccountID *string

	// REQUIRED; The SAP software installation Type.
	SoftwareInstallationType *SAPSoftwareInstallationType

	// REQUIRED; The software version to install.
	SoftwareVersion *string

	// Gets or sets the HA software configuration.
	HighAvailabilitySoftwareConfiguration *HighAvailabilitySoftwareConfiguration
}

// GetSoftwareConfiguration implements the SoftwareConfigurationClassification interface for type SAPInstallWithoutOSConfigSoftwareConfiguration.
func (s *SAPInstallWithoutOSConfigSoftwareConfiguration) GetSoftwareConfiguration() *SoftwareConfiguration {
	return &SoftwareConfiguration{
		SoftwareInstallationType: s.SoftwareInstallationType,
	}
}

// SAPSizingRecommendationRequest - The SAP Sizing Recommendation request.
type SAPSizingRecommendationRequest struct {
	// REQUIRED; The geo-location where the resource is to be created.
	AppLocation *string

	// REQUIRED; The database type.
	DatabaseType *SAPDatabaseType

	// REQUIRED; The database memory configuration.
	DbMemory *int64

	// REQUIRED; The deployment type. Eg: SingleServer/ThreeTier
	DeploymentType *SAPDeploymentType

	// REQUIRED; Defines the environment type - Production/Non Production.
	Environment *SAPEnvironmentType

	// REQUIRED; Defines the SAP Product type.
	SapProduct *SAPProductType

	// REQUIRED; The SAP Application Performance Standard measurement.
	Saps *int64

	// The DB scale method.
	DbScaleMethod *SAPDatabaseScaleMethod

	// The high availability type.
	HighAvailabilityType *SAPHighAvailabilityType
}

// SAPSizingRecommendationResult - The SAP sizing recommendation result.
type SAPSizingRecommendationResult struct {
	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType
}

// GetSAPSizingRecommendationResult implements the SAPSizingRecommendationResultClassification interface for type SAPSizingRecommendationResult.
func (s *SAPSizingRecommendationResult) GetSAPSizingRecommendationResult() *SAPSizingRecommendationResult {
	return s
}

// SAPSupportedResourceSKUsResult - The list of supported SKUs for different resources which are part of SAP deployment.
type SAPSupportedResourceSKUsResult struct {
	// Gets the list of SAP supported SKUs.
	SupportedSKUs []*SAPSupportedSKU
}

// SAPSupportedSKU - The SAP supported SKU.
type SAPSupportedSKU struct {
	// True if the Sku is certified for App server in the SAP system.
	IsAppServerCertified *bool

	// True if the Sku is certified for Database server in the SAP system.
	IsDatabaseCertified *bool

	// The VM Sku.
	VMSKU *string
}

// SAPSupportedSKUsRequest - The SAP request to get list of supported SKUs.
type SAPSupportedSKUsRequest struct {
	// REQUIRED; The geo-location where the resource is to be created.
	AppLocation *string

	// REQUIRED; The database type. Eg: HANA, DB2, etc
	DatabaseType *SAPDatabaseType

	// REQUIRED; The deployment type. Eg: SingleServer/ThreeTier
	DeploymentType *SAPDeploymentType

	// REQUIRED; Defines the environment type - Production/Non Production.
	Environment *SAPEnvironmentType

	// REQUIRED; Defines the SAP Product type.
	SapProduct *SAPProductType

	// The high availability type.
	HighAvailabilityType *SAPHighAvailabilityType
}

// SAPVirtualInstance - Define the Virtual Instance for SAP solutions resource.
type SAPVirtualInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Defines the Virtual Instance for SAP solutions resource properties.
	Properties *SAPVirtualInstanceProperties

	// A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit
	// the ACSS how-to-guide.
	Identity *UserAssignedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPVirtualInstanceError - An error response from the Virtual Instance for SAP Workload service.
type SAPVirtualInstanceError struct {
	// The Virtual Instance for SAP error body.
	Properties *ErrorDefinition
}

// SAPVirtualInstanceList - Defines the collection of Virtual Instance for SAP solutions resources.
type SAPVirtualInstanceList struct {
	// Gets the value of next link.
	NextLink *string

	// Gets the list of Virtual Instances for SAP solutions resources.
	Value []*SAPVirtualInstance
}

// SAPVirtualInstanceProperties - Defines the Virtual Instance for SAP solutions resource properties.
type SAPVirtualInstanceProperties struct {
	// REQUIRED; Defines if the SAP system is being created using Azure Center for SAP solutions (ACSS) or if an existing SAP
	// system is being registered with ACSS
	Configuration SAPConfigurationClassification

	// REQUIRED; Defines the environment type - Production/Non Production.
	Environment *SAPEnvironmentType

	// REQUIRED; Defines the SAP Product type.
	SapProduct *SAPProductType

	// Managed resource group configuration
	ManagedResourceGroupConfiguration *ManagedRGConfiguration

	// READ-ONLY; Indicates any errors on the Virtual Instance for SAP solutions resource.
	Errors *SAPVirtualInstanceError

	// READ-ONLY; Defines the health of SAP Instances.
	Health *SAPHealthState

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *SapVirtualInstanceProvisioningState

	// READ-ONLY; Defines the Virtual Instance for SAP state.
	State *SAPVirtualInstanceState

	// READ-ONLY; Defines the SAP Instance status.
	Status *SAPVirtualInstanceStatus
}

// SSHConfiguration - SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys []*SSHPublicKey
}

// SSHKeyPair - The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format.
// For creating ssh keys, see Create SSH keys on Linux and Mac for Linux VMs in Azure [https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed].
type SSHKeyPair struct {
	// SSH private key.
	PrivateKey *string

	// SSH public key
	PublicKey *string
}

// SSHPublicKey - Contains information about SSH certificate public key and the path on the Linux VM where the public key
// is placed.
type SSHPublicKey struct {
	// SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa
	// format.
	// For creating ssh keys, see Create SSH keys on Linux and Mac for Linux VMs in Azure [https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed].
	KeyData *string
}

// SapLandscapeMonitor - configuration associated with SAP Landscape Monitor Dashboard.
type SapLandscapeMonitor struct {
	// Sap Landscape Monitor properties
	Properties *SapLandscapeMonitorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SapLandscapeMonitorListResult - The response from the List SAP Landscape Monitor Dashboard operation.
type SapLandscapeMonitorListResult struct {
	// The URL to get the next set of SAP Landscape Monitor Dashboard.
	NextLink *string

	// The list of Sap Landscape Monitor configuration.
	Value []*SapLandscapeMonitor
}

// SapLandscapeMonitorMetricThresholds - Gets or sets the Threshold Values for Top Metrics Health.
type SapLandscapeMonitorMetricThresholds struct {
	// Gets or sets the threshold value for Green.
	Green *float32

	// Gets or sets the name of the threshold.
	Name *string

	// Gets or sets the threshold value for Red.
	Red *float32

	// Gets or sets the threshold value for Yellow.
	Yellow *float32
}

// SapLandscapeMonitorProperties - Gets or sets the properties for Sap Landscape Monitor Dashboard.
type SapLandscapeMonitorProperties struct {
	// Gets or sets the SID groupings by landscape and Environment.
	Grouping *SapLandscapeMonitorPropertiesGrouping

	// Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
	TopMetricsThresholds []*SapLandscapeMonitorMetricThresholds

	// READ-ONLY; State of provisioning of the SAP monitor.
	ProvisioningState *SapLandscapeMonitorProvisioningState
}

// SapLandscapeMonitorPropertiesGrouping - Gets or sets the SID groupings by landscape and Environment.
type SapLandscapeMonitorPropertiesGrouping struct {
	// Gets or sets the list of landscape to SID mappings.
	Landscape []*SapLandscapeMonitorSidMapping

	// Gets or sets the list of Sap Applications to SID mappings.
	SapApplication []*SapLandscapeMonitorSidMapping
}

// SapLandscapeMonitorSidMapping - Gets or sets the mapping for SID to Environment/Applications.
type SapLandscapeMonitorSidMapping struct {
	// Gets or sets the name of the grouping.
	Name *string

	// Gets or sets the list of SID's.
	TopSid []*string
}

// SapNetWeaverProviderInstanceProperties - Gets or sets the provider properties.
type SapNetWeaverProviderInstanceProperties struct {
	// REQUIRED; The provider type. For example, the value can be SapHana.
	ProviderType *string

	// Gets or sets the blob URI to SSL certificate for the SAP system.
	SSLCertificateURI *string

	// Gets or sets certificate preference if secure communication is enabled.
	SSLPreference *SSLPreference

	// Gets or sets the SAP Client ID.
	SapClientID *string

	// Gets or sets the list of HostFile Entries
	SapHostFileEntries []*string

	// Gets or sets the target virtual machine IP Address/FQDN.
	SapHostname *string

	// Gets or sets the instance number of SAP NetWeaver.
	SapInstanceNr *string

	// Sets the SAP password.
	SapPassword *string

	// Gets or sets the key vault URI to secret with the SAP password.
	SapPasswordURI *string

	// Gets or sets the SAP HTTP port number.
	SapPortNumber *string

	// Gets or sets the SAP System Identifier
	SapSid *string

	// Gets or sets the SAP user name.
	SapUsername *string
}

// GetProviderSpecificProperties implements the ProviderSpecificPropertiesClassification interface for type SapNetWeaverProviderInstanceProperties.
func (s *SapNetWeaverProviderInstanceProperties) GetProviderSpecificProperties() *ProviderSpecificProperties {
	return &ProviderSpecificProperties{
		ProviderType: s.ProviderType,
	}
}

// ServiceInitiatedSoftwareConfiguration - The SAP Software configuration Input when the software is to be installed by service.
type ServiceInitiatedSoftwareConfiguration struct {
	// REQUIRED; The URL to the SAP Build of Materials(BOM) file.
	BomURL *string

	// REQUIRED; The SSH private key.
	SSHPrivateKey *string

	// REQUIRED; The SAP bits storage account id.
	SapBitsStorageAccountID *string

	// REQUIRED; The FQDN to set for the SAP system during install.
	SapFqdn *string

	// REQUIRED; The SAP software installation Type.
	SoftwareInstallationType *SAPSoftwareInstallationType

	// REQUIRED; The software version to install.
	SoftwareVersion *string

	// Gets or sets the HA software configuration.
	HighAvailabilitySoftwareConfiguration *HighAvailabilitySoftwareConfiguration
}

// GetSoftwareConfiguration implements the SoftwareConfigurationClassification interface for type ServiceInitiatedSoftwareConfiguration.
func (s *ServiceInitiatedSoftwareConfiguration) GetSoftwareConfiguration() *SoftwareConfiguration {
	return &SoftwareConfiguration{
		SoftwareInstallationType: s.SoftwareInstallationType,
	}
}

// SharedStorageResourceNames - The resource names object for shared storage.
type SharedStorageResourceNames struct {
	// The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
	SharedStorageAccountName *string

	// The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
	SharedStorageAccountPrivateEndPointName *string
}

// SingleServerConfiguration - Gets or sets the single server configuration. For prerequisites for creating the infrastructure,
// please see here [https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409]
type SingleServerConfiguration struct {
	// REQUIRED; The application resource group where SAP system resources will be deployed.
	AppResourceGroup *string

	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType

	// REQUIRED; The subnet id.
	SubnetID *string

	// REQUIRED; Gets or sets the virtual machine configuration.
	VirtualMachineConfiguration *VirtualMachineConfiguration

	// The set of custom names to be used for underlying azure resources that are part of the SAP system.
	CustomResourceNames SingleServerCustomResourceNamesClassification

	// The database type.
	DatabaseType *SAPDatabaseType

	// Gets or sets the disk configuration.
	DbDiskConfiguration *DiskConfiguration

	// Network configuration for the server
	NetworkConfiguration *NetworkConfiguration
}

// GetInfrastructureConfiguration implements the InfrastructureConfigurationClassification interface for type SingleServerConfiguration.
func (s *SingleServerConfiguration) GetInfrastructureConfiguration() *InfrastructureConfiguration {
	return &InfrastructureConfiguration{
		AppResourceGroup: s.AppResourceGroup,
		DeploymentType:   s.DeploymentType,
	}
}

// SingleServerCustomResourceNames - The resource-names input to specify custom names for underlying azure resources that
// are part of a single server SAP system.
type SingleServerCustomResourceNames struct {
	// REQUIRED; The pattern type to be used for resource naming.
	NamingPatternType *NamingPatternType
}

// GetSingleServerCustomResourceNames implements the SingleServerCustomResourceNamesClassification interface for type SingleServerCustomResourceNames.
func (s *SingleServerCustomResourceNames) GetSingleServerCustomResourceNames() *SingleServerCustomResourceNames {
	return s
}

// SingleServerFullResourceNames - The resource name object where the specified values will be full resource names of the
// corresponding resources in a single server SAP system.
type SingleServerFullResourceNames struct {
	// REQUIRED; The pattern type to be used for resource naming.
	NamingPatternType *NamingPatternType

	// The resource names object for virtual machine and related resources.
	VirtualMachine *VirtualMachineResourceNames
}

// GetSingleServerCustomResourceNames implements the SingleServerCustomResourceNamesClassification interface for type SingleServerFullResourceNames.
func (s *SingleServerFullResourceNames) GetSingleServerCustomResourceNames() *SingleServerCustomResourceNames {
	return &SingleServerCustomResourceNames{
		NamingPatternType: s.NamingPatternType,
	}
}

// SingleServerRecommendationResult - The recommended configuration for a single server SAP system.
type SingleServerRecommendationResult struct {
	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType

	// The recommended VM SKU for single server.
	VMSKU *string
}

// GetSAPSizingRecommendationResult implements the SAPSizingRecommendationResultClassification interface for type SingleServerRecommendationResult.
func (s *SingleServerRecommendationResult) GetSAPSizingRecommendationResult() *SAPSizingRecommendationResult {
	return &SAPSizingRecommendationResult{
		DeploymentType: s.DeploymentType,
	}
}

// SkipFileShareConfiguration - Gets or sets the file share configuration for scenarios where transport directory fileshare
// is not created or required.
type SkipFileShareConfiguration struct {
	// REQUIRED; The type of file share config.
	ConfigurationType *ConfigurationType
}

// GetFileShareConfiguration implements the FileShareConfigurationClassification interface for type SkipFileShareConfiguration.
func (s *SkipFileShareConfiguration) GetFileShareConfiguration() *FileShareConfiguration {
	return &FileShareConfiguration{
		ConfigurationType: s.ConfigurationType,
	}
}

// SoftwareConfiguration - The SAP Software configuration Input.
type SoftwareConfiguration struct {
	// REQUIRED; The SAP software installation Type.
	SoftwareInstallationType *SAPSoftwareInstallationType
}

// GetSoftwareConfiguration implements the SoftwareConfigurationClassification interface for type SoftwareConfiguration.
func (s *SoftwareConfiguration) GetSoftwareConfiguration() *SoftwareConfiguration { return s }

// StopRequest - Stop SAP instance(s) request body.
type StopRequest struct {
	// This parameter defines how long (in seconds) the soft shutdown waits until the RFC/HTTP clients no longer consider the
	// server for calls with load balancing. Value 0 means that the kernel does not
	// wait, but goes directly into the next shutdown state, i.e. hard stop.
	SoftStopTimeoutSeconds *int64
}

// StorageConfiguration - Gets or sets the storage configuration.
type StorageConfiguration struct {
	// The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount
	// flow if storage configuration is missing.
	TransportFileShareConfiguration FileShareConfigurationClassification
}

// StorageInformation - Storage details of all the Storage accounts attached to the VM. For e.g. NFS on AFS Shared Storage.
type StorageInformation struct {
	// READ-ONLY
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Tags field of the resource.
type Tags struct {
	// Tags field of the resource.
	Tags map[string]*string
}

// ThreeTierConfiguration - Gets or sets the three tier SAP configuration. For prerequisites for creating the infrastructure,
// please see here [https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409]
type ThreeTierConfiguration struct {
	// REQUIRED; The application resource group where SAP system resources will be deployed.
	AppResourceGroup *string

	// REQUIRED; The application server configuration.
	ApplicationServer *ApplicationServerConfiguration

	// REQUIRED; The central server configuration.
	CentralServer *CentralServerConfiguration

	// REQUIRED; The database configuration.
	DatabaseServer *DatabaseConfiguration

	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType

	// The set of custom names to be used for underlying azure resources that are part of the SAP system.
	CustomResourceNames ThreeTierCustomResourceNamesClassification

	// The high availability configuration.
	HighAvailabilityConfig *HighAvailabilityConfiguration

	// Network configuration common to all servers
	NetworkConfiguration *NetworkConfiguration

	// The storage configuration.
	StorageConfiguration *StorageConfiguration
}

// GetInfrastructureConfiguration implements the InfrastructureConfigurationClassification interface for type ThreeTierConfiguration.
func (t *ThreeTierConfiguration) GetInfrastructureConfiguration() *InfrastructureConfiguration {
	return &InfrastructureConfiguration{
		AppResourceGroup: t.AppResourceGroup,
		DeploymentType:   t.DeploymentType,
	}
}

// ThreeTierCustomResourceNames - The resource-names input to specify custom names for underlying azure resources that are
// part of a three tier SAP system.
type ThreeTierCustomResourceNames struct {
	// REQUIRED; The pattern type to be used for resource naming.
	NamingPatternType *NamingPatternType
}

// GetThreeTierCustomResourceNames implements the ThreeTierCustomResourceNamesClassification interface for type ThreeTierCustomResourceNames.
func (t *ThreeTierCustomResourceNames) GetThreeTierCustomResourceNames() *ThreeTierCustomResourceNames {
	return t
}

// ThreeTierFullResourceNames - The resource name object where the specified values will be full resource names of the corresponding
// resources in a three tier SAP system.
type ThreeTierFullResourceNames struct {
	// REQUIRED; The pattern type to be used for resource naming.
	NamingPatternType *NamingPatternType

	// The full resource names object for application layer resources. The number of entries in this list should be equal to the
	// number VMs to be created for application layer.
	ApplicationServer *ApplicationServerFullResourceNames

	// The full resource names object for central server layer resources.
	CentralServer *CentralServerFullResourceNames

	// The full resource names object for database layer resources. The number of entries in this list should be equal to the
	// number VMs to be created for database layer.
	DatabaseServer *DatabaseServerFullResourceNames

	// The resource names object for shared storage.
	SharedStorage *SharedStorageResourceNames
}

// GetThreeTierCustomResourceNames implements the ThreeTierCustomResourceNamesClassification interface for type ThreeTierFullResourceNames.
func (t *ThreeTierFullResourceNames) GetThreeTierCustomResourceNames() *ThreeTierCustomResourceNames {
	return &ThreeTierCustomResourceNames{
		NamingPatternType: t.NamingPatternType,
	}
}

// ThreeTierRecommendationResult - The recommended configuration for a three tier SAP system.
type ThreeTierRecommendationResult struct {
	// REQUIRED; The type of SAP deployment, single server or Three tier.
	DeploymentType *SAPDeploymentType

	// The application server instance count.
	ApplicationServerInstanceCount *int64

	// The application server VM SKU.
	ApplicationServerVMSKU *string

	// The central server instance count.
	CentralServerInstanceCount *int64

	// The central server VM SKU.
	CentralServerVMSKU *string

	// The database server instance count.
	DatabaseInstanceCount *int64

	// The database VM SKU.
	DbVMSKU *string
}

// GetSAPSizingRecommendationResult implements the SAPSizingRecommendationResultClassification interface for type ThreeTierRecommendationResult.
func (t *ThreeTierRecommendationResult) GetSAPSizingRecommendationResult() *SAPSizingRecommendationResult {
	return &SAPSizingRecommendationResult{
		DeploymentType: t.DeploymentType,
	}
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UpdateMonitorRequest - Defines the request body for updating SAP monitor resource.
type UpdateMonitorRequest struct {
	// [currently not in use] Managed service identity(user assigned identities)
	Identity *UserAssignedServiceIdentity

	// Gets or sets the Resource tags.
	Tags map[string]*string
}

// UpdateSAPApplicationInstanceRequest - Defines the request body for updating SAP Application Instance.
type UpdateSAPApplicationInstanceRequest struct {
	// Gets or sets the Resource tags.
	Tags map[string]*string
}

// UpdateSAPCentralInstanceRequest - Defines the request body for updating SAP Central Instance.
type UpdateSAPCentralInstanceRequest struct {
	// Gets or sets the Resource tags.
	Tags map[string]*string
}

// UpdateSAPDatabaseInstanceRequest - Defines the request body for updating SAP Database Instance.
type UpdateSAPDatabaseInstanceRequest struct {
	// Gets or sets the Resource tags.
	Tags map[string]*string
}

// UpdateSAPVirtualInstanceRequest - Defines the request body for updating Virtual Instance for SAP.
type UpdateSAPVirtualInstanceRequest struct {
	// A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit
	// the ACSS how-to-guide.
	Identity *UserAssignedServiceIdentity

	// Gets or sets the Resource tags.
	Tags map[string]*string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// UserAssignedServiceIdentity - A pre-created user assigned identity with appropriate roles assigned. To learn more on identity
// and roles required, visit the ACSS how-to-guide.
type UserAssignedServiceIdentity struct {
	// REQUIRED; Type of manage identity
	Type *ManagedServiceIdentityType

	// User assigned identities dictionary
	UserAssignedIdentities map[string]*UserAssignedIdentity
}

// VirtualMachineConfiguration - Defines the virtual machine configuration.
type VirtualMachineConfiguration struct {
	// REQUIRED; The image reference.
	ImageReference *ImageReference

	// REQUIRED; The OS profile.
	OSProfile *OSProfile

	// REQUIRED; The virtual machine size.
	VMSize *string
}

// VirtualMachineResourceNames - The resource names object for virtual machine and related resources.
type VirtualMachineResourceNames struct {
	// The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per
	// volume. Currently supported volumes for database layer are ['hana/data',
	// 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
	DataDiskNames map[string][]*string

	// The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than
	// or equal to 13 characters long. If this value is not provided, vmName will be
	// used as host name.
	HostName *string

	// The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported
	// per virtual machine.
	NetworkInterfaces []*NetworkInterfaceResourceNames

	// The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default
	// naming standards (prefixed with vm name). There is only one OS disk attached per
	// Virtual Machine.
	OSDiskName *string

	// The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service
	// uses a default name based on the deployment type. For SingleServer, default name
	// is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end
	// in case of more than 1 vm per layer. For distributed and HA-AvSet systems,
	// default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
	VMName *string
}

// WindowsConfiguration - Specifies Windows operating system settings on the virtual machine.
type WindowsConfiguration struct {
	// REQUIRED; The OS Type
	OSType *OSType
}

// GetOSConfiguration implements the OSConfigurationClassification interface for type WindowsConfiguration.
func (w *WindowsConfiguration) GetOSConfiguration() *OSConfiguration {
	return &OSConfiguration{
		OSType: w.OSType,
	}
}
