//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/workloads/armworkloads"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSizingRecommendations_S4HANA_Distributed.json
func ExampleClient_SAPSizingRecommendations_sapSizingRecommendationsS4HanaDistributed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSizingRecommendations(ctx, "centralus", &armworkloads.ClientSAPSizingRecommendationsOptions{SAPSizingRecommendation: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armworkloads.ClientSAPSizingRecommendationsResponse{
	// 	                            SAPSizingRecommendationResultClassification: &armworkloads.ThreeTierRecommendationResult{
	// 		DeploymentType: to.Ptr(armworkloads.SAPDeploymentTypeThreeTier),
	// 		ApplicationServerInstanceCount: to.Ptr[int64](2),
	// 		ApplicationServerVMSKU: to.Ptr("Standard_E8ds_v4"),
	// 		CentralServerInstanceCount: to.Ptr[int64](1),
	// 		CentralServerVMSKU: to.Ptr("Standard_E4ds_v4"),
	// 		DatabaseInstanceCount: to.Ptr[int64](1),
	// 		DbVMSKU: to.Ptr("Standard_M64s"),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSizingRecommendations_S4HANA_HA_AvSet.json
func ExampleClient_SAPSizingRecommendations_sapSizingRecommendationsS4HanaDistributedHaAvSet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSizingRecommendations(ctx, "centralus", &armworkloads.ClientSAPSizingRecommendationsOptions{SAPSizingRecommendation: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armworkloads.ClientSAPSizingRecommendationsResponse{
	// 	                            SAPSizingRecommendationResultClassification: &armworkloads.ThreeTierRecommendationResult{
	// 		DeploymentType: to.Ptr(armworkloads.SAPDeploymentTypeThreeTier),
	// 		ApplicationServerInstanceCount: to.Ptr[int64](3),
	// 		ApplicationServerVMSKU: to.Ptr("Standard_E16ds_v4"),
	// 		CentralServerInstanceCount: to.Ptr[int64](2),
	// 		CentralServerVMSKU: to.Ptr("Standard_E8ds_v4"),
	// 		DatabaseInstanceCount: to.Ptr[int64](2),
	// 		DbVMSKU: to.Ptr("Standard_M64s"),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSizingRecommendations_S4HANA_HA_AvZone.json
func ExampleClient_SAPSizingRecommendations_sapSizingRecommendationsS4HanaDistributedHaAvZone() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSizingRecommendations(ctx, "centralus", &armworkloads.ClientSAPSizingRecommendationsOptions{SAPSizingRecommendation: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armworkloads.ClientSAPSizingRecommendationsResponse{
	// 	                            SAPSizingRecommendationResultClassification: &armworkloads.ThreeTierRecommendationResult{
	// 		DeploymentType: to.Ptr(armworkloads.SAPDeploymentTypeThreeTier),
	// 		ApplicationServerInstanceCount: to.Ptr[int64](6),
	// 		ApplicationServerVMSKU: to.Ptr("Standard_E8ds_v4"),
	// 		CentralServerInstanceCount: to.Ptr[int64](2),
	// 		CentralServerVMSKU: to.Ptr("Standard_E4ds_v4"),
	// 		DatabaseInstanceCount: to.Ptr[int64](2),
	// 		DbVMSKU: to.Ptr("Standard_M64s"),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSizingRecommendations_S4HANA_SingleServer.json
func ExampleClient_SAPSizingRecommendations_sapSizingRecommendationsS4HanaSingleServer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSizingRecommendations(ctx, "centralus", &armworkloads.ClientSAPSizingRecommendationsOptions{SAPSizingRecommendation: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armworkloads.ClientSAPSizingRecommendationsResponse{
	// 	                            SAPSizingRecommendationResultClassification: &armworkloads.SingleServerRecommendationResult{
	// 		DeploymentType: to.Ptr(armworkloads.SAPDeploymentTypeSingleServer),
	// 		VMSKU: to.Ptr("Standard_M128s"),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSupportedSkus_Distributed.json
func ExampleClient_SAPSupportedSKU_sapSupportedSkusDistributed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSupportedSKU(ctx, "centralus", &armworkloads.ClientSAPSupportedSKUOptions{SAPSupportedSKU: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPSupportedResourceSKUsResult = armworkloads.SAPSupportedResourceSKUsResult{
	// 	SupportedSKUs: []*armworkloads.SAPSupportedSKU{
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E4ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E8ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E16ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E20ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E32ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E48ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E64ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32ts"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208s_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416s_v2"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSupportedSkus_DistributedHA_AvSet.json
func ExampleClient_SAPSupportedSKU_sapSupportedSkusDistributedHaAvSet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSupportedSKU(ctx, "centralus", &armworkloads.ClientSAPSupportedSKUOptions{SAPSupportedSKU: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPSupportedResourceSKUsResult = armworkloads.SAPSupportedResourceSKUsResult{
	// 	SupportedSKUs: []*armworkloads.SAPSupportedSKU{
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E4ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E8ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E16ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E20ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E32ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E48ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E64ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32ts"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208s_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(false),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416s_v2"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSupportedSkus_DistributedHA_AvZone.json
func ExampleClient_SAPSupportedSKU_sapSupportedSkusDistributedHaAvZone() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSupportedSKU(ctx, "centralus", &armworkloads.ClientSAPSupportedSKUOptions{SAPSupportedSKU: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPSupportedResourceSKUsResult = armworkloads.SAPSupportedResourceSKUsResult{
	// 	SupportedSKUs: []*armworkloads.SAPSupportedSKU{
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_E32ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_E48ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_E64ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32ts"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64Is"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M64s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128ms"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M128s"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M208s_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416ms_v2"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M416s_v2"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPSupportedSkus_SingleServer.json
func ExampleClient_SAPSupportedSKU_sapSupportedSkusSingleServer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPSupportedSKU(ctx, "centralus", &armworkloads.ClientSAPSupportedSKUOptions{SAPSupportedSKU: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPSupportedResourceSKUsResult = armworkloads.SAPSupportedResourceSKUsResult{
	// 	SupportedSKUs: []*armworkloads.SAPSupportedSKU{
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E32ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E48ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(false),
	// 			VMSKU: to.Ptr("Standard_E64ds_v4"),
	// 		},
	// 		{
	// 			IsAppServerCertified: to.Ptr(true),
	// 			IsDatabaseCertified: to.Ptr(true),
	// 			VMSKU: to.Ptr("Standard_M32ts"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPDiskConfigurations_NonProd.json
func ExampleClient_SAPDiskConfigurations_sapDiskConfigurationsNonProd() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPDiskConfigurations(ctx, "centralus", &armworkloads.ClientSAPDiskConfigurationsOptions{SAPDiskConfigurations: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPDiskConfigurationsResult = armworkloads.SAPDiskConfigurationsResult{
	// 	VolumeConfigurations: map[string]*armworkloads.SAPDiskConfiguration{
	// 		"backup": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](2),
	// 				SizeGB: to.Ptr[int64](256),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("E10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E15"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E20"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P15"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P20"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/data": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](4),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](5),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](4),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/log": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](3),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](5),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](3),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/shared": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](256),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P15"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P20"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P30"),
	// 					IopsReadWrite: to.Ptr[int64](5000),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](200),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](1024),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P40"),
	// 					IopsReadWrite: to.Ptr[int64](7500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](250),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](2048),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P50"),
	// 					IopsReadWrite: to.Ptr[int64](7500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](250),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](4096),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E15"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E20"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E30"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](1024),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E40"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](2048),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E50"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](4096),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 			}},
	// 		},
	// 		"os": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](64),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P6"),
	// 					IopsReadWrite: to.Ptr[int64](240),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](50),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](64),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P6"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](64),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 			}},
	// 		},
	// 		"usr/sap": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E15"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("E20"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](60),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNameStandardSSDLRS),
	// 					},
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPDiskConfigurations_Prod.json
func ExampleClient_SAPDiskConfigurations_sapDiskConfigurationsProd() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPDiskConfigurations(ctx, "centralus", &armworkloads.ClientSAPDiskConfigurationsOptions{SAPDiskConfigurations: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPDiskConfigurationsResult = armworkloads.SAPDiskConfigurationsResult{
	// 	VolumeConfigurations: map[string]*armworkloads.SAPDiskConfiguration{
	// 		"backup": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](2),
	// 				SizeGB: to.Ptr[int64](256),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P15"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P20"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](6),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](0),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/data": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](4),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](5),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](4),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/log": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](3),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](5),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](3),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"hana/shared": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](256),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P15"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P20"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P30"),
	// 					IopsReadWrite: to.Ptr[int64](5000),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](200),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](1024),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P40"),
	// 					IopsReadWrite: to.Ptr[int64](7500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](250),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](2048),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P50"),
	// 					IopsReadWrite: to.Ptr[int64](7500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](250),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](4096),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"os": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](64),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P6"),
	// 					IopsReadWrite: to.Ptr[int64](240),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](50),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](64),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 		"usr/sap": &armworkloads.SAPDiskConfiguration{
	// 			RecommendedConfiguration: &armworkloads.DiskVolumeConfiguration{
	// 				Count: to.Ptr[int64](1),
	// 				SizeGB: to.Ptr[int64](128),
	// 				SKU: &armworkloads.DiskSKU{
	// 					Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 				},
	// 			},
	// 			SupportedConfigurations: []*armworkloads.DiskDetails{
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](500),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](100),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](128),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](1100),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](125),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](256),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 				},
	// 				{
	// 					DiskTier: to.Ptr("P10"),
	// 					IopsReadWrite: to.Ptr[int64](2300),
	// 					MaximumSupportedDiskCount: to.Ptr[int64](1),
	// 					MbpsReadWrite: to.Ptr[int64](150),
	// 					MinimumSupportedDiskCount: to.Ptr[int64](1),
	// 					SizeGB: to.Ptr[int64](512),
	// 					SKU: &armworkloads.DiskSKU{
	// 						Name: to.Ptr(armworkloads.DiskSKUNamePremiumLRS),
	// 					},
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPAvailabilityZoneDetails_eastus.json
func ExampleClient_SAPAvailabilityZoneDetails_sapAvailabilityZoneDetailsEastus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPAvailabilityZoneDetails(ctx, "centralus", &armworkloads.ClientSAPAvailabilityZoneDetailsOptions{SAPAvailabilityZoneDetails: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPAvailabilityZoneDetailsResult = armworkloads.SAPAvailabilityZoneDetailsResult{
	// 	AvailabilityZonePairs: []*armworkloads.SAPAvailabilityZonePair{
	// 		{
	// 			ZoneA: to.Ptr[int64](1),
	// 			ZoneB: to.Ptr[int64](2),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPAvailabilityZoneDetails_northeurope.json
func ExampleClient_SAPAvailabilityZoneDetails_sapAvailabilityZoneDetailsNortheurope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().SAPAvailabilityZoneDetails(ctx, "centralus", &armworkloads.ClientSAPAvailabilityZoneDetailsOptions{SAPAvailabilityZoneDetails: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPAvailabilityZoneDetailsResult = armworkloads.SAPAvailabilityZoneDetailsResult{
	// 	AvailabilityZonePairs: []*armworkloads.SAPAvailabilityZonePair{
	// 		{
	// 			ZoneA: to.Ptr[int64](2),
	// 			ZoneB: to.Ptr[int64](3),
	// 	}},
	// }
}
