//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/voiceservices/armvoiceservices"
	"net/http"
	"net/url"
	"regexp"
)

// TestLinesServer is a fake server for instances of the armvoiceservices.TestLinesClient type.
type TestLinesServer struct {
	// BeginCreateOrUpdate is the fake for method TestLinesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, communicationsGatewayName string, testLineName string, resource armvoiceservices.TestLine, options *armvoiceservices.TestLinesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armvoiceservices.TestLinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method TestLinesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, communicationsGatewayName string, testLineName string, options *armvoiceservices.TestLinesClientBeginDeleteOptions) (resp azfake.PollerResponder[armvoiceservices.TestLinesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TestLinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, communicationsGatewayName string, testLineName string, options *armvoiceservices.TestLinesClientGetOptions) (resp azfake.Responder[armvoiceservices.TestLinesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByCommunicationsGatewayPager is the fake for method TestLinesClient.NewListByCommunicationsGatewayPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCommunicationsGatewayPager func(resourceGroupName string, communicationsGatewayName string, options *armvoiceservices.TestLinesClientListByCommunicationsGatewayOptions) (resp azfake.PagerResponder[armvoiceservices.TestLinesClientListByCommunicationsGatewayResponse])

	// Update is the fake for method TestLinesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, communicationsGatewayName string, testLineName string, properties armvoiceservices.TestLineUpdate, options *armvoiceservices.TestLinesClientUpdateOptions) (resp azfake.Responder[armvoiceservices.TestLinesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewTestLinesServerTransport creates a new instance of TestLinesServerTransport with the provided implementation.
// The returned TestLinesServerTransport instance is connected to an instance of armvoiceservices.TestLinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTestLinesServerTransport(srv *TestLinesServer) *TestLinesServerTransport {
	return &TestLinesServerTransport{
		srv:                                 srv,
		beginCreateOrUpdate:                 newTracker[azfake.PollerResponder[armvoiceservices.TestLinesClientCreateOrUpdateResponse]](),
		beginDelete:                         newTracker[azfake.PollerResponder[armvoiceservices.TestLinesClientDeleteResponse]](),
		newListByCommunicationsGatewayPager: newTracker[azfake.PagerResponder[armvoiceservices.TestLinesClientListByCommunicationsGatewayResponse]](),
	}
}

// TestLinesServerTransport connects instances of armvoiceservices.TestLinesClient to instances of TestLinesServer.
// Don't use this type directly, use NewTestLinesServerTransport instead.
type TestLinesServerTransport struct {
	srv                                 *TestLinesServer
	beginCreateOrUpdate                 *tracker[azfake.PollerResponder[armvoiceservices.TestLinesClientCreateOrUpdateResponse]]
	beginDelete                         *tracker[azfake.PollerResponder[armvoiceservices.TestLinesClientDeleteResponse]]
	newListByCommunicationsGatewayPager *tracker[azfake.PagerResponder[armvoiceservices.TestLinesClientListByCommunicationsGatewayResponse]]
}

// Do implements the policy.Transporter interface for TestLinesServerTransport.
func (t *TestLinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TestLinesClient.BeginCreateOrUpdate":
		resp, err = t.dispatchBeginCreateOrUpdate(req)
	case "TestLinesClient.BeginDelete":
		resp, err = t.dispatchBeginDelete(req)
	case "TestLinesClient.Get":
		resp, err = t.dispatchGet(req)
	case "TestLinesClient.NewListByCommunicationsGatewayPager":
		resp, err = t.dispatchNewListByCommunicationsGatewayPager(req)
	case "TestLinesClient.Update":
		resp, err = t.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TestLinesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := t.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/communicationsGateways/(?P<communicationsGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testLines/(?P<testLineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armvoiceservices.TestLine](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		communicationsGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("communicationsGatewayName")])
		if err != nil {
			return nil, err
		}
		testLineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testLineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, communicationsGatewayNameParam, testLineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		t.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		t.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		t.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (t *TestLinesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := t.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/communicationsGateways/(?P<communicationsGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testLines/(?P<testLineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		communicationsGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("communicationsGatewayName")])
		if err != nil {
			return nil, err
		}
		testLineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testLineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDelete(req.Context(), resourceGroupNameParam, communicationsGatewayNameParam, testLineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		t.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		t.beginDelete.remove(req)
	}

	return resp, nil
}

func (t *TestLinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/communicationsGateways/(?P<communicationsGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testLines/(?P<testLineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	communicationsGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("communicationsGatewayName")])
	if err != nil {
		return nil, err
	}
	testLineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testLineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, communicationsGatewayNameParam, testLineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestLine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestLinesServerTransport) dispatchNewListByCommunicationsGatewayPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByCommunicationsGatewayPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCommunicationsGatewayPager not implemented")}
	}
	newListByCommunicationsGatewayPager := t.newListByCommunicationsGatewayPager.get(req)
	if newListByCommunicationsGatewayPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/communicationsGateways/(?P<communicationsGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testLines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		communicationsGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("communicationsGatewayName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByCommunicationsGatewayPager(resourceGroupNameParam, communicationsGatewayNameParam, nil)
		newListByCommunicationsGatewayPager = &resp
		t.newListByCommunicationsGatewayPager.add(req, newListByCommunicationsGatewayPager)
		server.PagerResponderInjectNextLinks(newListByCommunicationsGatewayPager, req, func(page *armvoiceservices.TestLinesClientListByCommunicationsGatewayResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCommunicationsGatewayPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByCommunicationsGatewayPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCommunicationsGatewayPager) {
		t.newListByCommunicationsGatewayPager.remove(req)
	}
	return resp, nil
}

func (t *TestLinesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/communicationsGateways/(?P<communicationsGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testLines/(?P<testLineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armvoiceservices.TestLineUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	communicationsGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("communicationsGatewayName")])
	if err != nil {
		return nil, err
	}
	testLineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testLineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Update(req.Context(), resourceGroupNameParam, communicationsGatewayNameParam, testLineNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestLine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
