//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/voiceservices/armvoiceservices"
	"net/http"
	"net/url"
	"regexp"
)

// NameAvailabilityServer is a fake server for instances of the armvoiceservices.NameAvailabilityClient type.
type NameAvailabilityServer struct {
	// CheckLocal is the fake for method NameAvailabilityClient.CheckLocal
	// HTTP status codes to indicate success: http.StatusOK
	CheckLocal func(ctx context.Context, location string, body armvoiceservices.CheckNameAvailabilityRequest, options *armvoiceservices.NameAvailabilityClientCheckLocalOptions) (resp azfake.Responder[armvoiceservices.NameAvailabilityClientCheckLocalResponse], errResp azfake.ErrorResponder)
}

// NewNameAvailabilityServerTransport creates a new instance of NameAvailabilityServerTransport with the provided implementation.
// The returned NameAvailabilityServerTransport instance is connected to an instance of armvoiceservices.NameAvailabilityClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNameAvailabilityServerTransport(srv *NameAvailabilityServer) *NameAvailabilityServerTransport {
	return &NameAvailabilityServerTransport{srv: srv}
}

// NameAvailabilityServerTransport connects instances of armvoiceservices.NameAvailabilityClient to instances of NameAvailabilityServer.
// Don't use this type directly, use NewNameAvailabilityServerTransport instead.
type NameAvailabilityServerTransport struct {
	srv *NameAvailabilityServer
}

// Do implements the policy.Transporter interface for NameAvailabilityServerTransport.
func (n *NameAvailabilityServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NameAvailabilityClient.CheckLocal":
		resp, err = n.dispatchCheckLocal(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NameAvailabilityServerTransport) dispatchCheckLocal(req *http.Request) (*http.Response, error) {
	if n.srv.CheckLocal == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckLocal not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VoiceServices/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armvoiceservices.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.CheckLocal(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
