//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/vmwarecloudsimple/armvmwarecloudsimple"
	"net/http"
	"net/url"
	"regexp"
)

// VirtualMachineTemplatesServer is a fake server for instances of the armvmwarecloudsimple.VirtualMachineTemplatesClient type.
type VirtualMachineTemplatesServer struct {
	// Get is the fake for method VirtualMachineTemplatesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, regionID string, pcName string, virtualMachineTemplateName string, options *armvmwarecloudsimple.VirtualMachineTemplatesClientGetOptions) (resp azfake.Responder[armvmwarecloudsimple.VirtualMachineTemplatesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VirtualMachineTemplatesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(pcName string, regionID string, resourcePoolName string, options *armvmwarecloudsimple.VirtualMachineTemplatesClientListOptions) (resp azfake.PagerResponder[armvmwarecloudsimple.VirtualMachineTemplatesClientListResponse])
}

// NewVirtualMachineTemplatesServerTransport creates a new instance of VirtualMachineTemplatesServerTransport with the provided implementation.
// The returned VirtualMachineTemplatesServerTransport instance is connected to an instance of armvmwarecloudsimple.VirtualMachineTemplatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualMachineTemplatesServerTransport(srv *VirtualMachineTemplatesServer) *VirtualMachineTemplatesServerTransport {
	return &VirtualMachineTemplatesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armvmwarecloudsimple.VirtualMachineTemplatesClientListResponse]](),
	}
}

// VirtualMachineTemplatesServerTransport connects instances of armvmwarecloudsimple.VirtualMachineTemplatesClient to instances of VirtualMachineTemplatesServer.
// Don't use this type directly, use NewVirtualMachineTemplatesServerTransport instead.
type VirtualMachineTemplatesServerTransport struct {
	srv          *VirtualMachineTemplatesServer
	newListPager *tracker[azfake.PagerResponder[armvmwarecloudsimple.VirtualMachineTemplatesClientListResponse]]
}

// Do implements the policy.Transporter interface for VirtualMachineTemplatesServerTransport.
func (v *VirtualMachineTemplatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualMachineTemplatesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualMachineTemplatesClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualMachineTemplatesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachineTemplates/(?P<virtualMachineTemplateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
	if err != nil {
		return nil, err
	}
	pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
	if err != nil {
		return nil, err
	}
	virtualMachineTemplateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineTemplateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), regionIDParam, pcNameParam, virtualMachineTemplateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualMachineTemplate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachineTemplatesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachineTemplates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
		if err != nil {
			return nil, err
		}
		regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
		if err != nil {
			return nil, err
		}
		resourcePoolNameParam, err := url.QueryUnescape(qp.Get("resourcePoolName"))
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(pcNameParam, regionIDParam, resourcePoolNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armvmwarecloudsimple.VirtualMachineTemplatesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
