//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtimeseriesinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyCreateOrUpdateParameters.
func (a AccessPolicyCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyCreateOrUpdateParameters.
func (a *AccessPolicyCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyListResponse.
func (a AccessPolicyListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyListResponse.
func (a *AccessPolicyListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyMutableProperties.
func (a AccessPolicyMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "roles", a.Roles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyMutableProperties.
func (a *AccessPolicyMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &a.Roles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyResource.
func (a AccessPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyResource.
func (a *AccessPolicyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyResourceProperties.
func (a AccessPolicyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "principalObjectId", a.PrincipalObjectID)
	populate(objectMap, "roles", a.Roles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyResourceProperties.
func (a *AccessPolicyResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "principalObjectId":
			err = unpopulate(val, "PrincipalObjectID", &a.PrincipalObjectID)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &a.Roles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyUpdateParameters.
func (a AccessPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyUpdateParameters.
func (a *AccessPolicyUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureEventSourceProperties.
func (a AzureEventSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "eventSourceResourceId", a.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", a.IngressStartAt)
	populate(objectMap, "localTimestamp", a.LocalTimestamp)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "timestampPropertyName", a.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureEventSourceProperties.
func (a *AzureEventSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &a.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &a.IngressStartAt)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &a.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &a.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrUpdateTrackedResourceProperties.
func (c CreateOrUpdateTrackedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateOrUpdateTrackedResourceProperties.
func (c *CreateOrUpdateTrackedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentCreateOrUpdateParameters.
func (e EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = e.Kind
	populate(objectMap, "location", e.Location)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentCreateOrUpdateParameters.
func (e *EnvironmentCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &e.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentListResponse.
func (e EnvironmentListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentListResponse.
func (e *EnvironmentListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			e.Value, err = unmarshalEnvironmentResourceClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentResource.
func (e EnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = e.Kind
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentResource.
func (e *EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &e.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentResourceProperties.
func (e EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "dataAccessFqdn", e.DataAccessFqdn)
	populate(objectMap, "dataAccessId", e.DataAccessID)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentResourceProperties.
func (e *EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &e.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &e.DataAccessID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentStateDetails.
func (e EnvironmentStateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentStateDetails.
func (e *EnvironmentStateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentStatus.
func (e EnvironmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ingress", e.Ingress)
	populate(objectMap, "warmStorage", e.WarmStorage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentStatus.
func (e *EnvironmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ingress":
			err = unpopulate(val, "Ingress", &e.Ingress)
			delete(rawMsg, key)
		case "warmStorage":
			err = unpopulate(val, "WarmStorage", &e.WarmStorage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentUpdateParameters.
func (e EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = e.Kind
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentUpdateParameters.
func (e *EnvironmentUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCommonProperties.
func (e EventHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCommonProperties.
func (e *EventHubEventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCreateOrUpdateParameters.
func (e EventHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EventSourceKindMicrosoftEventHub
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCreateOrUpdateParameters.
func (e *EventHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCreationProperties.
func (e EventHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessKey", e.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCreationProperties.
func (e *EventHubEventSourceCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &e.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceMutableProperties.
func (e EventHubEventSourceMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sharedAccessKey", e.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceMutableProperties.
func (e *EventHubEventSourceMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &e.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceResource.
func (e EventHubEventSourceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = EventSourceResourceKindMicrosoftEventHub
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceResource.
func (e *EventHubEventSourceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceResourceProperties.
func (e EventHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceResourceProperties.
func (e *EventHubEventSourceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceUpdateParameters.
func (e EventHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EventSourceKindMicrosoftEventHub
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceUpdateParameters.
func (e *EventHubEventSourceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceCommonProperties.
func (e EventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceCommonProperties.
func (e *EventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceCreateOrUpdateParameters.
func (e EventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = e.Kind
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceCreateOrUpdateParameters.
func (e *EventSourceCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceListResponse.
func (e EventSourceListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceListResponse.
func (e *EventSourceListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			e.Value, err = unmarshalEventSourceResourceClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceMutableProperties.
func (e EventSourceMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceMutableProperties.
func (e *EventSourceMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceResource.
func (e EventSourceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = e.Kind
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceResource.
func (e *EventSourceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceUpdateParameters.
func (e EventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = e.Kind
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceUpdateParameters.
func (e *EventSourceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentCreateOrUpdateParameters.
func (g Gen1EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EnvironmentKindGen1
	populate(objectMap, "location", g.Location)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentCreateOrUpdateParameters.
func (g *Gen1EnvironmentCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentCreationProperties.
func (g Gen1EnvironmentCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataRetentionTime", g.DataRetentionTime)
	populate(objectMap, "partitionKeyProperties", g.PartitionKeyProperties)
	populate(objectMap, "storageLimitExceededBehavior", g.StorageLimitExceededBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentCreationProperties.
func (g *Gen1EnvironmentCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataRetentionTime":
			err = unpopulate(val, "DataRetentionTime", &g.DataRetentionTime)
			delete(rawMsg, key)
		case "partitionKeyProperties":
			err = unpopulate(val, "PartitionKeyProperties", &g.PartitionKeyProperties)
			delete(rawMsg, key)
		case "storageLimitExceededBehavior":
			err = unpopulate(val, "StorageLimitExceededBehavior", &g.StorageLimitExceededBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentMutableProperties.
func (g Gen1EnvironmentMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataRetentionTime", g.DataRetentionTime)
	populate(objectMap, "storageLimitExceededBehavior", g.StorageLimitExceededBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentMutableProperties.
func (g *Gen1EnvironmentMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataRetentionTime":
			err = unpopulate(val, "DataRetentionTime", &g.DataRetentionTime)
			delete(rawMsg, key)
		case "storageLimitExceededBehavior":
			err = unpopulate(val, "StorageLimitExceededBehavior", &g.StorageLimitExceededBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentResource.
func (g Gen1EnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	objectMap["kind"] = EnvironmentResourceKindGen1
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentResource.
func (g *Gen1EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentResourceProperties.
func (g Gen1EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", g.CreationTime)
	populate(objectMap, "dataAccessFqdn", g.DataAccessFqdn)
	populate(objectMap, "dataAccessId", g.DataAccessID)
	populate(objectMap, "dataRetentionTime", g.DataRetentionTime)
	populate(objectMap, "partitionKeyProperties", g.PartitionKeyProperties)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "storageLimitExceededBehavior", g.StorageLimitExceededBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentResourceProperties.
func (g *Gen1EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &g.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &g.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &g.DataAccessID)
			delete(rawMsg, key)
		case "dataRetentionTime":
			err = unpopulate(val, "DataRetentionTime", &g.DataRetentionTime)
			delete(rawMsg, key)
		case "partitionKeyProperties":
			err = unpopulate(val, "PartitionKeyProperties", &g.PartitionKeyProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "storageLimitExceededBehavior":
			err = unpopulate(val, "StorageLimitExceededBehavior", &g.StorageLimitExceededBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentUpdateParameters.
func (g Gen1EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EnvironmentKindGen1
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentUpdateParameters.
func (g *Gen1EnvironmentUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentCreateOrUpdateParameters.
func (g Gen2EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EnvironmentKindGen2
	populate(objectMap, "location", g.Location)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentCreateOrUpdateParameters.
func (g *Gen2EnvironmentCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentCreationProperties.
func (g Gen2EnvironmentCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageConfiguration", g.StorageConfiguration)
	populate(objectMap, "timeSeriesIdProperties", g.TimeSeriesIDProperties)
	populate(objectMap, "warmStoreConfiguration", g.WarmStoreConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentCreationProperties.
func (g *Gen2EnvironmentCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageConfiguration":
			err = unpopulate(val, "StorageConfiguration", &g.StorageConfiguration)
			delete(rawMsg, key)
		case "timeSeriesIdProperties":
			err = unpopulate(val, "TimeSeriesIDProperties", &g.TimeSeriesIDProperties)
			delete(rawMsg, key)
		case "warmStoreConfiguration":
			err = unpopulate(val, "WarmStoreConfiguration", &g.WarmStoreConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentMutableProperties.
func (g Gen2EnvironmentMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageConfiguration", g.StorageConfiguration)
	populate(objectMap, "warmStoreConfiguration", g.WarmStoreConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentMutableProperties.
func (g *Gen2EnvironmentMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageConfiguration":
			err = unpopulate(val, "StorageConfiguration", &g.StorageConfiguration)
			delete(rawMsg, key)
		case "warmStoreConfiguration":
			err = unpopulate(val, "WarmStoreConfiguration", &g.WarmStoreConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentResource.
func (g Gen2EnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	objectMap["kind"] = EnvironmentResourceKindGen2
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentResource.
func (g *Gen2EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentResourceProperties.
func (g Gen2EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", g.CreationTime)
	populate(objectMap, "dataAccessFqdn", g.DataAccessFqdn)
	populate(objectMap, "dataAccessId", g.DataAccessID)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "storageConfiguration", g.StorageConfiguration)
	populate(objectMap, "timeSeriesIdProperties", g.TimeSeriesIDProperties)
	populate(objectMap, "warmStoreConfiguration", g.WarmStoreConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentResourceProperties.
func (g *Gen2EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &g.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &g.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &g.DataAccessID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "storageConfiguration":
			err = unpopulate(val, "StorageConfiguration", &g.StorageConfiguration)
			delete(rawMsg, key)
		case "timeSeriesIdProperties":
			err = unpopulate(val, "TimeSeriesIDProperties", &g.TimeSeriesIDProperties)
			delete(rawMsg, key)
		case "warmStoreConfiguration":
			err = unpopulate(val, "WarmStoreConfiguration", &g.WarmStoreConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentUpdateParameters.
func (g Gen2EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EnvironmentKindGen2
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentUpdateParameters.
func (g *Gen2EnvironmentUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2StorageConfigurationInput.
func (g Gen2StorageConfigurationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", g.AccountName)
	populate(objectMap, "managementKey", g.ManagementKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2StorageConfigurationInput.
func (g *Gen2StorageConfigurationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &g.AccountName)
			delete(rawMsg, key)
		case "managementKey":
			err = unpopulate(val, "ManagementKey", &g.ManagementKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2StorageConfigurationMutableProperties.
func (g Gen2StorageConfigurationMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managementKey", g.ManagementKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2StorageConfigurationMutableProperties.
func (g *Gen2StorageConfigurationMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managementKey":
			err = unpopulate(val, "ManagementKey", &g.ManagementKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2StorageConfigurationOutput.
func (g Gen2StorageConfigurationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", g.AccountName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2StorageConfigurationOutput.
func (g *Gen2StorageConfigurationOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &g.AccountName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngressEnvironmentStatus.
func (i IngressEnvironmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", i.State)
	populate(objectMap, "stateDetails", i.StateDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngressEnvironmentStatus.
func (i *IngressEnvironmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "stateDetails":
			err = unpopulate(val, "StateDetails", &i.StateDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngressStartAtProperties.
func (i IngressStartAtProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "time", i.Time)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngressStartAtProperties.
func (i *IngressStartAtProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "time":
			err = unpopulate(val, "Time", &i.Time)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCommonProperties.
func (i IoTHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCommonProperties.
func (i *IoTHubEventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCreateOrUpdateParameters.
func (i IoTHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EventSourceKindMicrosoftIoTHub
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCreateOrUpdateParameters.
func (i *IoTHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCreationProperties.
func (i IoTHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sharedAccessKey", i.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCreationProperties.
func (i *IoTHubEventSourceCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &i.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceMutableProperties.
func (i IoTHubEventSourceMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sharedAccessKey", i.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceMutableProperties.
func (i *IoTHubEventSourceMutableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &i.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceResource.
func (i IoTHubEventSourceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = EventSourceResourceKindMicrosoftIoTHub
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceResource.
func (i *IoTHubEventSourceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceResourceProperties.
func (i IoTHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateDateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceResourceProperties.
func (i *IoTHubEventSourceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceUpdateParameters.
func (i IoTHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = EventSourceKindMicrosoftIoTHub
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceUpdateParameters.
func (i *IoTHubEventSourceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalTimestamp.
func (l LocalTimestamp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "format", l.Format)
	populate(objectMap, "timeZoneOffset", l.TimeZoneOffset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalTimestamp.
func (l *LocalTimestamp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "format":
			err = unpopulate(val, "Format", &l.Format)
			delete(rawMsg, key)
		case "timeZoneOffset":
			err = unpopulate(val, "TimeZoneOffset", &l.TimeZoneOffset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalTimestampTimeZoneOffset.
func (l LocalTimestampTimeZoneOffset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertyName", l.PropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalTimestampTimeZoneOffset.
func (l *LocalTimestampTimeZoneOffset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertyName":
			err = unpopulate(val, "PropertyName", &l.PropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricAvailability.
func (m MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", m.BlobDuration)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAvailability.
func (m *MetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &m.BlobDuration)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.OperationProperties)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "OperationProperties", &o.OperationProperties)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetCreateOrUpdateParameters.
func (r ReferenceDataSetCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetCreateOrUpdateParameters.
func (r *ReferenceDataSetCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetCreationProperties.
func (r ReferenceDataSetCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStringComparisonBehavior", r.DataStringComparisonBehavior)
	populate(objectMap, "keyProperties", r.KeyProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetCreationProperties.
func (r *ReferenceDataSetCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStringComparisonBehavior":
			err = unpopulate(val, "DataStringComparisonBehavior", &r.DataStringComparisonBehavior)
			delete(rawMsg, key)
		case "keyProperties":
			err = unpopulate(val, "KeyProperties", &r.KeyProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetKeyProperty.
func (r ReferenceDataSetKeyProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetKeyProperty.
func (r *ReferenceDataSetKeyProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetListResponse.
func (r ReferenceDataSetListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetListResponse.
func (r *ReferenceDataSetListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetResource.
func (r ReferenceDataSetResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetResource.
func (r *ReferenceDataSetResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetResourceProperties.
func (r ReferenceDataSetResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "dataStringComparisonBehavior", r.DataStringComparisonBehavior)
	populate(objectMap, "keyProperties", r.KeyProperties)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetResourceProperties.
func (r *ReferenceDataSetResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "dataStringComparisonBehavior":
			err = unpopulate(val, "DataStringComparisonBehavior", &r.DataStringComparisonBehavior)
			delete(rawMsg, key)
		case "keyProperties":
			err = unpopulate(val, "KeyProperties", &r.KeyProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetUpdateParameters.
func (r ReferenceDataSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetUpdateParameters.
func (r *ReferenceDataSetUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProperties.
func (r ResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProperties.
func (r *ResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeSeriesIDProperty.
func (t TimeSeriesIDProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeSeriesIDProperty.
func (t *TimeSeriesIDProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WarmStorageEnvironmentStatus.
func (w WarmStorageEnvironmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertiesUsage", w.PropertiesUsage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WarmStorageEnvironmentStatus.
func (w *WarmStorageEnvironmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertiesUsage":
			err = unpopulate(val, "PropertiesUsage", &w.PropertiesUsage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WarmStoragePropertiesUsage.
func (w WarmStoragePropertiesUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", w.State)
	populate(objectMap, "stateDetails", w.StateDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WarmStoragePropertiesUsage.
func (w *WarmStoragePropertiesUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "stateDetails":
			err = unpopulate(val, "StateDetails", &w.StateDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WarmStoragePropertiesUsageStateDetails.
func (w WarmStoragePropertiesUsageStateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentCount", w.CurrentCount)
	populate(objectMap, "maxCount", w.MaxCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WarmStoragePropertiesUsageStateDetails.
func (w *WarmStoragePropertiesUsageStateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentCount":
			err = unpopulate(val, "CurrentCount", &w.CurrentCount)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &w.MaxCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WarmStoreConfigurationProperties.
func (w WarmStoreConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataRetention", w.DataRetention)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WarmStoreConfigurationProperties.
func (w *WarmStoreConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataRetention":
			err = unpopulate(val, "DataRetention", &w.DataRetention)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
