//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The Azure subscription ID. This is a GUID-formatted string.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAccountsClient creates a new instance of AccountsClient.
func (c *ClientFactory) NewAccountsClient() *AccountsClient {
	subClient, _ := NewAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAnalysisResultsClient creates a new instance of AnalysisResultsClient.
func (c *ClientFactory) NewAnalysisResultsClient() *AnalysisResultsClient {
	subClient, _ := NewAnalysisResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAvailableOSClient creates a new instance of AvailableOSClient.
func (c *ClientFactory) NewAvailableOSClient() *AvailableOSClient {
	subClient, _ := NewAvailableOSClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCustomerEventsClient creates a new instance of CustomerEventsClient.
func (c *ClientFactory) NewCustomerEventsClient() *CustomerEventsClient {
	subClient, _ := NewCustomerEventsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEmailEventsClient creates a new instance of EmailEventsClient.
func (c *ClientFactory) NewEmailEventsClient() *EmailEventsClient {
	subClient, _ := NewEmailEventsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFavoriteProcessesClient creates a new instance of FavoriteProcessesClient.
func (c *ClientFactory) NewFavoriteProcessesClient() *FavoriteProcessesClient {
	subClient, _ := NewFavoriteProcessesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFlightingRingsClient creates a new instance of FlightingRingsClient.
func (c *ClientFactory) NewFlightingRingsClient() *FlightingRingsClient {
	subClient, _ := NewFlightingRingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOSUpdatesClient creates a new instance of OSUpdatesClient.
func (c *ClientFactory) NewOSUpdatesClient() *OSUpdatesClient {
	subClient, _ := NewOSUpdatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPackagesClient creates a new instance of PackagesClient.
func (c *ClientFactory) NewPackagesClient() *PackagesClient {
	subClient, _ := NewPackagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	subClient, _ := NewSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTestResultsClient creates a new instance of TestResultsClient.
func (c *ClientFactory) NewTestResultsClient() *TestResultsClient {
	subClient, _ := NewTestResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTestSummariesClient creates a new instance of TestSummariesClient.
func (c *ClientFactory) NewTestSummariesClient() *TestSummariesClient {
	subClient, _ := NewTestSummariesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTestTypesClient creates a new instance of TestTypesClient.
func (c *ClientFactory) NewTestTypesClient() *TestTypesClient {
	subClient, _ := NewTestTypesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsageClient creates a new instance of UsageClient.
func (c *ClientFactory) NewUsageClient() *UsageClient {
	subClient, _ := NewUsageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
