//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerVulnerabilityAssessment.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().Get(ctx, "wsg-7398", "testWorkspace", armsynapse.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsynapse.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 			StorageContainerPath: to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceManagedSqlServerVulnerabilityAssessmentWithAllParameters.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_CreateOrUpdate_createOrUpdateAWorkspaceManagedSqlServersVulnerabilityAssessmentWithAllParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "wsg-7398", "testWorkspace", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.ServerVulnerabilityAssessment{
		Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
			RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
				EmailSubscriptionAdmins: to.Ptr(true),
				Emails: []*string{
					to.Ptr("email1@mail.com"),
					to.Ptr("email2@mail.com")},
				IsEnabled: to.Ptr(true),
			},
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey:  to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsynapse.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 			StorageContainerPath: to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateStorageAccessKeyMin.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_CreateOrUpdate_createOrUpdateAWorkspaceManagedSqlServersVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "wsg-7398", "testWorkspace", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.ServerVulnerabilityAssessment{
		Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsynapse.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 		StorageContainerPath: to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateContainerSasKeyMin.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_CreateOrUpdate_createOrUpdateAWorkspaceManagedSqlServersVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "wsg-7398", "testWorkspace", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.ServerVulnerabilityAssessment{
		Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
			StorageContainerPath:   to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsynapse.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 		StorageContainerPath: to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteWorkspaceManagedSqlServerVulnerabilityAssessment.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().Delete(ctx, "wsg-7398", "testWorkspace", armsynapse.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListWorkspaceManagedSqlServerVulnerabilityAssessmentPolicies.json
func ExampleWorkspaceManagedSQLServerVulnerabilityAssessmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient().NewListPager("wsg-7398", "testWorkspace", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerVulnerabilityAssessmentListResult = armsynapse.ServerVulnerabilityAssessmentListResult{
		// 	Value: []*armsynapse.ServerVulnerabilityAssessment{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/vulnerabilityAssessments/default"),
		// 			Properties: &armsynapse.ServerVulnerabilityAssessmentProperties{
		// 				RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
		// 					EmailSubscriptionAdmins: to.Ptr(true),
		// 					Emails: []*string{
		// 						to.Ptr("email1@mail.com"),
		// 						to.Ptr("email2@mail.com")},
		// 						IsEnabled: to.Ptr(true),
		// 					},
		// 					StorageContainerPath: to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
		// 				},
		// 		}},
		// 	}
	}
}
