//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolTablesServer is a fake server for instances of the armsynapse.SQLPoolTablesClient type.
type SQLPoolTablesServer struct {
	// Get is the fake for method SQLPoolTablesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, schemaName string, tableName string, options *armsynapse.SQLPoolTablesClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolTablesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySchemaPager is the fake for method SQLPoolTablesClient.NewListBySchemaPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySchemaPager func(resourceGroupName string, workspaceName string, sqlPoolName string, schemaName string, options *armsynapse.SQLPoolTablesClientListBySchemaOptions) (resp azfake.PagerResponder[armsynapse.SQLPoolTablesClientListBySchemaResponse])
}

// NewSQLPoolTablesServerTransport creates a new instance of SQLPoolTablesServerTransport with the provided implementation.
// The returned SQLPoolTablesServerTransport instance is connected to an instance of armsynapse.SQLPoolTablesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolTablesServerTransport(srv *SQLPoolTablesServer) *SQLPoolTablesServerTransport {
	return &SQLPoolTablesServerTransport{
		srv:                  srv,
		newListBySchemaPager: newTracker[azfake.PagerResponder[armsynapse.SQLPoolTablesClientListBySchemaResponse]](),
	}
}

// SQLPoolTablesServerTransport connects instances of armsynapse.SQLPoolTablesClient to instances of SQLPoolTablesServer.
// Don't use this type directly, use NewSQLPoolTablesServerTransport instead.
type SQLPoolTablesServerTransport struct {
	srv                  *SQLPoolTablesServer
	newListBySchemaPager *tracker[azfake.PagerResponder[armsynapse.SQLPoolTablesClientListBySchemaResponse]]
}

// Do implements the policy.Transporter interface for SQLPoolTablesServerTransport.
func (s *SQLPoolTablesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolTablesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLPoolTablesClient.NewListBySchemaPager":
		resp, err = s.dispatchNewListBySchemaPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolTablesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas/(?P<schemaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	schemaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("schemaName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, schemaNameParam, tableNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolTable, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolTablesServerTransport) dispatchNewListBySchemaPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySchemaPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySchemaPager not implemented")}
	}
	newListBySchemaPager := s.newListBySchemaPager.get(req)
	if newListBySchemaPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas/(?P<schemaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		schemaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("schemaName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsynapse.SQLPoolTablesClientListBySchemaOptions
		if filterParam != nil {
			options = &armsynapse.SQLPoolTablesClientListBySchemaOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListBySchemaPager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, schemaNameParam, options)
		newListBySchemaPager = &resp
		s.newListBySchemaPager.add(req, newListBySchemaPager)
		server.PagerResponderInjectNextLinks(newListBySchemaPager, req, func(page *armsynapse.SQLPoolTablesClientListBySchemaResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySchemaPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySchemaPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySchemaPager) {
		s.newListBySchemaPager.remove(req)
	}
	return resp, nil
}
