//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SparkConfigurationsServer is a fake server for instances of the armsynapse.SparkConfigurationsClient type.
type SparkConfigurationsServer struct {
	// NewListByWorkspacePager is the fake for method SparkConfigurationsClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armsynapse.SparkConfigurationsClientListByWorkspaceOptions) (resp azfake.PagerResponder[armsynapse.SparkConfigurationsClientListByWorkspaceResponse])
}

// NewSparkConfigurationsServerTransport creates a new instance of SparkConfigurationsServerTransport with the provided implementation.
// The returned SparkConfigurationsServerTransport instance is connected to an instance of armsynapse.SparkConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSparkConfigurationsServerTransport(srv *SparkConfigurationsServer) *SparkConfigurationsServerTransport {
	return &SparkConfigurationsServerTransport{
		srv:                     srv,
		newListByWorkspacePager: newTracker[azfake.PagerResponder[armsynapse.SparkConfigurationsClientListByWorkspaceResponse]](),
	}
}

// SparkConfigurationsServerTransport connects instances of armsynapse.SparkConfigurationsClient to instances of SparkConfigurationsServer.
// Don't use this type directly, use NewSparkConfigurationsServerTransport instead.
type SparkConfigurationsServerTransport struct {
	srv                     *SparkConfigurationsServer
	newListByWorkspacePager *tracker[azfake.PagerResponder[armsynapse.SparkConfigurationsClientListByWorkspaceResponse]]
}

// Do implements the policy.Transporter interface for SparkConfigurationsServerTransport.
func (s *SparkConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SparkConfigurationsClient.NewListByWorkspacePager":
		resp, err = s.dispatchNewListByWorkspacePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SparkConfigurationsServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := s.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sparkconfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		s.newListByWorkspacePager.add(req, newListByWorkspacePager)
		server.PagerResponderInjectNextLinks(newListByWorkspacePager, req, func(page *armsynapse.SparkConfigurationsClientListByWorkspaceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		s.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}
