//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// KustoPoolAttachedDatabaseConfigurationsServer is a fake server for instances of the armsynapse.KustoPoolAttachedDatabaseConfigurationsClient type.
type KustoPoolAttachedDatabaseConfigurationsServer struct {
	// BeginCreateOrUpdate is the fake for method KustoPoolAttachedDatabaseConfigurationsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string, parameters armsynapse.AttachedDatabaseConfiguration, options *armsynapse.KustoPoolAttachedDatabaseConfigurationsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method KustoPoolAttachedDatabaseConfigurationsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string, options *armsynapse.KustoPoolAttachedDatabaseConfigurationsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method KustoPoolAttachedDatabaseConfigurationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string, options *armsynapse.KustoPoolAttachedDatabaseConfigurationsClientGetOptions) (resp azfake.Responder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByKustoPoolPager is the fake for method KustoPoolAttachedDatabaseConfigurationsClient.NewListByKustoPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByKustoPoolPager func(workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolResponse])
}

// NewKustoPoolAttachedDatabaseConfigurationsServerTransport creates a new instance of KustoPoolAttachedDatabaseConfigurationsServerTransport with the provided implementation.
// The returned KustoPoolAttachedDatabaseConfigurationsServerTransport instance is connected to an instance of armsynapse.KustoPoolAttachedDatabaseConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewKustoPoolAttachedDatabaseConfigurationsServerTransport(srv *KustoPoolAttachedDatabaseConfigurationsServer) *KustoPoolAttachedDatabaseConfigurationsServerTransport {
	return &KustoPoolAttachedDatabaseConfigurationsServerTransport{
		srv:                     srv,
		beginCreateOrUpdate:     newTracker[azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientCreateOrUpdateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientDeleteResponse]](),
		newListByKustoPoolPager: newTracker[azfake.PagerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolResponse]](),
	}
}

// KustoPoolAttachedDatabaseConfigurationsServerTransport connects instances of armsynapse.KustoPoolAttachedDatabaseConfigurationsClient to instances of KustoPoolAttachedDatabaseConfigurationsServer.
// Don't use this type directly, use NewKustoPoolAttachedDatabaseConfigurationsServerTransport instead.
type KustoPoolAttachedDatabaseConfigurationsServerTransport struct {
	srv                     *KustoPoolAttachedDatabaseConfigurationsServer
	beginCreateOrUpdate     *tracker[azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientCreateOrUpdateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientDeleteResponse]]
	newListByKustoPoolPager *tracker[azfake.PagerResponder[armsynapse.KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolResponse]]
}

// Do implements the policy.Transporter interface for KustoPoolAttachedDatabaseConfigurationsServerTransport.
func (k *KustoPoolAttachedDatabaseConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "KustoPoolAttachedDatabaseConfigurationsClient.BeginCreateOrUpdate":
		resp, err = k.dispatchBeginCreateOrUpdate(req)
	case "KustoPoolAttachedDatabaseConfigurationsClient.BeginDelete":
		resp, err = k.dispatchBeginDelete(req)
	case "KustoPoolAttachedDatabaseConfigurationsClient.Get":
		resp, err = k.dispatchGet(req)
	case "KustoPoolAttachedDatabaseConfigurationsClient.NewListByKustoPoolPager":
		resp, err = k.dispatchNewListByKustoPoolPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (k *KustoPoolAttachedDatabaseConfigurationsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := k.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDatabaseConfigurations/(?P<attachedDatabaseConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.AttachedDatabaseConfiguration](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		attachedDatabaseConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDatabaseConfigurationName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginCreateOrUpdate(req.Context(), workspaceNameParam, kustoPoolNameParam, attachedDatabaseConfigurationNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		k.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		k.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		k.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolAttachedDatabaseConfigurationsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if k.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := k.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDatabaseConfigurations/(?P<attachedDatabaseConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		attachedDatabaseConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDatabaseConfigurationName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginDelete(req.Context(), workspaceNameParam, kustoPoolNameParam, attachedDatabaseConfigurationNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		k.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		k.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		k.beginDelete.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolAttachedDatabaseConfigurationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if k.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDatabaseConfigurations/(?P<attachedDatabaseConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	attachedDatabaseConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDatabaseConfigurationName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.Get(req.Context(), workspaceNameParam, kustoPoolNameParam, attachedDatabaseConfigurationNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AttachedDatabaseConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolAttachedDatabaseConfigurationsServerTransport) dispatchNewListByKustoPoolPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListByKustoPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByKustoPoolPager not implemented")}
	}
	newListByKustoPoolPager := k.newListByKustoPoolPager.get(req)
	if newListByKustoPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDatabaseConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListByKustoPoolPager(workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		newListByKustoPoolPager = &resp
		k.newListByKustoPoolPager.add(req, newListByKustoPoolPager)
	}
	resp, err := server.PagerResponderNext(newListByKustoPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListByKustoPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByKustoPoolPager) {
		k.newListByKustoPoolPager.remove(req)
	}
	return resp, nil
}
