//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// DataMaskingRulesServer is a fake server for instances of the armsynapse.DataMaskingRulesClient type.
type DataMaskingRulesServer struct {
	// CreateOrUpdate is the fake for method DataMaskingRulesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, dataMaskingRuleName string, parameters armsynapse.DataMaskingRule, options *armsynapse.DataMaskingRulesClientCreateOrUpdateOptions) (resp azfake.Responder[armsynapse.DataMaskingRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataMaskingRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, dataMaskingRuleName string, options *armsynapse.DataMaskingRulesClientGetOptions) (resp azfake.Responder[armsynapse.DataMaskingRulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLPoolPager is the fake for method DataMaskingRulesClient.NewListBySQLPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLPoolPager func(resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.DataMaskingRulesClientListBySQLPoolOptions) (resp azfake.PagerResponder[armsynapse.DataMaskingRulesClientListBySQLPoolResponse])
}

// NewDataMaskingRulesServerTransport creates a new instance of DataMaskingRulesServerTransport with the provided implementation.
// The returned DataMaskingRulesServerTransport instance is connected to an instance of armsynapse.DataMaskingRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataMaskingRulesServerTransport(srv *DataMaskingRulesServer) *DataMaskingRulesServerTransport {
	return &DataMaskingRulesServerTransport{
		srv:                   srv,
		newListBySQLPoolPager: newTracker[azfake.PagerResponder[armsynapse.DataMaskingRulesClientListBySQLPoolResponse]](),
	}
}

// DataMaskingRulesServerTransport connects instances of armsynapse.DataMaskingRulesClient to instances of DataMaskingRulesServer.
// Don't use this type directly, use NewDataMaskingRulesServerTransport instead.
type DataMaskingRulesServerTransport struct {
	srv                   *DataMaskingRulesServer
	newListBySQLPoolPager *tracker[azfake.PagerResponder[armsynapse.DataMaskingRulesClientListBySQLPoolResponse]]
}

// Do implements the policy.Transporter interface for DataMaskingRulesServerTransport.
func (d *DataMaskingRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataMaskingRulesClient.CreateOrUpdate":
		resp, err = d.dispatchCreateOrUpdate(req)
	case "DataMaskingRulesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataMaskingRulesClient.NewListBySQLPoolPager":
		resp, err = d.dispatchNewListBySQLPoolPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataMaskingRulesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataMaskingPolicies/(?P<dataMaskingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<dataMaskingRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.DataMaskingRule](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	dataMaskingRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataMaskingRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, dataMaskingRuleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataMaskingRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataMaskingRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataMaskingPolicies/(?P<dataMaskingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<dataMaskingRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	dataMaskingRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataMaskingRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, dataMaskingRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataMaskingRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataMaskingRulesServerTransport) dispatchNewListBySQLPoolPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySQLPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLPoolPager not implemented")}
	}
	newListBySQLPoolPager := d.newListBySQLPoolPager.get(req)
	if newListBySQLPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataMaskingPolicies/(?P<dataMaskingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListBySQLPoolPager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
		newListBySQLPoolPager = &resp
		d.newListBySQLPoolPager.add(req, newListBySQLPoolPager)
	}
	resp, err := server.PagerResponderNext(newListBySQLPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySQLPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLPoolPager) {
		d.newListBySQLPoolPager.remove(req)
	}
	return resp, nil
}
