//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ChatTranscriptsNoSubscriptionClient contains the methods for the ChatTranscriptsNoSubscription group.
// Don't use this type directly, use NewChatTranscriptsNoSubscriptionClient() instead.
type ChatTranscriptsNoSubscriptionClient struct {
	internal *arm.Client
}

// NewChatTranscriptsNoSubscriptionClient creates a new instance of ChatTranscriptsNoSubscriptionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewChatTranscriptsNoSubscriptionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ChatTranscriptsNoSubscriptionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ChatTranscriptsNoSubscriptionClient{
		internal: cl,
	}
	return client, nil
}

// Get - Returns chatTranscript details for a no subscription support ticket.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01
//   - supportTicketName - Support ticket name.
//   - chatTranscriptName - ChatTranscript name.
//   - options - ChatTranscriptsNoSubscriptionClientGetOptions contains the optional parameters for the ChatTranscriptsNoSubscriptionClient.Get
//     method.
func (client *ChatTranscriptsNoSubscriptionClient) Get(ctx context.Context, supportTicketName string, chatTranscriptName string, options *ChatTranscriptsNoSubscriptionClientGetOptions) (ChatTranscriptsNoSubscriptionClientGetResponse, error) {
	var err error
	const operationName = "ChatTranscriptsNoSubscriptionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, supportTicketName, chatTranscriptName, options)
	if err != nil {
		return ChatTranscriptsNoSubscriptionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ChatTranscriptsNoSubscriptionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ChatTranscriptsNoSubscriptionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ChatTranscriptsNoSubscriptionClient) getCreateRequest(ctx context.Context, supportTicketName string, chatTranscriptName string, options *ChatTranscriptsNoSubscriptionClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	if chatTranscriptName == "" {
		return nil, errors.New("parameter chatTranscriptName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{chatTranscriptName}", url.PathEscape(chatTranscriptName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ChatTranscriptsNoSubscriptionClient) getHandleResponse(resp *http.Response) (ChatTranscriptsNoSubscriptionClientGetResponse, error) {
	result := ChatTranscriptsNoSubscriptionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatTranscriptDetails); err != nil {
		return ChatTranscriptsNoSubscriptionClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all chat transcripts for a support ticket
//
// Generated from API version 2024-04-01
//   - supportTicketName - Support ticket name
//   - options - ChatTranscriptsNoSubscriptionClientListOptions contains the optional parameters for the ChatTranscriptsNoSubscriptionClient.NewListPager
//     method.
func (client *ChatTranscriptsNoSubscriptionClient) NewListPager(supportTicketName string, options *ChatTranscriptsNoSubscriptionClientListOptions) *runtime.Pager[ChatTranscriptsNoSubscriptionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChatTranscriptsNoSubscriptionClientListResponse]{
		More: func(page ChatTranscriptsNoSubscriptionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChatTranscriptsNoSubscriptionClientListResponse) (ChatTranscriptsNoSubscriptionClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ChatTranscriptsNoSubscriptionClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, supportTicketName, options)
			}, nil)
			if err != nil {
				return ChatTranscriptsNoSubscriptionClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ChatTranscriptsNoSubscriptionClient) listCreateRequest(ctx context.Context, supportTicketName string, options *ChatTranscriptsNoSubscriptionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ChatTranscriptsNoSubscriptionClient) listHandleResponse(resp *http.Response) (ChatTranscriptsNoSubscriptionClientListResponse, error) {
	result := ChatTranscriptsNoSubscriptionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatTranscriptsListResult); err != nil {
		return ChatTranscriptsNoSubscriptionClientListResponse{}, err
	}
	return result, nil
}
