//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/subscription/armsubscription"
	"net/http"
	"net/url"
	"regexp"
)

// SubscriptionsServer is a fake server for instances of the armsubscription.SubscriptionsClient type.
type SubscriptionsServer struct {
	// Get is the fake for method SubscriptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, subscriptionID string, options *armsubscription.SubscriptionsClientGetOptions) (resp azfake.Responder[armsubscription.SubscriptionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SubscriptionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsubscription.SubscriptionsClientListOptions) (resp azfake.PagerResponder[armsubscription.SubscriptionsClientListResponse])

	// NewListLocationsPager is the fake for method SubscriptionsClient.NewListLocationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListLocationsPager func(subscriptionID string, options *armsubscription.SubscriptionsClientListLocationsOptions) (resp azfake.PagerResponder[armsubscription.SubscriptionsClientListLocationsResponse])
}

// NewSubscriptionsServerTransport creates a new instance of SubscriptionsServerTransport with the provided implementation.
// The returned SubscriptionsServerTransport instance is connected to an instance of armsubscription.SubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubscriptionsServerTransport(srv *SubscriptionsServer) *SubscriptionsServerTransport {
	return &SubscriptionsServerTransport{
		srv:                   srv,
		newListPager:          newTracker[azfake.PagerResponder[armsubscription.SubscriptionsClientListResponse]](),
		newListLocationsPager: newTracker[azfake.PagerResponder[armsubscription.SubscriptionsClientListLocationsResponse]](),
	}
}

// SubscriptionsServerTransport connects instances of armsubscription.SubscriptionsClient to instances of SubscriptionsServer.
// Don't use this type directly, use NewSubscriptionsServerTransport instead.
type SubscriptionsServerTransport struct {
	srv                   *SubscriptionsServer
	newListPager          *tracker[azfake.PagerResponder[armsubscription.SubscriptionsClientListResponse]]
	newListLocationsPager *tracker[azfake.PagerResponder[armsubscription.SubscriptionsClientListLocationsResponse]]
}

// Do implements the policy.Transporter interface for SubscriptionsServerTransport.
func (s *SubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubscriptionsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubscriptionsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SubscriptionsClient.NewListLocationsPager":
		resp, err = s.dispatchNewListLocationsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubscriptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), subscriptionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Subscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		resp := s.srv.NewListPager(nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsubscription.SubscriptionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SubscriptionsServerTransport) dispatchNewListLocationsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListLocationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListLocationsPager not implemented")}
	}
	newListLocationsPager := s.newListLocationsPager.get(req)
	if newListLocationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListLocationsPager(subscriptionIDParam, nil)
		newListLocationsPager = &resp
		s.newListLocationsPager.add(req, newListLocationsPager)
	}
	resp, err := server.PagerResponderNext(newListLocationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListLocationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListLocationsPager) {
		s.newListLocationsPager.remove(req)
	}
	return resp, nil
}
