//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstreamanalytics_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Create_CompleteJob.json
func ExampleStreamingJobsClient_BeginCreateOrReplace_createACompleteStreamingJobAStreamingJobWithATransformationAtLeast1InputAndAtLeast1Output() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginCreateOrReplace(ctx, "sjrg3276", "sj7804", armstreamanalytics.StreamingJob{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1":      to.Ptr("value1"),
			"key3":      to.Ptr("value3"),
			"randomKey": to.Ptr("randomValue"),
		},
		Properties: &armstreamanalytics.StreamingJobProperties{
			CompatibilityLevel:                 to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
			DataLocale:                         to.Ptr("en-US"),
			EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
			EventsOutOfOrderMaxDelayInSeconds:  to.Ptr[int32](0),
			EventsOutOfOrderPolicy:             to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
			Externals: &armstreamanalytics.External{
				Path:      to.Ptr("UserCustomCode.zip"),
				Container: to.Ptr("mycontainer"),
				RefreshConfiguration: &armstreamanalytics.RefreshConfiguration{
					DateFormat:      to.Ptr("yyyy-dd-MM"),
					PathPattern:     to.Ptr("{date}\\\\{time}"),
					RefreshInterval: to.Ptr("00:01:00"),
					RefreshType:     to.Ptr(armstreamanalytics.UpdatableUdfRefreshTypeNonblocking),
					TimeFormat:      to.Ptr("HH"),
				},
				StorageAccount: &armstreamanalytics.StorageAccount{
					AccountKey:  to.Ptr("mykey"),
					AccountName: to.Ptr("mystorageaccount"),
				},
			},
			Functions: []*armstreamanalytics.Function{},
			Inputs: []*armstreamanalytics.Input{
				{
					Name: to.Ptr("inputtest"),
					Properties: &armstreamanalytics.StreamInputProperties{
						Type: to.Ptr("Stream"),
						Serialization: &armstreamanalytics.JSONSerialization{
							Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
							Properties: &armstreamanalytics.JSONSerializationProperties{
								Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
							},
						},
						Datasource: &armstreamanalytics.BlobStreamInputDataSource{
							Type: to.Ptr("Microsoft.Storage/Blob"),
							Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
								Container:   to.Ptr("containerName"),
								PathPattern: to.Ptr(""),
								StorageAccounts: []*armstreamanalytics.StorageAccount{
									{
										AccountKey:  to.Ptr("yourAccountKey=="),
										AccountName: to.Ptr("yourAccountName"),
									}},
							},
						},
					},
				}},
			OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
			Outputs: []*armstreamanalytics.Output{
				{
					Name: to.Ptr("outputtest"),
					Properties: &armstreamanalytics.OutputProperties{
						Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
							Type: to.Ptr("Microsoft.Sql/Server/Database"),
							Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
								Database: to.Ptr("databaseName"),
								Password: to.Ptr("userPassword"),
								Server:   to.Ptr("serverName"),
								Table:    to.Ptr("tableName"),
								User:     to.Ptr("<user>"),
							},
						},
					},
				}},
			SKU: &armstreamanalytics.SKU{
				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
			},
			Transformation: &armstreamanalytics.Transformation{
				Name: to.Ptr("transformationtest"),
				Properties: &armstreamanalytics.TransformationProperties{
					Query:          to.Ptr("Select Id, Name from inputtest"),
					StreamingUnits: to.Ptr[int32](1),
				},
			},
		},
	}, &armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sj7804"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:11.540Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		Functions: []*armstreamanalytics.Function{
	// 		},
	// 		Inputs: []*armstreamanalytics.Input{
	// 			{
	// 				Name: to.Ptr("inputtest"),
	// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
	// 				Properties: &armstreamanalytics.StreamInputProperties{
	// 					Type: to.Ptr("Stream"),
	// 					Etag: to.Ptr("ca88f8fa-605b-4c7f-8695-46f5faa60cd0"),
	// 					Serialization: &armstreamanalytics.JSONSerialization{
	// 						Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 						Properties: &armstreamanalytics.JSONSerializationProperties{
	// 							Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 						},
	// 					},
	// 					Datasource: &armstreamanalytics.BlobStreamInputDataSource{
	// 						Type: to.Ptr("Microsoft.Storage/Blob"),
	// 						Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
	// 							Container: to.Ptr("containerName"),
	// 							PathPattern: to.Ptr(""),
	// 							StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 								{
	// 									AccountName: to.Ptr("accountName"),
	// 							}},
	// 						},
	// 					},
	// 				},
	// 		}},
	// 		JobID: to.Ptr("732e4b1d-94a7-43ae-8297-3ad04f1540b9"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		Outputs: []*armstreamanalytics.Output{
	// 			{
	// 				Name: to.Ptr("outputtest"),
	// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/outputs/outputtest"),
	// 				Properties: &armstreamanalytics.OutputProperties{
	// 					Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
	// 						Type: to.Ptr("Microsoft.Sql/Server/Database"),
	// 						Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
	// 							Database: to.Ptr("databaseName"),
	// 							Server: to.Ptr("serverName"),
	// 							Table: to.Ptr("tableName"),
	// 							User: to.Ptr("userName"),
	// 						},
	// 					},
	// 					Etag: to.Ptr("62097c3c-b503-41ff-a56f-196a9598ab90"),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 		Transformation: &armstreamanalytics.Transformation{
	// 			Name: to.Ptr("transformationtest"),
	// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
	// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/transformations/transformationtest"),
	// 			Properties: &armstreamanalytics.TransformationProperties{
	// 				Etag: to.Ptr("91d8fcbe-60b3-49c3-9f21-9942b95602b8"),
	// 				Query: to.Ptr("Select Id, Name from inputtest"),
	// 				StreamingUnits: to.Ptr[int32](1),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Create_JobShell.json
func ExampleStreamingJobsClient_BeginCreateOrReplace_createAStreamingJobShellAStreamingJobWithNoInputsOutputsTransformationOrFunctions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginCreateOrReplace(ctx, "sjrg6936", "sj59", armstreamanalytics.StreamingJob{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1":      to.Ptr("value1"),
			"key3":      to.Ptr("value3"),
			"randomKey": to.Ptr("randomValue"),
		},
		Properties: &armstreamanalytics.StreamingJobProperties{
			CompatibilityLevel:                 to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
			DataLocale:                         to.Ptr("en-US"),
			EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](16),
			EventsOutOfOrderMaxDelayInSeconds:  to.Ptr[int32](5),
			EventsOutOfOrderPolicy:             to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
			Functions:                          []*armstreamanalytics.Function{},
			Inputs:                             []*armstreamanalytics.Input{},
			OutputErrorPolicy:                  to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
			Outputs:                            []*armstreamanalytics.Output{},
			SKU: &armstreamanalytics.SKU{
				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
			},
		},
	}, &armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sj59"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj59"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](16),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](5),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		Functions: []*armstreamanalytics.Function{
	// 		},
	// 		Inputs: []*armstreamanalytics.Input{
	// 		},
	// 		JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		Outputs: []*armstreamanalytics.Output{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Create_UserAssignedIdentity.json
func ExampleStreamingJobsClient_BeginCreateOrReplace_createAStreamingJobShellAStreamingJobWithNoInputsOutputsTransformationOrFunctionsWithUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginCreateOrReplace(ctx, "sjrg", "sjName", armstreamanalytics.StreamingJob{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1":      to.Ptr("value1"),
			"key3":      to.Ptr("value3"),
			"randomKey": to.Ptr("randomValue"),
		},
		Identity: &armstreamanalytics.Identity{
			Type: to.Ptr("UserAssigned"),
			UserAssignedIdentities: map[string]any{
				"/subscriptions/fa68082f-8ff7-4a25-95c7-ce9da541242f/resourceGroups/akvenkat/providers/Microsoft.ManagedIdentity/userAssignedIdentities/sdkIdentity": map[string]any{},
			},
		},
		Properties: &armstreamanalytics.StreamingJobProperties{
			CompatibilityLevel:                 to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
			DataLocale:                         to.Ptr("en-US"),
			EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](16),
			EventsOutOfOrderMaxDelayInSeconds:  to.Ptr[int32](5),
			EventsOutOfOrderPolicy:             to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
			Functions:                          []*armstreamanalytics.Function{},
			Inputs:                             []*armstreamanalytics.Input{},
			OutputErrorPolicy:                  to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
			Outputs:                            []*armstreamanalytics.Output{},
			SKU: &armstreamanalytics.SKU{
				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
			},
		},
	}, &armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sjName"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Identity: &armstreamanalytics.Identity{
	// 		Type: to.Ptr("UserAssigned"),
	// 		PrincipalID: to.Ptr("c10a9ec7-7136-441f-9e90-d17cd1a51b94"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 		UserAssignedIdentities: map[string]any{
	// 			"/subscriptions/fa68082f-8ff7-4a25-95c7-ce9da541242f/resourceGroups/akvenkat/providers/Microsoft.ManagedIdentity/userAssignedIdentities/sdkIdentity": map[string]any{
	// 			},
	// 		},
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](16),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](5),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		Functions: []*armstreamanalytics.Function{
	// 		},
	// 		Inputs: []*armstreamanalytics.Input{
	// 		},
	// 		JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		Outputs: []*armstreamanalytics.Output{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Update.json
func ExampleStreamingJobsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingJobsClient().Update(ctx, "sjrg6936", "sj59", armstreamanalytics.StreamingJob{
		Properties: &armstreamanalytics.StreamingJobProperties{
			EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](13),
			EventsOutOfOrderMaxDelayInSeconds:  to.Ptr[int32](21),
		},
	}, &armstreamanalytics.StreamingJobsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sj59"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj59"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](13),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](21),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 	},
	// 	SKU: &armstreamanalytics.SKU{
	// 		Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](36),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Delete.json
func ExampleStreamingJobsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginDelete(ctx, "sjrg6936", "sj59", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Get_NoExpand.json
func ExampleStreamingJobsClient_Get_getAStreamingJobAndDoNotUseTheExpandODataQueryParameter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingJobsClient().Get(ctx, "sjrg6936", "sj59", &armstreamanalytics.StreamingJobsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sj59"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj59"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](16),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](5),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 	},
	// 	SKU: &armstreamanalytics.SKU{
	// 		Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](36),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Get_Expand.json
func ExampleStreamingJobsClient_Get_getAStreamingJobAndUseTheExpandODataQueryParameterToExpandInputsOutputsTransformationAndFunctions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingJobsClient().Get(ctx, "sjrg3276", "sj7804", &armstreamanalytics.StreamingJobsClientGetOptions{Expand: to.Ptr("inputs,outputs,transformation,functions")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingJob = armstreamanalytics.StreamingJob{
	// 	Name: to.Ptr("sj7804"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key3": to.Ptr("value3"),
	// 		"randomKey": to.Ptr("randomValue"),
	// 	},
	// 	Properties: &armstreamanalytics.StreamingJobProperties{
	// 		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:11.540Z"); return t}()),
	// 		DataLocale: to.Ptr("en-US"),
	// 		EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
	// 		EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
	// 		EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
	// 		Functions: []*armstreamanalytics.Function{
	// 		},
	// 		Inputs: []*armstreamanalytics.Input{
	// 			{
	// 				Name: to.Ptr("inputtest"),
	// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
	// 				Properties: &armstreamanalytics.StreamInputProperties{
	// 					Type: to.Ptr("Stream"),
	// 					Etag: to.Ptr("ca88f8fa-605b-4c7f-8695-46f5faa60cd0"),
	// 					Serialization: &armstreamanalytics.JSONSerialization{
	// 						Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 						Properties: &armstreamanalytics.JSONSerializationProperties{
	// 							Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 						},
	// 					},
	// 					Datasource: &armstreamanalytics.BlobStreamInputDataSource{
	// 						Type: to.Ptr("Microsoft.Storage/Blob"),
	// 						Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
	// 							Container: to.Ptr("containerName"),
	// 							PathPattern: to.Ptr(""),
	// 							StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 								{
	// 									AccountName: to.Ptr("accountName"),
	// 							}},
	// 						},
	// 					},
	// 				},
	// 		}},
	// 		JobID: to.Ptr("732e4b1d-94a7-43ae-8297-3ad04f1540b9"),
	// 		JobState: to.Ptr("Created"),
	// 		OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
	// 		Outputs: []*armstreamanalytics.Output{
	// 			{
	// 				Name: to.Ptr("outputtest"),
	// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/outputs/outputtest"),
	// 				Properties: &armstreamanalytics.OutputProperties{
	// 					Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
	// 						Type: to.Ptr("Microsoft.Sql/Server/Database"),
	// 						Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
	// 							Database: to.Ptr("databaseName"),
	// 							Server: to.Ptr("serverName"),
	// 							Table: to.Ptr("tableName"),
	// 							User: to.Ptr("userName"),
	// 						},
	// 					},
	// 					Etag: to.Ptr("62097c3c-b503-41ff-a56f-196a9598ab90"),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstreamanalytics.SKU{
	// 			Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		},
	// 		Transformation: &armstreamanalytics.Transformation{
	// 			Name: to.Ptr("transformationtest"),
	// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
	// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/transformations/transformationtest"),
	// 			Properties: &armstreamanalytics.TransformationProperties{
	// 				Etag: to.Ptr("91d8fcbe-60b3-49c3-9f21-9942b95602b8"),
	// 				Query: to.Ptr("Select Id, Name from inputtest"),
	// 				StreamingUnits: to.Ptr[int32](1),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armstreamanalytics.SKU{
	// 		Name: to.Ptr(armstreamanalytics.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](36),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_List_ByResourceGroup_NoExpand.json
func ExampleStreamingJobsClient_NewListByResourceGroupPager_listAllStreamingJobsInAResourceGroupAndDoNotUseTheExpandODataQueryParameter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStreamingJobsClient().NewListByResourceGroupPager("sjrg6936", &armstreamanalytics.StreamingJobsClientListByResourceGroupOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StreamingJobListResult = armstreamanalytics.StreamingJobListResult{
		// 	Value: []*armstreamanalytics.StreamingJob{
		// 		{
		// 			Name: to.Ptr("sj59"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj59"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("3e6872bc-c9d0-45b6-91b6-da66f1773056"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](13),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](21),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
		// 				JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sj69"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj69"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:38:04.697Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("99538949-a164-4e2f-a991-40303e86024f"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](6),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
		// 				JobID: to.Ptr("817b36cf-a161-4a9e-86f2-eb00b3566d88"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_List_ByResourceGroup_Expand.json
func ExampleStreamingJobsClient_NewListByResourceGroupPager_listAllStreamingJobsInAResourceGroupAndUseTheExpandODataQueryParameterToExpandInputsOutputsTransformationAndFunctions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStreamingJobsClient().NewListByResourceGroupPager("sjrg3276", &armstreamanalytics.StreamingJobsClientListByResourceGroupOptions{Expand: to.Ptr("inputs,outputs,transformation,functions")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StreamingJobListResult = armstreamanalytics.StreamingJobListResult{
		// 	Value: []*armstreamanalytics.StreamingJob{
		// 		{
		// 			Name: to.Ptr("sj7804"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:11.540Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("8081b2a3-dfe6-457f-8740-1a22d209bf8a"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyAdjust),
		// 				Functions: []*armstreamanalytics.Function{
		// 				},
		// 				Inputs: []*armstreamanalytics.Input{
		// 					{
		// 						Name: to.Ptr("inputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
		// 						Properties: &armstreamanalytics.StreamInputProperties{
		// 							Type: to.Ptr("Stream"),
		// 							Etag: to.Ptr("ca88f8fa-605b-4c7f-8695-46f5faa60cd0"),
		// 							Serialization: &armstreamanalytics.JSONSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 								Properties: &armstreamanalytics.JSONSerializationProperties{
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 								},
		// 							},
		// 							Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 								Type: to.Ptr("Microsoft.Storage/Blob"),
		// 								Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 									Container: to.Ptr("containerName"),
		// 									PathPattern: to.Ptr(""),
		// 									StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 										{
		// 											AccountName: to.Ptr("accountName"),
		// 									}},
		// 								},
		// 							},
		// 						},
		// 				}},
		// 				JobID: to.Ptr("732e4b1d-94a7-43ae-8297-3ad04f1540b9"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyStop),
		// 				Outputs: []*armstreamanalytics.Output{
		// 					{
		// 						Name: to.Ptr("outputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/outputs/outputtest"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
		// 								Type: to.Ptr("Microsoft.Sql/Server/Database"),
		// 								Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
		// 									Database: to.Ptr("databaseName"),
		// 									Server: to.Ptr("serverName"),
		// 									Table: to.Ptr("tableName"),
		// 									User: to.Ptr("userName"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("62097c3c-b503-41ff-a56f-196a9598ab90"),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 				Transformation: &armstreamanalytics.Transformation{
		// 					Name: to.Ptr("transformationtest"),
		// 					Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
		// 					ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/transformations/transformationtest"),
		// 					Properties: &armstreamanalytics.TransformationProperties{
		// 						Etag: to.Ptr("91d8fcbe-60b3-49c3-9f21-9942b95602b8"),
		// 						Query: to.Ptr("Select Id, Name from inputtest"),
		// 						StreamingUnits: to.Ptr[int32](1),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sj7805"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7805"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:38:11.540Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("5420059f-e5d7-47d4-be44-40816a4dca7e"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyAdjust),
		// 				Functions: []*armstreamanalytics.Function{
		// 				},
		// 				Inputs: []*armstreamanalytics.Input{
		// 					{
		// 						Name: to.Ptr("inputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
		// 						Properties: &armstreamanalytics.StreamInputProperties{
		// 							Type: to.Ptr("Stream"),
		// 							Etag: to.Ptr("45dcf40f-88bb-4776-b5ca-7b10a607cb59"),
		// 							Serialization: &armstreamanalytics.JSONSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 								Properties: &armstreamanalytics.JSONSerializationProperties{
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 								},
		// 							},
		// 							Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 								Type: to.Ptr("Microsoft.Storage/Blob"),
		// 								Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 									Container: to.Ptr("containerName"),
		// 									PathPattern: to.Ptr(""),
		// 									StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 										{
		// 											AccountName: to.Ptr("accountName"),
		// 									}},
		// 								},
		// 							},
		// 						},
		// 				}},
		// 				JobID: to.Ptr("d8f4041a-0793-433e-a38d-5499d5332113"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyStop),
		// 				Outputs: []*armstreamanalytics.Output{
		// 					{
		// 						Name: to.Ptr("outputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/outputs/outputtest"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
		// 								Type: to.Ptr("Microsoft.Sql/Server/Database"),
		// 								Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
		// 									Database: to.Ptr("databaseName"),
		// 									Server: to.Ptr("serverName"),
		// 									Table: to.Ptr("tableName"),
		// 									User: to.Ptr("userName"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("b09606c8-1b0d-43c9-affb-fac0e18b9481"),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 				Transformation: &armstreamanalytics.Transformation{
		// 					Name: to.Ptr("transformationtest"),
		// 					Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
		// 					ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/transformations/transformationtest"),
		// 					Properties: &armstreamanalytics.TransformationProperties{
		// 						Etag: to.Ptr("288d95c0-204b-4c54-828f-f57aa6896b2a"),
		// 						Query: to.Ptr("Select Id, Name from inputtest"),
		// 						StreamingUnits: to.Ptr[int32](1),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_List_BySubscription_NoExpand.json
func ExampleStreamingJobsClient_NewListPager_listAllStreamingJobsInASubscriptionAndDoNotUseTheExpandODataQueryParameter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStreamingJobsClient().NewListPager(&armstreamanalytics.StreamingJobsClientListOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StreamingJobListResult = armstreamanalytics.StreamingJobListResult{
		// 	Value: []*armstreamanalytics.StreamingJob{
		// 		{
		// 			Name: to.Ptr("sj59"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj59"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:04.697Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("3e6872bc-c9d0-45b6-91b6-da66f1773056"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](13),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](21),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
		// 				JobID: to.Ptr("d53ecc3c-fcb0-485d-9caf-25e20fcb2061"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sj69"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6936/providers/Microsoft.StreamAnalytics/streamingjobs/sj69"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:38:04.697Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("99538949-a164-4e2f-a991-40303e86024f"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](6),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
		// 				JobID: to.Ptr("817b36cf-a161-4a9e-86f2-eb00b3566d88"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_List_BySubscription_Expand.json
func ExampleStreamingJobsClient_NewListPager_listAllStreamingJobsInASubscriptionAndUseTheExpandODataQueryParameterToExpandInputsOutputsTransformationAndFunctions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStreamingJobsClient().NewListPager(&armstreamanalytics.StreamingJobsClientListOptions{Expand: to.Ptr("inputs,outputs,transformation,functions")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StreamingJobListResult = armstreamanalytics.StreamingJobListResult{
		// 	Value: []*armstreamanalytics.StreamingJob{
		// 		{
		// 			Name: to.Ptr("sj7804"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:37:11.540Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("8081b2a3-dfe6-457f-8740-1a22d209bf8a"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyAdjust),
		// 				Functions: []*armstreamanalytics.Function{
		// 				},
		// 				Inputs: []*armstreamanalytics.Input{
		// 					{
		// 						Name: to.Ptr("inputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
		// 						Properties: &armstreamanalytics.StreamInputProperties{
		// 							Type: to.Ptr("Stream"),
		// 							Etag: to.Ptr("ca88f8fa-605b-4c7f-8695-46f5faa60cd0"),
		// 							Serialization: &armstreamanalytics.JSONSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 								Properties: &armstreamanalytics.JSONSerializationProperties{
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 								},
		// 							},
		// 							Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 								Type: to.Ptr("Microsoft.Storage/Blob"),
		// 								Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 									Container: to.Ptr("containerName"),
		// 									PathPattern: to.Ptr(""),
		// 									StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 										{
		// 											AccountName: to.Ptr("accountName"),
		// 									}},
		// 								},
		// 							},
		// 						},
		// 				}},
		// 				JobID: to.Ptr("732e4b1d-94a7-43ae-8297-3ad04f1540b9"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyStop),
		// 				Outputs: []*armstreamanalytics.Output{
		// 					{
		// 						Name: to.Ptr("outputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/outputs/outputtest"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
		// 								Type: to.Ptr("Microsoft.Sql/Server/Database"),
		// 								Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
		// 									Database: to.Ptr("databaseName"),
		// 									Server: to.Ptr("serverName"),
		// 									Table: to.Ptr("tableName"),
		// 									User: to.Ptr("userName"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("62097c3c-b503-41ff-a56f-196a9598ab90"),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 				Transformation: &armstreamanalytics.Transformation{
		// 					Name: to.Ptr("transformationtest"),
		// 					Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
		// 					ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/transformations/transformationtest"),
		// 					Properties: &armstreamanalytics.TransformationProperties{
		// 						Etag: to.Ptr("91d8fcbe-60b3-49c3-9f21-9942b95602b8"),
		// 						Query: to.Ptr("Select Id, Name from inputtest"),
		// 						StreamingUnits: to.Ptr[int32](1),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sj7805"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7805"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key3": to.Ptr("value3"),
		// 				"randomKey": to.Ptr("randomValue"),
		// 			},
		// 			Properties: &armstreamanalytics.StreamingJobProperties{
		// 				CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-11T04:38:11.540Z"); return t}()),
		// 				DataLocale: to.Ptr("en-US"),
		// 				Etag: to.Ptr("5420059f-e5d7-47d4-be44-40816a4dca7e"),
		// 				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
		// 				EventsOutOfOrderMaxDelayInSeconds: to.Ptr[int32](0),
		// 				EventsOutOfOrderPolicy: to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyAdjust),
		// 				Functions: []*armstreamanalytics.Function{
		// 				},
		// 				Inputs: []*armstreamanalytics.Input{
		// 					{
		// 						Name: to.Ptr("inputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7805/inputs/inputtest"),
		// 						Properties: &armstreamanalytics.StreamInputProperties{
		// 							Type: to.Ptr("Stream"),
		// 							Etag: to.Ptr("45dcf40f-88bb-4776-b5ca-7b10a607cb59"),
		// 							Serialization: &armstreamanalytics.JSONSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 								Properties: &armstreamanalytics.JSONSerializationProperties{
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 								},
		// 							},
		// 							Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 								Type: to.Ptr("Microsoft.Storage/Blob"),
		// 								Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 									Container: to.Ptr("containerName"),
		// 									PathPattern: to.Ptr(""),
		// 									StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 										{
		// 											AccountName: to.Ptr("accountName"),
		// 									}},
		// 								},
		// 							},
		// 						},
		// 				}},
		// 				JobID: to.Ptr("d8f4041a-0793-433e-a38d-5499d5332113"),
		// 				JobState: to.Ptr("Created"),
		// 				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyStop),
		// 				Outputs: []*armstreamanalytics.Output{
		// 					{
		// 						Name: to.Ptr("outputtest"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7805/outputs/outputtest"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
		// 								Type: to.Ptr("Microsoft.Sql/Server/Database"),
		// 								Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
		// 									Database: to.Ptr("databaseName"),
		// 									Server: to.Ptr("serverName"),
		// 									Table: to.Ptr("tableName"),
		// 									User: to.Ptr("userName"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("b09606c8-1b0d-43c9-affb-fac0e18b9481"),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstreamanalytics.SKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 				Transformation: &armstreamanalytics.Transformation{
		// 					Name: to.Ptr("transformationtest"),
		// 					Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/transformations"),
		// 					ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7805/transformations/transformationtest"),
		// 					Properties: &armstreamanalytics.TransformationProperties{
		// 						Etag: to.Ptr("288d95c0-204b-4c54-828f-f57aa6896b2a"),
		// 						Query: to.Ptr("Select Id, Name from inputtest"),
		// 						StreamingUnits: to.Ptr[int32](1),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armstreamanalytics.SKU{
		// 				Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](36),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Start_CustomTime.json
func ExampleStreamingJobsClient_BeginStart_startAStreamingJobWithCustomTimeOutputStartMode() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginStart(ctx, "sjrg6936", "sj59", &armstreamanalytics.StreamingJobsClientBeginStartOptions{StartJobParameters: &armstreamanalytics.StartStreamingJobParameters{
		OutputStartMode: to.Ptr(armstreamanalytics.OutputStartModeCustomTime),
		OutputStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-12-12T12:12:12.000Z"); return t }()),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Start_JobStartTime.json
func ExampleStreamingJobsClient_BeginStart_startAStreamingJobWithJobStartTimeOutputStartMode() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginStart(ctx, "sjrg6936", "sj59", &armstreamanalytics.StreamingJobsClientBeginStartOptions{StartJobParameters: &armstreamanalytics.StartStreamingJobParameters{
		OutputStartMode: to.Ptr(armstreamanalytics.OutputStartModeJobStartTime),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Start_LastOutputEventTime.json
func ExampleStreamingJobsClient_BeginStart_startAStreamingJobWithLastOutputEventTimeOutputStartMode() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginStart(ctx, "sjrg6936", "sj59", &armstreamanalytics.StreamingJobsClientBeginStartOptions{StartJobParameters: &armstreamanalytics.StartStreamingJobParameters{
		OutputStartMode: to.Ptr(armstreamanalytics.OutputStartModeLastOutputEventTime),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Stop.json
func ExampleStreamingJobsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginStop(ctx, "sjrg6936", "sj59", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Scale.json
func ExampleStreamingJobsClient_BeginScale() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingJobsClient().BeginScale(ctx, "sjrg", "sjName", &armstreamanalytics.StreamingJobsClientBeginScaleOptions{ScaleJobParameters: &armstreamanalytics.ScaleStreamingJobParameters{
		StreamingUnits: to.Ptr[int32](36),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
